/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.FaceSearchBean;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmLinkInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AreaBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.DetectObjectBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.FaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.PointBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.VehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.MasterDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.AlarmCallbackRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.AlarmLinkage.AlarmLinkageAction;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XMLConvertor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/ics/v1/zk/callback"})
public class CallbackController
implements BaseController<AlarmService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallbackController.class);
    @Autowired
    private AlarmService<IServerType.IVS1800> subscriptionIvs1800Service;
    @Autowired
    private AlarmService<IServerType.NVR800> subscriptionNvr800Service;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private SnapshotService<IServerType.IVS1800> snapshotIvs1800Service;
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;

    @RequestMapping(value={"/ivs1800/{domainCode}"}, method={RequestMethod.POST})
    public String callbackFor1800(HttpServletRequest request, @PathVariable String domainCode) {
        VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(domainCode);
        String content = this.getContent(request);
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.error("Received callback message is empty");
            return "";
        }
        content = content.replace("\\u0001", "");
        try {
            JSONObject contentObject = JSONObject.parseObject((String)content);
            String xml = contentObject.getString("eventData");
            if (StringUtils.isEmpty((CharSequence)xml)) {
                return "";
            }
            Integer eventType = contentObject.getInteger("eventType");
            if (eventType == 10025) {
                this.dealSearchCamera(xml, vcmReqBaseInfo, domainCode);
            } else if (eventType == 10013) {
                this.dealAlarmData(xml, vcmReqBaseInfo, domainCode);
            } else if (eventType != 10800 && eventType == 10316) {
                this.dealCameraStatus(xml, vcmReqBaseInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("IVS1800 dealAlarmData error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return "";
    }

    @RequestMapping(value={"/onvif/{domainCode}"})
    public String callbackForOnvif(HttpServletRequest request, @PathVariable String domainCode) {
        String content = this.getContent(request);
        LOGGER.info("onvif call back event data: {}", (Object)content);
        return "";
    }

    private void dealCameraStatus(String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        LOGGER.info("ivs 1800 camera status data:{}", (Object)xml);
        DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
        deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
        deviceEventRespond.setSubtype("cameraEvent");
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            Element root = document.getRootElement();
            JSONObject data = new JSONObject();
            data.put("cameraCode", (Object)root.element("DevCode").getText());
            data.put("domainCode", (Object)vcmReqBaseInfo.getDomainCode());
            data.put("parentDeviceId", (Object)vcmReqBaseInfo.getParentDeviceId());
            data.put("fileType", (Object)root.element("FileType").getText());
            data.put("status", (Object)root.element("Status").getText());
            data.put("resultCode", (Object)root.element("ResultCode").getText());
            if (Objects.nonNull(root.element("Progress"))) {
                if (StringUtils.equals((CharSequence)root.element("Progress").getText(), (CharSequence)"-2")) {
                    data.put("progress", (Object)"0");
                } else if (StringUtils.isNotBlank((CharSequence)root.element("Progress").getText())) {
                    data.put("progress", (Object)root.element("Progress").getText());
                }
            } else {
                data.put("progress", (Object)"50");
            }
            deviceEventRespond.getData().getChannels().add((Object)data);
        }
        catch (Exception e) {
            LOGGER.error("ivs 1800 parse camera event xml error", (Throwable)e);
        }
        this.webSocketService.send((BaseEventRespond)deviceEventRespond);
    }

    private void dealSearchCamera(String xml, VcmReqBaseInfo vcmInfo, String domainCode) {
        LOGGER.info("ivs 1800 search camera data:{}", (Object)xml);
        DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
        deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
        deviceEventRespond.setSubtype("searchCamera");
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            Element root = document.getRootElement();
            List elementList = root.element("DevList").elements("DevInfo");
            if (!CollectionUtils.isEmpty((Collection)elementList)) {
                for (Element element : elementList) {
                    CameraSearchRespond searchRespond = new CameraSearchRespond();
                    searchRespond.setIp(element.element("DevIP").getText());
                    searchRespond.setPort(element.element("DevPort").getText());
                    searchRespond.setProtocol(element.element("DevProtocolType").getText());
                    searchRespond.setVendor(element.element("DevVendor").getText());
                    searchRespond.setDeviceType(element.element("DevModelType").getText());
                    searchRespond.setSerialNumber(element.element("DevSN").getText());
                    if ("HUAWEI".equalsIgnoreCase(searchRespond.getVendor())) {
                        searchRespond.setVendor("HW");
                    }
                    deviceEventRespond.getData().getCameras().add(searchRespond);
                }
            }
            deviceEventRespond.setPercent(root.element("Percent").getText());
            deviceEventRespond.setDomainCode(root.element("ServerCode").getText());
        }
        catch (DocumentException e) {
            LOGGER.error("Callback fail when convertXMLToBean camera fail", (Throwable)e);
            return;
        }
        LOGGER.info("ivs 1800 search camera data:{}", (Object)deviceEventRespond.toJSON());
        this.webSocketService.send((BaseEventRespond)deviceEventRespond);
    }

    private void dealAlarmData(String xml, VcmReqBaseInfo vcmReqBaseInfo, String domainCode) {
        AlarmCallbackRespondIvs1800 respondIvs1800;
        if (vcmReqBaseInfo == null) {
            LOGGER.info("IVS1800 call back ignore, domainCode:{}", (Object)domainCode);
            return;
        }
        try {
            respondIvs1800 = (AlarmCallbackRespondIvs1800)XMLConvertor.convertXMLToBean((String)xml, AlarmCallbackRespondIvs1800.class);
        }
        catch (JAXBException e) {
            LOGGER.error("Callback fail when convertXMLToBean fail", (Throwable)e);
            return;
        }
        LOGGER.info("callback alarm data:{}", (Object)xml);
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setId(String.valueOf(respondIvs1800.getAlarmEventId()));
        alarmEventRespond.setName(Ivs1800Utils.getEventName((AlarmCallbackRespondIvs1800)respondIvs1800));
        alarmEventRespond.setCode(this.getAlarmEventCode(alarmEventRespond, respondIvs1800));
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getDomainCode())) {
            alarmEventRespond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        } else {
            alarmEventRespond.setDomainCode(respondIvs1800.getDevDomainCode());
        }
        alarmEventRespond.setStatus(respondIvs1800.getAlarmStatus());
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(this.convertToLocalTime(respondIvs1800.getOccurTime()));
        alarmEventRespond.setNotificationId("");
        alarmEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        if (ObjectUtils.isNotEmpty((Object)respondIvs1800.getAlarmLinkageInfoList())) {
            ArrayList<AlarmLinkInfoRespond> alarmLinkInfos = new ArrayList<AlarmLinkInfoRespond>();
            List action = respondIvs1800.getAlarmLinkageInfoList().getActionList().getAction();
            for (AlarmLinkageAction alarmLinkageAction : action) {
                AlarmLinkInfoRespond infoRespond = new AlarmLinkInfoRespond();
                infoRespond.setActionType(alarmLinkageAction.getActionType());
                infoRespond.setActionBranch(alarmLinkageAction.getActionBranch());
                ArrayList devList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)alarmLinkageAction.getDevList().getDevInfo())) {
                    alarmLinkageAction.getDevList().getDevInfo().forEach(dev -> devList.add(dev.getDevCode()));
                }
                infoRespond.setDevList(devList);
                infoRespond.setGlobalParam(alarmLinkageAction.getGlobalParam());
                alarmLinkInfos.add(infoRespond);
            }
            alarmEventRespond.setAlarmLinkInfos(alarmLinkInfos);
        }
        if (respondIvs1800.getAlarmLevelValue() == 100) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        } else if (respondIvs1800.getAlarmLevelValue() == 80) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
        } else if (respondIvs1800.getAlarmLevelValue() == 50) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.NORMAL);
        } else {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.NOTICE);
        }
        if (ObjectUtils.isNotEmpty((Object)respondIvs1800.getIsUserDefined()) && respondIvs1800.getIsUserDefined() == 1) {
            alarmEventRespond.setIsUserDefined(Integer.valueOf(1));
            alarmEventRespond.setAlarmLevelName(respondIvs1800.getAlarmLevelName());
            alarmEventRespond.setAlarmLevelValue(Integer.valueOf(respondIvs1800.getAlarmLevelValue()));
            alarmEventRespond.setAlarmLevelColor(respondIvs1800.getAlarmLevelColor());
        } else {
            alarmEventRespond.setIsUserDefined(Integer.valueOf(0));
        }
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        if (!StringUtils.isEmpty((CharSequence)alarmEventRespond.getAlarmCodeType())) {
            alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        }
        String snapshotImage = "";
        String panoramaImage = "";
        try {
            if (ObjectUtils.isNotEmpty((Object)respondIvs1800.getSnapshot()) && ObjectUtils.isNotEmpty((Object)respondIvs1800.getPanorama())) {
                snapshotImage = this.smartDaraHelpService.getDynamicGroupImage(vcmReqBaseInfo, respondIvs1800.getSnapshot());
                panoramaImage = this.smartDaraHelpService.getDynamicGroupImage(vcmReqBaseInfo, respondIvs1800.getPanorama());
            } else if (ConfigHolder.getSnapSwitch()) {
                SnapshotRespond snapshotRespond = this.snapshotIvs1800Service.createSnapshot(vcmReqBaseInfo, new SnapshotRequest(alarmEventRespond.getChannelCode()));
                panoramaImage = snapshotImage = snapshotRespond.getImgBase64Str();
            }
        }
        catch (Exception e) {
            if (e instanceof InvokeException) {
                LOGGER.info("call back snapshot api error,IP:{},origin:{}", (Object)vcmReqBaseInfo.getVcmIp(), ((InvokeException)e).getOriginalValue());
            }
            LOGGER.error("call back snapshot error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        if (AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            alarmEventRespond.setCode(StringUtils.isNotEmpty((CharSequence)respondIvs1800.getThirdAlarmType()) ? respondIvs1800.getThirdAlarmType() : "ALARM_THIRD_ALGORITHM");
            ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
            thirdAlgorithmBean.setPanorama(panoramaImage);
            thirdAlgorithmBean.setSnapshot(snapshotImage);
            thirdAlgorithmBean.setThirdAlgorithmName(StringUtils.isNotBlank((CharSequence)respondIvs1800.getAlarmDesc()) ? respondIvs1800.getAlarmDesc() : "unknown");
            alarmEventRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
            alarmEventRespond.setFilterName(thirdAlgorithmBean.getThirdAlgorithmName());
        } else if (AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            BehaviorBean behaviorBean = new BehaviorBean();
            behaviorBean.setPanorama(panoramaImage);
            behaviorBean.setSnapshot(snapshotImage);
            alarmEventRespond.setBehaviorBean(behaviorBean);
        } else if (AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
            situationAnalysisBean.setPanorama(panoramaImage);
            situationAnalysisBean.setSnapshot(snapshotImage);
            alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
        } else if (AlarmCodeTypeEnum.ALARM_FACE.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            FaceBean faceBean = new FaceBean();
            faceBean.setPanorama(panoramaImage);
            faceBean.setSnapshot(snapshotImage);
            if ("ALARM_FACE_MASK_PLATFORM".equals(alarmEventRespond.getCode())) {
                ArrayList detectObjectList = new ArrayList();
                faceBean.setDetectObject(this.dealFaceMaskPlatformXmlInfo(detectObjectList, respondIvs1800.getExtParam()));
            }
            alarmEventRespond.setFaceBean(faceBean);
        } else if (AlarmCodeTypeEnum.ALARM_VEHICLE.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            VehicleBean vehicleBean = new VehicleBean();
            vehicleBean.setPanorama(panoramaImage);
            vehicleBean.setSnapshot(snapshotImage);
            alarmEventRespond.setVehicleBean(vehicleBean);
        } else if (AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
            generalBusinessBean.setPanorama(panoramaImage);
            generalBusinessBean.setSnapshot(snapshotImage);
            if ("ALARM_HEATIMG_TEMPER".equals(alarmEventRespond.getCode())) {
                generalBusinessBean = this.dealHeatimgTemperXmlInfo(generalBusinessBean, respondIvs1800.getExtParam());
            }
            alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
        } else {
            if ("ALARM_IPC_OFFLINE".equals(alarmEventRespond.getCode()) || "ALARM_DEVICE_OFFLINE".equals(alarmEventRespond.getCode())) {
                alarmEventRespond.setStatus(1);
            }
            if (StringUtils.isNotBlank((CharSequence)respondIvs1800.getLocationInfo())) {
                alarmEventRespond.setLocationInfo(respondIvs1800.getLocationInfo());
            }
        }
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private String getAlarmEventCode(AlarmEventRespond alarmEventRespond, AlarmCallbackRespondIvs1800 respondIvs1800) {
        alarmEventRespond.setCode(respondIvs1800.getAlarmType().replaceAll("ALARM_LEAVE_DETECT", "ALARM_PERSON_LEAVE_DETECT"));
        alarmEventRespond.setChannelCode(respondIvs1800.getAlarmInCode());
        if ("ALARM_TYPE_DI".equals(alarmEventRespond.getCode()) || "ALARM_TYPE_SELF_DI".equals(alarmEventRespond.getCode())) {
            alarmEventRespond.setAlarmSourceSecType(1);
            alarmEventRespond.setAlarmSourceCode(respondIvs1800.getAlarmInCode());
            alarmEventRespond.setAlarmInName(respondIvs1800.getAlarmInName());
        }
        return alarmEventRespond.getCode();
    }

    private GeneralBusinessBean dealHeatimgTemperXmlInfo(GeneralBusinessBean generalBusinessBean, String xml) {
        try {
            if (xml.startsWith("<")) {
                SAXReader reader = new SAXReader();
                Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                Element extParam = document.getRootElement();
                generalBusinessBean.setTemAnomalyName(extParam.element("name").getText());
                generalBusinessBean.setTemperatureResult(extParam.element("result").getText());
                generalBusinessBean.setTemperatureAlarmContion(extParam.element("alarmContion").getText());
                generalBusinessBean.setTemperatureValue(extParam.element("temperatureValue").getText());
                generalBusinessBean.setTemperatureUnit(extParam.element("temperatureUnit").getText());
                generalBusinessBean.setTemperaturePresetId(extParam.element("presetID").getText());
                List elementList = extParam.element("area").elements("point");
                if (!CollectionUtils.isEmpty((Collection)elementList)) {
                    ArrayList<PointBean> points = new ArrayList<PointBean>();
                    AreaBean areaBean = new AreaBean();
                    for (Element element : elementList) {
                        PointBean point = new PointBean();
                        point.setXValue(Integer.parseInt(element.elementText("x")));
                        point.setYValue(Integer.parseInt(element.elementText("y")));
                        points.add(point);
                    }
                    areaBean.setPointBeans(points);
                    generalBusinessBean.setAreaBean(areaBean);
                }
            }
            return generalBusinessBean;
        }
        catch (DocumentException e) {
            LOGGER.error("Callback fail when convertXMLToBean camera fail", (Throwable)e);
            return new GeneralBusinessBean();
        }
    }

    private String convertToLocalTime(String strTime) {
        Date date;
        if (StringUtils.isBlank((CharSequence)strTime)) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = sdf.parse(strTime);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strTime);
            return strTime;
        }
        sdf.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
        return sdf.format(date);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContent(HttpServletRequest request) {
        try (BufferedReader br = request.getReader();){
            String str;
            StringBuilder sb = new StringBuilder();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Read from request fail", (Throwable)e);
            return null;
        }
    }

    @PostMapping(value={"/bio"})
    public ContentResponse<String, Boolean> callbackForBio(@RequestBody String data) {
        try {
            JSONObject dataObject = JSONObject.parseObject((String)data);
            JSONArray deviceArray = dataObject.getJSONArray("data");
            DeviceEventRespond respond = new DeviceEventRespond();
            respond.setSubtype(dataObject.getString("subType"));
            respond.setType(EventTypeEnum.OPERATE_RESULT);
            respond.getData().setChangeId(dataObject.getString("changeId"));
            if ("parentDeviceChangeStatus".equals(respond.getSubtype()) || "parentDeviceDeleteStatus".equals(respond.getSubtype()) || "parentDeviceAddStatus".equals(respond.getSubtype()) || "parentDeviceUpdateStatus".equals(respond.getSubtype()) || "parentDeviceAbnormalReason".equals(respond.getSubtype())) {
                if (!CollectionUtils.isEmpty((Collection)deviceArray)) {
                    for (int i = 0; i < deviceArray.size(); ++i) {
                        JSONObject deviceObject = deviceArray.getJSONObject(i);
                        MasterDeviceRespond parentDeviceBean = (MasterDeviceRespond)JsonUtil.convertJsonToBean((String)deviceObject.toJSONString(), MasterDeviceRespond.class).get();
                        respond.getData().getParentDevices().add(parentDeviceBean);
                    }
                }
            } else if ("channelChangeStatus".equals(respond.getSubtype())) {
                respond.getData().setChannels(deviceArray);
            }
            LOGGER.info("push device data:{}", (Object)respond.toJSON());
            this.webSocketService.send((BaseEventRespond)respond);
        }
        catch (Exception e) {
            LOGGER.error("call back bio error", (Throwable)e);
        }
        return ResultHelper.success((Object)true);
    }

    private List<DetectObjectBean> dealFaceMaskPlatformXmlInfo(List<DetectObjectBean> detectObjectList, String xml) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)xml) && xml.startsWith("<")) {
                xml = "<content>" + xml + "</content>";
                FaceSearchBean faceSearchBean = (FaceSearchBean)XMLConvertor.convertXMLToBean((String)xml, FaceSearchBean.class);
                DetectObjectBean detectObject = new DetectObjectBean();
                detectObject.setLeft(Integer.valueOf(faceSearchBean.getLeft()));
                detectObject.setTop(Integer.valueOf(faceSearchBean.getTop()));
                detectObject.setRight(Integer.valueOf(faceSearchBean.getRight()));
                detectObject.setBottom(Integer.valueOf(faceSearchBean.getBottom()));
                detectObjectList.add(detectObject);
            }
            return detectObjectList;
        }
        catch (JAXBException e) {
            LOGGER.error("Callback fail when convertXMLToBean camera fail", (Throwable)e);
            return detectObjectList;
        }
    }

    public AlarmService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public AlarmService<IServerType.IVS1800> getIvs1800Server() {
        return this.subscriptionIvs1800Service;
    }

    public AlarmService<IServerType.NVR800> getNvr800Server() {
        return this.subscriptionNvr800Service;
    }
}

