/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.aspect.IcsCheck;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.BehaviorAnalysis1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbilityNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.BehaviorAnalysisNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u667a\u80fd\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/behavior"})
public class BehaviorAnalysisController
implements BaseController<BehaviorAnalysisService<?>> {
    @Autowired
    private BehaviorAnalysisService<IServerType.NVR800> behaviorAnalysisService;
    @Autowired
    private AbilityNvr800ServiceImpl abilityNvr800Service;
    @Autowired
    private DeviceManageNvr800ServiceImpl deviceManageNvr800Service;
    @Autowired
    private BehaviorAnalysisNvr800ServiceImpl behaviorAnalysisServiceImpl;
    @Autowired
    private Set<BehaviorAnalysisService<IServerType.SDC>> behaviorAnalysisSdcServiceSet;
    @Autowired
    private BehaviorAnalysis1800ServiceImpl behaviorAnalysis1800Service;
    @Autowired
    private BehaviorAnalysisService<IServerType.ZKNVR> behaviorAnalysisZKNvrService;
    @Autowired
    private BehaviorAnalysisService<IServerType.ZKIPC> behaviorAnalysisZKIpcService;

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u8054\u52a8\u53c2\u6570\u914d\u7f6e   \u4ec5\u4f9bNVR800")
    @IcsCheck
    @RequestMapping(value={"/allAlarmConfig/get"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getAllAlarmConfig(@RequestBody ParamBean<ChannelListRequest> obj) {
        List channelCodeList = ((ChannelListRequest)obj.getRequestBody()).getChannelCode();
        Map<Object, Object> aliasMap = new HashMap();
        if (Objects.isNull(channelCodeList) || channelCodeList.size() <= 0) {
            List channelRespondList = this.deviceManageNvr800Service.listChannel(obj.getVcmInfo());
            channelCodeList = channelRespondList.stream().map(ChannelRespond::getChannelCode).collect(Collectors.toList());
            aliasMap = channelRespondList.stream().collect(Collectors.toMap(ChannelRespond::getChannelCode, ChannelRespond::getCameraName));
        }
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        ChannelListRequest channelListRequest = new ChannelListRequest();
        channelListRequest.setChannelCode(channelCodeList);
        paramBean.setRequestBody((Object)channelListRequest);
        Map abilityMap = this.abilityNvr800Service.getAbilities(paramBean);
        List<String> nameList = Arrays.asList("PerimeterZone", "PerimeterLine", "AreaEnter", "AreaExit", "Loitering", "FastMove", "MotionDetect", "LensBlocking", "CrossCounting", "QueueDetect", "CrowdDensity", "MaskAlarm", "SoundDetect", "ThirdPartyAlgorithm", "ItemLeave", "ItemMove", "VehicleIllegalPark", "ElectroMobile", "LeaveDetect", "ParkingDetection");
        List<Nvr800MsgType> configUrlList = Arrays.asList(Nvr800MsgType.PERIMETER_ZONE_GET_URI, Nvr800MsgType.PERIMETER_LINE_GET_URI, Nvr800MsgType.AREA_ENTER_GET_URI, Nvr800MsgType.AREA_EXIT_GET_URI, Nvr800MsgType.LOITERING_GET_URI, Nvr800MsgType.FAST_MOVEMENT_GET_URI, Nvr800MsgType.MOTION_CONFIG_GET, Nvr800MsgType.OCCLUSION_CONFIG_GET, Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_GET, Nvr800MsgType.QUEUE_DETECTION_GET, Nvr800MsgType.CROWD_DENSITY_GET, Nvr800MsgType.MASK_ALARM_CONFIG_GET, Nvr800MsgType.SOUND_DETECTION_GET, Nvr800MsgType.THIRD_PARTY_ALGORITHM_GET, Nvr800MsgType.PERIMETER_ITEM_LEAVE_GET_URI, Nvr800MsgType.PERIMETER_ITEM_MOVE_GET_URI, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_GET_URI, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_GET_URI, Nvr800MsgType.PERSON_LEAVE_DETECT_GET, Nvr800MsgType.PARKING_DETECT_GET);
        List<Nvr800MsgType> rangeUrlList = Arrays.asList(Nvr800MsgType.PERIMETER_ZONE_RANGE_URI, Nvr800MsgType.PERIMETER_LINE_RANGE_URI, Nvr800MsgType.AREA_ENTER_RANGE_URI, Nvr800MsgType.AREA_EXIT_RANGE_URI, Nvr800MsgType.LOITERING_RANGE_URI, Nvr800MsgType.FAST_MOVEMENT_RANGE_URI, Nvr800MsgType.MOTION_CONFIG_RANGE, Nvr800MsgType.OCCLUSION_CONFIG_RANGE, Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_RANGE, Nvr800MsgType.QUEUE_DETECTION_RANGE, Nvr800MsgType.CROWD_DENSITY_RANGE, Nvr800MsgType.MASK_ALARM_CONFIG_RANGE_GET, Nvr800MsgType.SOUND_DETECTION_RANGE, Nvr800MsgType.THIRD_PARTY_ALGORITHM_RANGE, Nvr800MsgType.PERIMETER_ITEM_LEAVE_RANGE_URI, Nvr800MsgType.PERIMETER_ITEM_MOVE_RANGE_URI, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_RANGE_URI, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_RANGE_URI, Nvr800MsgType.PERSON_LEAVE_DETECT_RANGE, Nvr800MsgType.PARKING_DETECT_RANGE_GET);
        ArrayList<JSONObject> configJsonList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> rangeJsonList = new ArrayList<JSONObject>();
        for (int i = 0; i < nameList.size(); ++i) {
            List codeList = this.getChannelCodeList(abilityMap, nameList.get(i));
            if (CollectionUtils.isEmpty((Collection)codeList)) {
                configJsonList.add(new JSONObject());
                rangeJsonList.add(new JSONObject());
                continue;
            }
            JSONObject configJson = this.behaviorAnalysisServiceImpl.getAlarmConfig(obj.getVcmInfo(), codeList, configUrlList.get(i));
            configJsonList.add(configJson);
            JSONObject rangeJson = this.behaviorAnalysisServiceImpl.getRange(obj.getVcmInfo(), rangeUrlList.get(i));
            rangeJsonList.add(rangeJson);
        }
        JSONObject resultJson = new JSONObject();
        for (String channelCode : channelCodeList) {
            for (int i = 0; i < nameList.size(); ++i) {
                if (!((JSONObject)configJsonList.get(i)).containsKey((Object)channelCode)) continue;
                JSONObject channelNode = this.getNode(resultJson, channelCode, aliasMap);
                channelNode.put(nameList.get(i), (Object)new JSONObject());
                channelNode.getJSONObject(nameList.get(i)).put("config", (Object)((JSONObject)configJsonList.get(i)).getJSONObject(channelCode));
                channelNode.getJSONObject(nameList.get(i)).put("range", (Object)((JSONObject)rangeJsonList.get(i)).getJSONObject(channelCode));
            }
        }
        return ResultHelper.success((Object)resultJson);
    }

    private JSONObject getNode(JSONObject jsonObject, String channelCode, Map<String, String> aliasMap) {
        if (!jsonObject.containsKey((Object)channelCode)) {
            jsonObject.put(channelCode, (Object)new JSONObject());
        }
        return jsonObject.getJSONObject(channelCode);
    }

    private List<String> getChannelCodeList(Map<String, List<String>> abilityMap, String abilityName) {
        ArrayList<String> channelCodeList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : abilityMap.entrySet()) {
            if (!entry.getValue().contains(abilityName)) continue;
            channelCodeList.add(entry.getKey());
        }
        return channelCodeList;
    }

    @ApiOperation(value="\u83b7\u53d6\u5165\u4fb5\u68c0\u6d4b")
    @IcsCheck
    @RequestMapping(value={"/perimeterZone/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getPerimeterZone(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getPerimeterZone(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5165\u4fb5\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/perimeterZone/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setPerimeterZone(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        Boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setPerimeterZone(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d8a\u7ebf\u68c0\u6d4b")
    @IcsCheck
    @RequestMapping(value={"/perimeterLine/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getPerimeterLine(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getPerimeterLine(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u8d8a\u7ebf\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/perimeterLine/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setPerimeterLine(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setPerimeterLine(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u533a\u57df\u8fdb\u5165\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/areaEnter/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getAreaEnter(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getAreaEnter(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u533a\u57df\u8fdb\u5165")
    @IcsCheck
    @RequestMapping(value={"/areaEnter/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setAreaEnter(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setAreaEnter(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u533a\u57df\u79bb\u5f00\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/areaExit/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getAreaExit(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getAreaExit(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u533a\u57df\u79bb\u5f00")
    @IcsCheck
    @RequestMapping(value={"/areaExit/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setAreaExit(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setAreaExit(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f98\u5f8a\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/loitering/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getLoitering(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getLoitering(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5f98\u5f8a\u68c0\u6d4b")
    @IcsCheck
    @RequestMapping(value={"/loitering/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setLoitering(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setLoitering(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5feb\u901f\u79fb\u52a8\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/fastMovement/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getFastMovement(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getFastMovement(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5feb\u901f\u79fb\u52a8")
    @IcsCheck
    @RequestMapping(value={"/fastMovement/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setFastMovement(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setFastMovement(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u9057\u7559\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/itemLeave/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getItemLeave(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getItemLeave(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u9057\u7559\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/itemLeave/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setItemLeave(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setItemLeave(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u79fb\u8d70\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/itemMove/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getItemMove(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getItemMove(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u79fb\u8d70\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/itemMove/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setItemMove(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setItemMove(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7535\u74f6\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/electroMobile/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getElectroMobile(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getElectroMobile(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7535\u74f6\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/electroMobile/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setElectroMobile(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setElectroMobile(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u4e3a\u5206\u6790\u5168\u5c40\u914d\u7f6e")
    @RequestMapping(value={"/igtAlarmConfig/get"}, method={RequestMethod.POST})
    public ContentResponse<String, IgtAlarmConfigRespond> getIgtAlarmConfig(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        IgtAlarmConfigRespond alarmConfig = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getIgtAlarmConfig(obj);
        return ResultHelper.success((Object)alarmConfig);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u884c\u4e3a\u5206\u6790\u5168\u5c40\u914d\u7f6e")
    @IcsCheck
    @RequestMapping(value={"/igtAlarmConfig/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setIgtAlarmConfig(@RequestBody ParamBean<IgtAlarmConfigSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setIgtAlarmConfig(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u975e\u4eba\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleDetect/get"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleParameterRespond> getVehicleDetect(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        VehicleParameterRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getVehicleDetect(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u673a\u975e\u4eba\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleDetect/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setVehicleDetect(@RequestBody ParamBean<VehicleParameterSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setVehicleDetect(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u52a8\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleParameter/get"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleParameterRespond> getVehicleParameter(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        VehicleParameterRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getVehicleParameter(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u673a\u52a8\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleParameter/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setVehicleParameter(@RequestBody ParamBean<VehicleParameterSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setVehicleParameter(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u8fdd\u505c\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleIllegal/get"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleParameterRespond> getVehicleIllegal(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        VehicleParameterRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getVehicleIllegal(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u8fdd\u505c\u8f66\u8f86\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/vehicleIllegal/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setVehicleIllegal(@RequestBody ParamBean<VehicleParameterSetRequest> obj) {
        boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setVehicleIllegal(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d61800\u540e\u7aef\u7b2c\u4e09\u65b9\u7b97\u6cd5\u5217\u8868")
    @RequestMapping(value={"/thirdalgorithm"}, method={RequestMethod.POST})
    public ContentResponse<String, ThirdAlgorithmRespond> thirdAlgorithm(@RequestBody ParamBean<EmptyRequest> obj) {
        ThirdAlgorithmRespond respond = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).thirdAlgorithm(obj.getVcmInfo());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u67e5\u8be2\u7b2c\u4e09\u65b9\u7b97\u6cd5\u914d\u7f6e\u53c2\u6570")
    @RequestMapping(value={"/thirdalgorithmParam/get"}, method={RequestMethod.POST})
    public ContentResponse<String, ThirdAlgorithmRespond> thirdalgorithmParam(@RequestBody ParamBean<ThirdAlgorithm> obj) {
        ThirdAlgorithmRespond respond = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).thirdalgorithmParam(obj.getVcmInfo(), (ThirdAlgorithm)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u66f4\u65b0\u7b2c\u4e09\u65b9\u7b97\u6cd5\u914d\u7f6e\u53c2\u6570")
    @RequestMapping(value={"/thirdalgorithmParam/update"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> updateThirdalgorithmParam(@RequestBody ParamBean<ThirdAlgorithm> obj) {
        Boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).updateThirdalgorithmParam(obj.getVcmInfo(), (ThirdAlgorithm)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u505c\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/parkDetect/get"}, method={RequestMethod.POST})
    public ContentResponse<String, BehaviorRespond> getParkDetect(@RequestBody ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).getParkDetect(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u505c\u8f66\u68c0\u6d4b\u53c2\u6570")
    @RequestMapping(value={"/parkDetect/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setParkDetect(@RequestBody ParamBean<BehaviorSetRequest> obj) {
        Boolean result = ((BehaviorAnalysisService)this.getServer(obj.getVcmInfo())).setParkDetect(obj);
        return ResultHelper.success((Object)result);
    }

    public BehaviorAnalysisService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public BehaviorAnalysisService<IServerType.IVS1800> getIvs1800Server() {
        return this.behaviorAnalysis1800Service;
    }

    public BehaviorAnalysisService<IServerType.NVR800> getNvr800Server() {
        return this.behaviorAnalysisService;
    }

    public BehaviorAnalysisService<IServerType.ZKNVR> getZKNVRServer() {
        return this.behaviorAnalysisZKNvrService;
    }

    public BehaviorAnalysisService<IServerType.ZKIPC> getZKIPCServer() {
        return this.behaviorAnalysisZKIpcService;
    }

    public BehaviorAnalysisService<?> getSdcServer(int implType) {
        for (BehaviorAnalysisService behaviorAnalysisService : this.behaviorAnalysisSdcServiceSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)behaviorAnalysisService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return behaviorAnalysisService;
        }
        return null;
    }
}

