/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarmLinkage.AlarmLevelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarmLinkage.AlarmLinkageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarmLinkage.AlarmSourceDetailsRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmTypeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLevelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLinkageImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLinkageRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmLinkageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u544a\u8b66\u8054\u52a8"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/alarmLinkage"})
public class AlarmLinkageController
implements BaseController<AlarmLinkageService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmLinkageController.class);
    @Autowired
    private AlarmLinkageService<IServerType.IVS1800> alarmLinkageIvs1800Service;
    @Autowired
    private AlarmLinkageService<IServerType.NVR800> alarmLinkageNvr800Service;

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u8054\u52a8\u7b56\u7565\u5217\u8868")
    @RequestMapping(value={"/getAlarmLinkage"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> getAlarmLinkage(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond success = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmLinkage(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u8054\u52a8\u7b56\u7565\u8be6\u60c5")
    @RequestMapping(value={"/getAlarmLinkageDetails"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> getAlarmLinkageDetails(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond success = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmLinkageDetails(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u7c7b\u578b\u5217\u8868")
    @RequestMapping(value={"/getAlarmType"}, method={RequestMethod.POST})
    public ContentResponse<String, PageRespond<AlarmTypeRespond>> getAlarmType(@RequestBody ParamBean<EmptyRequest> obj) {
        PageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmType(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u7c7b\u578b\u5217\u8868")
    @RequestMapping(value={"/getThirdAlgorithmAlarmType"}, method={RequestMethod.POST})
    public ContentResponse<String, PageRespond<AlarmTypeRespond>> getThirdAlgorithmAlarmType(@RequestBody ParamBean<EmptyRequest> obj) {
        ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
        for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                ParamBean paramBean = new ParamBean();
                paramBean.setVcmInfo(vcmInfo);
                PageRespond result = ((AlarmLinkageService)this.getServer(vcmInfo)).getThirdAlgorithmAlarmType(paramBean);
                return result.getData();
            });
            futureList.add(future);
        }
        ArrayList alarmTypleList = new ArrayList();
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()])).whenComplete((v, t) -> futureList.forEach(temp -> {
            AlarmLinkageController alarmLinkageController = this;
            synchronized (alarmLinkageController) {
                alarmTypleList.addAll(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("alarm type complex CompletableFuture get error", (Throwable)e);
        }
        List resultList = alarmTypleList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AlarmTypeRespond>(Comparator.comparing(AlarmTypeRespond::getAlarmType))), ArrayList::new));
        LOGGER.info("alarm type  result size:" + resultList.size());
        PageRespond respond = new PageRespond();
        respond.setData(resultList);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u8054\u52a8\u7b56\u7565\u52a8\u4f5c\u8be6\u60c5")
    @RequestMapping(value={"/getAlarmAction"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> getAlarmAction(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmAction(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u52a8\u6293\u62cd\u56fe\u7247\u5217\u8868")
    @RequestMapping(value={"/getAlarmLinkageImage"}, method={RequestMethod.POST})
    public ContentResponse<String, PageRespond<AlarmLinkageImageRespond>> getAlarmLinkageImage(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        PageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmLinkageImage(obj.getVcmInfo(), (AlarmLinkageRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u65b0\u589e\u544a\u8b66\u8054\u52a8\u7b56\u7565")
    @RequestMapping(value={"addAlarmLinkage"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> addAlarmLinkage(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).addAlarmLinkage(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4fee\u6539\u544a\u8b66\u8054\u52a8\u7b56\u7565")
    @RequestMapping(value={"setAlarmLinkage"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> setAlarmLinkage(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).setAlarmLinkage(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u5220\u9664\u544a\u8b66\u8054\u52a8\u7b56\u7565")
    @RequestMapping(value={"delAlarmLinkage"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> delAlarmLinkage(@RequestBody ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).delAlarmLinkage(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u7b49\u7ea7\u5217\u8868")
    @RequestMapping(value={"getAlarmLevel"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLevelRespond> getAlarmLevel(@RequestBody ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmLevel(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u589e\u52a0\u544a\u8b66\u7b49\u7ea7\u5217\u8868")
    @RequestMapping(value={"addAlarmLevel"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLevelRespond> addAlarmLevel(@RequestBody ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).addAlarmLevel(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4fee\u6539\u544a\u8b66\u7b49\u7ea7\u5217\u8868")
    @RequestMapping(value={"setAlarmLevel"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLevelRespond> setAlarmLevel(@RequestBody ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).setAlarmLevel(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u5220\u9664\u544a\u8b66\u7b49\u7ea7\u5217\u8868")
    @RequestMapping(value={"delAlarmLevel"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLevelRespond> delAlarmLevel(@RequestBody ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond respond = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).delAlarmLevel(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u6e90\u5217\u8868\u8be6\u60c5---\u4ec5\u652f\u6301NVR800")
    @RequestMapping(value={"/getAlarmSourceDetails"}, method={RequestMethod.POST})
    public ContentResponse<String, AlarmLinkageRespond> getAlarmSourceDetails(@RequestBody ParamBean<AlarmSourceDetailsRequest> obj) {
        AlarmLinkageRespond respondList = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).getAlarmSourceDetails(obj);
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u544a\u8b66\u6e90\u5217\u8868\u8be6\u60c5---\u4ec5\u652f\u6301NVR800")
    @RequestMapping(value={"/setAlarmSourceDetails"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setAlarmSourceDetails(@RequestBody ParamBean<AlarmSourceDetailsRequest> obj) {
        Boolean respondList = ((AlarmLinkageService)this.getServer(obj.getVcmInfo())).setAlarmSourceDetails(obj);
        return ResultHelper.success((Object)respondList);
    }

    public AlarmLinkageService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public AlarmLinkageService<IServerType.IVS1800> getIvs1800Server() {
        return this.alarmLinkageIvs1800Service;
    }

    public AlarmLinkageService<IServerType.NVR800> getNvr800Server() {
        return this.alarmLinkageNvr800Service;
    }

    public AlarmLinkageService<IServerType.SDC> getSdcServer() {
        throw new InvokeException("500", "cu_device_not_support");
    }
}

