/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.aspect.BaseCheck;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.PictureRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.OperationsAlarmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u544a\u8b66\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/alarm"})
public class AlarmController
implements BaseController<AlarmService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmController.class);
    @Autowired
    private AlarmService<IServerType.IVS1800> alarmIvs1800Service;
    @Autowired
    private AlarmService<IServerType.NVR800> alarmNvr800Service;
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;
    @Autowired
    private Set<AlarmService<IServerType.SDC>> alarmServiceSdcSet;
    private AlarmService<IServerType.SDC> alarmSdcService;
    @Autowired
    private AlarmService<IServerType.Cloud> alarmCloudService;
    @Autowired
    private AlarmService<IServerType.ZKNVR> alarmZKNvrService;
    @Autowired
    private AlarmService<IServerType.Tiandy> alarmTianDyService;
    @Autowired
    private AlarmService<IServerType.Onvif> onvifAlarmService;

    @ApiOperation(value="\u544a\u8b66\u8ba2\u9605")
    @RequestMapping(value={"/subscribe"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> subscribe(@RequestBody ParamBean<SubscriptionRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).subscribe(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u5220\u9664\u544a\u8b66\u8ba2\u9605")
    @BaseCheck
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> deleteSubscribe(@RequestBody ParamBean<SubscriptionRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).delSubscribe(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u547d\u4e2d\u56fe\u7247")
    @RequestMapping(value={"/matchedImage"}, method={RequestMethod.POST})
    public ContentResponse<String, String> matchedImage(@RequestBody ParamBean<PictureRequest> obj) {
        String success = this.smartDaraHelpService.getTargetMatchedImage(obj.getVcmInfo(), Long.valueOf(((PictureRequest)obj.getRequestBody()).getFileId()));
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u544a\u8b66\u786e\u8ba4")
    @RequestMapping(value={"/confirm"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> confirm(@RequestBody ParamBean<AlarmDealRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).confirm(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u544a\u8b66\u53d6\u6d88")
    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> cancel(@RequestBody ParamBean<AlarmDealRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).cancel(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u544a\u8b66\u67e5\u8be2")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public ContentResponse<String, PageRespond<AlarmSearchRespond>> search(@RequestBody ParamBean<AlarmSearchRequest> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ((AlarmSearchRequest)obj.getRequestBody()).setPage(1);
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            PageRespond respond = new PageRespond();
            AlarmSearchRequest request = (AlarmSearchRequest)obj.getRequestBody();
            JSONArray exArray = new JSONArray();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        AlarmSearchRequest alarmSearchRequest = new AlarmSearchRequest();
                        BeanUtils.copyProperties((Object)request, (Object)alarmSearchRequest);
                        alarmSearchRequest.setChannelCodeList(request.getChannelCode().getJSONArray(vcmInfo.getDomainCode()).toJavaList(String.class));
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody((Object)alarmSearchRequest);
                        ((AlarmSearchRequest)paramBean.getRequestBody()).setDomainCode(vcmInfo.getDomainCode());
                        PageRespond result = ((AlarmService)this.getServer(vcmInfo)).search(paramBean);
                        return result.getData();
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture get history alarm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        JSONObject exObject = new JSONObject();
                        exObject.put("domainCode", (Object)vcmInfo.getDomainCode());
                        exObject.put("resultCode", (Object)e.getMessage());
                        exArray.add((Object)exObject);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
                if (vcmInfo.getVcmType() != 4) continue;
                break;
            }
            respond.setExceptionInfo(exArray);
            ArrayList alarmList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                AlarmController alarmController = this;
                synchronized (alarmController) {
                    alarmList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("alarm search complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = alarmList.stream().sorted(Comparator.comparing(BaseEventRespond::getTime).reversed()).collect(Collectors.toList());
            LOGGER.info("alarm search complex result size:" + resultList.size());
            respond.setData(resultList);
            respond.setTotal(resultList.size());
            respond.setPage(1);
            respond.setPageSize(resultList.size());
            respond.setMultiDevice(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice().intValue());
            return ResultHelper.success((Object)respond);
        }
        PageRespond result = ((AlarmService)this.getServer(obj.getVcmInfo())).search(obj);
        if (Objects.nonNull(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice())) {
            result.setMultiDevice(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice().intValue());
        } else {
            result.setMultiDevice(0);
        }
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8fd0\u7ef4\u7c7b\u544a\u8b66\u67e5\u8be2")
    @RequestMapping(value={"/searchOperations"}, method={RequestMethod.POST})
    public ContentResponse<String, PageRespond<OperationsAlarmRespond>> searchOperations(@RequestBody ParamBean<AlarmSearchRequest> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ((AlarmSearchRequest)obj.getRequestBody()).setPage(1);
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            PageRespond respond = new PageRespond();
            AlarmSearchRequest request = (AlarmSearchRequest)obj.getRequestBody();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        AlarmSearchRequest alarmSearchRequest = new AlarmSearchRequest();
                        BeanUtils.copyProperties((Object)request, (Object)alarmSearchRequest);
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody((Object)alarmSearchRequest);
                        ((AlarmSearchRequest)paramBean.getRequestBody()).setDomainCode(vcmInfo.getDomainCode());
                        PageRespond result = ((AlarmService)this.getServer(vcmInfo)).searchOperations(paramBean);
                        return result.getData();
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture get history alarm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
                if (vcmInfo.getVcmType() != 4) continue;
                break;
            }
            ArrayList alarmList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                AlarmController alarmController = this;
                synchronized (alarmController) {
                    alarmList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("alarm search complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = alarmList.stream().sorted(Comparator.comparing(OperationsAlarmRespond::getTime).reversed()).collect(Collectors.toList());
            LOGGER.info("alarm search complex result size:" + resultList.size());
            respond.setData(resultList);
            respond.setTotal(resultList.size());
            respond.setPage(1);
            respond.setPageSize(resultList.size());
            respond.setMultiDevice(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice().intValue());
            return ResultHelper.success((Object)respond);
        }
        PageRespond result = ((AlarmService)this.getServer(obj.getVcmInfo())).searchOperations(obj);
        if (Objects.nonNull(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice())) {
            result.setMultiDevice(((AlarmSearchRequest)obj.getRequestBody()).getMultiDevice().intValue());
        } else {
            result.setMultiDevice(0);
        }
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u9605\u5730\u5740")
    @RequestMapping(value={"/registerUrl"}, method={RequestMethod.POST})
    public ContentResponse<String, String> getUrl(@RequestBody ParamBean<EmptyRequest> obj) {
        String url = ((AlarmService)this.getServer(obj.getVcmInfo())).getRegisterUrlList(obj);
        return ResultHelper.success((Object)url);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u767b\u5f55\u7528\u6237\u5207\u6362\u8eab\u4efd")
    @RequestMapping(value={"/switchEnterprise"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> switchEnterprise(@RequestBody ParamBean<EmptyRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).switchEnterprise(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u544a\u8b66\u786e\u8ba4")
    @RequestMapping(value={"/alarmCancel"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> alarmCancel(@RequestBody ParamBean<AlarmDealRequest> obj) {
        boolean success = ((AlarmService)this.getServer(obj.getVcmInfo())).alarmCancel(obj);
        return ResultHelper.success((Object)success);
    }

    public AlarmService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public AlarmService<IServerType.IVS1800> getIvs1800Server() {
        return this.alarmIvs1800Service;
    }

    public AlarmService<IServerType.NVR800> getNvr800Server() {
        return this.alarmNvr800Service;
    }

    public AlarmService<IServerType.Cloud> getCloudServer() {
        return this.alarmCloudService;
    }

    public AlarmService<IServerType.ZKNVR> getZKNVRServer() {
        return this.alarmZKNvrService;
    }

    public AlarmService<IServerType.Tiandy> getTIANDYServer() {
        return this.alarmTianDyService;
    }

    public AlarmService<IServerType.SDC> getSdcServer(int implType) {
        for (AlarmService alarmService : this.alarmServiceSdcSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)alarmService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return alarmService;
        }
        return null;
    }

    public AlarmService<?> getOnvifServer() {
        return this.onvifAlarmService;
    }
}

