/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AbilityService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u80fd\u529b\u96c6"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/ability"})
public class AbilityController
implements BaseController<AbilityService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbilityController.class);
    @Autowired
    private AbilityService<IServerType.NVR800> abilityNvr800Service;
    @Autowired
    private Set<AbilityService<IServerType.SDC>> abilitySdcServices;
    @Autowired
    private AbilityService<IServerType.IVS1800> abilityIvs1800Service;
    @Autowired
    private AbilityService<IServerType.Tiandy> abilityTianDyService;
    @Autowired
    private AbilityService<IServerType.ZKNVR> abilityZKNvrService;
    @Autowired
    private AbilityService<IServerType.ZKIPC> abilityZKIpcService;
    @Autowired
    private AbilityService<IServerType.Onvif> abilityOnvifService;

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u80fd\u529b\u96c6  key\uff1a\u80fd\u529b\u96c6\u53c2\u6570\u5b57\u6bb5\uff0c\u4f7f\u80fd\u4e3aboolean\u7c7b\u578b")
    @RequestMapping(method={RequestMethod.POST})
    public ContentResponse<String, Map<String, Boolean>> getAbility(@RequestBody ParamBean<ChannelRequest> obj) throws SDKException {
        Map abilityMap = ((AbilityService)this.getServer(obj.getVcmInfo())).getAbility(obj);
        return ResultHelper.success((Object)abilityMap);
    }

    @ApiOperation(value="\u83b7\u53d6\u76ee\u6807\u667a\u80fd\u529f\u80fd\u6388\u6743\u72b6\u6001")
    @RequestMapping(value={"/getAuth"}, method={RequestMethod.POST})
    public ContentResponse<String, Map<String, Boolean>> getAbilityAuth(@RequestBody ParamBean<ChannelRequest> obj) {
        Map abilityAuth = ((AbilityService)this.getServer(obj.getVcmInfo())).getAbilityAuth(obj);
        return ResultHelper.success((Object)abilityAuth);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u76ee\u6807\u667a\u80fd\u529f\u80fd\u6388\u6743\u72b6\u6001")
    @RequestMapping(value={"/setAuth"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> setAbilityAuth(@RequestBody ParamBean<ChannelRequest> obj) {
        JSONObject respond = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ArrayList<CompletableFuture<JSONObject>> futureList = new ArrayList<CompletableFuture<JSONObject>>();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                    JSONObject map = new JSONObject();
                    try {
                        Boolean abilityAuth = ((AbilityService)this.getServer(vcmInfo)).setAbilityAuth(vcmInfo, (ChannelRequest)obj.getRequestBody());
                        map.put(vcmInfo.getDomainCode(), (Object)abilityAuth);
                        return map;
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture set Auth error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        map.put(vcmInfo.getDomainCode(), (Object)false);
                        return map;
                    }
                });
                futureList.add(future);
            }
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                AbilityController abilityController = this;
                synchronized (abilityController) {
                    respond.putAll((Map)temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("auth complex CompletableFuture set error", (Throwable)e);
            }
            return ResultHelper.success((Object)respond);
        }
        Boolean abilityAuth = ((AbilityService)this.getServer(obj.getVcmInfo())).setAbilityAuth(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody());
        respond.put(obj.getVcmInfo().getParentDeviceId(), (Object)abilityAuth);
        return ResultHelper.success((Object)respond);
    }

    public AbilityService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public AbilityService<IServerType.IVS1800> getIvs1800Server() {
        return this.abilityIvs1800Service;
    }

    public AbilityService<IServerType.NVR800> getNvr800Server() {
        return this.abilityNvr800Service;
    }

    public AbilityService<IServerType.Tiandy> getTIANDYServer() {
        return this.abilityTianDyService;
    }

    public AbilityService<IServerType.ZKNVR> getZKNVRServer() {
        return this.abilityZKNvrService;
    }

    public AbilityService<IServerType.ZKIPC> getZKIPCServer() {
        return this.abilityZKIpcService;
    }

    public AbilityService<IServerType.Onvif> getOnvifServer() {
        return this.abilityOnvifService;
    }

    public AbilityService<?> getSdcServer(int implType) {
        for (AbilityService abilityService : this.abilitySdcServices) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)abilityService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return abilityService;
        }
        return null;
    }
}

