/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility;

import com.sun.java.accessibility.AccessBridgeLoader;
import com.sun.java.accessibility.util.AWTEventMonitor;
import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.SwingEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jdk.Exported;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

@Exported(value=false)
public final class AccessBridge
extends AccessBridgeLoader {
    private final String AccessBridgeVersion = "AccessBridge 2.0.4";
    private static AccessBridge theAccessBridge;
    private ObjectReferences references;
    private EventHandler eventHandler;
    private boolean runningOnJDK1_4 = false;
    private boolean runningOnJDK1_5 = false;
    private ConcurrentHashMap<String, AccessibleRole> accessibleRoleMap = new ConcurrentHashMap();
    private ArrayList<AccessibleRole> extendedVirtualNameSearchRoles = new ArrayList();
    private ArrayList<AccessibleRole> noExtendedVirtualNameSearchParentRoles = new ArrayList();
    private Method javaGetComponentFromNativeWindowHandleMethod;
    private Method javaGetNativeWindowHandleFromComponentMethod;
    Toolkit toolkit;
    private static ConcurrentHashMap<Integer, AccessibleContext> windowHandleToContextMap;
    private static ConcurrentHashMap<AccessibleContext, Integer> contextToWindowHandleMap;
    private static Vector<NativeWindowHandler> nativeWindowHandlers;
    ConcurrentHashMap<AccessibleTable, AccessibleContext> hashtab = new ConcurrentHashMap();
    private Map<AccessibleHypertext, AccessibleContext> hyperTextContextMap = new WeakHashMap<AccessibleHypertext, AccessibleContext>();
    private Map<AccessibleHyperlink, AccessibleContext> hyperLinkContextMap = new WeakHashMap<AccessibleHyperlink, AccessibleContext>();
    private int _visibleChildrenCount;
    private AccessibleContext _visibleChild;
    private int _currentVisibleIndex;
    private boolean _foundVisibleChild;
    private static final long PROPERTY_CHANGE_EVENTS = 1L;
    private static final long FOCUS_GAINED_EVENTS = 2L;
    private static final long FOCUS_LOST_EVENTS = 4L;
    private static final long FOCUS_EVENTS = 6L;
    private static final long CARET_UPATE_EVENTS = 8L;
    private static final long CARET_EVENTS = 8L;
    private static final long MOUSE_CLICKED_EVENTS = 16L;
    private static final long MOUSE_ENTERED_EVENTS = 32L;
    private static final long MOUSE_EXITED_EVENTS = 64L;
    private static final long MOUSE_PRESSED_EVENTS = 128L;
    private static final long MOUSE_RELEASED_EVENTS = 256L;
    private static final long MOUSE_EVENTS = 496L;
    private static final long MENU_CANCELED_EVENTS = 512L;
    private static final long MENU_DESELECTED_EVENTS = 1024L;
    private static final long MENU_SELECTED_EVENTS = 2048L;
    private static final long MENU_EVENTS = 3584L;
    private static final long POPUPMENU_CANCELED_EVENTS = 4096L;
    private static final long POPUPMENU_WILL_BECOME_INVISIBLE_EVENTS = 8192L;
    private static final long POPUPMENU_WILL_BECOME_VISIBLE_EVENTS = 16384L;
    private static final long POPUPMENU_EVENTS = 28672L;
    private static final long PROPERTY_NAME_CHANGE_EVENTS = 1L;
    private static final long PROPERTY_DESCRIPTION_CHANGE_EVENTS = 2L;
    private static final long PROPERTY_STATE_CHANGE_EVENTS = 4L;
    private static final long PROPERTY_VALUE_CHANGE_EVENTS = 8L;
    private static final long PROPERTY_SELECTION_CHANGE_EVENTS = 16L;
    private static final long PROPERTY_TEXT_CHANGE_EVENTS = 32L;
    private static final long PROPERTY_CARET_CHANGE_EVENTS = 64L;
    private static final long PROPERTY_VISIBLEDATA_CHANGE_EVENTS = 128L;
    private static final long PROPERTY_CHILD_CHANGE_EVENTS = 256L;
    private static final long PROPERTY_ACTIVEDESCENDENT_CHANGE_EVENTS = 512L;
    private static final long PROPERTY_EVENTS = 1023L;
    private AccessibleRole[] allAccessibleRoles = new AccessibleRole[]{AccessibleRole.ALERT, AccessibleRole.COLUMN_HEADER, AccessibleRole.CANVAS, AccessibleRole.COMBO_BOX, AccessibleRole.DESKTOP_ICON, AccessibleRole.INTERNAL_FRAME, AccessibleRole.DESKTOP_PANE, AccessibleRole.OPTION_PANE, AccessibleRole.WINDOW, AccessibleRole.FRAME, AccessibleRole.DIALOG, AccessibleRole.COLOR_CHOOSER, AccessibleRole.DIRECTORY_PANE, AccessibleRole.FILE_CHOOSER, AccessibleRole.FILLER, AccessibleRole.ICON, AccessibleRole.LABEL, AccessibleRole.ROOT_PANE, AccessibleRole.GLASS_PANE, AccessibleRole.LAYERED_PANE, AccessibleRole.LIST, AccessibleRole.LIST_ITEM, AccessibleRole.MENU_BAR, AccessibleRole.POPUP_MENU, AccessibleRole.MENU, AccessibleRole.MENU_ITEM, AccessibleRole.SEPARATOR, AccessibleRole.PAGE_TAB_LIST, AccessibleRole.PAGE_TAB, AccessibleRole.PANEL, AccessibleRole.PROGRESS_BAR, AccessibleRole.PASSWORD_TEXT, AccessibleRole.PUSH_BUTTON, AccessibleRole.TOGGLE_BUTTON, AccessibleRole.CHECK_BOX, AccessibleRole.RADIO_BUTTON, AccessibleRole.ROW_HEADER, AccessibleRole.SCROLL_PANE, AccessibleRole.SCROLL_BAR, AccessibleRole.VIEWPORT, AccessibleRole.SLIDER, AccessibleRole.SPLIT_PANE, AccessibleRole.TABLE, AccessibleRole.TEXT, AccessibleRole.TREE, AccessibleRole.TOOL_BAR, AccessibleRole.TOOL_TIP, AccessibleRole.AWT_COMPONENT, AccessibleRole.SWING_COMPONENT, AccessibleRole.UNKNOWN};

    public AccessBridge() {
        theAccessBridge = this;
        this.references = new ObjectReferences();
        Runtime runTime = Runtime.getRuntime();
        shutdownHook hook = new shutdownHook();
        runTime.addShutdownHook(new Thread(hook));
        this.initAccessibleRoleMap();
        String version = this.getJavaVersionProperty();
        this.debugString("[INFO]:JDK version = " + version);
        this.runningOnJDK1_4 = version.compareTo("1.4") >= 0;
        boolean bl = this.runningOnJDK1_5 = version.compareTo("1.5") >= 0;
        if (this.initHWNDcalls()) {
            EventQueueMonitor.isGUIInitialized();
            this.eventHandler = new EventHandler(this);
            if (this.runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this.eventHandler);
            }
            AccessBridge.addNativeWindowHandler(new DefaultNativeWindowHandler());
            Thread abthread = new Thread(new dllRunner());
            abthread.setDaemon(true);
            abthread.start();
            this.debugString("[INFO]:AccessBridge started");
        }
    }

    private void initAccessibleRoleMap() {
        try {
            Class<?> clAccessibleRole = Class.forName("javax.accessibility.AccessibleRole");
            if (null != clAccessibleRole) {
                AccessibleRole roleUnknown = AccessibleRole.UNKNOWN;
                Field[] fields = clAccessibleRole.getFields();
                int i = 0;
                for (i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    if (AccessibleRole.class != f.getType()) continue;
                    AccessibleRole nextRole = (AccessibleRole)f.get(roleUnknown);
                    String nextRoleString = nextRole.toDisplayString(Locale.US);
                    this.accessibleRoleMap.put(nextRoleString, nextRole);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.COMBO_BOX);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.DATE_EDITOR);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.LIST);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.PASSWORD_TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.SLIDER);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.SPIN_BOX);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TABLE);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.UNKNOWN);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TABLE);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TOOL_BAR);
    }

    private native void runDLL();

    private native void sendDebugString(String var1);

    private void debugString(String debugStr) {
        this.sendDebugString(debugStr);
    }

    private void decrementReference(Object o) {
        this.references.decrement(o);
    }

    private String getJavaVersionProperty() {
        String s = System.getProperty("java.version");
        if (s != null) {
            this.references.increment(s);
            return s;
        }
        return null;
    }

    private String getAccessBridgeVersion() {
        String s = new String("AccessBridge 2.0.4");
        this.references.increment(s);
        return s;
    }

    private native int isJAWTInstalled();

    private native int jawtGetNativeWindowHandleFromComponent(Component var1);

    private native Component jawtGetComponentFromNativeWindowHandle(int var1);

    private boolean initHWNDcalls() {
        Class[] integerParemter = new Class[]{Integer.TYPE};
        Class[] componentParemter = new Class[1];
        try {
            componentParemter[0] = Class.forName("java.awt.Component");
        }
        catch (ClassNotFoundException e) {
            this.debugString("[ERROR]:Exception: " + e.toString());
        }
        Object[] args = new Object[1];
        boolean returnVal = false;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.useJAWT_DLL) {
            returnVal = true;
        } else {
            try {
                this.javaGetComponentFromNativeWindowHandleMethod = this.toolkit.getClass().getMethod("getComponentFromNativeWindowHandle", integerParemter);
                if (this.javaGetComponentFromNativeWindowHandleMethod != null) {
                    try {
                        args[0] = new Integer(1);
                        Component c = (Component)this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)this.toolkit, args);
                        returnVal = true;
                    }
                    catch (InvocationTargetException e) {
                        this.debugString("[ERROR]:Exception: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        this.debugString("[ERROR]:Exception: " + e.toString());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
            catch (SecurityException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
            try {
                this.javaGetNativeWindowHandleFromComponentMethod = this.toolkit.getClass().getMethod("getNativeWindowHandleFromComponent", componentParemter);
                if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
                    try {
                        args[0] = new Button("OK");
                        Integer i = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, args);
                        returnVal = true;
                    }
                    catch (InvocationTargetException e) {
                        this.debugString("[ERROR]:Exception: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        this.debugString("[ERROR]:Exception: " + e.toString());
                    }
                    catch (Exception e) {
                        this.debugString("[ERROR]:Exception: " + e.toString());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
            catch (SecurityException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
        }
        return returnVal;
    }

    private static void registerVirtualFrame(final Accessible a, Integer nativeWindowHandle) {
        if (a != null) {
            AccessibleContext ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return a.getAccessibleContext();
                }
            }, a);
            windowHandleToContextMap.put(nativeWindowHandle, ac);
            contextToWindowHandleMap.put(ac, nativeWindowHandle);
        }
    }

    private static void revokeVirtualFrame(final Accessible a, Integer nativeWindowHandle) {
        AccessibleContext ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return a.getAccessibleContext();
            }
        }, a);
        windowHandleToContextMap.remove(nativeWindowHandle);
        contextToWindowHandleMap.remove(ac);
    }

    private static void addNativeWindowHandler(NativeWindowHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        nativeWindowHandlers.addElement(handler);
    }

    private static boolean removeNativeWindowHandler(NativeWindowHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        return nativeWindowHandlers.removeElement(handler);
    }

    private boolean isJavaWindow(int nativeHandle) {
        AccessibleContext ac = this.getContextFromNativeWindowHandle(nativeHandle);
        if (ac != null) {
            this.saveContextToWindowHandleMapping(ac, nativeHandle);
            return true;
        }
        return false;
    }

    private void saveContextToWindowHandleMapping(AccessibleContext ac, int nativeHandle) {
        this.debugString("[INFO]:saveContextToWindowHandleMapping...");
        if (ac == null) {
            return;
        }
        if (!contextToWindowHandleMap.containsKey(ac)) {
            this.debugString("[INFO]: saveContextToWindowHandleMapping: ac = " + ac + "; handle = " + nativeHandle);
            contextToWindowHandleMap.put(ac, nativeHandle);
        }
    }

    private AccessibleContext getContextFromNativeWindowHandle(int nativeHandle) {
        AccessibleContext ac = windowHandleToContextMap.get(nativeHandle);
        if (ac != null) {
            this.saveContextToWindowHandleMapping(ac, nativeHandle);
            return ac;
        }
        int numHandlers = nativeWindowHandlers.size();
        for (int i = 0; i < numHandlers; ++i) {
            NativeWindowHandler nextHandler = nativeWindowHandlers.elementAt(i);
            final Accessible a = nextHandler.getAccessibleFromNativeWindowHandle(nativeHandle);
            if (a == null) continue;
            ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return a.getAccessibleContext();
                }
            }, a);
            this.saveContextToWindowHandleMapping(ac, nativeHandle);
            return ac;
        }
        return null;
    }

    private int getNativeWindowHandleFromContext(AccessibleContext ac) {
        this.debugString("[INFO]: getNativeWindowHandleFromContext: ac = " + ac);
        try {
            return contextToWindowHandleMap.get(ac);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int getNativeWindowHandleFromComponent(final Component target) {
        if (this.useJAWT_DLL) {
            this.debugString("[INFO]:*** calling jawtGetNativeWindowHandleFromComponent");
            return this.jawtGetNativeWindowHandleFromComponent(target);
        }
        Object[] args = new Object[1];
        this.debugString("[INFO]:*** calling javaGetNativeWindowHandleFromComponent");
        if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
            try {
                args[0] = target;
                Integer i = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, args);
                AccessibleContext ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return target.getAccessibleContext();
                    }
                }, target);
                contextToWindowHandleMap.put(ac, i);
                return i;
            }
            catch (InvocationTargetException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
            catch (IllegalAccessException e) {
                this.debugString("[ERROR]:Exception: " + e.toString());
            }
        }
        return -1;
    }

    private AccessibleContext getAccessibleContextAt(int x, int y, AccessibleContext parent) {
        if (parent == null) {
            return null;
        }
        if (windowHandleToContextMap != null && windowHandleToContextMap.containsValue(this.getRootAccessibleContext(parent))) {
            return this.getAccessibleContextAt_1(x, y, parent);
        }
        return this.getAccessibleContextAt_2(x, y, parent);
    }

    private AccessibleContext getRootAccessibleContext(final AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible parent = ac.getAccessibleParent();
                if (parent == null) {
                    return ac;
                }
                Accessible tmp = parent.getAccessibleContext().getAccessibleParent();
                while (tmp != null) {
                    parent = tmp;
                    tmp = parent.getAccessibleContext().getAccessibleParent();
                }
                return parent.getAccessibleContext();
            }
        }, ac);
    }

    private AccessibleContext getAccessibleContextAt_1(final int x, int y, final AccessibleContext parent) {
        AccessibleContext foundAC;
        Point loc;
        Accessible a;
        this.debugString("[INFO]: getAccessibleContextAt_1 called");
        this.debugString("[INFO]:   -> x = " + x + " y = " + y + " parent = " + parent);
        if (parent == null) {
            return null;
        }
        final AccessibleComponent acmp = InvocationUtils.invokeAndWait(new Callable<AccessibleComponent>(){

            @Override
            public AccessibleComponent call() throws Exception {
                return parent.getAccessibleComponent();
            }
        }, parent);
        if (acmp != null && (a = InvocationUtils.invokeAndWait(new Callable<Accessible>(loc = InvocationUtils.invokeAndWait(new Callable<Point>(){

            @Override
            public Point call() throws Exception {
                return acmp.getLocation();
            }
        }, parent), y){
            final /* synthetic */ Point val$loc;
            final /* synthetic */ int val$y;
            {
                this.val$loc = point;
                this.val$y = n2;
            }

            @Override
            public Accessible call() throws Exception {
                return acmp.getAccessibleAt(new Point(x - this.val$loc.x, this.val$y - this.val$loc.y));
            }
        }, parent)) != null && (foundAC = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return a.getAccessibleContext();
            }
        }, parent)) != null) {
            if (foundAC != parent) {
                return this.getAccessibleContextAt_1(x - loc.x, y - loc.y, foundAC);
            }
            return foundAC;
        }
        return parent;
    }

    private AccessibleContext getAccessibleContextAt_2(final int x, final int y, AccessibleContext parent) {
        this.debugString("[INFO]: getAccessibleContextAt_2 called");
        this.debugString("[INFO]:   -> x = " + x + " y = " + y + " parent = " + parent);
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleContext childAC;
                Accessible a = EventQueueMonitor.getAccessibleAt(new Point(x, y));
                if (a != null && (childAC = a.getAccessibleContext()) != null) {
                    AccessBridge.this.debugString("[INFO]:   returning childAC = " + childAC);
                    return childAC;
                }
                return null;
            }
        }, parent);
    }

    private AccessibleContext getAccessibleContextWithFocus() {
        AccessibleContext ac;
        Accessible a;
        Component c = AWTEventMonitor.getComponentWithFocus();
        if (c != null && (a = Translator.getAccessible(c)) != null && (ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return a.getAccessibleContext();
            }
        }, c)) != null) {
            return ac;
        }
        return null;
    }

    private String getAccessibleNameFromContext(final AccessibleContext ac) {
        this.debugString("[INFO]: ***** ac = " + ac.getClass());
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ac.getAccessibleName();
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                this.debugString("[INFO]: Returning AccessibleName from Context: " + s);
                return s;
            }
            return null;
        }
        this.debugString("[INFO]: getAccessibleNameFromContext; ac = null!");
        return null;
    }

    private String getVirtualAccessibleNameFromContext(final AccessibleContext ac) {
        if (null != ac) {
            AccessibleRole childRole;
            AccessibleContext childContext;
            Accessible child;
            int childIndexTemp;
            AccessibleContext parentContextInnerTemp;
            int childIndex;
            String version;
            AccessibleContext parentContextInnerTemp2;
            String nameString = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ac.getAccessibleName();
                }
            }, ac);
            if (null != nameString && 0 != nameString.length()) {
                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleName.");
                this.references.increment(nameString);
                return nameString;
            }
            String descriptionString = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ac.getAccessibleDescription();
                }
            }, ac);
            if (null != descriptionString && 0 != descriptionString.length()) {
                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleDescription.");
                this.references.increment(descriptionString);
                return descriptionString;
            }
            this.debugString("[WARN]: The Virtual Accessible Name was not found using AccessibleContext::getAccessibleDescription. or getAccessibleName");
            boolean bExtendedSearch = false;
            AccessibleRole role = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                @Override
                public AccessibleRole call() throws Exception {
                    return ac.getAccessibleRole();
                }
            }, ac);
            AccessibleContext parentContext = null;
            AccessibleRole parentRole = AccessibleRole.UNKNOWN;
            if (this.extendedVirtualNameSearchRoles.contains(role) && null != (parentContext = this.getAccessibleParentFromContext(ac)) && AccessibleRole.UNKNOWN != (parentRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(parentContextInnerTemp2 = parentContext){
                final /* synthetic */ AccessibleContext val$parentContextInnerTemp;
                {
                    this.val$parentContextInnerTemp = accessibleContext;
                }

                @Override
                public AccessibleRole call() throws Exception {
                    return this.val$parentContextInnerTemp.getAccessibleRole();
                }
            }, ac))) {
                bExtendedSearch = true;
                if (this.noExtendedVirtualNameSearchParentRoles.contains(parentRole)) {
                    bExtendedSearch = false;
                }
            }
            if (!bExtendedSearch) {
                AccessibleValue av;
                this.debugString("[INFO]: bk -- getVirtualAccessibleNameFromContext will not use the extended name search algorithm.  role = " + (role != null ? role.toDisplayString(Locale.US) : "null"));
                if (AccessibleRole.LABEL == role) {
                    int charCount;
                    String text;
                    final AccessibleText at = InvocationUtils.invokeAndWait(new Callable<AccessibleText>(){

                        @Override
                        public AccessibleText call() throws Exception {
                            return ac.getAccessibleText();
                        }
                    }, ac);
                    if (null != at && null != (text = this.getAccessibleTextRangeFromContext(ac, 0, charCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            return at.getCharCount();
                        }
                    }, ac).intValue()))) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from the Accessible Text of the LABEL object.");
                        this.references.increment(text);
                        return text;
                    }
                    this.debugString("[INFO]: bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    final AccessibleIcon[] ai = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                        @Override
                        public AccessibleIcon[] call() throws Exception {
                            return ac.getAccessibleIcon();
                        }
                    }, ac);
                    if (null != ai && ai.length > 0) {
                        String iconDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return ai[0].getAccessibleIconDescription();
                            }
                        }, ac);
                        if (iconDescription != null) {
                            this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the LABEL object.");
                            this.references.increment(iconDescription);
                            return iconDescription;
                        }
                    } else {
                        AccessibleContext parentContextInnerTemp3;
                        parentContext = this.getAccessibleParentFromContext(ac);
                        if (null != parentContext && AccessibleRole.TABLE == (parentRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(parentContextInnerTemp3 = parentContext){
                            final /* synthetic */ AccessibleContext val$parentContextInnerTemp;
                            {
                                this.val$parentContextInnerTemp = accessibleContext;
                            }

                            @Override
                            public AccessibleRole call() throws Exception {
                                return this.val$parentContextInnerTemp.getAccessibleRole();
                            }
                        }, ac))) {
                            String iconDescription;
                            AccessibleIcon[] aiRet;
                            int indexInParent = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                                @Override
                                public Integer call() throws Exception {
                                    return ac.getAccessibleIndexInParent();
                                }
                            }, ac);
                            final AccessibleContext acTableCell = this.getAccessibleChildFromContext(parentContext, indexInParent);
                            this.debugString("[INFO]: bk -- Making a second attempt to obtain the Virtual Accessible Name from the Accessible Icon information for the Table Cell.");
                            if (acTableCell != null && null != (aiRet = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                                @Override
                                public AccessibleIcon[] call() throws Exception {
                                    return acTableCell.getAccessibleIcon();
                                }
                            }, ac)) && aiRet.length > 0 && (iconDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                                @Override
                                public String call() {
                                    return aiRet[0].getAccessibleIconDescription();
                                }
                            }, ac)) != null) {
                                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the Table Cell object.");
                                this.references.increment(iconDescription);
                                return iconDescription;
                            }
                        }
                    }
                } else if (AccessibleRole.TOGGLE_BUTTON == role || AccessibleRole.PUSH_BUTTON == role) {
                    String iconDescription;
                    this.debugString("[INFO]: bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    final AccessibleIcon[] ai = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                        @Override
                        public AccessibleIcon[] call() {
                            return ac.getAccessibleIcon();
                        }
                    }, ac);
                    if (null != ai && ai.length > 0 && (iconDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return ai[0].getAccessibleIconDescription();
                        }
                    }, ac)) != null) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the TOGGLE_BUTTON or PUSH_BUTTON object.");
                        this.references.increment(iconDescription);
                        return iconDescription;
                    }
                } else if (AccessibleRole.CHECK_BOX == role && null != (av = InvocationUtils.invokeAndWait(new Callable<AccessibleValue>(){

                    @Override
                    public AccessibleValue call() throws Exception {
                        return ac.getAccessibleValue();
                    }
                }, ac))) {
                    nameString = null;
                    Number value = InvocationUtils.invokeAndWait(new Callable<Number>(){

                        @Override
                        public Number call() throws Exception {
                            return av.getCurrentAccessibleValue();
                        }
                    }, ac);
                    if (null != value && null != (nameString = 1 == value.intValue() ? Boolean.TRUE.toString() : (0 == value.intValue() ? Boolean.FALSE.toString() : value.toString()))) {
                        this.references.increment(nameString);
                        return nameString;
                    }
                }
                return null;
            }
            final AccessibleContext parentContextOuterTemp = parentContext;
            String parentName = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return parentContextOuterTemp.getAccessibleName();
                }
            }, ac);
            String parentDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return parentContextOuterTemp.getAccessibleDescription();
                }
            }, ac);
            if (AccessibleRole.SLIDER == role && AccessibleRole.PANEL == parentRole && null != parentName) {
                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from the Accessible Name of the SLIDER object's parent object.");
                this.references.increment(parentName);
                return parentName;
            }
            boolean bIsEditCombo = false;
            AccessibleContext testContext = ac;
            if (AccessibleRole.TEXT == role && AccessibleRole.COMBO_BOX == parentRole) {
                bIsEditCombo = true;
                if (null != parentName) {
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Name of the object's parent object.");
                    this.references.increment(parentName);
                    return parentName;
                }
                if (null != parentDescription) {
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Description of the object's parent object.");
                    this.references.increment(parentDescription);
                    return parentDescription;
                }
                testContext = parentContext;
                parentRole = AccessibleRole.UNKNOWN;
                parentContext = this.getAccessibleParentFromContext(testContext);
                if (null != parentContext) {
                    final AccessibleContext parentContextInnerTemp4 = parentContext;
                    parentRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                        @Override
                        public AccessibleRole call() throws Exception {
                            return parentContextInnerTemp4.getAccessibleRole();
                        }
                    }, ac);
                }
            }
            if (null != (version = this.getJavaVersionProperty()) && version.compareTo("1.3") >= 0) {
                AccessibleContext labelContext;
                Object[] targets;
                Object o;
                AccessibleRelation labeledByRelation;
                final AccessibleContext parentContextTempInner = parentContext;
                AccessibleRelationSet ars = InvocationUtils.invokeAndWait(new Callable<AccessibleRelationSet>(){

                    @Override
                    public AccessibleRelationSet call() throws Exception {
                        return parentContextTempInner.getAccessibleRelationSet();
                    }
                }, ac);
                if (ars != null && ars.size() > 0 && ars.contains(AccessibleRelation.LABELED_BY) && (labeledByRelation = ars.get(AccessibleRelation.LABELED_BY)) != null && (o = (targets = labeledByRelation.getTarget())[0]) instanceof Accessible && (labelContext = ((Accessible)o).getAccessibleContext()) != null) {
                    String labelName = labelContext.getAccessibleName();
                    String labelDescription = labelContext.getAccessibleDescription();
                    if (null != labelName) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Name Case.");
                        this.references.increment(labelName);
                        return labelName;
                    }
                    if (null != labelDescription) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Description Case.");
                        this.references.increment(labelDescription);
                        return labelDescription;
                    }
                }
            } else {
                this.debugString("[ERROR]:bk -- This version of Java does not support AccessibleContext::getAccessibleRelationSet.");
            }
            int testIndexMax = 0;
            int testX = 0;
            int testY = 0;
            int testWidth = 0;
            int testHeight = 0;
            int targetX = 0;
            int targetY = 0;
            final AccessibleContext tempContext = testContext;
            int testIndex = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return tempContext.getAccessibleIndexInParent();
                }
            }, ac);
            if (null != parentContext) {
                final AccessibleContext parentContextInnerTemp5 = parentContext;
                testIndexMax = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return parentContextInnerTemp5.getAccessibleChildrenCount() - 1;
                    }
                }, ac);
            }
            testX = this.getAccessibleXcoordFromContext(testContext);
            testY = this.getAccessibleYcoordFromContext(testContext);
            testWidth = this.getAccessibleWidthFromContext(testContext);
            testHeight = this.getAccessibleHeightFromContext(testContext);
            targetX = testX + 2;
            targetY = testY + 2;
            int childX = 0;
            int childY = 0;
            int childWidth = 0;
            int childHeight = 0;
            String childName = null;
            String childDescription = null;
            for (childIndex = testIndex - 1; childIndex >= 0; --childIndex) {
                parentContextInnerTemp = parentContext;
                childIndexTemp = childIndex;
                child = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                    @Override
                    public Accessible call() throws Exception {
                        return parentContextInnerTemp.getAccessibleChild(childIndexTemp);
                    }
                }, ac);
                if (null == child || null == (childContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return child.getAccessibleContext();
                    }
                }, ac)) || AccessibleRole.LABEL != (childRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                    @Override
                    public AccessibleRole call() throws Exception {
                        return childContext.getAccessibleRole();
                    }
                }, ac))) continue;
                childX = this.getAccessibleXcoordFromContext(childContext);
                childY = this.getAccessibleYcoordFromContext(childContext);
                childWidth = this.getAccessibleWidthFromContext(childContext);
                childHeight = this.getAccessibleHeightFromContext(childContext);
                if (childX < testX && childY <= targetY && targetY <= childY + childHeight) {
                    childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleName();
                        }
                    }, ac);
                    if (null != childName) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleDescription();
                        }
                    }, ac);
                    if (null == childDescription) continue;
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                if (childY >= targetY || childX > targetX || targetX > childX + childWidth) continue;
                childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return childContext.getAccessibleName();
                    }
                }, ac);
                if (null != childName) {
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(childName);
                    return childName;
                }
                childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return childContext.getAccessibleDescription();
                    }
                }, ac);
                if (null == childDescription) continue;
                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(childDescription);
                return childDescription;
            }
            for (childIndex = testIndex + 1; childIndex <= testIndexMax; ++childIndex) {
                parentContextInnerTemp = parentContext;
                childIndexTemp = childIndex;
                child = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                    @Override
                    public Accessible call() throws Exception {
                        return parentContextInnerTemp.getAccessibleChild(childIndexTemp);
                    }
                }, ac);
                if (null == child || null == (childContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return child.getAccessibleContext();
                    }
                }, ac)) || AccessibleRole.LABEL != (childRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                    @Override
                    public AccessibleRole call() throws Exception {
                        return childContext.getAccessibleRole();
                    }
                }, ac))) continue;
                childX = this.getAccessibleXcoordFromContext(childContext);
                childY = this.getAccessibleYcoordFromContext(childContext);
                childWidth = this.getAccessibleWidthFromContext(childContext);
                childHeight = this.getAccessibleHeightFromContext(childContext);
                if (childX < testX && childY <= targetY && targetY <= childY + childHeight) {
                    childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleName();
                        }
                    }, ac);
                    if (null != childName) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleDescription();
                        }
                    }, ac);
                    if (null == childDescription) continue;
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                if (childY >= targetY || childX > targetX || targetX > childX + childWidth) continue;
                childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return childContext.getAccessibleName();
                    }
                }, ac);
                if (null != childName) {
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(childName);
                    return childName;
                }
                childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return childContext.getAccessibleDescription();
                    }
                }, ac);
                if (null == childDescription) continue;
                this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(childDescription);
                return childDescription;
            }
            if (AccessibleRole.TEXT == role || AccessibleRole.COMBO_BOX == role || bIsEditCombo) {
                for (childIndex = testIndex - 1; childIndex >= 0; --childIndex) {
                    parentContextInnerTemp = parentContext;
                    childIndexTemp = childIndex;
                    child = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                        @Override
                        public Accessible call() throws Exception {
                            return parentContextInnerTemp.getAccessibleChild(childIndexTemp);
                        }
                    }, ac);
                    if (null == child || null == (childContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                        @Override
                        public AccessibleContext call() throws Exception {
                            return child.getAccessibleContext();
                        }
                    }, ac)) || AccessibleRole.PUSH_BUTTON != (childRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                        @Override
                        public AccessibleRole call() throws Exception {
                            return childContext.getAccessibleRole();
                        }
                    }, ac)) && AccessibleRole.TOGGLE_BUTTON != childRole) continue;
                    childX = this.getAccessibleXcoordFromContext(childContext);
                    childY = this.getAccessibleYcoordFromContext(childContext);
                    childWidth = this.getAccessibleWidthFromContext(childContext);
                    childHeight = this.getAccessibleHeightFromContext(childContext);
                    if (childX >= testX || childY > targetY || targetY > childY + childHeight) continue;
                    childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleName();
                        }
                    }, ac);
                    if (null != childName) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleDescription();
                        }
                    }, ac);
                    if (null == childDescription) continue;
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                for (childIndex = testIndex + 1; childIndex <= testIndexMax; ++childIndex) {
                    parentContextInnerTemp = parentContext;
                    childIndexTemp = childIndex;
                    child = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                        @Override
                        public Accessible call() throws Exception {
                            return parentContextInnerTemp.getAccessibleChild(childIndexTemp);
                        }
                    }, ac);
                    if (null == child || null == (childContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                        @Override
                        public AccessibleContext call() throws Exception {
                            return child.getAccessibleContext();
                        }
                    }, ac)) || AccessibleRole.PUSH_BUTTON != (childRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                        @Override
                        public AccessibleRole call() throws Exception {
                            return childContext.getAccessibleRole();
                        }
                    }, ac)) && AccessibleRole.TOGGLE_BUTTON != childRole) continue;
                    childX = this.getAccessibleXcoordFromContext(childContext);
                    childY = this.getAccessibleYcoordFromContext(childContext);
                    childWidth = this.getAccessibleWidthFromContext(childContext);
                    childHeight = this.getAccessibleHeightFromContext(childContext);
                    if (childX >= testX || childY > targetY || targetY > childY + childHeight) continue;
                    childName = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleName();
                        }
                    }, ac);
                    if (null != childName) {
                        this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return childContext.getAccessibleDescription();
                        }
                    }, ac);
                    if (null == childDescription) continue;
                    this.debugString("[INFO]: bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
            }
            return null;
        }
        this.debugString("[ERROR]: AccessBridge::getVirtualAccessibleNameFromContext error - ac == null.");
        return null;
    }

    private String getAccessibleDescriptionFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ac.getAccessibleDescription();
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                this.debugString("[INFO]: Returning AccessibleDescription from Context: " + s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleDescriptionFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleRoleStringFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleRole role = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                @Override
                public AccessibleRole call() throws Exception {
                    return ac.getAccessibleRole();
                }
            }, ac);
            if (role != null && (s = role.toDisplayString(Locale.US)) != null) {
                this.references.increment(s);
                this.debugString("[INFO]: Returning AccessibleRole from Context: " + s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleRoleStringFromContext_en_US(AccessibleContext ac) {
        return this.getAccessibleRoleStringFromContext(ac);
    }

    private String getAccessibleStatesStringFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleStateSet stateSet = InvocationUtils.invokeAndWait(new Callable<AccessibleStateSet>(){

                @Override
                public AccessibleStateSet call() throws Exception {
                    return ac.getAccessibleStateSet();
                }
            }, ac);
            if (stateSet != null && (s = stateSet.toString()) != null && s.indexOf(AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US)) == -1) {
                AccessibleRole role = InvocationUtils.invokeAndWait(() -> ac.getAccessibleRole(), ac);
                if (role == AccessibleRole.LIST || role == AccessibleRole.TABLE || role == AccessibleRole.TREE) {
                    s = s + ",";
                    s = s + AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US);
                }
                this.references.increment(s);
                this.debugString("[INFO]: Returning AccessibleStateSet from Context: " + s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleStatesStringFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleStatesStringFromContext_en_US(final AccessibleContext ac) {
        AccessibleStateSet stateSet;
        if (ac != null && (stateSet = InvocationUtils.invokeAndWait(new Callable<AccessibleStateSet>(){

            @Override
            public AccessibleStateSet call() throws Exception {
                return ac.getAccessibleStateSet();
            }
        }, ac)) != null) {
            String s = "";
            AccessibleState[] states = stateSet.toArray();
            if (states != null && states.length > 0) {
                s = states[0].toDisplayString(Locale.US);
                for (int i = 1; i < states.length; ++i) {
                    s = s + "," + states[i].toDisplayString(Locale.US);
                }
            }
            this.references.increment(s);
            this.debugString("[INFO]: Returning AccessibleStateSet en_US from Context: " + s);
            return s;
        }
        this.debugString("[ERROR]: getAccessibleStatesStringFromContext; ac = null");
        return null;
    }

    private int getNonVisibleChildrenCountTillIndex(AccessibleContext parentAC, int index) {
        if (parentAC != null && index >= 0 && index < parentAC.getAccessibleChildrenCount()) {
            int nonVisibleChildrenCount = 0;
            for (int i = 0; i <= index; ++i) {
                if (parentAC.getAccessibleChild(i).getAccessibleContext().getAccessibleStateSet().contains(AccessibleState.VISIBLE)) continue;
                ++nonVisibleChildrenCount;
            }
            return nonVisibleChildrenCount;
        }
        return 0;
    }

    private Accessible getVisibleChildAtIndex(AccessibleContext parentAC, int index) {
        if (parentAC != null && index >= 0 && index < parentAC.getAccessibleChildrenCount()) {
            int visibleIndex = -1;
            int childrenCount = parentAC.getAccessibleChildrenCount();
            for (int i = 0; i <= childrenCount; ++i) {
                Accessible child = parentAC.getAccessibleChild(i);
                if (child == null) continue;
                AccessibleContext ac = child.getAccessibleContext();
                if (ac != null && ac.getAccessibleStateSet().contains(AccessibleState.VISIBLE)) {
                    ++visibleIndex;
                }
                if (visibleIndex != index) continue;
                return child;
            }
        }
        return null;
    }

    private AccessibleContext getAccessibleParentFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleContext apc;
                Accessible a = ac.getAccessibleParent();
                if (a != null && (apc = a.getAccessibleContext()) != null) {
                    return apc;
                }
                return null;
            }
        }, ac);
    }

    private int getAccessibleIndexInParentFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int indexInParent = ac.getAccessibleIndexInParent();
                Accessible parent = ac.getAccessibleParent();
                if (parent != null) {
                    indexInParent -= AccessBridge.this.getNonVisibleChildrenCountTillIndex(parent.getAccessibleContext(), indexInParent);
                }
                return indexInParent;
            }
        }, ac);
    }

    private int getAccessibleChildrenCountFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int childrenCount = ac.getAccessibleChildrenCount();
                return childrenCount - AccessBridge.this.getNonVisibleChildrenCountTillIndex(ac, childrenCount - 1);
            }
        }, ac);
    }

    private AccessibleContext getAccessibleChildFromContext(final AccessibleContext ac, final int index) {
        if (ac == null) {
            return null;
        }
        final JTable table = InvocationUtils.invokeAndWait(new Callable<JTable>(){

            @Override
            public JTable call() throws Exception {
                Accessible parent = ac.getAccessibleParent();
                if (parent != null) {
                    int indexInParent = ac.getAccessibleIndexInParent();
                    Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                    if (child instanceof JTable) {
                        return (JTable)child;
                    }
                }
                return null;
            }
        }, ac);
        if (table == null) {
            return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible a = AccessBridge.this.getVisibleChildAtIndex(ac, index);
                    if (a != null) {
                        return a.getAccessibleContext();
                    }
                    return null;
                }
            }, ac);
        }
        AccessibleTable at = this.getAccessibleTableFromContext(ac);
        final int row = this.getAccessibleTableRow(at, index);
        final int column = this.getAccessibleTableColumn(at, index);
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Component component;
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                if (renderer == null) {
                    Class<?> columnClass = table.getColumnClass(column);
                    renderer = table.getDefaultRenderer(columnClass);
                }
                if ((component = renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column)) instanceof Accessible) {
                    return component.getAccessibleContext();
                }
                return null;
            }
        }, ac);
    }

    private Rectangle getAccessibleBoundsOnScreenFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle r;
                AccessibleComponent acmp = ac.getAccessibleComponent();
                if (acmp != null && (r = acmp.getBounds()) != null) {
                    try {
                        Point p = acmp.getLocationOnScreen();
                        if (p != null) {
                            r.x = p.x;
                            r.y = p.y;
                            return r;
                        }
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
        }, ac);
    }

    private int getAccessibleXcoordFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                this.debugString("[INFO]: Returning Accessible x coord from Context: " + r.x);
                return r.x;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleXcoordFromContext ac = null");
        }
        return -1;
    }

    private int getAccessibleYcoordFromContext(AccessibleContext ac) {
        this.debugString("[INFO]: getAccessibleYcoordFromContext() called");
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.y;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleYcoordFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleHeightFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.height;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleHeightFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleWidthFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.width;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleWidthFromContext; ac = null");
        }
        return -1;
    }

    private AccessibleComponent getAccessibleComponentFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleComponent acmp = InvocationUtils.invokeAndWait(() -> ac.getAccessibleComponent(), ac);
            if (acmp != null) {
                this.debugString("[INFO]: Returning AccessibleComponent Context");
                return acmp;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleComponentFromContext; ac = null");
        }
        return null;
    }

    private AccessibleAction getAccessibleActionFromContext(final AccessibleContext ac) {
        this.debugString("[INFO]: Returning AccessibleAction Context");
        return ac == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleAction>(){

            @Override
            public AccessibleAction call() throws Exception {
                return ac.getAccessibleAction();
            }
        }, ac);
    }

    private AccessibleSelection getAccessibleSelectionFromContext(final AccessibleContext ac) {
        return ac == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleSelection>(){

            @Override
            public AccessibleSelection call() throws Exception {
                return ac.getAccessibleSelection();
            }
        }, ac);
    }

    private AccessibleText getAccessibleTextFromContext(final AccessibleContext ac) {
        return ac == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleText>(){

            @Override
            public AccessibleText call() throws Exception {
                return ac.getAccessibleText();
            }
        }, ac);
    }

    private AccessibleValue getAccessibleValueFromContext(final AccessibleContext ac) {
        return ac == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleValue>(){

            @Override
            public AccessibleValue call() throws Exception {
                return ac.getAccessibleValue();
            }
        }, ac);
    }

    private Rectangle getCaretLocation(final AccessibleContext ac) {
        this.debugString("[INFO]: getCaretLocation");
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle r = null;
                Accessible parent = ac.getAccessibleParent();
                if (parent instanceof Accessible) {
                    int indexInParent = ac.getAccessibleIndexInParent();
                    Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                    if (child instanceof JTextComponent) {
                        JTextComponent text = (JTextComponent)child;
                        try {
                            r = text.modelToView(text.getCaretPosition());
                            if (r != null) {
                                Point p = text.getLocationOnScreen();
                                r.translate(p.x, p.y);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                return r;
            }
        }, ac);
    }

    private int getCaretLocationX(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.x;
        }
        return -1;
    }

    private int getCaretLocationY(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.y;
        }
        return -1;
    }

    private int getCaretLocationHeight(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.height;
        }
        return -1;
    }

    private int getCaretLocationWidth(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.width;
        }
        return -1;
    }

    private int getAccessibleCharCountFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    return at.getCharCount();
                }
                return -1;
            }
        }, ac);
    }

    private int getAccessibleCaretPositionFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    return at.getCaretPosition();
                }
                return -1;
            }
        }, ac);
    }

    private int getAccessibleIndexAtPointFromContext(final AccessibleContext ac, final int x, final int y) {
        this.debugString("[INFO]: getAccessibleIndexAtPointFromContext: x = " + x + "; y = " + y);
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                AccessibleComponent acomp = ac.getAccessibleComponent();
                if (at != null && acomp != null) {
                    try {
                        Point p = acomp.getLocationOnScreen();
                        if (p != null) {
                            int y1;
                            int x1 = x - p.x;
                            if (x1 < 0) {
                                x1 = 0;
                            }
                            if ((y1 = y - p.y) < 0) {
                                y1 = 0;
                            }
                            Point newPoint = new Point(x1, y1);
                            int indexAtPoint = at.getIndexAtPoint(new Point(x1, y1));
                            return indexAtPoint;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return -1;
            }
        }, ac);
    }

    private String getAccessibleLetterAtIndexFromContext(final AccessibleContext ac, final int index) {
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText at = ac.getAccessibleText();
                    if (at == null) {
                        return null;
                    }
                    return at.getAtIndex(1, index);
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleLetterAtIndexFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleWordAtIndexFromContext(final AccessibleContext ac, final int index) {
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText at = ac.getAccessibleText();
                    if (at == null) {
                        return null;
                    }
                    return at.getAtIndex(2, index);
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleWordAtIndexFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleSentenceAtIndexFromContext(final AccessibleContext ac, final int index) {
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText at = ac.getAccessibleText();
                    if (at == null) {
                        return null;
                    }
                    return at.getAtIndex(3, index);
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleSentenceAtIndexFromContext; ac = null");
        }
        return null;
    }

    private int getAccessibleTextSelectionStartFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    return at.getSelectionStart();
                }
                return -1;
            }
        }, ac);
    }

    private int getAccessibleTextSelectionEndFromContext(final AccessibleContext ac) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    return at.getSelectionEnd();
                }
                return -1;
            }
        }, ac);
    }

    private String getAccessibleTextSelectedTextFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText at = ac.getAccessibleText();
                    if (at == null) {
                        return null;
                    }
                    return at.getSelectedText();
                }
            }, ac);
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleTextSelectedTextFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleAttributesAtIndexFromContext(final AccessibleContext ac, final int index) {
        if (ac == null) {
            return null;
        }
        AttributeSet as = InvocationUtils.invokeAndWait(new Callable<AttributeSet>(){

            @Override
            public AttributeSet call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    return at.getCharacterAttribute(index);
                }
                return null;
            }
        }, ac);
        String s = this.expandStyleConstants(as);
        if (s != null) {
            this.references.increment(s);
            return s;
        }
        return null;
    }

    private int getAccessibleTextLineLeftBoundsFromContext(final AccessibleContext ac, final int index) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    Rectangle indexRect = at.getCharacterBounds(index);
                    int textLen = at.getCharCount();
                    if (indexRect == null) {
                        return -1;
                    }
                    int offset = 1;
                    int lineStart = index - offset < 0 ? 0 : index - offset;
                    Rectangle charRect = at.getCharacterBounds(lineStart);
                    while (charRect != null && charRect.y >= indexRect.y && lineStart > 0) {
                        lineStart = index - (offset <<= 1) < 0 ? 0 : index - offset;
                        charRect = at.getCharacterBounds(lineStart);
                    }
                    if (lineStart != 0) {
                        offset >>= 1;
                        while (offset > 0) {
                            charRect = at.getCharacterBounds(lineStart + offset);
                            if (charRect.y < indexRect.y) {
                                lineStart += offset;
                            }
                            offset >>= 1;
                        }
                        ++lineStart;
                    }
                    return lineStart;
                }
                return -1;
            }
        }, ac);
    }

    private int getAccessibleTextLineRightBoundsFromContext(final AccessibleContext ac, final int index) {
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (at != null) {
                    Rectangle indexRect = at.getCharacterBounds(index);
                    int textLen = at.getCharCount();
                    if (indexRect == null) {
                        return -1;
                    }
                    int offset = 1;
                    int lineEnd = index + offset > textLen - 1 ? textLen - 1 : index + offset;
                    Rectangle charRect = at.getCharacterBounds(lineEnd);
                    while (charRect != null && charRect.y <= indexRect.y && lineEnd < textLen - 1) {
                        lineEnd = index + (offset <<= 1) > textLen - 1 ? textLen - 1 : index + offset;
                        charRect = at.getCharacterBounds(lineEnd);
                    }
                    if (lineEnd != textLen - 1) {
                        offset >>= 1;
                        while (offset > 0) {
                            charRect = at.getCharacterBounds(lineEnd - offset);
                            if (charRect.y > indexRect.y) {
                                lineEnd -= offset;
                            }
                            offset >>= 1;
                        }
                        --lineEnd;
                    }
                    return lineEnd;
                }
                return -1;
            }
        }, ac);
    }

    private String getAccessibleTextRangeFromContext(final AccessibleContext ac, final int start, final int end) {
        String s = InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleText at;
                if (ac != null && (at = ac.getAccessibleText()) != null) {
                    if (start > end) {
                        return null;
                    }
                    if (end >= at.getCharCount()) {
                        return null;
                    }
                    StringBuffer buf = new StringBuffer(end - start + 1);
                    for (int i = start; i <= end; ++i) {
                        buf.append(at.getAtIndex(1, i));
                    }
                    return buf.toString();
                }
                return null;
            }
        }, ac);
        if (s != null) {
            this.references.increment(s);
            return s;
        }
        return null;
    }

    private AttributeSet getAccessibleAttributeSetAtIndexFromContext(final AccessibleContext ac, final int index) {
        return InvocationUtils.invokeAndWait(new Callable<AttributeSet>(){

            @Override
            public AttributeSet call() throws Exception {
                AttributeSet as;
                AccessibleText at;
                if (ac != null && (at = ac.getAccessibleText()) != null && (as = at.getCharacterAttribute(index)) != null) {
                    AccessBridge.this.references.increment(as);
                    return as;
                }
                return null;
            }
        }, ac);
    }

    private Rectangle getAccessibleTextRectAtIndexFromContext(final AccessibleContext ac, final int index) {
        Rectangle r = InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle rect;
                AccessibleText at;
                if (ac != null && (at = ac.getAccessibleText()) != null && (rect = at.getCharacterBounds(index)) != null) {
                    String s = at.getAtIndex(1, index);
                    if (s != null && s.equals("\n")) {
                        rect.width = 0;
                    }
                    return rect;
                }
                return null;
            }
        }, ac);
        Rectangle acRect = this.getAccessibleBoundsOnScreenFromContext(ac);
        if (r != null && acRect != null) {
            r.translate(acRect.x, acRect.y);
            return r;
        }
        return null;
    }

    private int getAccessibleXcoordTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.x;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleXcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleYcoordTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.y;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleYcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleHeightTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.height;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleHeightTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleWidthTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.width;
            }
        } else {
            this.debugString("[ERROR]: getAccessibleWidthTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private boolean getBoldFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isBold(as);
        }
        this.debugString("[ERROR]: getBoldFromAttributeSet; as = null");
        return false;
    }

    private boolean getItalicFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isItalic(as);
        }
        this.debugString("[ERROR]: getItalicFromAttributeSet; as = null");
        return false;
    }

    private boolean getUnderlineFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isUnderline(as);
        }
        this.debugString("[ERROR]: getUnderlineFromAttributeSet; as = null");
        return false;
    }

    private boolean getStrikethroughFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isStrikeThrough(as);
        }
        this.debugString("[ERROR]: getStrikethroughFromAttributeSet; as = null");
        return false;
    }

    private boolean getSuperscriptFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isSuperscript(as);
        }
        this.debugString("[ERROR]: getSuperscriptFromAttributeSet; as = null");
        return false;
    }

    private boolean getSubscriptFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isSubscript(as);
        }
        this.debugString("[ERROR]: getSubscriptFromAttributeSet; as = null");
        return false;
    }

    private String getBackgroundColorFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getBackground(as).toString();
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getBackgroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    private String getForegroundColorFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getForeground(as).toString();
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getForegroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    private String getFontFamilyFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getFontFamily(as).toString();
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getFontFamilyFromAttributeSet; as = null");
        }
        return null;
    }

    private int getFontSizeFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getFontSize(as);
        }
        this.debugString("[ERROR]: getFontSizeFromAttributeSet; as = null");
        return -1;
    }

    private int getAlignmentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getAlignment(as);
        }
        this.debugString("[ERROR]: getAlignmentFromAttributeSet; as = null");
        return -1;
    }

    private int getBidiLevelFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getBidiLevel(as);
        }
        this.debugString("[ERROR]: getBidiLevelFromAttributeSet; as = null");
        return -1;
    }

    private float getFirstLineIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getFirstLineIndent(as);
        }
        this.debugString("[ERROR]: getFirstLineIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getLeftIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getLeftIndent(as);
        }
        this.debugString("[ERROR]: getLeftIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getRightIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getRightIndent(as);
        }
        this.debugString("[ERROR]: getRightIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getLineSpacingFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getLineSpacing(as);
        }
        this.debugString("[ERROR]: getLineSpacingFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getSpaceAboveFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getSpaceAbove(as);
        }
        this.debugString("[ERROR]: getSpaceAboveFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getSpaceBelowFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getSpaceBelow(as);
        }
        this.debugString("[ERROR]: getSpaceBelowFromAttributeSet; as = null");
        return -1.0f;
    }

    private String expandStyleConstants(AttributeSet as) {
        Color c;
        Icon i;
        String attrString = "";
        attrString = attrString + "BidiLevel = " + StyleConstants.getBidiLevel(as);
        final Component comp = StyleConstants.getComponent(as);
        if (comp != null) {
            AccessibleContext ac;
            attrString = comp instanceof Accessible ? ((ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return comp.getAccessibleContext();
                }
            }, comp)) != null ? attrString + "; Accessible Component = " + InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ac.getAccessibleName();
                }
            }, ac) : attrString + "; Innaccessible Component = " + comp) : attrString + "; Innaccessible Component = " + comp;
        }
        if ((i = StyleConstants.getIcon(as)) != null) {
            attrString = i instanceof ImageIcon ? attrString + "; ImageIcon = " + ((ImageIcon)i).getDescription() : attrString + "; Icon = " + i;
        }
        attrString = attrString + "; FontFamily = " + StyleConstants.getFontFamily(as);
        attrString = attrString + "; FontSize = " + StyleConstants.getFontSize(as);
        if (StyleConstants.isBold(as)) {
            attrString = attrString + "; bold";
        }
        if (StyleConstants.isItalic(as)) {
            attrString = attrString + "; italic";
        }
        if (StyleConstants.isUnderline(as)) {
            attrString = attrString + "; underline";
        }
        if (StyleConstants.isStrikeThrough(as)) {
            attrString = attrString + "; strikethrough";
        }
        if (StyleConstants.isSuperscript(as)) {
            attrString = attrString + "; superscript";
        }
        if (StyleConstants.isSubscript(as)) {
            attrString = attrString + "; subscript";
        }
        if ((c = StyleConstants.getForeground(as)) != null) {
            attrString = attrString + "; Foreground = " + c;
        }
        if ((c = StyleConstants.getBackground(as)) != null) {
            attrString = attrString + "; Background = " + c;
        }
        attrString = attrString + "; FirstLineIndent = " + StyleConstants.getFirstLineIndent(as);
        attrString = attrString + "; RightIndent = " + StyleConstants.getRightIndent(as);
        attrString = attrString + "; LeftIndent = " + StyleConstants.getLeftIndent(as);
        attrString = attrString + "; LineSpacing = " + StyleConstants.getLineSpacing(as);
        attrString = attrString + "; SpaceAbove = " + StyleConstants.getSpaceAbove(as);
        attrString = attrString + "; SpaceBelow = " + StyleConstants.getSpaceBelow(as);
        attrString = attrString + "; Alignment = " + StyleConstants.getAlignment(as);
        TabSet ts = StyleConstants.getTabSet(as);
        if (ts != null) {
            attrString = attrString + "; TabSet = " + ts;
        }
        return attrString;
    }

    private String getCurrentAccessibleValueFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue av = ac.getAccessibleValue();
                    if (av == null) {
                        return null;
                    }
                    return av.getCurrentAccessibleValue();
                }
            }, ac);
            if (value != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getCurrentAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private String getMaximumAccessibleValueFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue av = ac.getAccessibleValue();
                    if (av == null) {
                        return null;
                    }
                    return av.getMaximumAccessibleValue();
                }
            }, ac);
            if (value != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getMaximumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private String getMinimumAccessibleValueFromContext(final AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue av = ac.getAccessibleValue();
                    if (av == null) {
                        return null;
                    }
                    return av.getMinimumAccessibleValue();
                }
            }, ac);
            if (value != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("[ERROR]: getMinimumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private void addAccessibleSelectionFromContext(final AccessibleContext ac, final int i) {
        try {
            InvocationUtils.invokeAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AccessibleSelection as;
                    if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                        as.addAccessibleSelection(i);
                    }
                    return null;
                }
            }, ac);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearAccessibleSelectionFromContext(final AccessibleContext ac) {
        try {
            InvocationUtils.invokeAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AccessibleSelection as = ac.getAccessibleSelection();
                    if (as != null) {
                        as.clearAccessibleSelection();
                    }
                    return null;
                }
            }, ac);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AccessibleContext getAccessibleSelectionFromContext(final AccessibleContext ac, final int i) {
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleSelection as;
                if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                    Accessible a = as.getAccessibleSelection(i);
                    if (a == null) {
                        return null;
                    }
                    return a.getAccessibleContext();
                }
                return null;
            }
        }, ac);
    }

    private int getAccessibleSelectionCountFromContext(final AccessibleContext ac) {
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleSelection as;
                if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                    return as.getAccessibleSelectionCount();
                }
                return -1;
            }
        }, ac);
    }

    private boolean isAccessibleChildSelectedFromContext(final AccessibleContext ac, final int i) {
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleSelection as;
                if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                    return as.isAccessibleChildSelected(i);
                }
                return false;
            }
        }, ac);
    }

    private void removeAccessibleSelectionFromContext(final AccessibleContext ac, final int i) {
        InvocationUtils.invokeAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AccessibleSelection as;
                if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                    as.removeAccessibleSelection(i);
                }
                return null;
            }
        }, ac);
    }

    private void selectAllAccessibleSelectionFromContext(final AccessibleContext ac) {
        InvocationUtils.invokeAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AccessibleSelection as;
                if (ac != null && (as = ac.getAccessibleSelection()) != null) {
                    as.selectAllAccessibleSelection();
                }
                return null;
            }
        }, ac);
    }

    private AccessibleTable getAccessibleTableFromContext(final AccessibleContext ac) {
        String version = this.getJavaVersionProperty();
        if (version != null && version.compareTo("1.3") >= 0) {
            return InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

                @Override
                public AccessibleTable call() throws Exception {
                    AccessibleTable at;
                    if (ac != null && (at = ac.getAccessibleTable()) != null) {
                        AccessBridge.this.hashtab.put(at, ac);
                        return at;
                    }
                    return null;
                }
            }, ac);
        }
        return null;
    }

    private AccessibleContext getContextFromAccessibleTable(AccessibleTable at) {
        return this.hashtab.get(at);
    }

    private int getAccessibleTableRowCount(final AccessibleContext ac) {
        this.debugString("[INFO]: ##### getAccessibleTableRowCount");
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleTable at;
                if (ac != null && (at = ac.getAccessibleTable()) != null) {
                    return at.getAccessibleRowCount();
                }
                return -1;
            }
        }, ac);
    }

    private int getAccessibleTableColumnCount(final AccessibleContext ac) {
        this.debugString("[INFO]: ##### getAccessibleTableColumnCount");
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleTable at;
                if (ac != null && (at = ac.getAccessibleTable()) != null) {
                    return at.getAccessibleColumnCount();
                }
                return -1;
            }
        }, ac);
    }

    private AccessibleContext getAccessibleTableCellAccessibleContext(final AccessibleTable at, final int row, final int column) {
        this.debugString("[INFO]: getAccessibleTableCellAccessibleContext: at = " + at.getClass());
        if (at == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                if (!(at instanceof AccessibleContext)) {
                    Accessible a = at.getAccessibleAt(row, column);
                    if (a != null) {
                        return a.getAccessibleContext();
                    }
                } else {
                    AccessibleContext ac = (AccessibleContext)((Object)at);
                    Accessible parent = ac.getAccessibleParent();
                    if (parent != null) {
                        int indexInParent = ac.getAccessibleIndexInParent();
                        Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                        if (child instanceof JTable) {
                            Component component;
                            JTable table = (JTable)child;
                            TableCellRenderer renderer = table.getCellRenderer(row, column);
                            if (renderer == null) {
                                Class<?> columnClass = table.getColumnClass(column);
                                renderer = table.getDefaultRenderer(columnClass);
                            }
                            if ((component = renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column)) instanceof Accessible) {
                                return component.getAccessibleContext();
                            }
                        }
                    }
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private int getAccessibleTableCellIndex(final AccessibleTable at, int row, int column) {
        this.debugString("[INFO]: ##### getAccessibleTableCellIndex: at=" + at);
        if (at != null) {
            int cellIndex = row * InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return at.getAccessibleColumnCount();
                }
            }, this.getContextFromAccessibleTable(at)) + column;
            this.debugString("[INFO]:    ##### getAccessibleTableCellIndex=" + cellIndex);
            return cellIndex;
        }
        this.debugString("[ERROR]: ##### getAccessibleTableCellIndex FAILED");
        return -1;
    }

    private int getAccessibleTableCellRowExtent(final AccessibleTable at, final int row, final int column) {
        this.debugString("[INFO]: ##### getAccessibleTableCellRowExtent");
        if (at != null) {
            int rowExtent = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return at.getAccessibleRowExtentAt(row, column);
                }
            }, this.getContextFromAccessibleTable(at));
            this.debugString("[INFO]:   ##### getAccessibleTableCellRowExtent=" + rowExtent);
            return rowExtent;
        }
        this.debugString("[ERROR]: ##### getAccessibleTableCellRowExtent FAILED");
        return -1;
    }

    private int getAccessibleTableCellColumnExtent(final AccessibleTable at, final int row, final int column) {
        this.debugString("[INFO]: ##### getAccessibleTableCellColumnExtent");
        if (at != null) {
            int columnExtent = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return at.getAccessibleColumnExtentAt(row, column);
                }
            }, this.getContextFromAccessibleTable(at));
            this.debugString("[INFO]:   ##### getAccessibleTableCellColumnExtent=" + columnExtent);
            return columnExtent;
        }
        this.debugString("[ERROR]: ##### getAccessibleTableCellColumnExtent FAILED");
        return -1;
    }

    private boolean isAccessibleTableCellSelected(final AccessibleTable at, final int row, final int column) {
        this.debugString("[INFO]: ##### isAccessibleTableCellSelected: [" + row + "][" + column + "]");
        if (at == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean isSelected = false;
                Accessible a = at.getAccessibleAt(row, column);
                if (a != null) {
                    AccessibleContext ac = a.getAccessibleContext();
                    if (ac == null) {
                        return false;
                    }
                    AccessibleStateSet as = ac.getAccessibleStateSet();
                    if (as != null) {
                        isSelected = as.contains(AccessibleState.SELECTED);
                    }
                }
                return isSelected;
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private AccessibleTable getAccessibleTableRowHeader(final AccessibleContext ac) {
        this.debugString("[INFO]: #####  getAccessibleTableRowHeader called");
        AccessibleTable at = InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

            @Override
            public AccessibleTable call() throws Exception {
                AccessibleTable at;
                if (ac != null && (at = ac.getAccessibleTable()) != null) {
                    return at.getAccessibleRowHeader();
                }
                return null;
            }
        }, ac);
        if (at != null) {
            this.hashtab.put(at, ac);
        }
        return at;
    }

    private AccessibleTable getAccessibleTableColumnHeader(final AccessibleContext ac) {
        this.debugString("[INFO]: ##### getAccessibleTableColumnHeader");
        if (ac == null) {
            return null;
        }
        AccessibleTable at = InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

            @Override
            public AccessibleTable call() throws Exception {
                AccessibleTable at;
                Accessible parent = ac.getAccessibleParent();
                if (parent != null) {
                    JTable table;
                    int indexInParent = ac.getAccessibleIndexInParent();
                    Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                    if (child instanceof JTable && (table = (JTable)child).getTableHeader() == null) {
                        return null;
                    }
                }
                if ((at = ac.getAccessibleTable()) != null) {
                    return at.getAccessibleColumnHeader();
                }
                return null;
            }
        }, ac);
        if (at != null) {
            this.hashtab.put(at, ac);
        }
        return at;
    }

    private int getAccessibleTableRowHeaderRowCount(AccessibleContext ac) {
        AccessibleTable atRowHeader;
        this.debugString("[INFO]: #####  getAccessibleTableRowHeaderRowCount called");
        if (ac != null && (atRowHeader = this.getAccessibleTableRowHeader(ac)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (atRowHeader != null) {
                        return atRowHeader.getAccessibleRowCount();
                    }
                    return -1;
                }
            }, ac);
        }
        return -1;
    }

    private int getAccessibleTableRowHeaderColumnCount(AccessibleContext ac) {
        AccessibleTable atRowHeader;
        this.debugString("[INFO]: #####  getAccessibleTableRowHeaderColumnCount called");
        if (ac != null && (atRowHeader = this.getAccessibleTableRowHeader(ac)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (atRowHeader != null) {
                        return atRowHeader.getAccessibleColumnCount();
                    }
                    return -1;
                }
            }, ac);
        }
        this.debugString("[ERROR]: ##### getAccessibleTableRowHeaderColumnCount FAILED");
        return -1;
    }

    private int getAccessibleTableColumnHeaderRowCount(AccessibleContext ac) {
        AccessibleTable atColumnHeader;
        this.debugString("[INFO]: ##### getAccessibleTableColumnHeaderRowCount");
        if (ac != null && (atColumnHeader = this.getAccessibleTableColumnHeader(ac)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (atColumnHeader != null) {
                        return atColumnHeader.getAccessibleRowCount();
                    }
                    return -1;
                }
            }, ac);
        }
        this.debugString("[ERROR]: ##### getAccessibleTableColumnHeaderRowCount FAILED");
        return -1;
    }

    private int getAccessibleTableColumnHeaderColumnCount(AccessibleContext ac) {
        AccessibleTable atColumnHeader;
        this.debugString("[ERROR]: #####  getAccessibleTableColumnHeaderColumnCount");
        if (ac != null && (atColumnHeader = this.getAccessibleTableColumnHeader(ac)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (atColumnHeader != null) {
                        return atColumnHeader.getAccessibleColumnCount();
                    }
                    return -1;
                }
            }, ac);
        }
        this.debugString("[ERROR]: ##### getAccessibleTableColumnHeaderColumnCount FAILED");
        return -1;
    }

    private AccessibleContext getAccessibleTableRowDescription(final AccessibleTable table, final int row) {
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible a;
                if (table != null && (a = table.getAccessibleRowDescription(row)) != null) {
                    return a.getAccessibleContext();
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(table));
    }

    private AccessibleContext getAccessibleTableColumnDescription(final AccessibleTable at, final int column) {
        if (at == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible a = at.getAccessibleColumnDescription(column);
                if (a != null) {
                    return a.getAccessibleContext();
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private int getAccessibleTableRowSelectionCount(final AccessibleTable at) {
        if (at != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int[] selections = at.getSelectedAccessibleRows();
                    if (selections != null) {
                        return selections.length;
                    }
                    return -1;
                }
            }, this.getContextFromAccessibleTable(at));
        }
        return -1;
    }

    private int getAccessibleTableRowSelections(final AccessibleTable at, final int i) {
        if (at != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int[] selections = at.getSelectedAccessibleRows();
                    if (selections.length > i) {
                        return selections[i];
                    }
                    return -1;
                }
            }, this.getContextFromAccessibleTable(at));
        }
        return -1;
    }

    private boolean isAccessibleTableRowSelected(final AccessibleTable at, final int row) {
        if (at == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return at.isAccessibleRowSelected(row);
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private boolean isAccessibleTableColumnSelected(final AccessibleTable at, final int column) {
        if (at == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return at.isAccessibleColumnSelected(column);
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private int getAccessibleTableColumnSelectionCount(final AccessibleTable at) {
        if (at == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int[] selections = at.getSelectedAccessibleColumns();
                if (selections != null) {
                    return selections.length;
                }
                return -1;
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private int getAccessibleTableColumnSelections(final AccessibleTable at, final int i) {
        if (at == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int[] selections = at.getSelectedAccessibleColumns();
                if (selections != null && selections.length > i) {
                    return selections[i];
                }
                return -1;
            }
        }, this.getContextFromAccessibleTable(at));
    }

    private int getAccessibleTableRow(final AccessibleTable at, int index) {
        if (at == null) {
            return -1;
        }
        int colCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return at.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(at));
        return index / colCount;
    }

    private int getAccessibleTableColumn(final AccessibleTable at, int index) {
        if (at == null) {
            return -1;
        }
        int colCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return at.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(at));
        return index % colCount;
    }

    private int getAccessibleTableIndex(final AccessibleTable at, int row, int column) {
        if (at == null) {
            return -1;
        }
        int colCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return at.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(at));
        return row * colCount + column;
    }

    private int getAccessibleRelationCount(final AccessibleContext ac) {
        AccessibleRelationSet ars;
        String version = this.getJavaVersionProperty();
        if (version != null && version.compareTo("1.3") >= 0 && ac != null && (ars = InvocationUtils.invokeAndWait(new Callable<AccessibleRelationSet>(){

            @Override
            public AccessibleRelationSet call() throws Exception {
                return ac.getAccessibleRelationSet();
            }
        }, ac)) != null) {
            return ars.size();
        }
        return 0;
    }

    private String getAccessibleRelationKey(final AccessibleContext ac, final int i) {
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleRelation[] relations;
                AccessibleRelationSet ars;
                if (ac != null && (ars = ac.getAccessibleRelationSet()) != null && (relations = ars.toArray()) != null && i >= 0 && i < relations.length) {
                    return relations[i].getKey();
                }
                return null;
            }
        }, ac);
    }

    private int getAccessibleRelationTargetCount(final AccessibleContext ac, final int i) {
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Object[] targets;
                AccessibleRelation[] relations;
                AccessibleRelationSet ars;
                if (ac != null && (ars = ac.getAccessibleRelationSet()) != null && (relations = ars.toArray()) != null && i >= 0 && i < relations.length && (targets = relations[i].getTarget()) != null) {
                    int targetCount = targets.length - AccessBridge.this.getNonVisibleTargetCountTillIndex(targets, targets.length - 1);
                    return targetCount;
                }
                return -1;
            }
        }, ac);
    }

    private AccessibleContext getAccessibleRelationTarget(final AccessibleContext ac, final int i, final int j) {
        this.debugString("[INFO]: ***** getAccessibleRelationTarget");
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Object o;
                Object[] targets;
                AccessibleRelation[] relations;
                AccessibleRelationSet ars;
                if (ac != null && (ars = ac.getAccessibleRelationSet()) != null && (relations = ars.toArray()) != null && i >= 0 && i < relations.length && (targets = relations[i].getTarget()) != null && j >= 0 & j < targets.length && (o = AccessBridge.this.getVisibleTargetAtIndex(targets, j)) instanceof Accessible) {
                    return ((Accessible)o).getAccessibleContext();
                }
                return null;
            }
        }, ac);
    }

    private Object getVisibleTargetAtIndex(Object[] targets, int index) {
        if (index >= 0 && index < targets.length) {
            int visibleTargetIndex = -1;
            for (int i = 0; i < targets.length; ++i) {
                if (!(targets[i] instanceof Accessible)) continue;
                AccessibleContext ac = ((Accessible)targets[i]).getAccessibleContext();
                if (ac != null && ac.getAccessibleStateSet().contains(AccessibleState.VISIBLE)) {
                    ++visibleTargetIndex;
                }
                if (visibleTargetIndex != index) continue;
                return targets[i];
            }
        }
        return null;
    }

    private int getNonVisibleTargetCountTillIndex(Object[] targets, int index) {
        if (index >= 0 && index < targets.length) {
            int nonVisibleTargetsCount = 0;
            for (int i = 0; i <= index; ++i) {
                AccessibleContext ac;
                if (!(targets[i] instanceof Accessible) || (ac = ((Accessible)targets[i]).getAccessibleContext()) == null || ac.getAccessibleStateSet().contains(AccessibleState.VISIBLE)) continue;
                ++nonVisibleTargetsCount;
            }
            return nonVisibleTargetsCount;
        }
        return 0;
    }

    private AccessibleHypertext getAccessibleHypertext(final AccessibleContext ac) {
        this.debugString("[INFO]: getAccessibleHyperlink");
        if (ac == null) {
            return null;
        }
        AccessibleHypertext hypertext = InvocationUtils.invokeAndWait(new Callable<AccessibleHypertext>(){

            @Override
            public AccessibleHypertext call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (!(at instanceof AccessibleHypertext)) {
                    return null;
                }
                return (AccessibleHypertext)at;
            }
        }, ac);
        this.hyperTextContextMap.put(hypertext, ac);
        return hypertext;
    }

    private int getAccessibleHyperlinkCount(AccessibleContext ac) {
        this.debugString("[INFO]: getAccessibleHyperlinkCount");
        if (ac == null) {
            return 0;
        }
        final AccessibleHypertext hypertext = this.getAccessibleHypertext(ac);
        if (hypertext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return hypertext.getLinkCount();
            }
        }, ac);
    }

    private AccessibleHyperlink getAccessibleHyperlink(final AccessibleHypertext hypertext, final int i) {
        this.debugString("[INFO]: getAccessibleHyperlink");
        if (hypertext == null) {
            return null;
        }
        AccessibleContext ac = this.hyperTextContextMap.get(hypertext);
        if (i < 0 || i >= InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return hypertext.getLinkCount();
            }
        }, ac)) {
            return null;
        }
        AccessibleHyperlink acLink = InvocationUtils.invokeAndWait(new Callable<AccessibleHyperlink>(){

            @Override
            public AccessibleHyperlink call() throws Exception {
                AccessibleHyperlink link = hypertext.getLink(i);
                if (link == null || !link.isValid()) {
                    return null;
                }
                return link;
            }
        }, ac);
        this.hyperLinkContextMap.put(acLink, ac);
        return acLink;
    }

    private String getAccessibleHyperlinkText(final AccessibleHyperlink link) {
        this.debugString("[INFO]: getAccessibleHyperlinkText");
        if (link == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String o = link.getAccessibleActionDescription(0);
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
        }, this.hyperLinkContextMap.get(link));
    }

    private String getAccessibleHyperlinkURL(final AccessibleHyperlink link) {
        this.debugString("[INFO]: getAccessibleHyperlinkURL");
        if (link == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object o = link.getAccessibleActionObject(0);
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
        }, this.hyperLinkContextMap.get(link));
    }

    private int getAccessibleHyperlinkStartIndex(final AccessibleHyperlink link) {
        this.debugString("[INFO]: getAccessibleHyperlinkStartIndex");
        if (link == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return link.getStartIndex();
            }
        }, this.hyperLinkContextMap.get(link));
    }

    private int getAccessibleHyperlinkEndIndex(final AccessibleHyperlink link) {
        this.debugString("[INFO]: getAccessibleHyperlinkEndIndex");
        if (link == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return link.getEndIndex();
            }
        }, this.hyperLinkContextMap.get(link));
    }

    private int getAccessibleHypertextLinkIndex(final AccessibleHypertext hypertext, final int charIndex) {
        this.debugString("[INFO]: getAccessibleHypertextLinkIndex: charIndex = " + charIndex);
        if (hypertext == null) {
            return -1;
        }
        int linkIndex = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return hypertext.getLinkIndex(charIndex);
            }
        }, this.hyperTextContextMap.get(hypertext));
        this.debugString("[INFO]: getAccessibleHypertextLinkIndex returning " + linkIndex);
        return linkIndex;
    }

    private boolean activateAccessibleHyperlink(AccessibleContext ac, final AccessibleHyperlink link) {
        if (link == null) {
            return false;
        }
        boolean retval = InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return link.doAccessibleAction(0);
            }
        }, ac);
        this.debugString("[INFO]: activateAccessibleHyperlink: returning = " + retval);
        return retval;
    }

    private KeyStroke getMnemonic(final AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<KeyStroke>(){

            @Override
            public KeyStroke call() throws Exception {
                Object o;
                AccessibleKeyBinding akb;
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (!(comp instanceof AccessibleExtendedComponent)) {
                    return null;
                }
                AccessibleExtendedComponent aec = (AccessibleExtendedComponent)comp;
                if (aec != null && (akb = aec.getAccessibleKeyBinding()) != null && (o = akb.getAccessibleKeyBinding(0)) instanceof KeyStroke) {
                    return (KeyStroke)o;
                }
                return null;
            }
        }, ac);
    }

    private KeyStroke getAccelerator(final AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<KeyStroke>(){

            @Override
            public KeyStroke call() throws Exception {
                Accessible parent = ac.getAccessibleParent();
                if (parent instanceof Accessible) {
                    int indexInParent = ac.getAccessibleIndexInParent();
                    Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                    if (child instanceof JMenuItem) {
                        JMenuItem menuItem = (JMenuItem)child;
                        if (menuItem == null) {
                            return null;
                        }
                        KeyStroke keyStroke = menuItem.getAccelerator();
                        return keyStroke;
                    }
                }
                return null;
            }
        }, ac);
    }

    private int fKeyNumber(KeyStroke keyStroke) {
        String prefix;
        if (keyStroke == null) {
            return 0;
        }
        int fKey = 0;
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        if (keyText != null && (keyText.length() == 2 || keyText.length() == 3) && (prefix = keyText.substring(0, 1)).equals("F")) {
            try {
                int suffix = Integer.parseInt(keyText.substring(1));
                if (suffix >= 1 && suffix <= 24) {
                    fKey = suffix;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fKey;
    }

    private int controlCode(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return 0;
        }
        int code = keyStroke.getKeyCode();
        switch (code) {
            case 8: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 127: 
            case 155: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                break;
            }
            default: {
                code = 0;
            }
        }
        return code;
    }

    private char getKeyChar(KeyStroke keyStroke) {
        CharSequence seq;
        if (keyStroke == null) {
            return '\u0000';
        }
        int fKey = this.fKeyNumber(keyStroke);
        if (fKey != 0) {
            this.debugString("[INFO]:   Shortcut is: F" + fKey);
            return (char)fKey;
        }
        int keyCode = this.controlCode(keyStroke);
        if (keyCode != 0) {
            this.debugString("[INFO]:   Shortcut is control character: " + Integer.toHexString(keyCode));
            return (char)keyCode;
        }
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        this.debugString("[INFO]:   Shortcut is: " + keyText);
        if (!(keyText == null && keyText.length() <= 0 || (seq = keyText.subSequence(0, 1)) == null && seq.length() <= 0)) {
            return seq.charAt(0);
        }
        return '\u0000';
    }

    private int getModifiers(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return 0;
        }
        this.debugString("[INFO]: In AccessBridge.getModifiers");
        int modifiers = 0;
        if (this.fKeyNumber(keyStroke) != 0) {
            modifiers |= 0x100;
        }
        if (this.controlCode(keyStroke) != 0) {
            modifiers |= 0x200;
        }
        StringTokenizer st = new StringTokenizer(keyStroke.toString());
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            if (text.startsWith("met")) {
                this.debugString("[INFO]:   found meta");
                modifiers |= 4;
            }
            if (text.startsWith("ctr")) {
                this.debugString("[INFO]:   found ctrl");
                modifiers |= 2;
            }
            if (text.startsWith("alt")) {
                this.debugString("[INFO]:   found alt");
                modifiers |= 8;
            }
            if (!text.startsWith("shi")) continue;
            this.debugString("[INFO]:   found shift");
            modifiers |= 1;
        }
        this.debugString("[INFO]:   returning modifiers: 0x" + Integer.toHexString(modifiers));
        return modifiers;
    }

    private int getAccessibleKeyBindingsCount(AccessibleContext ac) {
        if (ac == null || !this.runningOnJDK1_4) {
            return 0;
        }
        int count = 0;
        if (this.getMnemonic(ac) != null) {
            ++count;
        }
        if (this.getAccelerator(ac) != null) {
            ++count;
        }
        return count;
    }

    private char getAccessibleKeyBindingChar(AccessibleContext ac, int index) {
        KeyStroke keyStroke;
        if (ac == null || !this.runningOnJDK1_4) {
            return '\u0000';
        }
        if (index == 0 && this.getMnemonic(ac) == null && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getKeyChar(keyStroke);
        }
        if (index == 0 ? (keyStroke = this.getMnemonic(ac)) != null : index == 1 && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getKeyChar(keyStroke);
        }
        return '\u0000';
    }

    private int getAccessibleKeyBindingModifiers(AccessibleContext ac, int index) {
        KeyStroke keyStroke;
        if (ac == null || !this.runningOnJDK1_4) {
            return 0;
        }
        if (index == 0 && this.getMnemonic(ac) == null && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getModifiers(keyStroke);
        }
        if (index == 0 ? (keyStroke = this.getMnemonic(ac)) != null : index == 1 && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getModifiers(keyStroke);
        }
        return 0;
    }

    private int getAccessibleIconsCount(final AccessibleContext ac) {
        this.debugString("[INFO]: getAccessibleIconsCount");
        if (ac == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] ai = ac.getAccessibleIcon();
                if (ai == null) {
                    return 0;
                }
                return ai.length;
            }
        }, ac);
    }

    private String getAccessibleIconDescription(final AccessibleContext ac, final int index) {
        this.debugString("[INFO]: getAccessibleIconDescription: index = " + index);
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleIcon[] ai = ac.getAccessibleIcon();
                if (ai == null || index < 0 || index >= ai.length) {
                    return null;
                }
                return ai[index].getAccessibleIconDescription();
            }
        }, ac);
    }

    private int getAccessibleIconHeight(final AccessibleContext ac, final int index) {
        this.debugString("[INFO]: getAccessibleIconHeight: index = " + index);
        if (ac == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] ai = ac.getAccessibleIcon();
                if (ai == null || index < 0 || index >= ai.length) {
                    return 0;
                }
                return ai[index].getAccessibleIconHeight();
            }
        }, ac);
    }

    private int getAccessibleIconWidth(final AccessibleContext ac, final int index) {
        this.debugString("[INFO]: getAccessibleIconWidth: index = " + index);
        if (ac == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] ai = ac.getAccessibleIcon();
                if (ai == null || index < 0 || index >= ai.length) {
                    return 0;
                }
                return ai[index].getAccessibleIconWidth();
            }
        }, ac);
    }

    private int getAccessibleActionsCount(final AccessibleContext ac) {
        this.debugString("[INFO]: getAccessibleActionsCount");
        if (ac == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleAction aa = ac.getAccessibleAction();
                if (aa == null) {
                    return 0;
                }
                return aa.getAccessibleActionCount();
            }
        }, ac);
    }

    private String getAccessibleActionName(final AccessibleContext ac, final int index) {
        this.debugString("[INFO]: getAccessibleActionName: index = " + index);
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleAction aa = ac.getAccessibleAction();
                if (aa == null) {
                    return null;
                }
                return aa.getAccessibleActionDescription(index);
            }
        }, ac);
    }

    private boolean doAccessibleActions(final AccessibleContext ac, final String name) {
        this.debugString("[INFO]: doAccessibleActions: action name = " + name);
        if (ac == null || name == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleAction aa = ac.getAccessibleAction();
                if (aa == null) {
                    return false;
                }
                int index = -1;
                int numActions = aa.getAccessibleActionCount();
                for (int i = 0; i < numActions; ++i) {
                    String actionName = aa.getAccessibleActionDescription(i);
                    if (!name.equals(actionName)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return false;
                }
                boolean retval = aa.doAccessibleAction(index);
                return retval;
            }
        }, ac);
    }

    private boolean setTextContents(final AccessibleContext ac, final String text) {
        this.debugString("[INFO]: setTextContents: ac = " + ac + "; text = " + text);
        if (!(ac instanceof AccessibleEditableText)) {
            this.debugString("[WARN]:   ac not instanceof AccessibleEditableText: " + ac);
            return false;
        }
        if (text == null) {
            this.debugString("[WARN]:   text is null");
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleStateSet ass = ac.getAccessibleStateSet();
                if (!ass.contains(AccessibleState.ENABLED)) {
                    return false;
                }
                ((AccessibleEditableText)((Object)ac)).setTextContents(text);
                return true;
            }
        }, ac);
    }

    private AccessibleContext getInternalFrame(AccessibleContext ac) {
        return this.getParentWithRole(ac, AccessibleRole.INTERNAL_FRAME.toString());
    }

    private AccessibleContext getTopLevelObject(final AccessibleContext ac) {
        this.debugString("[INFO]: getTopLevelObject; ac = " + ac);
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                if (ac.getAccessibleRole() == AccessibleRole.DIALOG) {
                    return ac;
                }
                Accessible parent = ac.getAccessibleParent();
                if (parent == null) {
                    return ac;
                }
                Accessible tmp = parent;
                while (tmp != null && tmp.getAccessibleContext() != null) {
                    AccessibleContext ac2 = tmp.getAccessibleContext();
                    if (ac2 != null && ac2.getAccessibleRole() == AccessibleRole.DIALOG) {
                        return ac2;
                    }
                    parent = tmp;
                    tmp = parent.getAccessibleContext().getAccessibleParent();
                }
                return parent.getAccessibleContext();
            }
        }, ac);
    }

    private AccessibleContext getParentWithRole(final AccessibleContext ac, final String roleName) {
        this.debugString("[INFO]: getParentWithRole; ac = " + ac + "\n role = " + roleName);
        if (ac == null || roleName == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleRole role = (AccessibleRole)AccessBridge.this.accessibleRoleMap.get(roleName);
                if (role == null) {
                    return ac;
                }
                Accessible parent = ac.getAccessibleParent();
                if (parent == null && ac.getAccessibleRole() == role) {
                    return ac;
                }
                Accessible tmp = parent;
                AccessibleContext tmp_ac = null;
                while (tmp != null && (tmp_ac = tmp.getAccessibleContext()) != null) {
                    AccessibleRole ar = tmp_ac.getAccessibleRole();
                    if (ar == role) {
                        return tmp_ac;
                    }
                    parent = tmp;
                    tmp = parent.getAccessibleContext().getAccessibleParent();
                }
                return null;
            }
        }, ac);
    }

    private AccessibleContext getParentWithRoleElseRoot(AccessibleContext ac, String roleName) {
        AccessibleContext retval = this.getParentWithRole(ac, roleName);
        if (retval == null) {
            retval = this.getTopLevelObject(ac);
        }
        return retval;
    }

    private int getObjectDepth(final AccessibleContext ac) {
        this.debugString("[INFO]: getObjectDepth: ac = " + ac);
        if (ac == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int count = 0;
                Accessible parent = ac.getAccessibleParent();
                if (parent == null) {
                    return count;
                }
                Accessible tmp = parent;
                while (tmp != null && tmp.getAccessibleContext() != null) {
                    parent = tmp;
                    tmp = parent.getAccessibleContext().getAccessibleParent();
                    ++count;
                }
                return count;
            }
        }, ac);
    }

    private AccessibleContext getActiveDescendent(final AccessibleContext ac) {
        Accessible child;
        this.debugString("[INFO]: getActiveDescendent: ac = " + ac);
        if (ac == null) {
            return null;
        }
        final Accessible parent = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                return ac.getAccessibleParent();
            }
        }, ac);
        if (parent != null && (child = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                int indexInParent = ac.getAccessibleIndexInParent();
                return parent.getAccessibleContext().getAccessibleChild(indexInParent);
            }
        }, ac)) instanceof JTree) {
            final JTree tree = (JTree)child;
            return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return new AccessibleJTreeNode(tree, tree.getSelectionPath(), null);
                }
            }, child);
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleSelection as = ac.getAccessibleSelection();
                if (as == null) {
                    return null;
                }
                if (as.getAccessibleSelectionCount() != 1) {
                    return null;
                }
                Accessible a = as.getAccessibleSelection(0);
                if (a == null) {
                    return null;
                }
                return a.getAccessibleContext();
            }
        }, ac);
    }

    private String getJAWSAccessibleName(final AccessibleContext ac) {
        this.debugString("[INFO]:  getJAWSAccessibleName");
        if (ac == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ac.getAccessibleName();
            }
        }, ac);
    }

    private boolean requestFocus(final AccessibleContext ac) {
        this.debugString("[INFO]:  requestFocus");
        if (ac == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleComponent acomp = ac.getAccessibleComponent();
                if (acomp == null) {
                    return false;
                }
                acomp.requestFocus();
                return ac.getAccessibleStateSet().contains(AccessibleState.FOCUSED);
            }
        }, ac);
    }

    private boolean selectTextRange(final AccessibleContext ac, final int startIndex, final int endIndex) {
        this.debugString("[INFO]:  selectTextRange: start = " + startIndex + "; end = " + endIndex);
        if (ac == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (!(at instanceof AccessibleEditableText)) {
                    return false;
                }
                ((AccessibleEditableText)at).selectText(startIndex, endIndex);
                boolean result = at.getSelectionStart() == startIndex && at.getSelectionEnd() == endIndex;
                return result;
            }
        }, ac);
    }

    private boolean setCaretPosition(final AccessibleContext ac, final int position) {
        this.debugString("[INFO]: setCaretPosition: position = " + position);
        if (ac == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleText at = ac.getAccessibleText();
                if (!(at instanceof AccessibleEditableText)) {
                    return false;
                }
                ((AccessibleEditableText)at).selectText(position, position);
                return at.getCaretPosition() == position;
            }
        }, ac);
    }

    private int getVisibleChildrenCount(AccessibleContext ac) {
        this.debugString("[INFO]: getVisibleChildrenCount");
        if (ac == null) {
            return -1;
        }
        this._visibleChildrenCount = 0;
        this._getVisibleChildrenCount(ac);
        this.debugString("[INFO]:   _visibleChildrenCount = " + this._visibleChildrenCount);
        return this._visibleChildrenCount;
    }

    private void _getVisibleChildrenCount(final AccessibleContext ac) {
        if (ac == null) {
            return;
        }
        if (ac instanceof AccessibleExtendedTable) {
            this._getVisibleChildrenCount((AccessibleExtendedTable)((Object)ac));
            return;
        }
        int numChildren = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ac.getAccessibleChildrenCount();
            }
        }, ac);
        for (int i = 0; i < numChildren; ++i) {
            final int idx = i;
            final AccessibleContext ac2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible a = ac.getAccessibleChild(idx);
                    if (a != null) {
                        return a.getAccessibleContext();
                    }
                    return null;
                }
            }, ac);
            if (ac2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                }
            }, ac).booleanValue()) continue;
            ++this._visibleChildrenCount;
            if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ac2.getAccessibleChildrenCount();
                }
            }, ac) <= 0) continue;
            this._getVisibleChildrenCount(ac2);
        }
    }

    private void _getVisibleChildrenCount(final AccessibleExtendedTable acTable) {
        if (acTable == null) {
            return;
        }
        int lastVisibleRow = -1;
        int lastVisibleColumn = -1;
        boolean foundVisible = false;
        int rowCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return acTable.getAccessibleRowCount();
            }
        }, acTable);
        int columnCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return acTable.getAccessibleColumnCount();
            }
        }, acTable);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            for (int columnIdx = 0; columnIdx < columnCount; ++columnIdx) {
                if (lastVisibleRow != -1 && rowIdx > lastVisibleRow || lastVisibleColumn != -1 && columnIdx > lastVisibleColumn) continue;
                final int finalRowIdx = rowIdx;
                final int finalColumnIdx = columnIdx;
                final AccessibleContext ac2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        Accessible a = acTable.getAccessibleAt(finalRowIdx, finalColumnIdx);
                        if (a == null) {
                            return null;
                        }
                        return a.getAccessibleContext();
                    }
                }, acTable);
                if (ac2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                    }
                }, acTable).booleanValue()) {
                    if (!foundVisible) continue;
                    if (columnIdx != 0 && lastVisibleColumn == -1) {
                        lastVisibleColumn = columnIdx - 1;
                        continue;
                    }
                    if (columnIdx != 0 || lastVisibleRow != -1) continue;
                    lastVisibleRow = rowIdx - 1;
                    continue;
                }
                foundVisible = true;
                ++this._visibleChildrenCount;
                if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ac2.getAccessibleChildrenCount();
                    }
                }, acTable) <= 0) continue;
                this._getVisibleChildrenCount(ac2);
            }
        }
    }

    private AccessibleContext getVisibleChild(AccessibleContext ac, int index) {
        this.debugString("[INFO]: getVisibleChild: index = " + index);
        if (ac == null) {
            return null;
        }
        this._visibleChild = null;
        this._currentVisibleIndex = 0;
        this._foundVisibleChild = false;
        this._getVisibleChild(ac, index);
        if (this._visibleChild != null) {
            this.debugString("[INFO]:     getVisibleChild: found child = " + InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return AccessBridge.this._visibleChild.getAccessibleName();
                }
            }, ac));
        }
        return this._visibleChild;
    }

    private void _getVisibleChild(final AccessibleContext ac, int index) {
        if (this._visibleChild != null) {
            return;
        }
        if (ac instanceof AccessibleExtendedTable) {
            this._getVisibleChild((AccessibleExtendedTable)((Object)ac), index);
            return;
        }
        int numChildren = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ac.getAccessibleChildrenCount();
            }
        }, ac);
        for (int i = 0; i < numChildren; ++i) {
            final int idx = i;
            final AccessibleContext ac2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible a = ac.getAccessibleChild(idx);
                    if (a == null) {
                        return null;
                    }
                    return a.getAccessibleContext();
                }
            }, ac);
            if (ac2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                }
            }, ac).booleanValue()) continue;
            if (!this._foundVisibleChild && this._currentVisibleIndex == index) {
                this._visibleChild = ac2;
                this._foundVisibleChild = true;
                return;
            }
            ++this._currentVisibleIndex;
            if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ac2.getAccessibleChildrenCount();
                }
            }, ac) <= 0) continue;
            this._getVisibleChild(ac2, index);
        }
    }

    private void _getVisibleChild(final AccessibleExtendedTable acTable, int index) {
        if (this._visibleChild != null) {
            return;
        }
        int lastVisibleRow = -1;
        int lastVisibleColumn = -1;
        boolean foundVisible = false;
        int rowCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return acTable.getAccessibleRowCount();
            }
        }, acTable);
        int columnCount = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return acTable.getAccessibleColumnCount();
            }
        }, acTable);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            for (int columnIdx = 0; columnIdx < columnCount; ++columnIdx) {
                if (lastVisibleRow != -1 && rowIdx > lastVisibleRow || lastVisibleColumn != -1 && columnIdx > lastVisibleColumn) continue;
                final int finalRowIdx = rowIdx;
                final int finalColumnIdx = columnIdx;
                final AccessibleContext ac2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        Accessible a = acTable.getAccessibleAt(finalRowIdx, finalColumnIdx);
                        if (a == null) {
                            return null;
                        }
                        return a.getAccessibleContext();
                    }
                }, acTable);
                if (ac2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                    }
                }, acTable).booleanValue()) {
                    if (!foundVisible) continue;
                    if (columnIdx != 0 && lastVisibleColumn == -1) {
                        lastVisibleColumn = columnIdx - 1;
                        continue;
                    }
                    if (columnIdx != 0 || lastVisibleRow != -1) continue;
                    lastVisibleRow = rowIdx - 1;
                    continue;
                }
                foundVisible = true;
                if (!this._foundVisibleChild && this._currentVisibleIndex == index) {
                    this._visibleChild = ac2;
                    this._foundVisibleChild = true;
                    return;
                }
                ++this._currentVisibleIndex;
                if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ac2.getAccessibleChildrenCount();
                    }
                }, acTable) <= 0) continue;
                this._getVisibleChild(ac2, index);
            }
        }
    }

    private native void propertyCaretChange(PropertyChangeEvent var1, AccessibleContext var2, int var3, int var4);

    private native void propertyDescriptionChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyNameChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertySelectionChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyStateChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyTextChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyValueChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyVisibleDataChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyChildChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    private native void propertyActiveDescendentChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    private native void javaShutdown();

    private native void focusGained(FocusEvent var1, AccessibleContext var2);

    private native void focusLost(FocusEvent var1, AccessibleContext var2);

    private native void caretUpdate(CaretEvent var1, AccessibleContext var2);

    private native void mouseClicked(MouseEvent var1, AccessibleContext var2);

    private native void mouseEntered(MouseEvent var1, AccessibleContext var2);

    private native void mouseExited(MouseEvent var1, AccessibleContext var2);

    private native void mousePressed(MouseEvent var1, AccessibleContext var2);

    private native void mouseReleased(MouseEvent var1, AccessibleContext var2);

    private native void menuCanceled(MenuEvent var1, AccessibleContext var2);

    private native void menuDeselected(MenuEvent var1, AccessibleContext var2);

    private native void menuSelected(MenuEvent var1, AccessibleContext var2);

    private native void popupMenuCanceled(PopupMenuEvent var1, AccessibleContext var2);

    private native void popupMenuWillBecomeInvisible(PopupMenuEvent var1, AccessibleContext var2);

    private native void popupMenuWillBecomeVisible(PopupMenuEvent var1, AccessibleContext var2);

    private void addJavaEventNotification(final long type) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.addJavaEventNotification(type);
            }
        });
    }

    private void removeJavaEventNotification(final long type) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.removeJavaEventNotification(type);
            }
        });
    }

    private void addAccessibilityEventNotification(final long type) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.addAccessibilityEventNotification(type);
            }
        });
    }

    private void removeAccessibilityEventNotification(final long type) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.removeAccessibilityEventNotification(type);
            }
        });
    }

    static {
        windowHandleToContextMap = new ConcurrentHashMap();
        contextToWindowHandleMap = new ConcurrentHashMap();
        nativeWindowHandlers = new Vector();
    }

    private static class InvocationUtils {
        private InvocationUtils() {
        }

        public static <T> T invokeAndWait(Callable<T> callable, AccessibleExtendedTable accessibleTable) {
            if (accessibleTable instanceof AccessibleContext) {
                return InvocationUtils.invokeAndWait(callable, (AccessibleContext)((Object)accessibleTable));
            }
            throw new RuntimeException("Unmapped AccessibleContext used to dispatch event: " + accessibleTable);
        }

        public static <T> T invokeAndWait(Callable<T> callable, Accessible accessible) {
            if (accessible instanceof Component) {
                return InvocationUtils.invokeAndWait(callable, (Component)((Object)accessible));
            }
            if (accessible instanceof AccessibleContext) {
                return InvocationUtils.invokeAndWait(callable, (AccessibleContext)((Object)accessible));
            }
            throw new RuntimeException("Unmapped Accessible used to dispatch event: " + accessible);
        }

        public static <T> T invokeAndWait(Callable<T> callable, Component component) {
            return InvocationUtils.invokeAndWait(callable, SunToolkit.targetToAppContext(component));
        }

        public static <T> T invokeAndWait(Callable<T> callable, AccessibleContext accessibleContext) {
            Object source;
            AppContext targetContext = AWTAccessor.getAccessibleContextAccessor().getAppContext(accessibleContext);
            if (targetContext != null) {
                return InvocationUtils.invokeAndWait(callable, targetContext);
            }
            if (accessibleContext instanceof Translator && (source = ((Translator)accessibleContext).getSource()) instanceof Component) {
                return InvocationUtils.invokeAndWait(callable, (Component)source);
            }
            throw new RuntimeException("Unmapped AccessibleContext used to dispatch event: " + accessibleContext);
        }

        private static <T> T invokeAndWait(Callable<T> callable, AppContext targetAppContext) {
            CallableWrapper<T> wrapper = new CallableWrapper<T>(callable);
            try {
                InvocationUtils.invokeAndWait(wrapper, targetAppContext);
                T result = wrapper.getResult();
                InvocationUtils.updateAppContextMap(result, targetAppContext);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void invokeAndWait(Runnable runnable, AppContext appContext) throws InterruptedException, InvocationTargetException {
            EventQueue eq = SunToolkit.getSystemEventQueueImplPP(appContext);
            Object lock = new Object();
            Toolkit source = Toolkit.getDefaultToolkit();
            InvocationEvent event = new InvocationEvent((Object)source, runnable, lock, true);
            Object object = lock;
            synchronized (object) {
                eq.postEvent(event);
                lock.wait();
            }
            Throwable eventThrowable = event.getThrowable();
            if (eventThrowable != null) {
                throw new InvocationTargetException(eventThrowable);
            }
        }

        public static void registerAccessibleContext(AccessibleContext accessibleContext, AppContext targetContext) {
            if (accessibleContext != null) {
                AWTAccessor.getAccessibleContextAccessor().setAppContext(accessibleContext, targetContext);
            }
        }

        private static <T> void updateAppContextMap(T accessibleContext, AppContext targetContext) {
            if (accessibleContext instanceof AccessibleContext) {
                InvocationUtils.registerAccessibleContext((AccessibleContext)accessibleContext, targetContext);
            }
        }

        private static class CallableWrapper<T>
        implements Runnable {
            private final Callable<T> callable;
            private volatile T object;
            private Exception e;

            CallableWrapper(Callable<T> callable) {
                this.callable = callable;
            }

            @Override
            public void run() {
                try {
                    if (this.callable != null) {
                        this.object = this.callable.call();
                    }
                }
                catch (Exception e) {
                    this.e = e;
                }
            }

            T getResult() throws Exception {
                if (this.e != null) {
                    throw this.e;
                }
                return this.object;
            }
        }
    }

    private class AccessibleJTreeNode
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleSelection,
    AccessibleAction {
        private JTree tree = null;
        private TreeModel treeModel = null;
        private Object obj = null;
        private TreePath path = null;
        private Accessible accessibleParent = null;
        private int index = 0;
        private boolean isLeaf = false;

        AccessibleJTreeNode(JTree t, TreePath p, Accessible ap) {
            this.tree = t;
            this.path = p;
            this.accessibleParent = ap;
            if (t != null) {
                this.treeModel = t.getModel();
            }
            if (p != null) {
                this.obj = p.getLastPathComponent();
                if (this.treeModel != null && this.obj != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }
            AccessBridge.this.debugString("[INFO]: AccessibleJTreeNode: name = " + this.getAccessibleName() + "; TreePath = " + p + "; parent = " + ap);
        }

        private TreePath getChildTreePath(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount() || this.path == null || this.treeModel == null) {
                return null;
            }
            Object childObj = this.treeModel.getChild(this.obj, i);
            Object[] objPath = this.path.getPath();
            Object[] objChildPath = new Object[objPath.length + 1];
            System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
            objChildPath[objChildPath.length - 1] = childObj;
            return new TreePath(objChildPath);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component c = this.getCurrentComponent();
            if (c instanceof Accessible) {
                return c.getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            AccessBridge.this.debugString("[INFO]: AccessibleJTreeNode: getCurrentComponent");
            if (this.tree != null && this.tree.isVisible(this.path)) {
                TreeCellRenderer r = this.tree.getCellRenderer();
                if (r == null) {
                    AccessBridge.this.debugString("[WARN]:  returning null 1");
                    return null;
                }
                TreeUI ui = this.tree.getUI();
                if (ui != null) {
                    int row = ui.getRowForPath(this.tree, this.path);
                    boolean selected = this.tree.isPathSelected(this.path);
                    boolean expanded = this.tree.isExpanded(this.path);
                    boolean hasFocus = false;
                    Component retval = r.getTreeCellRendererComponent(this.tree, this.obj, selected, expanded, this.isLeaf, row, hasFocus);
                    AccessBridge.this.debugString("[INFO]:   returning = " + retval.getClass());
                    return retval;
                }
            }
            AccessBridge.this.debugString("[WARN]:  returning null 2");
            return null;
        }

        @Override
        public String getAccessibleName() {
            AccessBridge.this.debugString("[INFO]: AccessibleJTreeNode: getAccessibleName");
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                String name = ac.getAccessibleName();
                if (name != null && !name.isEmpty()) {
                    String retval = ac.getAccessibleName();
                    AccessBridge.this.debugString("[INFO]:     returning " + retval);
                    return retval;
                }
                return null;
            }
            if (this.accessibleName != null && this.accessibleName.isEmpty()) {
                return this.accessibleName;
            }
            return null;
        }

        @Override
        public void setAccessibleName(String s) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(s);
            } else {
                super.setAccessibleName(s);
            }
        }

        @Override
        public String getAccessibleDescription() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        @Override
        public void setAccessibleDescription(String s) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.setAccessibleDescription(s);
            } else {
                super.setAccessibleDescription(s);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleRole();
            }
            return AccessibleRole.UNKNOWN;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (this.tree == null) {
                return null;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            int row = this.tree.getUI().getRowForPath(this.tree, this.path);
            int lsr = this.tree.getLeadSelectionRow();
            AccessibleStateSet states = ac != null ? ac.getAccessibleStateSet() : new AccessibleStateSet();
            if (this.isShowing()) {
                states.add(AccessibleState.SHOWING);
            } else if (states.contains(AccessibleState.SHOWING)) {
                states.remove(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                states.add(AccessibleState.VISIBLE);
            } else if (states.contains(AccessibleState.VISIBLE)) {
                states.remove(AccessibleState.VISIBLE);
            }
            if (this.tree.isPathSelected(this.path)) {
                states.add(AccessibleState.SELECTED);
            }
            if (lsr == row) {
                states.add(AccessibleState.ACTIVE);
            }
            if (!this.isLeaf) {
                states.add(AccessibleState.EXPANDABLE);
            }
            if (this.tree.isExpanded(this.path)) {
                states.add(AccessibleState.EXPANDED);
            } else {
                states.add(AccessibleState.COLLAPSED);
            }
            if (this.tree.isEditable()) {
                states.add(AccessibleState.EDITABLE);
            }
            return states;
        }

        @Override
        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null && this.path != null) {
                Object[] objPath = this.path.getPath();
                if (objPath.length > 1) {
                    Object objParent = objPath[objPath.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                    }
                    Object[] objParentPath = new Object[objPath.length - 1];
                    System.arraycopy(objPath, 0, objParentPath, 0, objPath.length - 1);
                    TreePath parentPath = new TreePath(objParentPath);
                    this.accessibleParent = new AccessibleJTreeNode(this.tree, parentPath, null);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.accessibleParent = this.tree;
                    this.index = 0;
                    this.setAccessibleParent(this.accessibleParent);
                }
            }
            return this.accessibleParent;
        }

        @Override
        public int getAccessibleIndexInParent() {
            Object[] objPath;
            if (this.accessibleParent == null) {
                this.getAccessibleParent();
            }
            if (this.path != null && (objPath = this.path.getPath()).length > 1) {
                Object objParent = objPath[objPath.length - 2];
                if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                }
            }
            return this.index;
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (this.obj != null && this.treeModel != null) {
                return this.treeModel.getChildCount(this.obj);
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount() || this.path == null || this.treeModel == null) {
                return null;
            }
            Object childObj = this.treeModel.getChild(this.obj, i);
            Object[] objPath = this.path.getPath();
            Object[] objChildPath = new Object[objPath.length + 1];
            System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
            objChildPath[objChildPath.length - 1] = childObj;
            TreePath childPath = new TreePath(objChildPath);
            return new AccessibleJTreeNode(this.tree, childPath, this);
        }

        @Override
        public Locale getLocale() {
            if (this.tree == null) {
                return null;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getLocale();
            }
            return this.tree.getLocale();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.addPropertyChangeListener(l);
            } else {
                super.addPropertyChangeListener(l);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.removePropertyChangeListener(l);
            } else {
                super.removePropertyChangeListener(l);
            }
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null && this.isLeaf) {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }
            return this;
        }

        @Override
        public AccessibleText getAccessibleText() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public Color getBackground() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getBackground();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getBackground();
            }
            return null;
        }

        @Override
        public void setBackground(Color c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setBackground(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setBackground(c);
                }
            }
        }

        @Override
        public Color getForeground() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getForeground();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getForeground();
            }
            return null;
        }

        @Override
        public void setForeground(Color c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setForeground(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setForeground(c);
                }
            }
        }

        @Override
        public Cursor getCursor() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getCursor();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getCursor();
            }
            Accessible ap = this.getAccessibleParent();
            if (ap instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ap)).getCursor();
            }
            return null;
        }

        @Override
        public void setCursor(Cursor c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setCursor(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setCursor(c);
                }
            }
        }

        @Override
        public Font getFont() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getFont();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getFont();
            }
            return null;
        }

        @Override
        public void setFont(Font f) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setFont(f);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setFont(f);
                }
            }
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getFontMetrics(f);
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).isEnabled();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.isEnabled();
            }
            return false;
        }

        @Override
        public void setEnabled(boolean b) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setEnabled(b);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setEnabled(b);
                }
            }
        }

        @Override
        public boolean isVisible() {
            if (this.tree == null) {
                return false;
            }
            Rectangle pathBounds = this.tree.getPathBounds(this.path);
            Rectangle parentBounds = this.tree.getVisibleRect();
            return pathBounds != null && parentBounds != null && parentBounds.intersects(pathBounds);
        }

        @Override
        public void setVisible(boolean b) {
        }

        @Override
        public boolean isShowing() {
            return this.tree.isShowing() && this.isVisible();
        }

        @Override
        public boolean contains(Point p) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                return r.contains(p);
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                Rectangle r = c.getBounds();
                return r.contains(p);
            }
            return this.getBounds().contains(p);
        }

        @Override
        public Point getLocationOnScreen() {
            if (this.tree != null) {
                Point treeLocation = this.tree.getLocationOnScreen();
                Rectangle pathBounds = this.tree.getPathBounds(this.path);
                if (treeLocation != null && pathBounds != null) {
                    Point nodeLocation = new Point(pathBounds.x, pathBounds.y);
                    nodeLocation.translate(treeLocation.x, treeLocation.y);
                    return nodeLocation;
                }
                return null;
            }
            return null;
        }

        private Point getLocationInJTree() {
            Rectangle r = this.tree.getPathBounds(this.path);
            if (r != null) {
                return r.getLocation();
            }
            return null;
        }

        @Override
        public Point getLocation() {
            Rectangle r = this.getBounds();
            if (r != null) {
                return r.getLocation();
            }
            return null;
        }

        @Override
        public void setLocation(Point p) {
        }

        @Override
        public Rectangle getBounds() {
            if (this.tree == null) {
                return null;
            }
            Rectangle r = this.tree.getPathBounds(this.path);
            Accessible parent = this.getAccessibleParent();
            if (parent instanceof AccessibleJTreeNode) {
                Point parentLoc = ((AccessibleJTreeNode)parent).getLocationInJTree();
                if (parentLoc != null && r != null) {
                    r.translate(-parentLoc.x, -parentLoc.y);
                } else {
                    return null;
                }
            }
            return r;
        }

        @Override
        public void setBounds(Rectangle r) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setBounds(r);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setBounds(r);
                }
            }
        }

        @Override
        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        @Override
        public void setSize(Dimension d) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setSize(d);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setSize(d);
                }
            }
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.isFocusable();
            }
            return false;
        }

        @Override
        public void requestFocus() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).requestFocus();
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.requestFocus();
                }
            }
        }

        @Override
        public void addFocusListener(FocusListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).addFocusListener(l);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.addFocusListener(l);
                }
            }
        }

        @Override
        public void removeFocusListener(FocusListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.removeFocusListener(l);
                }
            }
        }

        @Override
        public int getAccessibleSelectionCount() {
            int count = 0;
            int childCount = this.getAccessibleChildrenCount();
            for (int i = 0; i < childCount; ++i) {
                TreePath childPath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(childPath)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            int childCount = this.getAccessibleChildrenCount();
            if (i < 0 || i >= childCount) {
                return null;
            }
            int count = 0;
            for (int j = 0; j < childCount && i >= count; ++j) {
                TreePath childPath = this.getChildTreePath(j);
                if (!this.tree.isPathSelected(childPath)) continue;
                if (count == i) {
                    return new AccessibleJTreeNode(this.tree, childPath, this);
                }
                ++count;
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            int childCount = this.getAccessibleChildrenCount();
            if (i < 0 || i >= childCount) {
                return false;
            }
            TreePath childPath = this.getChildTreePath(i);
            return this.tree.isPathSelected(childPath);
        }

        @Override
        public void addAccessibleSelection(int i) {
            if (this.tree == null) {
                return;
            }
            TreeModel model = this.tree.getModel();
            if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                TreePath path = this.getChildTreePath(i);
                this.tree.addSelectionPath(path);
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (this.tree == null) {
                return;
            }
            TreeModel model = this.tree.getModel();
            if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                TreePath path = this.getChildTreePath(i);
                this.tree.removeSelectionPath(path);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            int childCount = this.getAccessibleChildrenCount();
            for (int i = 0; i < childCount; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            if (this.tree == null) {
                return;
            }
            TreeModel model = this.tree.getModel();
            if (model != null) {
                int childCount = this.getAccessibleChildrenCount();
                for (int i = 0; i < childCount; ++i) {
                    TreePath path = this.getChildTreePath(i);
                    this.tree.addSelectionPath(path);
                }
            }
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction aa;
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
            }
            return this.isLeaf ? 0 : 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            AccessibleAction aa;
            if (i < 0 || i >= this.getAccessibleActionCount()) {
                return null;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (i == 0) {
                return "toggle expand";
            }
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.getAccessibleActionDescription(i - 1);
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            AccessibleAction aa;
            if (i < 0 || i >= this.getAccessibleActionCount()) {
                return false;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (i == 0) {
                if (this.tree.isExpanded(this.path)) {
                    this.tree.collapsePath(this.path);
                } else {
                    this.tree.expandPath(this.path);
                }
                return true;
            }
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.doAccessibleAction(i - 1);
            }
            return false;
        }
    }

    private class EventHandler
    implements PropertyChangeListener,
    FocusListener,
    CaretListener,
    MenuListener,
    PopupMenuListener,
    MouseListener,
    WindowListener,
    ChangeListener {
        private AccessBridge accessBridge;
        private long javaEventMask = 0L;
        private long accessibilityEventMask = 0L;
        private AccessibleContext prevAC = null;
        private boolean stateChangeListenerAdded = false;

        EventHandler(AccessBridge bridge) {
            this.accessBridge = bridge;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            Object o = null;
            if (e != null) {
                o = e.getSource();
            }
            if (o instanceof NativeWindowHandler) {
                AccessBridge.addNativeWindowHandler((NativeWindowHandler)o);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Object o = null;
            if (e != null) {
                o = e.getSource();
            }
            if (o instanceof NativeWindowHandler) {
                AccessBridge.removeNativeWindowHandler((NativeWindowHandler)o);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        void addJavaEventNotification(long type) {
            long newEventMask = this.javaEventMask | type;
            if ((this.javaEventMask & 6L) == 0L && (newEventMask & 6L) != 0L) {
                SwingEventMonitor.addFocusListener(this);
            }
            if ((this.javaEventMask & 8L) == 0L && (newEventMask & 8L) != 0L) {
                SwingEventMonitor.addCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (newEventMask & 0x1F0L) != 0L) {
                SwingEventMonitor.addMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (newEventMask & 0xE00L) != 0L) {
                SwingEventMonitor.addMenuListener(this);
                SwingEventMonitor.addPopupMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (newEventMask & 0x7000L) != 0L) {
                SwingEventMonitor.addPopupMenuListener(this);
            }
            this.javaEventMask = newEventMask;
        }

        void removeJavaEventNotification(long type) {
            long newEventMask = this.javaEventMask & (type ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.javaEventMask & 6L) != 0L && (newEventMask & 6L) == 0L) {
                SwingEventMonitor.removeFocusListener(this);
            }
            if ((this.javaEventMask & 8L) != 0L && (newEventMask & 8L) == 0L) {
                SwingEventMonitor.removeCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (newEventMask & 0x1F0L) != 0L) {
                SwingEventMonitor.removeMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (newEventMask & 0xE00L) != 0L) {
                SwingEventMonitor.removeMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (newEventMask & 0x7000L) != 0L) {
                SwingEventMonitor.removePopupMenuListener(this);
            }
            this.javaEventMask = newEventMask;
        }

        void addAccessibilityEventNotification(long type) {
            long newEventMask = this.accessibilityEventMask | type;
            if ((this.accessibilityEventMask & 0x3FFL) == 0L && (newEventMask & 0x3FFL) != 0L) {
                AccessibilityEventMonitor.addPropertyChangeListener(this);
            }
            this.accessibilityEventMask = newEventMask;
        }

        void removeAccessibilityEventNotification(long type) {
            long newEventMask = this.accessibilityEventMask & (type ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.accessibilityEventMask & 0x3FFL) != 0L && (newEventMask & 0x3FFL) == 0L) {
                AccessibilityEventMonitor.removePropertyChangeListener(this);
            }
            this.accessibilityEventMask = newEventMask;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.accessBridge.debugString("[INFO]: propertyChange(" + e.toString() + ") called");
            if (e != null && (this.accessibilityEventMask & 0x3FFL) != 0L) {
                AccessibleContext ac;
                Object o = e.getSource();
                if (o instanceof AccessibleContext) {
                    ac = (AccessibleContext)o;
                } else {
                    Accessible a = Translator.getAccessible(e.getSource());
                    if (a == null) {
                        return;
                    }
                    ac = a.getAccessibleContext();
                }
                if (ac != null) {
                    InvocationUtils.registerAccessibleContext(ac, AppContext.getAppContext());
                    this.accessBridge.debugString("[INFO]: AccessibleContext: " + ac);
                    String propertyName = e.getPropertyName();
                    if (propertyName.compareTo("AccessibleCaret") == 0) {
                        int oldValue = 0;
                        int newValue = 0;
                        if (e.getOldValue() instanceof Integer) {
                            oldValue = (Integer)e.getOldValue();
                        }
                        if (e.getNewValue() instanceof Integer) {
                            newValue = (Integer)e.getNewValue();
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyCaretChange()   old value: " + oldValue + "new value: " + newValue);
                        this.accessBridge.propertyCaretChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleDescription") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyDescriptionChange()   old value: " + oldValue + "new value: " + newValue);
                        this.accessBridge.propertyDescriptionChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleName") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyNameChange()   old value: " + oldValue + " new value: " + newValue);
                        this.accessBridge.propertyNameChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleSelection") == 0) {
                        this.accessBridge.debugString("[INFO]:  - about to call propertySelectionChange() " + ac + "   " + Thread.currentThread() + "   " + e.getSource());
                        this.accessBridge.propertySelectionChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleState") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            AccessibleState oldState = (AccessibleState)e.getOldValue();
                            oldValue = oldState.toDisplayString(Locale.US);
                        }
                        if (e.getNewValue() != null) {
                            AccessibleState newState = (AccessibleState)e.getNewValue();
                            newValue = newState.toDisplayString(Locale.US);
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyStateChange()");
                        this.accessBridge.propertyStateChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleText") == 0) {
                        this.accessBridge.debugString("[INFO]:  - about to call propertyTextChange()");
                        this.accessBridge.propertyTextChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleValue") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyValueChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleVisibleData") == 0) {
                        this.accessBridge.propertyVisibleDataChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleChild") == 0) {
                        AccessibleContext oldAC = null;
                        AccessibleContext newAC = null;
                        if (e.getOldValue() instanceof AccessibleContext) {
                            oldAC = (AccessibleContext)e.getOldValue();
                            InvocationUtils.registerAccessibleContext(oldAC, AppContext.getAppContext());
                        }
                        if (e.getNewValue() instanceof AccessibleContext) {
                            newAC = (AccessibleContext)e.getNewValue();
                            InvocationUtils.registerAccessibleContext(newAC, AppContext.getAppContext());
                        }
                        this.accessBridge.debugString("[INFO]:  - about to call propertyChildChange()   old AC: " + oldAC + "new AC: " + newAC);
                        this.accessBridge.propertyChildChange(e, ac, oldAC, newAC);
                    } else if (propertyName.compareTo("AccessibleActiveDescendant") == 0) {
                        this.handleActiveDescendentEvent(e, ac);
                    }
                }
            }
        }

        private void handleActiveDescendentEvent(PropertyChangeEvent e, AccessibleContext ac) {
            Accessible parent;
            Accessible a;
            if (e == null || ac == null) {
                return;
            }
            AccessibleContext oldAC = null;
            AccessibleContext newAC = null;
            if (e.getOldValue() instanceof Accessible) {
                oldAC = ((Accessible)e.getOldValue()).getAccessibleContext();
            } else if (e.getOldValue() instanceof Component && (a = Translator.getAccessible(e.getOldValue())) != null) {
                oldAC = a.getAccessibleContext();
            }
            if (oldAC != null && (parent = oldAC.getAccessibleParent()) instanceof JTree) {
                oldAC = this.prevAC;
            }
            if (e.getNewValue() instanceof Accessible) {
                newAC = ((Accessible)e.getNewValue()).getAccessibleContext();
            } else if (e.getNewValue() instanceof Component && (a = Translator.getAccessible(e.getNewValue())) != null) {
                newAC = a.getAccessibleContext();
            }
            if (newAC != null && (parent = newAC.getAccessibleParent()) instanceof JTree) {
                JTree tree = (JTree)parent;
                newAC = new AccessibleJTreeNode(tree, tree.getSelectionPath(), null);
            }
            this.prevAC = newAC;
            this.accessBridge.debugString("[INFO]:   - about to call propertyActiveDescendentChange()   AC: " + ac + "   old AC: " + oldAC + "new AC: " + newAC);
            InvocationUtils.registerAccessibleContext(oldAC, AppContext.getAppContext());
            InvocationUtils.registerAccessibleContext(newAC, AppContext.getAppContext());
            this.accessBridge.propertyActiveDescendentChange(e, ac, oldAC, newAC);
        }

        @Override
        public void focusGained(FocusEvent e) {
            Accessible a;
            if (AccessBridge.this.runningOnJDK1_4) {
                this.processFocusGained();
            } else if ((this.javaEventMask & 2L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, SunToolkit.targetToAppContext(e.getSource()));
                this.accessBridge.focusGained(e, context);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null) {
                return;
            }
            if (focusOwner instanceof JRootPane) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 1) {
                    Component penult = path[path.length - 2].getComponent();
                    Component last = path[path.length - 1].getComponent();
                    if (last instanceof JPopupMenu) {
                        FocusEvent e = new FocusEvent(penult, 1004);
                        AccessibleContext context = penult.getAccessibleContext();
                        InvocationUtils.registerAccessibleContext(context, SunToolkit.targetToAppContext(penult));
                        this.accessBridge.focusGained(e, context);
                    } else if (penult instanceof JPopupMenu) {
                        FocusEvent e = new FocusEvent(last, 1004);
                        AccessibleContext focusedAC = last.getAccessibleContext();
                        InvocationUtils.registerAccessibleContext(focusedAC, SunToolkit.targetToAppContext(last));
                        this.accessBridge.debugString("[INFO]:  - about to call focusGained()   AC: " + focusedAC);
                        this.accessBridge.focusGained(e, focusedAC);
                    }
                }
            } else if (focusOwner instanceof Accessible) {
                FocusEvent e = new FocusEvent(focusOwner, 1004);
                AccessibleContext focusedAC = focusOwner.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(focusedAC, SunToolkit.targetToAppContext(focusOwner));
                this.accessBridge.debugString("[INFO]:  - about to call focusGained()   AC: " + focusedAC);
                this.accessBridge.focusGained(e, focusedAC);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 4L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.debugString("[INFO]:  - about to call focusLost()   AC: " + a.getAccessibleContext());
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.focusLost(e, context);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 8L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.caretUpdate(e, context);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x10L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.mouseClicked(e, context);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x20L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.mouseEntered(e, context);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x40L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.mouseExited(e, context);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x80L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.mousePressed(e, context);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x100L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.mouseReleased(e, context);
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x200L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.menuCanceled(e, context);
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x400L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.menuDeselected(e, context);
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x800L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.menuSelected(e, context);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x1000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.popupMenuCanceled(e, context);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x2000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.popupMenuWillBecomeInvisible(e, context);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Accessible a;
            if (e != null && (this.javaEventMask & 0x4000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                AccessibleContext context = a.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(context, AppContext.getAppContext());
                this.accessBridge.popupMenuWillBecomeVisible(e, context);
            }
        }
    }

    private class ObjectReferences {
        private ConcurrentHashMap<Object, Reference> refs = new ConcurrentHashMap(4);

        ObjectReferences() {
        }

        String dump() {
            return this.refs.toString();
        }

        void increment(Object o) {
            if (o == null) {
                AccessBridge.this.debugString("[WARN]: ObjectReferences::increment - Passed in object is null");
                return;
            }
            if (this.refs.containsKey(o)) {
                this.refs.get(o).value++;
            } else {
                this.refs.put(o, new Reference(1));
            }
        }

        void decrement(Object o) {
            Reference aRef = this.refs.get(o);
            if (aRef != null) {
                aRef.value--;
                if (aRef.value == 0) {
                    this.refs.remove(o);
                } else if (aRef.value < 0) {
                    AccessBridge.this.debugString("[ERROR]: decrementing reference count below 0");
                }
            } else {
                AccessBridge.this.debugString("[ERROR]: object to decrement not in ObjectReferences table");
            }
        }

        private class Reference {
            private int value;

            Reference(int i) {
                this.value = i;
            }

            public String toString() {
                return "refCount: " + this.value;
            }
        }
    }

    private class DefaultNativeWindowHandler
    implements NativeWindowHandler {
        private DefaultNativeWindowHandler() {
        }

        @Override
        public Accessible getAccessibleFromNativeWindowHandle(int nativeHandle) {
            final Component c = this.getComponentFromNativeWindowHandle(nativeHandle);
            if (c instanceof Accessible) {
                AccessibleContext ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return c.getAccessibleContext();
                    }
                }, c);
                AccessBridge.this.saveContextToWindowHandleMapping(ac, nativeHandle);
                return (Accessible)((Object)c);
            }
            return null;
        }

        private Component getComponentFromNativeWindowHandle(int nativeHandle) {
            if (AccessBridge.this.useJAWT_DLL) {
                AccessBridge.this.debugString("[INFO]:*** calling jawtGetComponentFromNativeWindowHandle");
                return AccessBridge.this.jawtGetComponentFromNativeWindowHandle(nativeHandle);
            }
            AccessBridge.this.debugString("[INFO]:*** calling javaGetComponentFromNativeWindowHandle");
            Object[] args = new Object[1];
            if (AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod != null) {
                try {
                    args[0] = nativeHandle;
                    Object o = AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)AccessBridge.this.toolkit, args);
                    if (o instanceof Accessible) {
                        final Accessible acc = (Accessible)o;
                        AccessibleContext ac = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                            @Override
                            public AccessibleContext call() throws Exception {
                                return acc.getAccessibleContext();
                            }
                        }, (Component)o);
                        AccessBridge.this.saveContextToWindowHandleMapping(ac, nativeHandle);
                    }
                    return (Component)o;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    AccessBridge.this.debugString("[ERROR]:Exception: " + e.toString());
                }
            }
            return null;
        }
    }

    private static interface NativeWindowHandler {
        public Accessible getAccessibleFromNativeWindowHandle(int var1);
    }

    private class shutdownHook
    implements Runnable {
        private shutdownHook() {
        }

        @Override
        public void run() {
            AccessBridge.this.debugString("[INFO]:***** shutdownHook: shutting down...");
            AccessBridge.this.javaShutdown();
        }
    }

    private class dllRunner
    implements Runnable {
        private dllRunner() {
        }

        @Override
        public void run() {
            AccessBridge.this.runDLL();
        }
    }
}

