/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.client.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.ApiException;
import com.zkteco.cloud.sdk.BaseRequest;
import com.zkteco.cloud.sdk.DefaultZKCloudClient;
import com.zkteco.cloud.sdk.FileItem;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.bean.FileBean;
import com.zkteco.cloud.sdk.resp.ObjectResponse;
import com.zkteco.cloud.sdk.util.ZKCloudApiFileUploadUtil;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiAlipayGroupFaceCodeItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiAlipayGroupQrcodeItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiAlipaySignEmployeeDeleteItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiAlipaySmilepayInitializeItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudBarcodePayItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudCheckOrderItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudCutPaymentItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudQrcodePayItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudWxPayFaceAuthInfoItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiGetPayServiceProviderItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiGetUserIdByBarcodeItem;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDAlipaySignEmployeeDeleteRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudAlipayGroupFaceCodeRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudAlipayGroupQrcodeRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudAlipaySmilepayInitializeRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudBarcodePayRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudCheckOrderRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudCutPaymentRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudGetPayServiceProviderRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudGetUserIdByBarcodeRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudPaymentParamsRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudQrcodePayRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudWxPayFaceAuthInfoRequest;
import com.zkteco.zkbiosecurity.posid.service.PosIDCloudService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAliOfflineFaceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAliPayFaceConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOfflineFaceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPayOrderItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDWxPayFaceConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDWxPayFaceItem;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PosIDCloudServiceImpl
implements PosIDCloudService {
    private static final Logger log = LoggerFactory.getLogger(PosIDCloudServiceImpl.class);
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;
    @Value(value="${cloud.server.upload.url:https://zkcloud.xmzkteco.com/BiosecurityApp/router/rest}")
    private String serverUrl;
    @Value(value="${cloud.server.file.url:https://zfs.zkbiosecurity.com}")
    private String uploadUrl;

    public ZKResultMsg cloudBarcodePay(Integer money, String code, String sn) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            try {
                String token = this.baseAuthCloudMessageSendService.createToken();
                ZKCouldClient couldClient = this.getSendMsgClient();
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                PosIDApiCloudBarcodePayItem posIDApiCloudBarcodePayItem = new PosIDApiCloudBarcodePayItem();
                posIDApiCloudBarcodePayItem.setCode(code);
                posIDApiCloudBarcodePayItem.setPrice(money);
                posIDApiCloudBarcodePayItem.setOrderSn(uuid);
                posIDApiCloudBarcodePayItem.setDeviceSn(sn);
                InetAddress address = InetAddress.getLocalHost();
                String hostAddress = address.getHostAddress();
                posIDApiCloudBarcodePayItem.setIp(hostAddress);
                posIDApiCloudBarcodePayItem.setBody(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
                ApiPosIDCloudBarcodePayRequest ppiPosIDCloudBarcodePayRequest = new ApiPosIDCloudBarcodePayRequest();
                ppiPosIDCloudBarcodePayRequest.setPosIDApiCloudBarcodePayItem(posIDApiCloudBarcodePayItem);
                ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)ppiPosIDCloudBarcodePayRequest, token);
                Integer ret = Integer.parseInt(rsp.getCode());
                log.info("cloudBarcodePay ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                if (ret == -27) {
                    token = this.baseAuthCloudMessageSendService.refreshToken();
                    rsp = (ObjectResponse)couldClient.execute((BaseRequest)ppiPosIDCloudBarcodePayRequest, token);
                    ret = Integer.parseInt(rsp.getCode());
                }
                if (ret != 0) {
                    return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
                }
                JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
                if ("orderSuccess".equals(jsonObject.getString("msg"))) {
                    ZKResultMsg zkResultMsg = this.cheOrderPay(jsonObject.getString("data"), couldClient);
                    if (!zkResultMsg.isSuccess()) {
                        return zkResultMsg;
                    }
                    jsonObject = (JSONObject)zkResultMsg.getData();
                }
                String data = uuid + "=" + jsonObject.getString("data");
                return new ZKResultMsg((Object)data);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZKResultMsg.failMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }

    public ZKCouldClient getSendMsgClient() {
        String appId = this.baseLicenseService.getAppId();
        String appKey = this.baseSysParamService.getValByName("zkteco:cloud:appkey");
        DefaultZKCloudClient couldClient = new DefaultZKCloudClient(this.serverUrl, appId, appKey, "json", 15000, 45000);
        return couldClient;
    }

    public ZKResultMsg cloudQrcodePay(PosIDPayOrderItem posIDPayOrderItem, String body) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)posIDPayOrderItem.getId())) {
            try {
                String token = this.baseAuthCloudMessageSendService.createToken();
                ZKCouldClient couldClient = this.getSendMsgClient();
                PosIDApiCloudQrcodePayItem posIDApiCloudQrcodePayItem = new PosIDApiCloudQrcodePayItem();
                posIDApiCloudQrcodePayItem.setPin(posIDPayOrderItem.getPin());
                posIDApiCloudQrcodePayItem.setType(posIDPayOrderItem.getPayType().toString());
                posIDApiCloudQrcodePayItem.setPrice(posIDPayOrderItem.getAmount());
                posIDApiCloudQrcodePayItem.setOrderSn(posIDPayOrderItem.getId());
                posIDApiCloudQrcodePayItem.setDeviceSn(posIDPayOrderItem.getSn());
                posIDApiCloudQrcodePayItem.setIp(posIDPayOrderItem.getClientIp());
                posIDApiCloudQrcodePayItem.setBody(body);
                ApiPosIDCloudQrcodePayRequest apiPosIDCloudQrcodePayRequest = new ApiPosIDCloudQrcodePayRequest();
                apiPosIDCloudQrcodePayRequest.setPosIDApiCloudQrcodePayItem(posIDApiCloudQrcodePayItem);
                ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudQrcodePayRequest, token);
                Integer ret = Integer.parseInt(rsp.getCode());
                log.info("cloudQrcodePay ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                if (ret == -27) {
                    token = this.baseAuthCloudMessageSendService.refreshToken();
                    rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudQrcodePayRequest, token);
                    ret = Integer.parseInt(rsp.getCode());
                }
                if (ret != 0) {
                    return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
                }
                JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
                String data = jsonObject.getString("data");
                return new ZKResultMsg((Object)data);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZKResultMsg.failMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }

    private ZKResultMsg cheOrderPay(String orderId, ZKCouldClient couldClient) {
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            PosIDApiCloudCheckOrderItem posIDApiCloudCheckOrderItem = new PosIDApiCloudCheckOrderItem();
            posIDApiCloudCheckOrderItem.setOrderSn(orderId);
            ApiPosIDCloudCheckOrderRequest apiPosIDCloudCheckOrderRequest = new ApiPosIDCloudCheckOrderRequest();
            apiPosIDCloudCheckOrderRequest.setPosIDApiCloudCheckOrderItem(posIDApiCloudCheckOrderItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudCheckOrderRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("cheOrderPay ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudCheckOrderRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg upload(String filePath) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            FileBean fileBean = new FileBean();
            fileBean.setModuleName("posid");
            fileBean.setAppId(this.baseLicenseService.getAppId());
            fileBean.setAppKey(this.baseSysParamService.getValByName("zkteco:cloud:appkey"));
            fileBean.setCloudServerFileUrl(this.uploadUrl);
            fileBean.setFile(new FileItem(filePath));
            JSONObject jsonObject = JSONObject.parseObject((String)ZKCloudApiFileUploadUtil.upload((FileBean)fileBean).getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (ApiException e) {
            log.error("upload file fail fileName = " + filePath);
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg getWxPayFaceAuthinfo(String sn, PosIDWxPayFaceItem posIDWxPayFaceItem) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiCloudWxPayFaceAuthInfoItem posIDApiCloudWxPayFaceAuthInfoItem = new PosIDApiCloudWxPayFaceAuthInfoItem();
            posIDApiCloudWxPayFaceAuthInfoItem.setDevSn(sn);
            posIDApiCloudWxPayFaceAuthInfoItem.setRawdata(posIDWxPayFaceItem.getRawdata());
            ApiPosIDCloudWxPayFaceAuthInfoRequest apiPosIDCloudWxPayFaceAuthInfoRequest = new ApiPosIDCloudWxPayFaceAuthInfoRequest();
            apiPosIDCloudWxPayFaceAuthInfoRequest.setPosIDApiCloudWxPayFaceAuthInfoItem(posIDApiCloudWxPayFaceAuthInfoItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudWxPayFaceAuthInfoRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getWxPayFaceAuthinfo ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudWxPayFaceAuthInfoRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getJSONObject("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg getPaymentParams(String sn) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiCloudWxPayFaceAuthInfoItem posIDApiCloudWxPayFaceAuthInfoItem = new PosIDApiCloudWxPayFaceAuthInfoItem();
            posIDApiCloudWxPayFaceAuthInfoItem.setDevSn(sn);
            ApiPosIDCloudPaymentParamsRequest apiPosIDCloudPaymentParamsRequest = new ApiPosIDCloudPaymentParamsRequest();
            apiPosIDCloudPaymentParamsRequest.setPosIDApiCloudWxPayFaceAuthInfoItem(posIDApiCloudWxPayFaceAuthInfoItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudPaymentParamsRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getPaymentParams ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudPaymentParamsRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getJSONObject("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg offlineface(PosIDWxPayFaceConsumeItem posIDWxPayFaceConsumeItem, PosIDOfflineFaceItem posIDOfflineFaceItem, String description, String attach) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiCloudCutPaymentItem posIDApiCloudCutPaymentItem = new PosIDApiCloudCutPaymentItem();
            posIDApiCloudCutPaymentItem.setDevSn(posIDWxPayFaceConsumeItem.getSn());
            posIDApiCloudCutPaymentItem.setAuthCode(posIDWxPayFaceConsumeItem.getAuthCode());
            posIDApiCloudCutPaymentItem.setAmount(posIDOfflineFaceItem.getWxPayMoney());
            posIDApiCloudCutPaymentItem.setIpAddress(posIDWxPayFaceConsumeItem.getIpAddress());
            posIDApiCloudCutPaymentItem.setDescription(description);
            posIDApiCloudCutPaymentItem.setAttach(attach);
            ApiPosIDCloudCutPaymentRequest apiPosIDCloudCutPaymentRequest = new ApiPosIDCloudCutPaymentRequest();
            apiPosIDCloudCutPaymentRequest.setPosIDApiCloudCutPaymentItem(posIDApiCloudCutPaymentItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudCutPaymentRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("offlineface ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudCutPaymentRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg aliDevInit(String metaInfo) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiAlipaySmilepayInitializeItem posIDApiAlipaySmilepayInitializeItem = new PosIDApiAlipaySmilepayInitializeItem();
            posIDApiAlipaySmilepayInitializeItem.setMetaInfo(metaInfo);
            ApiPosIDCloudAlipaySmilepayInitializeRequest apiPosIDCloudAlipaySmilepayInitializeRequest = new ApiPosIDCloudAlipaySmilepayInitializeRequest();
            apiPosIDCloudAlipaySmilepayInitializeRequest.setPosIDApiAlipaySmilepayInitializeItem(posIDApiAlipaySmilepayInitializeItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipaySmilepayInitializeRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("aliDevInit ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipaySmilepayInitializeRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg getUserIdByBarcode(String barcode) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiGetUserIdByBarcodeItem posIDApiGetUserIdByBarcodeItem = new PosIDApiGetUserIdByBarcodeItem();
            posIDApiGetUserIdByBarcodeItem.setBarcode(barcode);
            ApiPosIDCloudGetUserIdByBarcodeRequest apiPosIDCloudGetUserIdByBarcodeRequest = new ApiPosIDCloudGetUserIdByBarcodeRequest();
            apiPosIDCloudGetUserIdByBarcodeRequest.setPosIDApiGetUserIdByBarcodeItem(posIDApiGetUserIdByBarcodeItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudGetUserIdByBarcodeRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getUserIdByBarcode ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudGetUserIdByBarcodeRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg alipayGroupQrcode(String id, PosIDAliOfflineFaceItem posIDAliOfflineFaceItem, PosIDAliPayFaceConsumeItem posIDAliPayFaceConsumeItem, String ipAddress) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiAlipayGroupQrcodeItem posIDApiAlipayGroupQrcodeItem = new PosIDApiAlipayGroupQrcodeItem();
            posIDApiAlipayGroupQrcodeItem.setMchOrderNo(id);
            posIDApiAlipayGroupQrcodeItem.setTradeType("2");
            posIDApiAlipayGroupQrcodeItem.setCurrency("cny");
            posIDApiAlipayGroupQrcodeItem.setSubject(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
            posIDApiAlipayGroupQrcodeItem.setBody(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
            posIDApiAlipayGroupQrcodeItem.setCode(posIDAliPayFaceConsumeItem.getAuthCode());
            posIDApiAlipayGroupQrcodeItem.setClientIp(ipAddress);
            posIDApiAlipayGroupQrcodeItem.setTerminalParams(posIDAliPayFaceConsumeItem.getTerminalParams());
            if ("OK".equals(posIDAliOfflineFaceItem.getSignStatus()) && "1".equals(posIDAliOfflineFaceItem.getAliPayEnterprise())) {
                posIDApiAlipayGroupQrcodeItem.setAmount(PosIDCloudServiceImpl.moneyAdd(posIDAliOfflineFaceItem.getAliPayMoney(), posIDAliOfflineFaceItem.getAllowanceWallet()));
                posIDApiAlipayGroupQrcodeItem.setIsEnterprisePay("1");
                posIDApiAlipayGroupQrcodeItem.setEnterprisePayAmount(posIDAliOfflineFaceItem.getAllowanceWallet());
                posIDApiAlipayGroupQrcodeItem.setParam2("aliPayEnterpriseCard");
            } else {
                posIDApiAlipayGroupQrcodeItem.setIsEnterprisePay("0");
                posIDApiAlipayGroupQrcodeItem.setAmount(posIDAliOfflineFaceItem.getAliPayMoney());
            }
            ApiPosIDCloudAlipayGroupQrcodeRequest apiPosIDCloudAlipayGroupQrcodeRequest = new ApiPosIDCloudAlipayGroupQrcodeRequest();
            apiPosIDCloudAlipayGroupQrcodeRequest.setPosIDApiAlipayGroupQrcodeItem(posIDApiAlipayGroupQrcodeItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipayGroupQrcodeRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("alipayGroupQrcode ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipayGroupQrcodeRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg alipayGroupFace(String id, PosIDAliOfflineFaceItem posIDAliOfflineFaceItem, PosIDAliPayFaceConsumeItem posIDAliPayFaceConsumeItem, String ipAddress) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiAlipayGroupFaceCodeItem posIDApiAlipayGroupFaceCodeItem = new PosIDApiAlipayGroupFaceCodeItem();
            posIDApiAlipayGroupFaceCodeItem.setMchOrderNo(id);
            posIDApiAlipayGroupFaceCodeItem.setTradeType("2");
            posIDApiAlipayGroupFaceCodeItem.setCurrency("cny");
            posIDApiAlipayGroupFaceCodeItem.setSubject(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
            posIDApiAlipayGroupFaceCodeItem.setBody(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
            posIDApiAlipayGroupFaceCodeItem.setFace_code(posIDAliPayFaceConsumeItem.getAuthCode());
            posIDApiAlipayGroupFaceCodeItem.setClientIp(ipAddress);
            posIDApiAlipayGroupFaceCodeItem.setTerminalParams(posIDAliPayFaceConsumeItem.getTerminalParams());
            if ("OK".equals(posIDAliOfflineFaceItem.getSignStatus()) && "1".equals(posIDAliOfflineFaceItem.getAliPayEnterprise())) {
                posIDApiAlipayGroupFaceCodeItem.setAmount(PosIDCloudServiceImpl.moneyAdd(posIDAliOfflineFaceItem.getAliPayMoney(), posIDAliOfflineFaceItem.getAllowanceWallet()));
                posIDApiAlipayGroupFaceCodeItem.setIsEnterprisePay("1");
                posIDApiAlipayGroupFaceCodeItem.setEnterprisePayAmount(posIDAliOfflineFaceItem.getAllowanceWallet());
                posIDApiAlipayGroupFaceCodeItem.setParam2("aliPayEnterpriseCard");
            } else {
                posIDApiAlipayGroupFaceCodeItem.setAmount(posIDAliOfflineFaceItem.getAliPayMoney());
                posIDApiAlipayGroupFaceCodeItem.setIsEnterprisePay("0");
            }
            ApiPosIDCloudAlipayGroupFaceCodeRequest apiPosIDCloudAlipayGroupFaceCodeRequest = new ApiPosIDCloudAlipayGroupFaceCodeRequest();
            apiPosIDCloudAlipayGroupFaceCodeRequest.setPosIDApiAlipayGroupFaceCodeItem(posIDApiAlipayGroupFaceCodeItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipayGroupFaceCodeRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("alipayGroupFace ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudAlipayGroupFaceCodeRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg getPayServiceProvider() {
        String appid = this.baseLicenseService.getAppId();
        if (StringUtils.isBlank((CharSequence)appid)) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiGetPayServiceProviderItem posIDApiGetPayServiceProviderItem = new PosIDApiGetPayServiceProviderItem();
            posIDApiGetPayServiceProviderItem.setAppId(appid);
            ApiPosIDCloudGetPayServiceProviderRequest apiPosIDCloudGetPayServiceProviderRequest = new ApiPosIDCloudGetPayServiceProviderRequest();
            apiPosIDCloudGetPayServiceProviderRequest.setPosIDApiGetPayServiceProviderItem(posIDApiGetPayServiceProviderItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudGetPayServiceProviderRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getPayServiceProvider ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudGetPayServiceProviderRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
            return new ZKResultMsg((Object)jsonObject.getString("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg alipayGroupMealEmployeeDelete(String personPin, String employeeId) {
        String appid = this.baseLicenseService.getAppId();
        if (StringUtils.isBlank((CharSequence)appid)) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        try {
            String token = this.baseAuthCloudMessageSendService.createToken();
            ZKCouldClient couldClient = this.getSendMsgClient();
            PosIDApiAlipaySignEmployeeDeleteItem posIDApiAlipaySignEmployeeDeleteItem = new PosIDApiAlipaySignEmployeeDeleteItem();
            posIDApiAlipaySignEmployeeDeleteItem.setPin(personPin);
            posIDApiAlipaySignEmployeeDeleteItem.setEmployeeId(employeeId);
            ApiPosIDAlipaySignEmployeeDeleteRequest apiPosIDAlipaySignEmployeeDeleteRequest = new ApiPosIDAlipaySignEmployeeDeleteRequest();
            apiPosIDAlipaySignEmployeeDeleteRequest.setPosIDApiAlipaySignEmployeeDeleteItem(posIDApiAlipaySignEmployeeDeleteItem);
            ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDAlipaySignEmployeeDeleteRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("alipayGroupMealEmployeeDelete ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDAlipaySignEmployeeDeleteRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret != 0) {
                return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
            }
            return new ZKResultMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ZKResultMsg.failMsg();
        }
    }

    public static Integer moneyAdd(Integer money, Integer addMoney) {
        BigDecimal moneyDecimal = money != null ? new BigDecimal(money.toString()) : BigDecimal.ZERO;
        BigDecimal addMoneyDecimal = addMoney != null ? new BigDecimal(addMoney.toString()) : BigDecimal.ZERO;
        return moneyDecimal.add(addMoneyDecimal).intValue();
    }
}

