/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="BASE_LANGUAGE LC LEFT JOIN BASE_LANG_RES BLR ON LC.ID = BLR.LANG_ID ")
@GroupBy(after="LC.ID, LC.BUILD_IN_FLAG,LC.CODE")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="download", click="downloadResource", permission="system:baseLanguage:downloadResource", url="baseLanguage.do?downloadResource", label="base_language_export")})
public class BaseLanguageItem
extends BaseItem
implements Serializable {
    @Column(name="LC.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="LC.CODE")
    @GridColumn(label="base_language_code", width="150", columnType="custom", convert="convertI18NNameByCode")
    private String code;
    @Column(name="LC.BUILD_IN_FLAG")
    @GridColumn(label="base_language_buildInFlag", width="150", columnType="custom", convert="convertToIcon")
    private Boolean buildInFlag;
    @GridColumn(label="base_language_finishProgress", width="150")
    private String finishProgress;
    @Column(name="COUNT(BLR.ID)")
    private Long translatedSum;
    @Column(name="(SELECT COUNT(BLR.ID) FROM BASE_LANG_RES BLR LEFT JOIN BASE_LANGUAGE TT ON TT.ID = BLR.LANG_ID WHERE TT.CODE ='zh_CN')")
    private Long totalSum;
    @Condition(value="LC.ID", equalTag="in")
    private String languageId;
    private String languageName;
    private String i18nName;

    public BaseLanguageItem() {
    }

    public BaseLanguageItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public BaseLanguageItem(String id, String code, Boolean buildInFlag) {
        this.id = id;
        this.code = code;
        this.buildInFlag = buildInFlag;
    }

    public void setTotalSum(Long totalSum) {
        this.totalSum = totalSum;
        this.finishProgress = this.translatedSum.equals(totalSum) ? "<font color='green'>" + this.translatedSum + "/" + totalSum + "</font>" : "<font color='red'>" + this.translatedSum + "/" + totalSum + "</font>";
    }

    public BaseLanguageItem setId(String id) {
        this.id = id;
        return this;
    }

    public BaseLanguageItem setCode(String code) {
        this.code = code;
        return this;
    }

    public BaseLanguageItem setBuildInFlag(Boolean buildInFlag) {
        this.buildInFlag = buildInFlag;
        return this;
    }

    public BaseLanguageItem setFinishProgress(String finishProgress) {
        this.finishProgress = finishProgress;
        return this;
    }

    public BaseLanguageItem setTranslatedSum(Long translatedSum) {
        this.translatedSum = translatedSum;
        return this;
    }

    public BaseLanguageItem setLanguageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    public BaseLanguageItem setLanguageName(String languageName) {
        this.languageName = languageName;
        return this;
    }

    public BaseLanguageItem setI18nName(String i18nName) {
        this.i18nName = i18nName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getBuildInFlag() {
        return this.buildInFlag;
    }

    public String getFinishProgress() {
        return this.finishProgress;
    }

    public Long getTranslatedSum() {
        return this.translatedSum;
    }

    public Long getTotalSum() {
        return this.totalSum;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getI18nName() {
        return this.i18nName;
    }

    public String toString() {
        return "BaseLanguageItem(id=" + this.getId() + ", code=" + this.getCode() + ", buildInFlag=" + this.getBuildInFlag() + ", finishProgress=" + this.getFinishProgress() + ", translatedSum=" + this.getTranslatedSum() + ", totalSum=" + this.getTotalSum() + ", languageId=" + this.getLanguageId() + ", languageName=" + this.getLanguageName() + ", i18nName=" + this.getI18nName() + ")";
    }
}

