/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAcmsUtil {
    private static Logger logger = LoggerFactory.getLogger(SystemAcmsUtil.class);
    public static final String ACMS_LOGIN_PATH = "/api/v2.0/armatura_one/login";
    public static final String ACMS_EMPLOYEE_PATH = "/api/v2.0/employee";
    public static final String ACMS_ISSUE_CARD_PATH = "/api/v2.0/armatura_one/issue";
    public static final String ACMS_DELETE_CARD_PATH = "/api/v2.0/armatura_one/delete";
    public static final String ACMS_REQUEST_METHOD_POST = "POST";
    public static final String ACMS_REQUEST_METHOD_DELETE = "DELETE";
    public static final String ACMS_CONTENT_TYPE = "application/json";
    public static final String ACMS_CACHE_CONTROL = "no-cache";
    public static final String ACMS_CODE_SUCCESS = "CMAI0000";
    public static final String ACMS_CODE_USERNAME_OR_PASSWORD_ERROR = "CMAE0073";
    public static final String ACMS_CODE_COMPANYCODE_ERROR = "CMAE0171";
    public static final String ACMS_CODE_CREATE_EMP_SUCCESS = "CMAI0000";
    public static final String ACMS_CODE_CARD_OVERCOUNT = "CMAE0169";
    public static final String ACMS_ACCESSTOKEN = "system:ACMS:accessToken";
    private static HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslsession) {
            return true;
        }
    };
    private static X509TrustManager ignoreCertificationTrustManger = new X509TrustManager(){
        private X509Certificate[] certificates;

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            if (this.certificates == null) {
                this.certificates = certificates;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
            if (this.certificates == null) {
                this.certificates = ax509certificate;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public static String buildRequest(String loginUrl, String params, String authorization, String requestMethod) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
        try {
            URL url = new URL(loginUrl);
            System.setProperty("https.protocols", "TLSv1.2");
            HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod(requestMethod);
            connection.setRequestProperty("Content-Type", ACMS_CONTENT_TYPE);
            connection.setRequestProperty("Cache-Control", ACMS_CACHE_CONTROL);
            TrustManager[] tm = new TrustManager[]{ignoreCertificationTrustManger};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            connection.setSSLSocketFactory(ssf);
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(20000);
            if (StringUtils.isNotBlank((CharSequence)authorization)) {
                connection.setRequestProperty("Authorization", authorization);
            }
            if (StringUtils.isNotBlank((CharSequence)params)) {
                connection.setDoOutput(true);
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(params.getBytes());
                outputStream.flush();
            }
            InputStream reader = connection.getInputStream();
            byte[] bytes = new byte[512];
            int length = reader.read(bytes);
            do {
                buffer.write(bytes, 0, length);
            } while ((length = reader.read(bytes)) > 0);
            reader.close();
            connection.disconnect();
        }
        catch (Exception ex) {
            logger.error("connect ACMS server error--" + ex.toString());
        }
        String resultString = new String(buffer.toByteArray());
        return resultString;
    }
}

