/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.line.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.line.pay.login.AccessToken;
import com.zkteco.zkbiosecurity.line.pay.login.Profile;
import com.zkteco.zkbiosecurity.line.pay.reserve.Reserve;
import com.zkteco.zkbiosecurity.line.pay.reserve.ReserveResponse;
import com.zkteco.zkbiosecurity.line.remote.LinePayDemoRemote;
import com.zkteco.zkbiosecurity.line.service.LinePayService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LinePayDemoController
extends BaseController
implements LinePayDemoRemote {
    @Autowired
    private LinePayService linePayService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;

    public ZKResultMsg getAccessUrlQrcode(@RequestParam(value="client_id") String client_id, @RequestParam(value="redirect_uri") String redirect_uri) {
        ZKResultMsg res = new ZKResultMsg();
        String accessUrl = String.format("https://access.line.me/dialog/oauth/weblogin?response_type=code&client_id=%s&redirect_uri=%s", client_id, redirect_uri);
        res.setData((Object)accessUrl);
        return res;
    }

    public String lineCallback() {
        String code = this.request.getParameter("code");
        this.log.info("Line Callback .... Code = " + code);
        if (StringUtils.isBlank((CharSequence)code)) {
            this.request.setAttribute("message", (Object)I18nUtil.i18nCode((String)"Code Is Null", (Object[])new Object[0]));
            return "line/payDemo/LinePayDemoMessage";
        }
        AccessToken token = this.linePayService.accessToken(code, this.baseSysParamService.getValByName("linePay.lineCallbackURL"));
        if (token == null) {
            this.request.setAttribute("message", (Object)I18nUtil.i18nCode((String)"Get AccessToken Fail", (Object[])new Object[0]));
            return "line/payDemo/LinePayDemoMessage";
        }
        Profile profile = this.linePayService.profile(token);
        this.request.setAttribute("profile", (Object)profile);
        this.log.info("Line Get Profile = " + profile.toString());
        return "line/payDemo/LinePayDemoIndex";
    }

    public ZKResultMsg getPayUrlQrcode() {
        ZKResultMsg res = new ZKResultMsg();
        res.setData((Object)this.request.getRequestURL().toString().replace("getPayUrlQrcode", "toPay"));
        return res;
    }

    public String toPay() {
        return "line/payDemo/LinePayDemoIndexEx";
    }

    public ZKResultMsg reserve(@RequestParam(value="amount", required=false) String amount) {
        this.log.info("Line Pay Reserve");
        ZKResultMsg resultMsg = new ZKResultMsg();
        Reserve reserve = new Reserve();
        reserve.setProductName(I18nUtil.i18nCode((String)"Line Pay Demo", (Object[])new Object[0]));
        Long amountL = 1L;
        if (StringUtils.isNotBlank((CharSequence)amount)) {
            amountL = Long.valueOf(amount);
        }
        reserve.setAmount((Number)amountL);
        String confirmUrl = this.baseSysParamService.getValByName("linePay.linePayCallbackURL");
        reserve.setConfirmUrl(confirmUrl);
        ReserveResponse response = this.linePayService.reserve(reserve);
        if ("0000".equals(response.getReturnCode())) {
            String paymentUrl = response.getInfo().getPaymentUrl().getWeb();
            String transactionId = response.getInfo().getTransactionId() + "";
            this.log.info("Line Pay Reserve Success ... transactionId = " + transactionId);
            resultMsg.setData((Object)paymentUrl);
        } else {
            resultMsg.setRet("fail");
            resultMsg.setMsg(response.getReturnMessage());
        }
        return resultMsg;
    }

    public String linePayCallback() {
        String transactionId = this.request.getParameter("transactionId");
        this.log.info("Line PayCallback .... transactionId = " + transactionId);
        this.request.setAttribute("message", (Object)I18nUtil.i18nCode((String)"Pay Success", (Object[])new Object[0]));
        return "line/payDemo/LinePayDemoMessage";
    }
}

