/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.line.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.line.constants.LineConstants;
import com.zkteco.zkbiosecurity.line.remote.LineNotificationRemote;
import com.zkteco.zkbiosecurity.line.service.LineNotificationService;
import com.zkteco.zkbiosecurity.line.vo.LineNotificationItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LineNotificationController
extends BaseController
implements LineNotificationRemote {
    @Autowired
    private LineNotificationService lineNotificationService;

    @RequiresPermissions(value={"line:notification"})
    public ModelAndView index() {
        return new ModelAndView("line/notification/lineNotification");
    }

    @RequiresPermissions(value={"line:notification:refresh"})
    public DxGrid list(LineNotificationItem condition) {
        Pager pager = this.lineNotificationService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"line:notification:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            LineNotificationItem item = this.lineNotificationService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("line/notification/editLineNotification");
    }

    @RequiresPermissions(value={"line:notification:del"})
    @LogRequest(module="system_module", object="line_notification", opType="common_op_del", requestParams={"notificationName"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        this.lineNotificationService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"line:notification:edit", "line:notification:add"})
    @LogRequest(module="system_module", object="line_notification", opType="common_op_edit", requestParams={"notificationName"}, opContent="line_notification_name")
    public ZKResultMsg save(LineNotificationItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.lineNotificationService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String validName(String notificationName) {
        LineNotificationItem item = this.lineNotificationService.getItemByName(notificationName);
        boolean rs = item == null;
        return rs + "";
    }

    public String validToken(String token) {
        LineNotificationItem item = this.lineNotificationService.getItemByToken(token);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem getEventPointList(String module) {
        List treeItems = new ArrayList();
        if (LineConstants.LINE_NOTIFICATIONTYPE_ACC.equals(Short.valueOf(module))) {
            treeItems = this.lineNotificationService.getAccDoorItems();
        } else if (LineConstants.LINE_NOTIFICATIONTYPE_ATT.equals(Short.valueOf(module))) {
            treeItems = this.lineNotificationService.getAttDeviceItems();
        }
        return new TreeItem("0", treeItems);
    }
}

