/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.line.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.line.remote.LineContactRemote;
import com.zkteco.zkbiosecurity.line.service.LineContactService;
import com.zkteco.zkbiosecurity.line.vo.LineContactItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LineContactController
extends BaseController
implements LineContactRemote {
    @Autowired
    private LineContactService lineContactService;

    @RequiresPermissions(value={"line:notification:setContact"})
    public ModelAndView index() {
        return new ModelAndView("line/contact/lineContact");
    }

    public DxGrid list(LineContactItem condition) {
        Pager pager = this.lineContactService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            LineContactItem item = this.lineContactService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("line/contact/editLineContact");
    }

    @LogRequest(module="system_module", object="line_notification", opType="common_op_edit", requestParams={"contact"}, opContent="system_systemClient_contacts")
    public ZKResultMsg save(LineContactItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.lineContactService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="system_module", object="line_notification", opType="common_op_del", requestParams={"contact"}, opContent="system_systemClient_contacts")
    public ZKResultMsg del(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.lineContactService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getContactList() {
        return new ZKResultMsg((Object)this.lineContactService.getContactList());
    }

    public String validName(String contact) {
        LineContactItem item = this.lineContactService.getItemByContact(contact);
        boolean rs = item == null;
        return rs + "";
    }
}

