/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ACC_FIRSTIN_LASTOUT t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class AccFirstInLastOutItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", show=false)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="t.READER_NAME_IN")
    @GridColumn(label="acc_inOut_inReaderName", width="160")
    private String readerNameIn;
    @Column(name="t.FIRST_IN_TIME")
    @GridColumn(label="acc_inOut_firstInTime", width="135")
    private Date firstInTime;
    @Column(name="t.READER_NAME_OUT")
    @GridColumn(label="acc_inOut_outReaderName", width="160")
    private String readerNameOut;
    @Column(name="t.LAST_OUT_TIME")
    @GridColumn(label="acc_inOut_lastOutTime", width="135")
    private Date lastOutTime;
    @Column(name="t.DEPT_CODE")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    private String deptName;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.FIRST_IN_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.FIRST_IN_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(t.DEPT_CODE in (%s) or t.DEPT_CODE is null or t.DEPT_CODE = '')", formatType="quote")
    private String deptCodeIn;
    @Condition(value="(t.DEPT_CODE IN (select ud.code from auth_department ud where ud.id in(select aud.auth_dept_id from auth_user_dept aud where aud.auth_user_id = ''{0}'')) or t.DEPT_CODE is null or t.DEPT_CODE = '''')")
    private String deptCodeInByUserId;
    @Condition(value="t.PIN", equalTag="=")
    private String pinEqual;

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getReaderNameIn() {
        return this.readerNameIn;
    }

    public Date getFirstInTime() {
        return this.firstInTime;
    }

    public String getReaderNameOut() {
        return this.readerNameOut;
    }

    public Date getLastOutTime() {
        return this.lastOutTime;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getDeptCodeIn() {
        return this.deptCodeIn;
    }

    public String getDeptCodeInByUserId() {
        return this.deptCodeInByUserId;
    }

    public String getPinEqual() {
        return this.pinEqual;
    }

    public AccFirstInLastOutItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccFirstInLastOutItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AccFirstInLastOutItem setName(String name) {
        this.name = name;
        return this;
    }

    public AccFirstInLastOutItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AccFirstInLastOutItem setReaderNameIn(String readerNameIn) {
        this.readerNameIn = readerNameIn;
        return this;
    }

    public AccFirstInLastOutItem setFirstInTime(Date firstInTime) {
        this.firstInTime = firstInTime;
        return this;
    }

    public AccFirstInLastOutItem setReaderNameOut(String readerNameOut) {
        this.readerNameOut = readerNameOut;
        return this;
    }

    public AccFirstInLastOutItem setLastOutTime(Date lastOutTime) {
        this.lastOutTime = lastOutTime;
        return this;
    }

    public AccFirstInLastOutItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AccFirstInLastOutItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AccFirstInLastOutItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AccFirstInLastOutItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AccFirstInLastOutItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AccFirstInLastOutItem setDeptCodeIn(String deptCodeIn) {
        this.deptCodeIn = deptCodeIn;
        return this;
    }

    public AccFirstInLastOutItem setDeptCodeInByUserId(String deptCodeInByUserId) {
        this.deptCodeInByUserId = deptCodeInByUserId;
        return this;
    }

    public AccFirstInLastOutItem setPinEqual(String pinEqual) {
        this.pinEqual = pinEqual;
        return this;
    }

    public String toString() {
        return "AccFirstInLastOutItem(id=" + this.getId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", readerNameIn=" + this.getReaderNameIn() + ", firstInTime=" + this.getFirstInTime() + ", readerNameOut=" + this.getReaderNameOut() + ", lastOutTime=" + this.getLastOutTime() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", likeName=" + this.getLikeName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", deptCodeIn=" + this.getDeptCodeIn() + ", deptCodeInByUserId=" + this.getDeptCodeInByUserId() + ", pinEqual=" + this.getPinEqual() + ")";
    }
}

