/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDWalletRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDWalletService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountWalletItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDWalletItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDWalletController
extends ExportController
implements PosIDWalletRemote {
    @Autowired
    private PosIDWalletService posIDWalletService;

    @RequiresPermissions(value={"posid:wallet"})
    public ModelAndView index() {
        return new ModelAndView("posid/wallet/posIDWallet");
    }

    @RequiresPermissions(value={"posid:wallet:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDWalletService.getItemById(id));
        }
        return new ModelAndView("posid/account/editPosIDAccount");
    }

    @RequiresPermissions(value={"posid:wallet:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_wallet", opType="common_op_new", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosIDWalletItem item) {
        return null;
    }

    @RequiresPermissions(value={"posid:wallet:refresh"})
    public DxGrid list(PosIDAccountWalletItem condition) {
        Pager pager = this.posIDWalletService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:wallet:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardManage", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        return null;
    }
}

