/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDTransactionRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionDetailService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDErrorRecoveryItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionDetailItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDTransactionController
extends ExportController
implements PosIDTransactionRemote {
    @Autowired
    private PosIDTransactionService posIDTransactionService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDTransactionDetailService posIDTransactionDetailService;
    @Value(value="${system.language}")
    private String language;

    @RequiresPermissions(value={"posid:transaction"})
    public ModelAndView index() {
        return new ModelAndView("posid/transaction/posIDTransaction");
    }

    @RequiresPermissions(value={"posid:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDTransactionService.getItemById(id));
        }
        return new ModelAndView("posid/transaction/editPosIDTransaction");
    }

    @RequiresPermissions(value={"posid:transaction:edit"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:transaction:refresh"})
    public DxGrid list(PosIDTransactionItem codition) {
        Pager pager = this.posIDTransactionService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"posid:transaction:del"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView showDetailIndex(String transactionId) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posIDSystemParamService.getDoubleCash();
        param.put("transactionId", transactionId);
        return new ModelAndView("posid/transaction/posIDTransactionDetail", param);
    }

    public DxGrid showDetailList(String transactionId) {
        PosIDTransactionDetailItem posIDTransactionDetailItem = new PosIDTransactionDetailItem();
        posIDTransactionDetailItem.setTransactionId(transactionId);
        Pager pager = this.posIDTransactionDetailService.getItemsByPage((BaseItem)posIDTransactionDetailItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, posIDTransactionDetailItem.getClass());
    }

    @RequiresPermissions(value={"posid:transaction:errorRecovery"})
    public ZKResultMsg errorRecoveryData(PosIDErrorRecoveryItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.posIDTransactionService.errorRecoveryData(item));
    }

    @RequiresPermissions(value={"posid:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDTransactionItem posIDTransactionItem = new PosIDTransactionItem();
        this.setConditionValue((BaseItem)posIDTransactionItem);
        List posIDTransactionExportItemList = this.posIDTransactionService.loadListByAuthFilter(posIDTransactionItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionExportItemList, PosIDTransactionExportItem.class);
    }

    public ZKResultMsg getConsumeMode() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_fixMode", (Object[])new Object[0]), String.valueOf(1)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_amountMode", (Object[])new Object[0]), String.valueOf(2)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_timesMode", (Object[])new Object[0]), String.valueOf(4)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_storeMode", (Object[])new Object[0]), String.valueOf(5)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_timingMode", (Object[])new Object[0]), String.valueOf(6)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_order", (Object[])new Object[0]), String.valueOf(11)));
        if ("zh_CN".equals(this.language)) {
            selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_dev_intelligence", (Object[])new Object[0]), String.valueOf(12)));
        }
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_leftMenu_handConsume", (Object[])new Object[0]), String.valueOf(8)));
        return new ZKResultMsg(selectItems);
    }

    public void getDecryptFileBase64(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)path);
            if (this.posIDSystemParamService.photoEncryptProp()) {
                decryptFileBase64 = ImgEncodeUtil.base64BoxBlurFilter((String)decryptFileBase64);
            }
            try {
                ServletOutputStream outputStream = this.response.getOutputStream();
                this.response.reset();
                outputStream.write(Base64.getDecoder().decode(decryptFileBase64));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ZKResultMsg checkErrorRecovery(String id) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.posIDTransactionService.checkErrorRecovery(id));
    }

    @RequiresPermissions(value={"posid:transaction:errorRecovery"})
    public ModelAndView errorRecovery(String id) {
        this.request.setAttribute("item", (Object)this.posIDTransactionService.getItemById(id));
        return new ModelAndView("posid/transaction/errorRecovery");
    }

    public ZKResultMsg getConsumeOrder() {
        List<Object> selectItems = new ArrayList<SelectItem>();
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_onlyCash", (Object[])new Object[0]), String.valueOf(0)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_onlySubsidy", (Object[])new Object[0]), String.valueOf(1)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_firstCash", (Object[])new Object[0]), String.valueOf(2)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_firstSubsidy", (Object[])new Object[0]), String.valueOf(3)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_onlyWechat", (Object[])new Object[0]), String.valueOf(4)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_firstCash_secondWechat", (Object[])new Object[0]), String.valueOf(5)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_firstCash_laseWechat", (Object[])new Object[0]), String.valueOf(6)));
        selectItems.add(new SelectItem((Object)I18nUtil.i18nCode((String)"posid_system_firstSubsidy_laseWechat", (Object[])new Object[0]), String.valueOf(7)));
        selectItems = selectItems.stream().sorted(Comparator.comparing(SelectItem::getValue)).collect(Collectors.toList());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(selectItems));
    }
}

