/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDTransactionCardRecordRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionCardService;
import com.zkteco.zkbiosecurity.posid.utils.CopyUtils;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardBlanceExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardBlanceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardRefundExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardRefundItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardSubsidyExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordCardSubsidyItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordRechargeformExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionRecordRechargeformItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDTransactionCardRecordController
extends ExportController
implements PosIDTransactionCardRecordRemote {
    @Autowired
    private PosIDTransactionCardService posIDTransactionCardService;

    @RequiresPermissions(value={"posid:sendTable", "posid:rechargeForm", "posid:cardRefund", "posid:cardSubsidy", "posid:backCard", "posid:cardCost", "posid:cardBlance", "posid:cardNoCardBackCard", "posid:loseUniteCard"})
    public ModelAndView index() {
        String requestType = this.request.getParameter("requestType");
        return new ModelAndView("posid/transactionCardRecord/posID" + StrUtil.firstUpperCase((String)requestType));
    }

    public DxGrid list(PosIDTransactionCardItem codition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDTransactionCardItem posIDTransactionCardItem = new PosIDTransactionCardItem();
        this.setConditionValue((BaseItem)posIDTransactionCardItem);
        List itemList = this.posIDTransactionCardService.loadListByAuthFilter(posIDTransactionCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        List<Object> incomeExpendConsumeExportList = new ArrayList();
        if (null != itemList && itemList.size() > 0) {
            incomeExpendConsumeExportList = CopyUtils.copyListProperties(itemList, PosIDTransactionCardExportItem.class);
        }
        this.excelExport(incomeExpendConsumeExportList, PosIDTransactionCardExportItem.class);
    }

    @RequiresPermissions(value={"posid:rechargeForm:refresh"})
    public DxGrid getRechargeformItemList(PosIDTransactionRecordRechargeformItem condition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"posid:rechargeForm:export"})
    public void exportRechargeform(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosIDTransactionRecordRechargeformItem posIDTransactionRecordRechargeformItem = new PosIDTransactionRecordRechargeformItem();
        this.setConditionValue((BaseItem)posIDTransactionRecordRechargeformItem);
        List posIDTransactionRecordRechargeformExportItemList = this.posIDTransactionCardService.getRechargeformItemData(posIDTransactionRecordRechargeformItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionRecordRechargeformExportItemList, PosIDTransactionRecordRechargeformExportItem.class);
    }

    @RequiresPermissions(value={"posid:cardRefund:refresh"})
    public DxGrid getCardRefundItemList(PosIDTransactionRecordCardRefundItem condition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"posid:cardRefund:export"})
    public void exportCardRefund(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosIDTransactionRecordCardRefundItem posIDTransactionRecordCardRefundItem = new PosIDTransactionRecordCardRefundItem();
        this.setConditionValue((BaseItem)posIDTransactionRecordCardRefundItem);
        List posIDTransactionRecordCardRefundExportItemList = this.posIDTransactionCardService.getCardRefundItemData(posIDTransactionRecordCardRefundItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionRecordCardRefundExportItemList, PosIDTransactionRecordCardRefundExportItem.class);
    }

    @RequiresPermissions(value={"posid:cardSubsidy:refresh"})
    public DxGrid getCardSubsidyList(PosIDTransactionRecordCardSubsidyItem condition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"posid:cardSubsidy:export"})
    public void exportCardSubsidy(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosIDTransactionRecordCardSubsidyItem posIDTransactionRecordCardSubsidyItem = new PosIDTransactionRecordCardSubsidyItem();
        this.setConditionValue((BaseItem)posIDTransactionRecordCardSubsidyItem);
        List posIDTransactionRecordCardSubsidyExportItemList = this.posIDTransactionCardService.getCardSubsidyItemData(posIDTransactionRecordCardSubsidyItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionRecordCardSubsidyExportItemList, PosIDTransactionRecordCardSubsidyExportItem.class);
    }

    @RequiresPermissions(value={"posid:cardBlance:refresh"})
    public DxGrid getCardBlanceItemList(PosIDTransactionRecordCardBlanceItem condition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:cardBlance:export"})
    public void exportCardBlance(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosIDTransactionRecordCardBlanceItem posIDTransactionRecordCardBlanceItem = new PosIDTransactionRecordCardBlanceItem();
        this.setConditionValue((BaseItem)posIDTransactionRecordCardBlanceItem);
        List posIDTransactionRecordCardBlanceExportItemList = this.posIDTransactionCardService.getCardBlanceItemData(posIDTransactionRecordCardBlanceItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionRecordCardBlanceExportItemList, PosIDTransactionRecordCardBlanceExportItem.class);
    }
}

