/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDTransactionCardRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionCardService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDTransactionCardController
extends ExportController
implements PosIDTransactionCardRemote {
    @Autowired
    private PosIDTransactionCardService posIDTransactionCardService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;

    @RequiresPermissions(value={"posid:transactionCard"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posIDSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("posid/transactionCard/posIDTransactionCard", param);
    }

    @RequiresPermissions(value={"posid:transactionCard:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDTransactionCardService.getItemById(id));
        }
        return new ModelAndView("posid/transactionCard/editPosIDTransactionCard");
    }

    @RequiresPermissions(value={"posid:transactionCard:edit"})
    @LogRequest(module="posid_module", object="posid_transactionCard", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDTransactionCardItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDTransactionCardService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:transactionCard:refresh"})
    public DxGrid list(PosIDTransactionCardItem codition) {
        Pager pager = this.posIDTransactionCardService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"posid:transactionCard:del"})
    @LogRequest(module="posid_module", object="posid_transactionCard", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDTransactionCardService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:transactionCard:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        String queryCondition = request.getParameter("queryConditions");
        String[] conditionAry = queryCondition.replaceAll("%20", " ").split("&");
        PosIDTransactionCardItem posIDTransactionCardItem = new PosIDTransactionCardItem();
        this.setConditionValue((BaseItem)posIDTransactionCardItem);
        for (String condition : conditionAry) {
            String[] strAry;
            if (StringUtils.isBlank((CharSequence)condition) || !"checkTime".equals((strAry = condition.split("="))[0])) continue;
            Date date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            posIDTransactionCardItem.setCreateTime(date);
        }
        List posIDTransactionCardExportItemList = this.posIDTransactionCardService.loadListByAuthFilter(posIDTransactionCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        if (posIDTransactionCardExportItemList.size() > 1) {
            posIDTransactionCardExportItemList.remove(posIDTransactionCardExportItemList.size() - 1);
        }
        this.excelExport(posIDTransactionCardExportItemList, PosIDTransactionCardExportItem.class);
    }
}

