/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDTopUpRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDTopUpController
extends BaseController
implements PosIDTopUpRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:topUp"})
    public ModelAndView index() {
        return new ModelAndView("posid/topUp/posIDTopUp");
    }

    @RequiresPermissions(value={"posid:topUp:edit"})
    public ModelAndView edit(String id) {
        return new ModelAndView("posid/topUp/editPosIDTopUp");
    }

    @RequiresPermissions(value={"posid:topUp:del"})
    @LogRequest(module="posid_module", object="posid_op_topUp", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:topUp:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardBusiness", opType="posid_op_topUp", requestParams={"deptName"}, opContent="posid_card_personNum")
    public ZKResultMsg save() {
        Integer money = Integer.parseInt(this.request.getParameter("topUpSolde"));
        String accountNo = this.request.getParameter("accountNo");
        ZKResultMsg res = this.posIDAccountService.topUp(money, accountNo);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:batchTopUp:edit"})
    public ModelAndView batchTopUp() {
        return new ModelAndView("posid/topUp/editPosIDBatchTopUp");
    }

    @RequiresPermissions(value={"posid:batchTopUp:edit"})
    public void batchSave(String personIds, Integer money) {
        this.posIDAccountService.batchTopUp(personIds, money);
    }

    @RequiresPermissions(value={"posid:topUp:edit"})
    public ZKResultMsg getPersonByPin(String personPin) {
        PosIDAccountItem posIDAccountItem = this.posIDAccountService.getAccountByPin(personPin);
        if (Objects.isNull(posIDAccountItem)) {
            return ZKResultMsg.failMsg();
        }
        return new ZKResultMsg((Object)posIDAccountItem);
    }

    @RequiresPermissions(value={"posid:topUp:edit"})
    public ZKResultMsg getPersonByCardNo(String cardNo) {
        return this.posIDAccountService.getAccountByCardNo(cardNo);
    }
}

