/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDRefundRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDRefundItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDRefundController
extends BaseController
implements PosIDRefundRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:refund"})
    public ModelAndView index() {
        return new ModelAndView("posid/refund/posIDRefund");
    }

    @RequiresPermissions(value={"posid:refund:edit"})
    public ModelAndView edit() {
        this.request.setAttribute("refundType", (Object)5);
        return new ModelAndView("posid/refund/editPosIDRefund");
    }

    @RequiresPermissions(value={"posid:refund:del"})
    @LogRequest(module="posid_module", object="posid_op_refund", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:refund:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardBusiness", opType="posid_op_refund", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDRefundItem item) {
        ZKResultMsg res = this.posIDAccountService.refund(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:allowanceRefund:edit"})
    public ModelAndView allowanceRefund() {
        this.request.setAttribute("refundType", (Object)17);
        return new ModelAndView("posid/refund/editPosIDAllowanceRefund");
    }

    @RequiresPermissions(value={"posid:batchRefund:edit"})
    public ModelAndView batchRefund() {
        return new ModelAndView("posid/refund/editPosIDBatchRefund");
    }

    @RequiresPermissions(value={"posid:batchRefund:edit"})
    public void batchRefundSave(String accountIds, Integer money) {
        this.posIDAccountService.batchRefund(accountIds, money);
    }
}

