/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.constants.PosIDConstants;
import com.zkteco.zkbiosecurity.posid.remote.PosIDProductCategoryRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDProductCategoryService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDProductCategoryItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDProductCategoryController
extends BaseController
implements PosIDProductCategoryRemote {
    @Autowired
    private PosIDProductCategoryService posIDProductCategoryService;

    @RequiresPermissions(value={"posid:productCategory"})
    public ModelAndView index() {
        return new ModelAndView("posid/productCategory/posIDProductCategory");
    }

    @RequiresPermissions(value={"posid:productCategory:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PosIDProductCategoryItem item = this.posIDProductCategoryService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("posid/productCategory/editPosIDProductCategory");
    }

    @RequiresPermissions(value={"posid:productCategory:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_productCategory", opType="common_op_edit", requestParams={"name"}, opContent="posid_productCategory_name")
    public ZKResultMsg save(PosIDProductCategoryItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDProductCategoryService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:productCategory:refresh"})
    public DxGrid list(PosIDProductCategoryItem codition) {
        Pager pager = this.posIDProductCategoryService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:productCategory:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_productCategory", opType="common_op_del", requestParams={"names"}, opContent="posid_productCategory_name")
    public ZKResultMsg delete(String ids) {
        this.posIDProductCategoryService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(String code) {
        PosIDProductCategoryItem item = this.posIDProductCategoryService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getProductCategoryList() {
        List items = this.posIDProductCategoryService.getProductCategoryList();
        return new ZKResultMsg((Object)items);
    }

    public ZKResultMsg selectLabel() {
        return new ZKResultMsg((Object)PosIDConstants.POSID_PRODUCT_CATEGORY_LABLE_MAP);
    }
}

