/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOrderProductSummaryRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderProductService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderProductSummaryService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderStoreDetailService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallOrderItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductMealListItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductSumItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderStoreDetailItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDStoreDetailSumItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOrderProductSummaryController
extends BaseController
implements PosIDOrderProductSummaryRemote {
    @Autowired
    private PosIDOrderProductSummaryService posIDOrderProductSummaryService;
    @Autowired
    private PosIDOrderProductService posIDOrderProductService;
    @Autowired
    private PosIDOrderStoreDetailService posIDOrderStoreDetailService;

    @RequiresPermissions(value={"posid:orderProductSummary"})
    public ModelAndView index() {
        return new ModelAndView("posid/orderProductSummary/posIDOrderProductSummary");
    }

    @RequiresPermissions(value={"posid:orderProductSummary:refresh"})
    public DxGrid diningHallList(PosIDDiningHallOrderItem condition) {
        Pager pager = this.posIDOrderProductSummaryService.diningHallList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:orderProductSummary:refresh"})
    public DxGrid list(PosIDOrderProductSumItem condition) {
        Pager pager = new Pager();
        if (null == condition.getHallingId()) {
            pager.setData(new ArrayList());
        } else {
            pager = this.posIDOrderProductService.getOrderProductSummary(condition, this.getPageNo(), this.getPageSize());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:orderProductSummary:storeDetailList"})
    public ModelAndView storeDetailList(String diningHallId, String orderTime) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("diningHallId", diningHallId);
        map.put("orderTime", orderTime);
        return new ModelAndView("posid/orderProductSummary/posIDStoreDetailList", map);
    }

    public DxGrid storeDetailSum(PosIDStoreDetailSumItem condition) {
        Pager pager = new Pager();
        if (null == condition.getOrderTime()) {
            pager.setData(new ArrayList());
        } else {
            Date time = DateUtil.stringToDate((String)(condition.getOrderTime() + " 00:00:00"));
            condition.setStatusNotEql(Integer.valueOf(2));
            condition.setStartTime(DateUtil.getDayBeginTime((Date)time));
            condition.setEndTime(DateUtil.getDayEndTime((Date)time));
            pager = this.posIDOrderProductService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView orderMealList(String diningHallId, String orderTime, Integer type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("diningHallId", diningHallId);
        map.put("orderTime", orderTime);
        map.put("type", type);
        return new ModelAndView("posid/orderProductSummary/posIDOrderProductMealList", map);
    }

    public DxGrid getOrderMealList(PosIDOrderProductMealListItem condition) {
        Pager pager = new Pager();
        if (null == condition.getOrderTime()) {
            pager.setData(new ArrayList());
        } else {
            pager = this.posIDOrderProductService.getOrderMealList(condition, this.getPageNo(), this.getPageSize());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView orderStoreDetailPage(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        return new ModelAndView("posid/orderProductSummary/posIDOrderStoreDetailPage", map);
    }

    public DxGrid orderStoreDetailList(PosIDOrderStoreDetailItem condition) {
        Pager pager = this.posIDOrderStoreDetailService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

