/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOrderMealSummaryRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderMealSummaryService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDCusDiningHallOrderItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDCusOrderMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDCusOrderMealListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOrderMealSummaryController
extends ExportController
implements PosIDOrderMealSummaryRemote {
    @Autowired
    private PosIDDiningHallService posIDDiningHallService;
    @Autowired
    private PosIDOrderMealSummaryService posIDOrderMealSummaryService;

    @RequiresPermissions(value={"posid:orderMealSummary"})
    public ModelAndView index() {
        return new ModelAndView("posid/orderMealSummary/posIDOrderMealSummary");
    }

    @RequiresPermissions(value={"posid:orderMealSummary:refresh"})
    public DxGrid diningHallList(PosIDCusDiningHallOrderItem condition) {
        Pager pager = this.posIDDiningHallService.loadOrderPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:orderMealSummary:refresh"})
    public DxGrid list(PosIDCusOrderMealItem condition) {
        Pager pager = new Pager();
        if (null == condition.getHallingId()) {
            pager.setData(new ArrayList());
        } else {
            pager = this.posIDOrderMealSummaryService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView orderMealList(String diningHallId, String orderTime, Integer type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("diningHallId", diningHallId);
        map.put("orderTime", orderTime);
        map.put("type", type);
        return new ModelAndView("posid/orderMealSummary/posIDCusOrderMealList", map);
    }

    public DxGrid getOrderMealList(PosIDCusOrderMealListItem condition) {
        Pager pager = new Pager();
        if (StringUtils.isBlank((CharSequence)condition.getOrderTime())) {
            pager.setData(new ArrayList());
        } else {
            pager = this.posIDOrderMealSummaryService.loadOrderMealListByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:orderMealSummary:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDCusOrderMealListItem posIDCusOrderMealItem = new PosIDCusOrderMealListItem();
        this.setConditionValue((BaseItem)posIDCusOrderMealItem);
        String hallingId = request.getParameter("hallingId");
        String orderTime = request.getParameter("orderTime");
        posIDCusOrderMealItem.setHallingId(hallingId);
        posIDCusOrderMealItem.setStatus(Integer.valueOf(request.getParameter("status")));
        if (posIDCusOrderMealItem.getStatus() == 4) {
            posIDCusOrderMealItem.setStatus(null);
        } else if (posIDCusOrderMealItem.getStatus() == 0) {
            posIDCusOrderMealItem.setNotEatenMealEndTime(new Date());
        } else if (posIDCusOrderMealItem.getStatus() == 3) {
            posIDCusOrderMealItem.setStatus(Integer.valueOf(0));
            posIDCusOrderMealItem.setExpiredMealEndTime(new Date());
        }
        Date time = DateUtil.stringToDate((String)(orderTime + " 00:00:00"));
        posIDCusOrderMealItem.setStartTime(time);
        posIDCusOrderMealItem.setEndTime(DateUtil.getDayEndTime((Date)time));
        List posIDCusOrderMealExportItemList = this.posIDOrderMealSummaryService.loadListByAuthFilter(posIDCusOrderMealItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDCusOrderMealExportItemList, PosIDCusOrderMealListItem.class);
    }
}

