/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOfflineConsumeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDOfflineConsumeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOfflineConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPersonOfflineConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOfflineConsumeController
extends BaseController
implements PosIDOfflineConsumeRemote {
    @Autowired
    private PosIDOfflineConsumeService posIDOfflineConsumeService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"posid:offlineConsume"})
    public ModelAndView index() {
        return new ModelAndView("posid/offlineConsume/posIDOfflineConsume");
    }

    @RequiresPermissions(value={"posid:offlineConsume:refresh"})
    public DxGrid list(PosIDOfflineConsumeItem condition) {
        Pager pager = this.posIDOfflineConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:offlineConsume:refresh"})
    public DxGrid personList(PosIDPersonOfflineConsumeItem condition) {
        Pager pager = this.posIDOfflineConsumeService.getPersonList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:offlineConsume:verification"})
    public ModelAndView verification(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        String retMessage = this.posIDOfflineConsumeService.chekVerification(ids);
        this.request.setAttribute("retMessage", (Object)retMessage);
        return new ModelAndView("posid/offlineConsume/verificationOfflineConsume");
    }

    @RequiresPermissions(value={"posid:offlineConsume:verification"})
    public ZKResultMsg passVerification(String ids) {
        ZKResultMsg res = this.posIDOfflineConsumeService.passVerification(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"posid:offlineConsume:verification"})
    public ZKResultMsg enable() {
        int progress = 1;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.posIDOfflineConsumeService.enable());
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("transaction errorRecoveryData Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"posid:offlineConsume:import"})
    public ZKResultMsg importUSBRecord(MultipartFile upload) throws IOException {
        int progress = 1;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.posIDOfflineConsumeService.importUSBRecord(upload.getInputStream()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("offlineConsume importUSBRecord Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

