/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDMealRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDMealService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDMealItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDMealController
extends BaseController
implements PosIDMealRemote {
    @Autowired
    private PosIDMealService posIDMealService;

    @RequiresPermissions(value={"posid:meal"})
    public ModelAndView index() {
        return new ModelAndView("posid/meal/posIDMeal");
    }

    @RequiresPermissions(value={"posid:meal:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDMealService.getItemById(id));
        }
        return new ModelAndView("posid/meal/editPosIDMeal");
    }

    @RequiresPermissions(value={"posid:meal:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_meal", opType="common_op_edit", requestParams={"code"}, opContent="posid_meal_code")
    public ZKResultMsg save(PosIDMealItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldAvailable = Boolean.parseBoolean(this.request.getParameter("oldAvailable"));
        this.posIDMealService.saveItem(item, oldAvailable);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:meal:refresh"})
    public DxGrid list(PosIDMealItem codition) {
        Pager pager = this.posIDMealService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="posid_module", object="posid_leftMenu_meal", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public String validName(String name) {
        PosIDMealItem item = this.posIDMealService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem tree() {
        PosIDMealItem posIDMealItem = new PosIDMealItem();
        posIDMealItem.setAvailable(Boolean.valueOf(true));
        List items = this.posIDMealService.getByCondition(posIDMealItem);
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosIDMealItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName() + " " + depart.getStartTime() + "-" + depart.getEndTime());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getMealNameList() {
        return new ZKResultMsg((Object)this.posIDMealService.getMealNameList());
    }

    public ZKResultMsg checkTimeseg() {
        String id = this.request.getParameter("splitTimeId");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean available = Boolean.parseBoolean(this.request.getParameter("available"));
        return this.posIDMealService.checkTimeseg(id, startStr, endStr, available);
    }
}

