/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDMealConsumeDetailRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDMealConsumeDetailService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderStoreDetailItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDMealConsumeDetailController
extends BaseController
implements PosIDMealConsumeDetailRemote {
    @Autowired
    private PosIDMealConsumeDetailService posIDMealConsumeDetailService;

    @RequiresPermissions(value={"posid:mealConsumeDetail"})
    public ModelAndView index() {
        return new ModelAndView("posid/mealConsumeDetail/posIDMealConsumeDetail");
    }

    @RequiresPermissions(value={"posid:mealConsumeDetail:refresh"})
    public DxGrid list(PosIDOrderProductItem codition) {
        Pager pager = this.posIDMealConsumeDetailService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:mealConsumeDetail:refresh"})
    public ModelAndView listMealId(String orderProductId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderProductId", orderProductId);
        return new ModelAndView("posid/mealConsumeDetail/posIDMealConsumeDetailMeal", param);
    }

    @RequiresPermissions(value={"posid:mealConsumeDetail:refresh"})
    public ModelAndView listItemId(String orderProductMealId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderProductMealId", orderProductMealId);
        return new ModelAndView("posid/mealConsumeDetail/posIDMealConsumeDetailItem", param);
    }

    @RequiresPermissions(value={"posid:mealConsumeDetail:refresh"})
    public DxGrid listMeal(PosIDOrderProductMealItem codition) {
        Pager pager = this.posIDMealConsumeDetailService.orderProductDetail(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, PosIDOrderProductMealItem.class);
    }

    @RequiresPermissions(value={"posid:mealConsumeDetail:refresh"})
    public DxGrid listItem(PosIDOrderStoreDetailItem codition) {
        Pager pager = this.posIDMealConsumeDetailService.orderProductItem(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, PosIDOrderStoreDetailItem.class);
    }
}

