/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.constants.PosIDConstants;
import com.zkteco.zkbiosecurity.posid.remote.PosIDFaceConsumeDeviceRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.service.PosIDBioSyncRecordService;
import com.zkteco.zkbiosecurity.posid.service.PosIDCloudService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeptConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallService;
import com.zkteco.zkbiosecurity.posid.service.PosIDFaceConsumeDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDMealConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOfflineConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderMealService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderProductMealService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderProductService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOuterTransactionService;
import com.zkteco.zkbiosecurity.posid.service.PosIDPersonConsumeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDRechargeMoneyService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionCardService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionService;
import com.zkteco.zkbiosecurity.posid.utils.PosIDFileUtil;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountFaceDevItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAliPayFaceConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDBioSyncRecordItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeptConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceReserveItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceConsumeDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceConsumeDeviceMessage;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceDeviceApiItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceDeviceUpdateItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDMealConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOfflineConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderMealSystemItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOutsidersConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPayOrderItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPersonConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDRechargeMoneyItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDWxPayFaceConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDWxPayFaceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDFaceConsumeDeviceController
extends BaseController
implements PosIDFaceConsumeDeviceRemote {
    private static final Logger log = LoggerFactory.getLogger(PosIDFaceConsumeDeviceController.class);
    @Autowired
    private PosIDFaceConsumeDeviceService posIDFaceConsumeDeviceService;
    @Autowired
    private PosIDDiningHallService posIDDiningHallService;
    @Autowired
    private PosIDTransactionService posIDTransactionService;
    @Autowired
    private PosIDAccountService posIDAccountService;
    @Autowired
    private PosIDTransactionCardService posIDTransactionCardService;
    @Autowired
    private PosIDPersonConsumeService posIDPersonConsumeService;
    @Autowired
    private PosIDDeptConsumeService posIDDeptConsumeService;
    @Autowired
    private PosIDDiningHallConsumeService posIDDiningHallConsumeService;
    @Autowired
    private PosIDDeviceConsumeService posIDDeviceConsumeService;
    @Autowired
    private PosIDMealConsumeService posIDMealConsumeService;
    @Autowired
    private PosIDOfflineConsumeService posIDOfflineConsumeService;
    @Autowired
    private PosIDDeviceService posIDDeviceService;
    @Autowired
    private PosIDRechargeMoneyService posIDRechargeMoneyService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDOrderMealService posIDOrderMealService;
    @Autowired
    private PosIDOrderProductService posIDOrderProductService;
    @Autowired
    private PosIDOrderProductMealService posIDOrderProductMealService;
    @Autowired(required=false)
    private PosIDCloudService posIDCloudService;
    @Autowired
    private PosIDBioSyncRecordService posIDBioSyncRecordService;
    @Autowired
    private PosIDOuterTransactionService posIDOuterTransactionService;
    @Value(value="${server.port:8098}")
    private int hostPort;

    @RequiresPermissions(value={"posid:faceConsumeDevice"})
    public ModelAndView index() {
        return new ModelAndView("posid/faceConsumeDevice/posIDFaceConsumeDevice");
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        String diningHallId = ((PosIDDiningHallItem)this.posIDDiningHallService.getByCondition(new PosIDDiningHallItem()).get(0)).getId();
        param.put("diningHallId", diningHallId);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.buildItemById(id);
            this.request.setAttribute("item", (Object)posIDDeviceItem);
            if (PosIDConstants.POSID_FACE_CONSUME_QUERY_MACHINE.equals(posIDDeviceItem.getDeviceType())) {
                return new ModelAndView("posid/faceConsumeDevice/editPosIDFaceSelectDevice", param);
            }
        }
        return new ModelAndView("posid/faceConsumeDevice/editPosIDFaceConsumeDevice", param);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:enable"})
    public ZKResultMsg enable(String ids) {
        this.posIDFaceConsumeDeviceService.enable(ids);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:disable"})
    public ZKResultMsg disable(String ids) {
        this.posIDFaceConsumeDeviceService.disable(ids);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:syncTime"})
    public ZKResultMsg syncTime(String ids) {
        this.posIDFaceConsumeDeviceService.syncTime(ids);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:edit"})
    public ZKResultMsg save(PosIDFaceDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDFaceConsumeDeviceService.saveFaceDeviceItem(item);
        return res;
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:refresh"})
    public DxGrid list(PosIDFaceDeviceItem codition) {
        Pager pager = this.posIDFaceConsumeDeviceService.listPosIDFaceConsumeDeviceItem(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:del"})
    public ZKResultMsg delete(String ids) {
        this.posIDFaceConsumeDeviceService.deleteFaceDevice(ids);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:syncAllDataToDev"})
    public ZKResultMsg syncAllDataToDev(String ids) {
        this.posIDFaceConsumeDeviceService.syncAllDataToDev(ids, Boolean.valueOf(true), Boolean.valueOf(false));
        return ZKResultMsg.successMsg();
    }

    public PosIDFaceConsumeDeviceMessage registry(String sn, String ipAddress, Integer devType, String devName) {
        return this.posIDFaceConsumeDeviceService.registry(sn, ipAddress, devType, devName);
    }

    public PosIDFaceConsumeDeviceMessage heartBeat(String sn) {
        return this.posIDFaceConsumeDeviceService.heartBeat(sn);
    }

    public PosIDFaceConsumeDeviceMessage getBalance(String sn, @RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        log.info("PosIDFaceConsumeDeviceController getBalance Start");
        PosIDFaceConsumeDeviceMessage posIDFaceConsumeDeviceMessage = this.posIDAccountService.getBalance(posIDFaceDeviceApiItem.getPin());
        log.info("PosIDFaceConsumeDeviceController getBalance return " + posIDFaceConsumeDeviceMessage.toString());
        return posIDFaceConsumeDeviceMessage;
    }

    public PosIDFaceConsumeDeviceMessage onlineCosume(String sn, @RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        log.info("PosIDFaceConsumeDeviceController onlineCosume Start");
        PosIDFaceConsumeDeviceMessage posIDFaceConsumeDeviceMessage = this.posIDFaceConsumeDeviceService.onlineCosume(sn, posIDFaceDeviceApiItem.getPin(), posIDFaceDeviceApiItem.getMoney());
        log.info("PosIDFaceConsumeDeviceController onlineCosume return " + posIDFaceConsumeDeviceMessage.toString());
        return posIDFaceConsumeDeviceMessage;
    }

    public PosIDFaceConsumeDeviceMessage posTransaction(String sn, @RequestBody PosIDTransactionItem posIDTransactionItem) {
        if (StringUtils.isNotBlank((CharSequence)posIDTransactionItem.getPersonPin())) {
            posIDTransactionItem.setEqlPersonPin(posIDTransactionItem.getPersonPin());
        }
        Pager pager = this.posIDTransactionService.getPosTransaction(posIDTransactionItem, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage personPayAndReceive(String sn, @RequestBody PosIDTransactionCardItem posIDTransactionCardItem) {
        Pager pager = this.posIDTransactionCardService.getItemsByPage((BaseItem)posIDTransactionCardItem, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage personConsume(String sn, @RequestBody PosIDPersonConsumeItem condition) {
        if (StringUtils.isNotBlank((CharSequence)condition.getPersonPin())) {
            condition.setEqlPersonPin(condition.getPersonPin());
        }
        Pager pager = this.posIDPersonConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage deptConsume(String sn, @RequestBody PosIDDeptConsumeItem condition) {
        Pager pager = this.posIDDeptConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage diningHallConsume(String sn, @RequestBody PosIDDiningHallConsumeItem condition) {
        Pager pager = this.posIDDiningHallConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage deviceConsume(String sn, @RequestBody PosIDDeviceConsumeItem condition) {
        Pager pager = this.posIDDeviceConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage mealConsume(String sn, @RequestBody PosIDMealConsumeItem condition) {
        Pager pager = this.posIDMealConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage confirmPos(@RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem, String sn, @RequestParam(value="access_token") String accessToken) {
        log.info("PosIDFaceConsumeDeviceController confirmPos Start");
        PosIDFaceConsumeDeviceMessage posIDFaceConsumeDeviceMessage = this.posIDFaceConsumeDeviceService.confirmPos(sn, posIDFaceDeviceApiItem, accessToken);
        log.info("PosIDFaceConsumeDeviceController confirmPos return " + posIDFaceConsumeDeviceMessage);
        return posIDFaceConsumeDeviceMessage;
    }

    public PosIDFaceConsumeDeviceMessage offline(String sn, @RequestBody List<PosIDOfflineConsumeItem> list) {
        List ids = this.posIDOfflineConsumeService.offline(sn, list);
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)ids);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:search"})
    public ModelAndView getSearchFaceConsumeDevInfo() {
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("posid/faceConsumeDevice/opPosIDSearchFaceConsumeDev");
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:search"})
    public ZKResultMsg searchFaceConsumeDev(Long nowTime) {
        ZKResultMsg resultMsg = this.posIDFaceConsumeDeviceService.searchFaceConsumeDev(nowTime);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:add"})
    public ModelAndView faceConsumeDevAdd() {
        String ipAddress = this.request.getParameter("ipAddress");
        String devSn = this.request.getParameter("devSn");
        HashMap<String, String> param = new HashMap<String, String>();
        String diningHallId = ((PosIDDiningHallItem)this.posIDDiningHallService.getByCondition(new PosIDDiningHallItem()).get(0)).getId();
        param.put("diningHallId", diningHallId);
        PosIDFaceConsumeDeviceItem posIDFaceConsumeDeviceItem = this.posIDFaceConsumeDeviceService.getItemForAdd(devSn, ipAddress);
        this.request.setAttribute("item", (Object)posIDFaceConsumeDeviceItem);
        if (posIDFaceConsumeDeviceItem.getDeviceType() != null && posIDFaceConsumeDeviceItem.getDeviceType() == 2) {
            return new ModelAndView("posid/faceConsumeDevice/posIDFaceSelectDevAdd", param);
        }
        return new ModelAndView("posid/faceConsumeDevice/posIDFaceConsumeDevAdd", param);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:add"})
    public ZKResultMsg auth(PosIDFaceConsumeDeviceItem item) {
        ZKResultMsg resultMsg = this.posIDFaceConsumeDeviceService.auth(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView syncPersonDataToDev(String ids) {
        if (null != ids && !"".equals(ids)) {
            this.posIDFaceConsumeDeviceService.cacheSyncPersonDataToDevIds(ids);
        }
        return new ModelAndView("posid/faceConsumeDevice/syncPersonDataToDev");
    }

    public DxGrid selectFaceDevAccountList(PosIDAccountFaceDevItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posIDAccountService.selectFaceDevAccountList(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg syncPersonData(String accountIds) {
        ZKResultMsg resultMsg = this.posIDFaceConsumeDeviceService.syncPersonData(accountIds);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public PosIDFaceConsumeDeviceMessage diningHall() {
        List list = this.posIDDiningHallService.diningHallApiList();
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)list);
    }

    public PosIDFaceConsumeDeviceMessage getRechargeformItemList(String sn, @RequestBody PosIDTransactionCardItem condition) {
        if (StringUtils.isNotBlank((CharSequence)condition.getPersonPin())) {
            condition.setEqlPersonPin(condition.getPersonPin());
        }
        List<Short> typeList = Arrays.asList((short)1, (short)2, (short)3, (short)11, (short)12);
        Pager pager = this.posIDTransactionCardService.getApiTransactionCardList(condition, this.getPageNo(), this.getPageSize(), typeList);
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage getCardRefundItemList(String sn, @RequestBody PosIDTransactionCardItem condition) {
        List<Short> typeList = Arrays.asList((short)5, (short)17);
        Pager pager = this.posIDTransactionCardService.getApiTransactionCardList(condition, this.getPageNo(), this.getPageSize(), typeList);
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage getCardSubsidyList(String sn, @RequestBody PosIDTransactionCardItem condition) {
        List<Short> typeList = Arrays.asList((short)4);
        Pager pager = this.posIDTransactionCardService.getApiTransactionCardList(condition, this.getPageNo(), this.getPageSize(), typeList);
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage getProduct(String sn) {
        PosIDFaceConsumeDeviceMessage resultMsg = this.posIDFaceConsumeDeviceService.getProduct(sn);
        return resultMsg;
    }

    public PosIDFaceConsumeDeviceMessage deviceUpdate(String sn, @RequestBody PosIDFaceDeviceUpdateItem posIDFaceDeviceUpdateItem) {
        return this.posIDFaceConsumeDeviceService.deviceUpdate(sn, posIDFaceDeviceUpdateItem);
    }

    public ZKResultMsg getValidationModeNameList(String sn) {
        return new ZKResultMsg((Object)this.posIDFaceConsumeDeviceService.getValidationModeNameList(sn));
    }

    public ZKResultMsg persCardLoss(String pin) {
        return this.posIDFaceConsumeDeviceService.persCardLoss(pin);
    }

    public ZKResultMsg getPinByCardNo(String cardNo) {
        ZKResultMsg resultMsg = this.posIDFaceConsumeDeviceService.getPinByCardNo(cardNo);
        return resultMsg;
    }

    public ZKResultMsg uploadDevLog(String sn, MultipartFile multipartFile) {
        if (Objects.isNull(multipartFile)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        if (!multipartFile.getOriginalFilename().endsWith(".zip")) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_commStatus_fileNameError", (Object[])new Object[0]));
        }
        String fileName = FileUtil.saveFileToServer((String)"posID", (String)("DevLog" + File.separator + sn), (String)(System.currentTimeMillis() + multipartFile.getOriginalFilename()), (MultipartFile)multipartFile);
        if (FileUtil.fileExists((String)fileName)) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public PosIDFaceConsumeDeviceMessage networkRecharge(String sn, @RequestBody PosIDPayOrderItem posIDPayOrderItem) {
        posIDPayOrderItem.setSn(sn);
        return this.posIDFaceConsumeDeviceService.networkRecharge(posIDPayOrderItem);
    }

    public PosIDFaceConsumeDeviceMessage confirmPosScanBox(@RequestBody PosIDOutsidersConsumeItem posIDOutsidersConsumeItem, String sn, @RequestParam(value="access_token") String accessToken) {
        PosIDFaceConsumeDeviceMessage posIDFaceConsumeDeviceMessage = new PosIDFaceConsumeDeviceMessage();
        posIDFaceConsumeDeviceMessage = PosIDConstants.POSID_PAY_TYPE_DIGITAL_YUAN.equals(posIDOutsidersConsumeItem.getPayType()) ? this.posIDOuterTransactionService.outsidersConsume(posIDOutsidersConsumeItem, sn, accessToken) : this.posIDFaceConsumeDeviceService.confirmPosScanBox(sn, posIDOutsidersConsumeItem.getBarcode(), posIDOutsidersConsumeItem.getMoney(), posIDOutsidersConsumeItem.getPosMode(), posIDOutsidersConsumeItem.getData(), accessToken);
        log.info("PosIDFaceConsumeDeviceController confirmPos return " + posIDFaceConsumeDeviceMessage);
        return posIDFaceConsumeDeviceMessage;
    }

    public PosIDFaceConsumeDeviceMessage rechargeMoneyList() {
        PosIDRechargeMoneyItem condition = new PosIDRechargeMoneyItem();
        condition.setAvailable(Boolean.valueOf(true));
        List list = this.posIDRechargeMoneyService.getRechargeMoneyList(condition);
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)list);
    }

    public PosIDFaceConsumeDeviceMessage checkOrderPay(String sn, @RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        PosIDFaceConsumeDeviceMessage resultMsg = this.posIDFaceConsumeDeviceService.checkOrderPay(posIDFaceDeviceApiItem.getOutTradeNo());
        return resultMsg;
    }

    public PosIDFaceConsumeDeviceMessage getOrderMealSystem() {
        PosIDOrderMealSystemItem posIDOrderMealSystemItem = new PosIDOrderMealSystemItem();
        posIDOrderMealSystemItem.setOrderMealAdvanceDate(this.posIDSystemParamService.getValByName("posid.orderMealAdvanceDate"));
        posIDOrderMealSystemItem.setOrderMealMaxDate(this.posIDSystemParamService.getValByName("posid.orderMealMaxDate"));
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)posIDOrderMealSystemItem);
    }

    public PosIDFaceConsumeDeviceMessage getMeal(@RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        ZKResultMsg resultMsg = this.posIDOrderMealService.getMeal(posIDFaceDeviceApiItem.getPin(), posIDFaceDeviceApiItem.getOrderTime(), posIDFaceDeviceApiItem.getDiningId());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)resultMsg.getData());
    }

    public PosIDFaceConsumeDeviceMessage orderMeal(String sn, @RequestBody List<PosIDOrderMealItem> list) {
        if (null != list && list.size() > 0) {
            for (PosIDOrderMealItem posIDOrderMealItem : list) {
                posIDOrderMealItem.setSn(sn);
                ZKResultMsg zkResultMsg = this.posIDOrderMealService.apiOrderMeal(posIDOrderMealItem);
                if (zkResultMsg.isSuccess()) continue;
                return PosIDFaceConsumeDeviceMessage.failMessage((String)zkResultMsg.getMsg());
            }
        }
        return PosIDFaceConsumeDeviceMessage.successMessage();
    }

    public PosIDFaceConsumeDeviceMessage checkOrder(String sn, @RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemBySn(sn);
        if (null == posIDDeviceItem) {
            return PosIDFaceConsumeDeviceMessage.failMessage();
        }
        return this.posIDOrderMealService.checkOrder(posIDFaceDeviceApiItem.getPin(), posIDDeviceItem.getDiningHallId());
    }

    public PosIDFaceConsumeDeviceMessage delOrderMeal(String sn, @RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        return this.posIDOrderMealService.delOrderMeal(posIDFaceDeviceApiItem.getIds());
    }

    public PosIDFaceConsumeDeviceMessage editOrderMeal(String sn, @RequestBody PosIDOrderMealItem posIDOrderMealItem) {
        posIDOrderMealItem.setSn(sn);
        return this.posIDOrderMealService.orderMeal(posIDOrderMealItem);
    }

    public PosIDFaceConsumeDeviceMessage orderMealHistoryRecord(String sn, @RequestBody PosIDOrderMealItem posIDOrderMealItem) {
        if (StringUtils.isNotBlank((CharSequence)posIDOrderMealItem.getPin())) {
            posIDOrderMealItem.setEqlPersonPin(posIDOrderMealItem.getPin());
        }
        Pager pager = this.posIDOrderMealService.orderMealHistoryRecord(posIDOrderMealItem, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public ZKResultMsg getConsumeOrder(Integer deviceType) {
        return new ZKResultMsg((Object)this.posIDFaceConsumeDeviceService.getConsumeOrder(deviceType));
    }

    public ZKResultMsg getConsumeMode(Integer deviceType) {
        return new ZKResultMsg((Object)this.posIDFaceConsumeDeviceService.getConsumeMode(deviceType));
    }

    public PosIDFaceConsumeDeviceMessage errorRecoveryData(String sn, @RequestParam(value="pin") String pin) {
        if (StringUtils.isEmpty((CharSequence)pin)) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_not_found_person", (Object[])new Object[0]));
        }
        return this.posIDTransactionService.deviceErrorRecovery(sn, pin);
    }

    public PosIDFaceConsumeDeviceMessage getOrderStoreList(@RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        if (StringUtils.isEmpty((CharSequence)posIDFaceDeviceApiItem.getPin())) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_not_found_person", (Object[])new Object[0]));
        }
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)this.posIDOrderProductService.getOrderStoreList(posIDFaceDeviceApiItem.getPin(), posIDFaceDeviceApiItem.getOrderTime(), posIDFaceDeviceApiItem.getDiningId()));
    }

    public PosIDFaceConsumeDeviceMessage orderProduct(@RequestBody PosIDDeviceReserveItem posIDDeviceReserveItem) {
        try {
            ZKResultMsg resultMsg = this.posIDOrderProductService.orderProduct(posIDDeviceReserveItem);
            if (!resultMsg.isSuccess()) {
                return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)resultMsg.getMsg(), (Object[])new Object[0]));
            }
            return PosIDFaceConsumeDeviceMessage.successMessage((Object)resultMsg.getData());
        }
        catch (ZKBusinessException e) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]));
        }
    }

    public PosIDFaceConsumeDeviceMessage orderProductList(@RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        PosIDOrderProductItem condition = new PosIDOrderProductItem();
        condition.setEqlPersonPin(posIDFaceDeviceApiItem.getPin());
        condition.setOpOrderTimeBegin(posIDFaceDeviceApiItem.getStartDatetimeBegin());
        condition.setOpOrderTimeEnd(posIDFaceDeviceApiItem.getStartDatetimeEnd());
        Pager pager = this.posIDOrderProductService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)pager);
    }

    public PosIDFaceConsumeDeviceMessage orderProductDetail(@RequestParam(value="id") String id) {
        PosIDOrderProductItem productItem = new PosIDOrderProductItem();
        productItem.setId(id);
        ZKResultMsg zkResultMsg = this.posIDOrderProductService.orderProductDetail(productItem);
        if (!zkResultMsg.isSuccess()) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)zkResultMsg.getMsg(), (Object[])new Object[0]));
        }
        return PosIDFaceConsumeDeviceMessage.successMessage((Object)zkResultMsg.getData());
    }

    public PosIDFaceConsumeDeviceMessage cancelOrderProduct(@RequestBody PosIDFaceDeviceApiItem posIDFaceDeviceApiItem) {
        if (CollectionUtils.isEmpty((Collection)posIDFaceDeviceApiItem.getOrderProductIds())) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_pay_order_out_trade_no_notFound", (Object[])new Object[0]));
        }
        Integer cancelOrderMealTime = Integer.parseInt(this.posIDSystemParamService.getValByName("posid.cancelOrderMealTime"));
        for (String id : posIDFaceDeviceApiItem.getOrderProductIds()) {
            ZKResultMsg zkResultMsg;
            PosIDOrderProductMealItem posIDOrderProductMealItem = this.posIDOrderProductMealService.getItemById(id);
            if (!PosIDConstants.POSID_CONSUMEDETAIL_ORDERSUCCESS.equals(posIDOrderProductMealItem.getStatus())) {
                return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_orderMeal_cancelFail", (Object[])new Object[0]));
            }
            if (null == posIDOrderProductMealItem.getMealBeginTime() || DateUtil.addMinute((Date)new Date(), (int)cancelOrderMealTime).after(posIDOrderProductMealItem.getMealBeginTime())) {
                return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_system_cancellation_of_order_fail", (Object[])new Object[0]));
            }
            if (PosIDConstants.POSID_PAYSTATUS_SUCCESS.equals(posIDOrderProductMealItem.getPaymentStatus()) && StringUtils.isNotBlank((CharSequence)posIDOrderProductMealItem.getTransactionId()) && !(zkResultMsg = this.posIDTransactionService.cancelOrderProduct(posIDOrderProductMealItem.getTransactionId())).isSuccess()) {
                return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)zkResultMsg.getMsg(), (Object[])new Object[0]));
            }
            posIDOrderProductMealItem.setStatus(PosIDConstants.POSID_CONSUMEDETAIL_CANCELSUCCESS);
            this.posIDOrderProductMealService.saveItem(posIDOrderProductMealItem);
        }
        return PosIDFaceConsumeDeviceMessage.successMessage();
    }

    public PosIDFaceConsumeDeviceMessage isOperator(String sn, @RequestParam(value="pin") String pin) {
        if (StringUtils.isEmpty((CharSequence)pin)) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_not_found_person", (Object[])new Object[0]));
        }
        PosIDAccountItem posIDAccountItem = this.posIDAccountService.getAccountByPin(pin);
        if (Objects.isNull(posIDAccountItem) || !PosIDConstants.POSID_ACCOUNT_STATUS_ADMIN.equals(posIDAccountItem.getStatus())) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_check_isOperator_fail", (Object[])new Object[0]));
        }
        return PosIDFaceConsumeDeviceMessage.successMessage();
    }

    public ZKResultMsg uploadTransFaceImg(String sn, Integer transactionType, String transactionId, MultipartFile multipartFile) {
        String filePath = "upload/posID/posConsumeSuccessImg/" + DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD) + "/";
        String fileName = System.currentTimeMillis() + multipartFile.getOriginalFilename();
        FileUtils.saveMultipartFile((String)filePath, (String)fileName, (MultipartFile)multipartFile, (boolean)false);
        FileEncryptUtil.encryptFileByPath((String)(filePath + fileName));
        if (PosIDConstants.POS_TRANSACTION_CONSUMPTION.equals(transactionType)) {
            this.posIDTransactionService.uploadTransFaceImg(transactionId, filePath + fileName);
        } else if (PosIDConstants.POS_TRANSACTION_OFFLINE.equals(transactionType)) {
            this.posIDOfflineConsumeService.uploadTransFaceImg(sn, transactionId, filePath + fileName);
        }
        return ZKResultMsg.successMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDecryptPhoto(String photoPath) {
        OutputStream outputStream = null;
        try {
            byte[] buffer = FileEncryptUtil.getDecryptFile((String)photoPath);
            if (Objects.isNull(buffer)) {
                buffer = PosIDFileUtil.file2Byte(FileUtils.getLocalFullPath((String)photoPath));
            }
            if (Objects.nonNull(buffer)) {
                outputStream = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
                outputStream.write(buffer);
                outputStream.flush();
            }
        }
        catch (IOException ex) {
            log.info("get person photo error");
            ex.printStackTrace();
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.info("outputStream close error");
                    e.printStackTrace();
                }
            }
        }
    }

    public PosIDFaceConsumeDeviceMessage getWxPayFaceAuthinfo(String sn, @RequestBody PosIDWxPayFaceItem posIDWxPayFaceItem) {
        if (StringUtils.isBlank((CharSequence)posIDWxPayFaceItem.getRawdata())) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_wx_pay_face_rawdata_fail", (Object[])new Object[0]));
        }
        ZKResultMsg zkResultMsg = this.posIDCloudService.getWxPayFaceAuthinfo(sn, posIDWxPayFaceItem);
        if (zkResultMsg.isSuccess()) {
            return PosIDFaceConsumeDeviceMessage.successMessage((Object)zkResultMsg.getData());
        }
        return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)zkResultMsg.getMsg(), (Object[])new Object[0]));
    }

    public PosIDFaceConsumeDeviceMessage offlinefaceCheck(String sn, @RequestParam(value="access_token") String accessToken, @RequestBody PosIDWxPayFaceConsumeItem posIDWxPayFaceConsumeItem) {
        posIDWxPayFaceConsumeItem.setSn(sn);
        log.info(posIDWxPayFaceConsumeItem.toString());
        return this.posIDDeviceService.offlinefaceCheck(accessToken, posIDWxPayFaceConsumeItem);
    }

    public PosIDFaceConsumeDeviceMessage offlineface(String sn, @RequestParam(value="access_token") String accessToken, @RequestBody PosIDWxPayFaceConsumeItem posIDWxPayFaceConsumeItem) {
        if (StringUtils.isBlank((CharSequence)posIDWxPayFaceConsumeItem.getUniqueId())) {
            return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_wx_pay_face_bad_request", (Object[])new Object[0]));
        }
        posIDWxPayFaceConsumeItem.setSn(sn);
        return this.posIDDeviceService.offlineface(accessToken, posIDWxPayFaceConsumeItem);
    }

    public PosIDFaceConsumeDeviceMessage getPaymentParams(String sn) {
        ZKResultMsg zkResultMsg = this.posIDCloudService.getPaymentParams(sn);
        if (zkResultMsg.isSuccess()) {
            return PosIDFaceConsumeDeviceMessage.successMessage((Object)zkResultMsg.getData());
        }
        return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)zkResultMsg.getMsg(), (Object[])new Object[0]));
    }

    public PosIDFaceConsumeDeviceMessage aliFaceConsume(String sn, String accessToken, PosIDAliPayFaceConsumeItem posIDAliPayFaceConsumeItem) {
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{posIDAliPayFaceConsumeItem.getVerifyType(), posIDAliPayFaceConsumeItem.getAuthCode()})) {
                return PosIDFaceConsumeDeviceMessage.failMessage((String)I18nUtil.i18nCode((String)"posid_unsupported_authentication_method", (Object[])new Object[0]));
            }
            posIDAliPayFaceConsumeItem.setSn(sn);
            log.info("aliFaceConsume " + posIDAliPayFaceConsumeItem);
            return this.posIDDeviceService.aliFaceConsume(accessToken, posIDAliPayFaceConsumeItem);
        }
        catch (Exception e) {
            log.error("ali pay error " + e.getMessage());
            e.printStackTrace();
            return PosIDFaceConsumeDeviceMessage.failMessage((String)e.getMessage());
        }
    }

    public ZKResultMsg aliDevInit(String sn, PosIDAliPayFaceConsumeItem posIDAliPayFaceConsumeItem) {
        return this.posIDCloudService.aliDevInit(posIDAliPayFaceConsumeItem.getMetaInfo());
    }

    public PosIDFaceConsumeDeviceMessage uploadBioSyncRecord(String sn, List<PosIDBioSyncRecordItem> posIDBioSyncRecordItemList) {
        this.posIDBioSyncRecordService.saveBioSyncRecord(posIDBioSyncRecordItemList);
        return PosIDFaceConsumeDeviceMessage.successMessage();
    }
}

