/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDDiningHallRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDDiningHallController
extends BaseController
implements PosIDDiningHallRemote {
    @Autowired
    private PosIDDiningHallService posIDDiningHallService;

    @RequiresPermissions(value={"posid:diningHall"})
    public ModelAndView index() {
        return new ModelAndView("posid/diningHall/posIDDiningHall");
    }

    @RequiresPermissions(value={"posid:diningHall:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDDiningHallService.getItemById(id));
        }
        return new ModelAndView("posid/diningHall/editPosIDDiningHall");
    }

    @RequiresPermissions(value={"posid:diningHall:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_diningHall", opType="common_op_new", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosIDDiningHallItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDDiningHallService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:diningHall:refresh"})
    public DxGrid list(PosIDDiningHallItem codition) {
        Pager pager = this.posIDDiningHallService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:diningHall:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_diningHall", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.posIDDiningHallService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(String code) {
        PosIDDiningHallItem item = this.posIDDiningHallService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public String validName(String name) {
        PosIDDiningHallItem item = this.posIDDiningHallService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getDiningHallNameList() {
        return new ZKResultMsg((Object)this.posIDDiningHallService.getDiningHallNameList());
    }

    public ZKResultMsg photoUpload(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        ZKResultMsg zm = new ZKResultMsg();
        String fileName = System.currentTimeMillis() + "_" + new Random().nextInt(1000);
        if (file.getOriginalFilename().toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)$")) {
            String photoPath = FileUtil.saveFileToServer((String)"posID", (String)"diningHall", (String)(fileName + ".jpg"), (MultipartFile)file);
            zm.setData((Object)photoPath);
        } else {
            zm.setRet("fail");
            zm.setMsg("common_op_failed");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zm);
    }

    public ZKResultMsg getOrderMealDiningHall() {
        return new ZKResultMsg((Object)this.posIDDiningHallService.getOrderMealDiningHall());
    }
}

