/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.posid.constants.PosIDConstants;
import com.zkteco.zkbiosecurity.posid.remote.PosIDDeviceRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDDeviceController
extends BaseController
implements PosIDDeviceRemote {
    private static final Logger log = LoggerFactory.getLogger(PosIDDeviceController.class);
    @Autowired
    private PosIDDeviceService posIDDeviceService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PosIDDiningHallService posIDDiningHallService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;

    @RequiresPermissions(value={"posid:device"})
    public ModelAndView index() {
        return new ModelAndView("posid/device/posIDDevice");
    }

    @RequiresPermissions(value={"posid:device:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        String cardModel = this.posIDSystemParamService.getValByName("posid.cardModel");
        String diningHallId = ((PosIDDiningHallItem)this.posIDDiningHallService.getByCondition(new PosIDDiningHallItem()).get(0)).getId();
        param.put("diningHallId", diningHallId);
        param.put("cardModel", cardModel);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("doubleCashModel", (Object)this.posIDDeviceService.getDoubleCash());
            PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.buildItemById(id);
            this.request.setAttribute("item", (Object)posIDDeviceItem);
        }
        return new ModelAndView("posid/device/editPosIDDevice", param);
    }

    public ModelAndView devAdd() {
        String ipAddress = this.request.getParameter("ipAddress");
        String devSn = this.request.getParameter("devSn");
        this.request.setAttribute("ipAddress", (Object)ipAddress);
        this.request.setAttribute("sn", (Object)devSn);
        PosIDDeviceItem posIDDeviceItem = null;
        posIDDeviceItem = new PosIDDeviceItem();
        posIDDeviceItem.setDevAlias(devSn);
        posIDDeviceItem.setSn(devSn);
        posIDDeviceItem.setIpAddress(ipAddress);
        String cardModel = this.posIDSystemParamService.getValByName("posid.cardModel");
        this.request.setAttribute("item", (Object)posIDDeviceItem);
        this.request.setAttribute("cardModel", (Object)cardModel);
        this.request.setAttribute("hallDefaultValue", (Object)this.posIDDeviceService.getDiningHallDefaultValue());
        return new ModelAndView("posid/device/addPosIDDevice");
    }

    @RequiresPermissions(value={"posid:device:edit"})
    public ZKResultMsg auth(PosIDDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        res = this.posIDDeviceService.authDevice(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:device:enable"})
    public ZKResultMsg enable(String ids) {
        ZKResultMsg zKResultMsg = this.posIDDeviceService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:device:disable"})
    public ZKResultMsg disable(String ids) {
        ZKResultMsg zKResultMsg = this.posIDDeviceService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:device:edit"})
    @LogRequest(module="posid_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg save(PosIDDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:device:refresh"})
    public DxGrid list(PosIDDeviceItem codition) {
        codition.setDeviceType(Integer.valueOf(0));
        Pager pager = this.posIDDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:device:del"})
    @LogRequest(module="posid_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg delete(String ids) {
        this.posIDDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:device:deleteCmd"})
    public ZKResultMsg deleteCmd(String ids) {
        ZKResultMsg ret = this.posIDDeviceService.deleteCmd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"posid:device:reboot"})
    public ZKResultMsg reboot(String ids) {
        ZKResultMsg zKResultMsg = this.posIDDeviceService.reboot(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:device:syncAllDataToDev"})
    public ZKResultMsg syncAllDataToDev(String ids) {
        ZKResultMsg zKResultMsg = this.posIDDeviceService.syncAllDataToDev(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public TreeItem tree() {
        List items = this.posIDDeviceService.getByCondition(new PosIDDeviceItem());
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosIDDeviceItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getSn() + "(" + depart.getDevAlias() + ")");
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public TreeItem handConsumeTree() {
        PosIDDeviceItem posIDDeviceItem = new PosIDDeviceItem();
        posIDDeviceItem.setNotEqlDeviceType(PosIDConstants.POSID_FACE_CONSUME_QUERY_MACHINE);
        List items = this.posIDDeviceService.loadListByAuthFilter(this.request.getSession().getId(), posIDDeviceItem);
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosIDDeviceItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getSn() + "(" + depart.getDevAlias() + ")");
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getDevSnList() {
        return new ZKResultMsg((Object)this.posIDDeviceService.getDevSnList());
    }

    @RequiresPermissions(value={"posid:device:search"})
    public ZKResultMsg searchDev(Long nowTime) {
        JSONObject devInfoJson = new JSONObject();
        try {
            List devcieItems = this.posIDDeviceService.searchDeviceList();
            devInfoJson.put("ret", (Object)"ok");
            devInfoJson.put("devCount", (Object)devcieItems.size());
            JSONArray jsonArray = new JSONArray();
            devcieItems.forEach(item -> {
                JSONObject rowData = new JSONObject();
                rowData.put("IP", (Object)item.getIp());
                rowData.put("SN", (Object)item.getSn());
                rowData.put("Device", (Object)item.getDeviceName());
                jsonArray.add((Object)rowData);
            });
            devInfoJson.put("devData", (Object)jsonArray);
            devInfoJson.put("nowTime", (Object)nowTime);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg getAllIPSn() {
        JSONObject devInfoJson = new JSONObject();
        List posIDDeviceItemList = this.posIDDeviceService.getByCondition(new PosIDDeviceItem());
        JSONArray ipArray = new JSONArray();
        JSONArray snArray = new JSONArray();
        posIDDeviceItemList.stream().forEach(item -> {
            ipArray.add((Object)item.getIpAddress());
            snArray.add((Object)item.getSn());
        });
        devInfoJson.put("ipAddress", (Object)ipArray);
        devInfoJson.put("sn", (Object)snArray);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg convertParsedCmdCount(String value) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String data = this.posIDDeviceService.getCmdCount(value);
        zkResultMsg.setData((Object)data);
        return zkResultMsg;
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.posIDDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean isExistAlias(String alias) {
        return this.posIDDeviceService.isExistAlias(alias);
    }

    @RequiresPermissions(value={"posid:device:search"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("posid/device/opPosIDSearchDev");
    }

    public TreeItem orderMealTree() {
        PosIDDeviceItem posIDDeviceItem = new PosIDDeviceItem();
        List items = this.posIDDeviceService.loadListByAuthFilter(this.request.getSession().getId(), posIDDeviceItem);
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosIDDeviceItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getSn());
            item.setText(depart.getSn() + "(" + depart.getDevAlias() + ")");
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"posid:device:clearData"})
    public ZKResultMsg clearData(String ids) {
        ZKResultMsg ret = this.posIDDeviceService.clearData(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

