/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDBioSyncRecordRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDBioSyncRecordService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDBioSyncRecordItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDBioSyncRecordController
extends BaseController
implements PosIDBioSyncRecordRemote {
    @Autowired
    private PosIDBioSyncRecordService posIDBioSyncRecordService;
    @Autowired
    private PosIDDeviceService posIDDeviceService;

    @RequiresPermissions(value={"posid:faceConsumeDevice:getBioSyncRecord"})
    public ModelAndView index(String deviceId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deviceId", deviceId);
        return new ModelAndView("posid/bioSyncRecord/posIDBioSyncRecord", param);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getBioSyncRecord"})
    public DxGrid list(PosIDBioSyncRecordItem condition) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemById(condition.getDeviceId());
        if (Objects.nonNull(posIDDeviceItem)) {
            condition.setEqlSn(posIDDeviceItem.getSn());
        }
        Pager pager = this.posIDBioSyncRecordService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getBioSyncRecord"})
    public ZKResultMsg delByDeviceId(String deviceId) {
        return this.posIDBioSyncRecordService.delByDeviceIds(deviceId);
    }
}

