/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/transaction"})
@Api(tags={"PosidTransaction"}, description="posid transaction")
public class PosIDApiTransactionController {
    @Autowired
    private PosIDTransactionService posIDTransactionService;

    @ResponseBody
    @RequestMapping(value={"/listPosidTransaction"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Posid Transactions List", notes="Return Posid Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage listPosidTransaction(@RequestParam(required=false) String personPin, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam int pageNo, @RequestParam int pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        PosIDTransactionItem condition = new PosIDTransactionItem();
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            condition.setStartDatetimeBegin(startDate);
            condition.setStartDatetimeEnd(endDate);
        }
        if (StringUtils.isNotBlank((CharSequence)personPin)) {
            condition.setEqlPersonPin(personPin);
        }
        Pager pager = this.posIDTransactionService.getApiPosTransaction(condition, pageNo - 1, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    private ApiResultMessage checkParam(String startDate, String endDate, Integer pageNo, Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        return null;
    }
}

