/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiOrderMealSystemItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiThresholdValueItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiTransactionCardItem;
import com.zkteco.zkbiosecurity.posid.service.PosIDAllowanceLogRecordService;
import com.zkteco.zkbiosecurity.posid.service.PosIDApiService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderMealService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOrderProductService;
import com.zkteco.zkbiosecurity.posid.service.PosIDRechargeMoneyService;
import com.zkteco.zkbiosecurity.posid.service.PosIDStoreDetailService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransferAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAllowanceLogRecordItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceReserveItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDRechargeMoneyItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDStoreDetailItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransferAccountItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransferAccountTransactionCardItem;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/posID"})
public class PosIDApiController {
    @Autowired
    private PosIDApiService posIDApiService;
    @Autowired
    private PosIDOrderMealService posIDOrderMealService;
    @Autowired
    private PosIDRechargeMoneyService posIDRechargeMoneyService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDOrderProductService posIDOrderProductService;
    @Autowired
    private PosIDAllowanceLogRecordService posIDAllowanceLogRecordService;
    @Autowired
    private PosIDTransferAccountService posIDTransferAccountService;
    @Autowired
    private PosIDStoreDetailService posIDStoreDetailService;

    @RequestMapping(value={"/my"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg my(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        ZKResultMsg resultMsg = this.posIDApiService.my(MapUtils.getString((Map)map, (Object)"personPin"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/pplList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg pplList(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDAccountItem posIDAccountItem = new PosIDAccountItem();
        posIDAccountItem.setPersonName(MapUtils.getString((Map)map, (Object)"personName"));
        posIDAccountItem.setNotEqlPersonPin(MapUtils.getString((Map)map, (Object)"personPin"));
        posIDAccountItem.setPageSize(MapUtils.getIntValue((Map)map, (Object)"pageSize"));
        posIDAccountItem.setPosStart(MapUtils.getIntValue((Map)map, (Object)"posStart"));
        if (map.containsKey("staffPin") && null != MapUtils.getString((Map)map, (Object)"staffPin")) {
            posIDAccountItem.setEqlPersonPin(MapUtils.getString((Map)map, (Object)"staffPin"));
        }
        Pager pager = this.posIDApiService.personList(posIDAccountItem);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)pager));
    }

    @RequestMapping(value={"/transferAccount"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transferAccount(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDTransferAccountItem item = new PosIDTransferAccountItem();
        item.setTransferType(MapUtils.getInteger((Map)map, (Object)"transferType"));
        item.setReceiverId(MapUtils.getString((Map)map, (Object)"receiverId"));
        item.setTransferAmt(MapUtils.getInteger((Map)map, (Object)"transferAmt"));
        item.setSenderId(MapUtils.getString((Map)map, (Object)"senderId"));
        item.setNote(MapUtils.getString((Map)map, (Object)"note"));
        item.setType("1");
        return I18nUtil.i18nMsg((ZKResultMsg)this.posIDTransferAccountService.transferAccount(item));
    }

    @RequestMapping(value={"/getTransactionRecord"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getTransactionRecord(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDTransferAccountTransactionCardItem item = new PosIDTransferAccountTransactionCardItem();
        item.setEqlPersonPin(MapUtils.getString((Map)map, (Object)"loggerPin"));
        item.setTransferType(MapUtils.getInteger((Map)map, (Object)"transferType"));
        item.setBizStatus(MapUtils.getString((Map)map, (Object)"bizStatus"));
        item.setPageSize(MapUtils.getInteger((Map)map, (Object)"pageSize").intValue());
        item.setPageStart(MapUtils.getInteger((Map)map, (Object)"pageStart").intValue());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.posIDTransferAccountService.getTransferAccountRecord(item)));
    }

    @RequestMapping(value={"/getMeal"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getMeal(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String orderTime = MapUtils.getString((Map)map, (Object)"orderTime");
        String diningId = MapUtils.getString((Map)map, (Object)"diningId");
        ZKResultMsg resultMsg = this.posIDApiService.getMeal(pin, orderTime, diningId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/orderMeal"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg orderMeal(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String rvs = JSONArray.toJSONString(map.get("orderMealList"));
        List list = (List)JSONObject.parseObject((String)rvs, (TypeReference)new TypeReference<List<PosIDOrderMealItem>>(){}, (Feature[])new Feature[0]);
        if (null != list && list.size() > 0) {
            for (PosIDOrderMealItem posIDOrderMealItem : list) {
                posIDOrderMealItem.setPin(pin);
                ZKResultMsg zkResultMsg = this.posIDOrderMealService.apiOrderMeal(posIDOrderMealItem);
                if (zkResultMsg.isSuccess()) continue;
                return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequestMapping(value={"/cancelOrderMeal"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg cancelOrderMeal(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg zkResultMsg = this.posIDOrderMealService.setOrderMealStatus(MapUtils.getString((Map)zkMessage.getContent(), (Object)"id"), Integer.valueOf(2));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/myAllowanceApply"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg myAllowanceApply(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"personPin");
        int pageStart = MapUtils.getInteger((Map)map, (Object)"pageStart") == null ? 0 : MapUtils.getInteger((Map)map, (Object)"pageStart");
        int pageSize = MapUtils.getInteger((Map)map, (Object)"pageSize") == null ? 10 : MapUtils.getInteger((Map)map, (Object)"pageSize");
        PosIDAllowanceLogRecordItem posIDAllowanceLogRecordItem = new PosIDAllowanceLogRecordItem();
        posIDAllowanceLogRecordItem.setEqlPersonPin(pin);
        if (MapUtils.getInteger((Map)map, (Object)"isCheck") != null) {
            posIDAllowanceLogRecordItem.setIsCheck(MapUtils.getInteger((Map)map, (Object)"isCheck"));
        }
        Pager pager = this.posIDAllowanceLogRecordService.getItemsByPage((BaseItem)posIDAllowanceLogRecordItem, pageStart, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)pager));
    }

    @RequestMapping(value={"/orderMealList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg orderMealList(@RequestBody(required=false) ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        int pageStart = MapUtils.getInteger((Map)map, (Object)"pageStart") == null ? 0 : MapUtils.getInteger((Map)map, (Object)"pageStart");
        int pageSize = MapUtils.getInteger((Map)map, (Object)"pageSize") == null ? 10 : MapUtils.getInteger((Map)map, (Object)"pageSize");
        Date orderTime = MapUtils.getString((Map)map, (Object)"orderTime") == null ? new Date() : DateUtil.stringToDate((String)MapUtils.getString((Map)map, (Object)"orderTime"), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        PosIDOrderMealItem posIDOrderMealItem = new PosIDOrderMealItem();
        if (map.containsKey("status") && MapUtils.getInteger((Map)map, (Object)"status") != null) {
            Integer status = MapUtils.getInteger((Map)map, (Object)"status");
            if (status == 3) {
                posIDOrderMealItem.setStatus(Integer.valueOf(0));
                posIDOrderMealItem.setNoMeals(new Date());
            } else {
                if (status == 0) {
                    posIDOrderMealItem.setTimeMeals(new Date());
                }
                posIDOrderMealItem.setStatus(status);
            }
        }
        posIDOrderMealItem.setEqlPersonPin(pin);
        posIDOrderMealItem.setStartDatetimeBegin(DateUtil.getStartMonthDate((int)DateUtil.getYear((Date)orderTime), (int)(DateUtil.getMonth((Date)orderTime) + 1)));
        posIDOrderMealItem.setStartDatetimeEnd(DateUtil.getEndMonthDate((int)DateUtil.getYear((Date)orderTime), (int)(DateUtil.getMonth((Date)orderTime) + 1)));
        Pager pager = this.posIDOrderMealService.orderMealHistoryRecord(posIDOrderMealItem, pageStart, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)pager));
    }

    @RequestMapping(value={"/rechargeMoneyList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg rechargeMoneyList(@RequestBody ZKMessage zkMessage) {
        String pin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
        PosIDRechargeMoneyItem condition = new PosIDRechargeMoneyItem();
        condition.setAvailable(Boolean.valueOf(true));
        List list = this.posIDRechargeMoneyService.getRechargeMoneyList(condition);
        PosIDApiThresholdValueItem posIDApiThresholdValueItem = this.posIDApiService.thresholdValue(pin);
        posIDApiThresholdValueItem.setList(list);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)posIDApiThresholdValueItem));
    }

    @RequestMapping(value={"/recharge"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg recharge(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String ip = MapUtils.getString((Map)map, (Object)"ip");
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String openId = MapUtils.getString((Map)map, (Object)"openId");
        Integer money = MapUtils.getInteger((Map)map, (Object)"money");
        String payType = MapUtils.getString((Map)map, (Object)"payType");
        ZKResultMsg resultMsg = this.posIDApiService.recharge(ip, pin, openId, money, payType);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/transactionCard"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transactionCard(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDApiTransactionCardItem item = new PosIDApiTransactionCardItem();
        item.setPin(MapUtils.getString((Map)map, (Object)"pin"));
        item.setType(MapUtils.getInteger((Map)map, (Object)"type"));
        item.setLogFlag(MapUtils.getInteger((Map)map, (Object)"logFlag"));
        item.setAllowType(MapUtils.getInteger((Map)map, (Object)"allowType"));
        item.setSearchTime(DateUtil.stringToDate((String)MapUtils.getString((Map)map, (Object)"searchTime"), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        item.setPosStart(MapUtils.getInteger((Map)map, (Object)"pageStart").intValue());
        item.setPageSize(MapUtils.getInteger((Map)map, (Object)"pageSize").intValue());
        ZKResultMsg resultMsg = this.posIDApiService.transactionCard(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/transactionCardByPin"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transactionCardByPin(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        ZKResultMsg resultMsg = this.posIDApiService.transactionCardByPin(MapUtils.getString((Map)map, (Object)"pin"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/transactionCardDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transactionCardDetail(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg resultMsg = this.posIDApiService.transactionCardDetail(MapUtils.getString((Map)zkMessage.getContent(), (Object)"id"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/transaction"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transaction(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDTransactionItem posIDTransactionItem = new PosIDTransactionItem();
        posIDTransactionItem.setEqlPersonPin(MapUtils.getString((Map)map, (Object)"pin"));
        Integer posModel = MapUtils.getInteger((Map)map, (Object)"posModel");
        if (null != posModel && posModel > 0) {
            posIDTransactionItem.setPosModel(posModel);
        }
        Date searchTime = DateUtil.stringToDate((String)MapUtils.getString((Map)map, (Object)"searchTime"), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date opTimeBegin = DateUtil.getStartMonthDate((int)DateUtil.getYear((Date)searchTime), (int)(DateUtil.getMonth((Date)searchTime) + 1));
        posIDTransactionItem.setStartDatetimeBegin(DateUtil.dateToString((Date)opTimeBegin, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        posIDTransactionItem.setStartDatetimeEnd(DateUtil.dateToString((Date)searchTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        ZKResultMsg resultMsg = this.posIDApiService.transaction(posIDTransactionItem, MapUtils.getIntValue((Map)map, (Object)"pageStart"), MapUtils.getIntValue((Map)map, (Object)"pageSize"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/transactionDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg transactionDetail(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg resultMsg = this.posIDApiService.transactionDetail(MapUtils.getString((Map)zkMessage.getContent(), (Object)"id"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/getOrderMealSystem"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getOrderMealSystem(@RequestBody ZKMessage zkMessage) {
        PosIDApiOrderMealSystemItem posIDApiOrderMealSystemItem = new PosIDApiOrderMealSystemItem();
        posIDApiOrderMealSystemItem.setOrderMealAdvanceDate(this.posIDSystemParamService.getValByName("posid.orderMealAdvanceDate"));
        posIDApiOrderMealSystemItem.setOrderMealMaxDate(this.posIDSystemParamService.getValByName("posid.orderMealMaxDate"));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)posIDApiOrderMealSystemItem));
    }

    @RequestMapping(value={"/rechargeDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg rechargeDetail(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg resultMsg = this.posIDApiService.rechargeDetail(MapUtils.getString((Map)zkMessage.getContent(), (Object)"outTradeNo"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/diningHall"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg diningHall(@RequestBody ZKMessage zkMessage) {
        List list = this.posIDApiService.diningHallApiList();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)list));
    }

    @RequestMapping(value={"/allowanceLogRecord"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg allowanceLogRecord(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        PosIDAllowanceLogRecordItem posIDAllowanceLogRecordItem = new PosIDAllowanceLogRecordItem();
        posIDAllowanceLogRecordItem.setPersonPin(MapUtils.getString((Map)map, (Object)"personPin"));
        posIDAllowanceLogRecordItem.setMoney(MapUtils.getInteger((Map)map, (Object)"money"));
        posIDAllowanceLogRecordItem.setAllowType(MapUtils.getInteger((Map)map, (Object)"allowType"));
        posIDAllowanceLogRecordItem.setRemark(MapUtils.getString((Map)map, (Object)"remark"));
        ZKResultMsg res = this.posIDApiService.allowanceLogRecord(posIDAllowanceLogRecordItem);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequestMapping(value={"/getOrderProduct"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getOrderProduct(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg resultMsg = this.posIDApiService.getOrderProduct(MapUtils.getString((Map)zkMessage.getContent(), (Object)"diningId"));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/orderProduct"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg orderProduct(@RequestBody ZKMessage zkMessage) {
        try {
            Map map = zkMessage.getContent();
            String rvs = JSONArray.toJSONString(map.get("data"));
            PosIDDeviceReserveItem posIDApiReserveItem = (PosIDDeviceReserveItem)JSONObject.parseObject((String)rvs, (TypeReference)new TypeReference<PosIDDeviceReserveItem>(){}, (Feature[])new Feature[0]);
            posIDApiReserveItem.setPin(MapUtils.getString((Map)map, (Object)"pin"));
            ZKResultMsg resultMsg = this.posIDOrderProductService.orderProduct(posIDApiReserveItem);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        catch (ZKBusinessException e) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)e.getMessage(), (Object[])new Object[0]));
        }
    }

    @RequestMapping(value={"/orderProductDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg orderProductDetail(@RequestBody ZKMessage zkMessage) {
        PosIDOrderProductItem productItem = new PosIDOrderProductItem();
        productItem.setId(MapUtils.getString((Map)zkMessage.getContent(), (Object)"id"));
        ZKResultMsg zkResultMsg = this.posIDOrderProductService.orderProductDetail(productItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/orderProductList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg orderProductList(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        int pageStart = map.get("pageStart") == null ? 0 : MapUtils.getInteger((Map)map, (Object)"pageStart");
        int pageSize = map.get("pageSize") == null ? 10 : MapUtils.getInteger((Map)map, (Object)"pageSize");
        PosIDOrderProductItem condition = new PosIDOrderProductItem();
        condition.setEqlPersonPin(pin);
        Pager pager = this.posIDOrderProductService.getItemsByPage((BaseItem)condition, pageStart, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)pager));
    }

    @RequestMapping(value={"/allowanceApplyDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg allowanceApplyDetail(@RequestBody ZKMessage zkMessage) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.posIDAllowanceLogRecordService.getItemById(MapUtils.getString((Map)zkMessage.getContent(), (Object)"id"))));
    }

    @RequestMapping(value={"/getOrderProductMeal"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getOrderProductMeal(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String orderTime = MapUtils.getString((Map)map, (Object)"orderTime");
        String diningId = MapUtils.getString((Map)map, (Object)"diningId");
        ZKResultMsg resultMsg = this.posIDApiService.getOrderProductMeal(pin, orderTime, diningId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/cancelOrderByMealType"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg cancelOrderByMealType(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg msg;
        try {
            JSONArray jsonArray = JSONObject.parseArray((String)MapUtils.getString((Map)zkMessage.getContent(), (Object)"data"));
            msg = this.posIDApiService.cancelOrderByMealType(jsonArray);
        }
        catch (Exception e) {
            msg = ZKResultMsg.getFailMsg((String)"posid_orderMeal_cancelOrderFail");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    @RequestMapping(value={"/queryProductByCondition"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg queryProductByCondition(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String productName = MapUtils.getString((Map)map, (Object)"productName");
        Integer pageStart = MapUtils.getInteger((Map)map, (Object)"pageStart");
        Integer pageSize = MapUtils.getInteger((Map)map, (Object)"pageSize");
        String diningHallId = MapUtils.getString((Map)map, (Object)"diningId");
        PosIDStoreDetailItem item = new PosIDStoreDetailItem();
        if (StringUtils.isNotEmpty((CharSequence)diningHallId)) {
            item.setDiningHallId(diningHallId);
        }
        item.setName(productName);
        return I18nUtil.i18nMsg((ZKResultMsg)this.posIDApiService.getStoreAndProductByCondition(item, pageStart, pageSize));
    }

    @RequestMapping(value={"/queryRecommendStore"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg queryRecommendStore(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String type = MapUtils.getString((Map)map, (Object)"type");
        return I18nUtil.i18nMsg((ZKResultMsg)this.posIDStoreDetailService.getRecommendStore(Integer.parseInt(type)));
    }

    @RequestMapping(value={"/queryHotStore"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg queryHotStore(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg res = new ZKResultMsg((Object)this.posIDStoreDetailService.getHotDiningHall());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequestMapping(value={"/getOrderStoreList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getOrderStoreList(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String orderTime = MapUtils.getString((Map)map, (Object)"orderTime");
        String diningId = MapUtils.getString((Map)map, (Object)"diningId");
        ZKResultMsg zkResultMsg = new ZKResultMsg((Object)this.posIDApiService.getOrderStoreList(pin, orderTime, diningId));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/getFaceContracts"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg getFaceContracts(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String personPin = MapUtils.getString((Map)map, (Object)"personPin");
        Short contractsType = MapUtils.getShort((Map)map, (Object)"contractsType");
        ZKResultMsg zkResultMsg = this.posIDApiService.getFaceContracts(personPin, contractsType);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/thirdFaceContracts"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg thirdFaceContracts(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg zkResultMsg = this.posIDApiService.thirdFaceContracts(zkMessage.getContent());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/setAliUserId"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg setAliUserId(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String personPin = MapUtils.getString((Map)map, (Object)"personPin");
        String userId = MapUtils.getString((Map)map, (Object)"userId");
        ZKResultMsg resultMsg = this.posIDApiService.setAliUserId(personPin, userId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/setAliSignStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiPermissions(moduleCode="posid", moduleName="posid_module")
    @ResponseBody
    public ZKResultMsg setAliSignStatus(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String type = MapUtils.getString((Map)map, (Object)"type");
        String signStatus = MapUtils.getString((Map)map, (Object)"signStatus");
        String pin = MapUtils.getString((Map)map, (Object)"pin");
        String employeeId = MapUtils.getString((Map)map, (Object)"employeeId");
        ZKResultMsg resultMsg = this.posIDApiService.setAliSignStatus(type, signStatus, pin, employeeId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

