/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiAccountItem;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/account"})
@Api(tags={"PosidAccount"}, description="posid account")
public class PosIDApiAccountController {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @ResponseBody
    @RequestMapping(value={"/getAccount"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Posid Account Detail", notes="Return Posid Account Detail", response=ApiResultMessage.class)
    public ApiResultMessage getAccount(@RequestParam String personPin) {
        PosIDApiAccountItem posIDAccountItem = this.posIDAccountService.getApiAccountByPin(personPin);
        return ApiResultMessage.successMessage((Object)posIDAccountItem);
    }
}

