/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.util.ExportReadUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeRuleItem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PersExportUtil {
    private static final Logger log = LoggerFactory.getLogger(PersExportUtil.class);
    private static int maxCount = 30002;

    public static Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (FileMagic.valueOf((InputStream)inputStream) == FileMagic.OLE2) {
            workbook = new HSSFWorkbook(inputStream);
        } else if (DocumentFactoryHelper.hasOOXMLHeader((InputStream)inputStream)) {
            int len;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
            ByteArrayInputStream processStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ByteArrayInputStream stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ExportReadUtil exportReadUtil = new ExportReadUtil();
            int rowCount = exportReadUtil.processOneSheet(processStream);
            ((InputStream)processStream).close();
            processStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            if (rowCount > maxCount) {
                throw ZKBusinessException.errorException((String)"common_report_maxCount", (Object[])new Object[0]);
            }
            workbook = new XSSFWorkbook((InputStream)stream);
            ((InputStream)stream).close();
            stream = null;
        }
        return workbook;
    }

    public static Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = PersExportUtil.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            if (ex instanceof ZKBusinessException) {
                throw ZKBusinessException.errorException((String)ex.getMessage(), (Object[])new Object[0]);
            }
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        Workbook workbook = PersExportUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet.getLastRowNum() >= maxCount) {
            throw ZKBusinessException.errorException((String)"common_report_maxCount", (Object[])new Object[0]);
        }
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null || f.getType() == Map.class).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        ArrayList<T> list = new ArrayList<T>();
        PersAttributeRuleItem fieldAttr = null;
        HashMap<Integer, PersAttributeRuleItem> fieldAttrs = new HashMap<Integer, PersAttributeRuleItem>();
        HashSet<String> clunms = new HashSet<String>();
        String text = null;
        Field field = null;
        Date date = null;
        Field fieldStr = null;
        DataFormatter formatter = new DataFormatter();
        try {
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                if (rowNum == 1) {
                    int columnIndex = 0;
                    for (Cell cell : row) {
                        columnIndex = cell.getColumnIndex();
                        fieldAttr = (PersAttributeRuleItem)fieldAttrs.get(columnIndex);
                        Cell columnNameCell = columnNames.getCell(columnIndex);
                        if (StringUtils.isEmpty((Object)formatter.formatCellValue(columnNameCell))) {
                            throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_noComment", (Object[])new Object[]{rowNum + 1, columnIndex + 1}));
                        }
                        Comment comment = columnNameCell.getCellComment();
                        if (StringUtils.isEmpty((Object)comment)) {
                            throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_noComment", (Object[])new Object[]{rowNum + 1, columnIndex + 1}));
                        }
                        text = comment.getString().getString();
                        fieldAttr = new PersAttributeRuleItem(text, rowNum, columnIndex);
                        fieldAttrs.put(columnIndex, fieldAttr);
                        if (clunms.add(fieldAttr.getName())) continue;
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_fieldRepeat", (Object[])new Object[]{rowNum + 1, columnIndex + 1, fieldAttr.getName()}));
                    }
                    continue;
                }
                if (rowNum <= 1) continue;
                T t = cls.newInstance();
                HashMap<String, String> attrMap = new HashMap<String, String>();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    if (StringUtils.isEmpty((Object)formatter.formatCellValue(columnNameCell))) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    if (columnNameCell == null) continue;
                    String columnName = formatter.formatCellValue(columnNameCell);
                    fieldAttr = (PersAttributeRuleItem)fieldAttrs.get(cell.getColumnIndex());
                    field = fieldAttr.getName().contains("attrMap") ? fieldList.stream().filter(f -> f.getAnnotation(GridColumn.class) == null && f.getType() == Map.class).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError")) : fieldList.stream().filter(f -> f.getAnnotation(GridColumn.class) != null && columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = PersExportUtil.getDateFormt(dateType);
                        if (cell.getCellType() == CellType.NUMERIC) {
                            if (!(cell.getNumericCellValue() > 0.0)) continue;
                            date = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue());
                            if (date == null) {
                                fieldStr = cls.getDeclaredField(String.valueOf(field.getName()) + "Str");
                                fieldStr.setAccessible(true);
                                fieldStr.set(t, "-1");
                                continue;
                            }
                            field.set(t, date);
                            continue;
                        }
                        if (!StringUtils.isEmpty((Object)formatter.formatCellValue(cell))) {
                            date = DateUtil.stringToDate((String)formatter.formatCellValue(cell), (String)format);
                            if (date == null) {
                                fieldStr = cls.getDeclaredField(String.valueOf(field.getName()) + "Str");
                                fieldStr.setAccessible(true);
                                fieldStr.set(t, "-1");
                                continue;
                            }
                            field.set(t, date);
                            continue;
                        }
                        fieldStr = cls.getDeclaredField(String.valueOf(field.getName()) + "Str");
                        fieldStr.setAccessible(true);
                        fieldStr.set(t, "-2");
                        continue;
                    }
                    if (field.getType() == Map.class) {
                        attrMap.put(fieldAttr.getName(), formatter.formatCellValue(cell).replaceAll("&", ","));
                        field.set(t, ConvertUtils.convert(attrMap, field.getType()));
                        continue;
                    }
                    if (!StringUtils.isEmpty((Object)formatter.formatCellValue(cell))) {
                        field.set(t, ConvertUtils.convert((String)formatter.formatCellValue(cell), field.getType()));
                        continue;
                    }
                    field.set(t, "");
                }
                field = cls.getDeclaredField("rowNum");
                field.setAccessible(true);
                field.set(t, ConvertUtils.convert((Object)(rowNum + 1), Integer.class));
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            log.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static String getDateFormt(DateType dateType) {
        String format;
        block13: {
            format = "yyyy-MM-dd HH:mm:ss";
            if (dateType == null) break block13;
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }

    public static HttpServletResponse excelEncryptZip(String tempPath, ArrayList<File> files, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        ZipFile zipFile = new ZipFile(tempPath, password.toCharArray());
        zipFile.addFiles(files, zipParameters);
        return PersExportUtil.downloadZip(zipFile.getFile(), response);
    }

    public static HttpServletResponse downloadZip(File file, HttpServletResponse response) {
        InputStream fis = null;
        OutputStream toClient = null;
        try {
            int i;
            fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            response.reset();
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
            byte[] buffer = new byte[1024];
            while ((i = fis.read(buffer)) != -1) {
                toClient.write(buffer, 0, i);
            }
            HttpServletResponse httpServletResponse = response;
            return httpServletResponse;
        }
        catch (IOException var9) {
            log.error("exception:", (Throwable)var9);
        }
        finally {
            try {
                fis.close();
                toClient.flush();
                toClient.close();
            }
            catch (IOException e) {
                log.error("exception:", (Throwable)e);
            }
        }
        return null;
    }
}

