/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.web.bean.ExportParameterItem;
import com.zkteco.zkbiosecurity.pers.util.PersExportInfoUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonExportItem;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PersBigExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(PersBigExcelUtil.class);

    public static boolean isBigExport() {
        String count = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.maxExportCount");
        if (!StringUtils.isEmpty((Object)count)) {
            return Integer.parseInt(count) > 30000;
        }
        return false;
    }

    public static void export(List<PersPersonExportItem> data, Class<PersPersonExportItem> cls, String[] attrs, String fileName, OutputStream outputStream) throws Exception {
        long start;
        block14: {
            start = System.currentTimeMillis();
            if (PersBigExcelUtil.isBigExport()) {
                try {
                    try {
                        ExportParameterItem<PersPersonExportItem> params = PersBigExcelUtil.convertToExportParameter(data, cls, fileName, outputStream);
                        PersBigExcelUtil.exportXls(params, attrs);
                        break block14;
                    }
                    catch (Exception var18) {
                        throw new ZKBusinessException("common_op_failed");
                    }
                }
                finally {
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            }
            BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
            try {
                try {
                    HSSFWorkbook workbook = PersBigExcelUtil.generateExcelAndFillData(data, attrs, fileName);
                    workbook.write((OutputStream)ops);
                }
                catch (Exception var20) {
                    throw new ZKBusinessException("common_op_failed");
                }
            }
            finally {
                if (ops != null) {
                    ops.flush();
                    ops.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
        }
        log.info("Export data cost " + (System.currentTimeMillis() - start) + "ms");
    }

    private static void exportXls(ExportParameterItem<PersPersonExportItem> params, String[] attrs) throws Exception {
        PersBigExcelUtil.createHeaderForXls(params, attrs);
        PersBigExcelUtil.createBodyForXls(params, attrs);
        params.getBook().write(params.getOutputStream());
        params.getBook().close();
    }

    private static ExportParameterItem<PersPersonExportItem> convertToExportParameter(List<PersPersonExportItem> data, Class<PersPersonExportItem> cls, String fileName, OutputStream outputStream) {
        ExportParameterItem params = new ExportParameterItem();
        params.setData(data);
        params.setCls(cls);
        params.setTableName(fileName);
        params.setOutputStream(outputStream);
        return params;
    }

    private static void createHeaderForXls(ExportParameterItem<PersPersonExportItem> params, String[] attrs) {
        SXSSFWorkbook book = new SXSSFWorkbook(1000);
        book.setCompressTempFiles(true);
        SXSSFSheet sheet = book.createSheet(params.getTableName());
        CellStyle headStyle = PersBigExcelUtil.getHeadCellStyle((Workbook)book);
        CellStyle dataStyle = PersBigExcelUtil.getDataCellStyle((Workbook)book);
        params.setBook((Workbook)book);
        params.setSheet((Sheet)sheet);
        params.setHeadStyle(headStyle);
        params.setDataStyle(dataStyle);
        int rowNum = 2;
        SXSSFRow titleRow = sheet.createRow(0);
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(params.getTableName().replaceAll("\\+", " "));
        titleCell.setCellStyle(params.getHeadStyle());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, attrs.length - 1));
        SXSSFDrawing drawing = sheet.createDrawingPatriarch();
        CreationHelper factory = book.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(1);
        anchor.setCol2(4);
        anchor.setRow1(2);
        anchor.setRow2(8);
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        SXSSFRow headRow = sheet.createRow(1);
        Map<String, String> commentMap = PersBigExcelUtil.getPersAttributeComment();
        int i = 0;
        while (i < attrs.length) {
            String[] attr = attrs[i].split("-");
            attr[0] = attr[0].replaceAll("\\+", " ");
            Cell cell = PersBigExcelUtil.createCellForXls((Sheet)sheet, (Row)headRow, i, attr[0], params.getDataStyle());
            String commentStr = I18nUtil.i18nCode((String)"pers_export_templateCommentName", (Object[])new Object[]{attr[1]});
            String attrComment = commentMap.get(attr[1]);
            if (!StringUtils.isEmpty((Object)attrComment)) {
                commentStr = String.valueOf(commentStr) + attrComment;
            }
            Comment comment = drawing.createCellComment(anchor);
            RichTextString str = factory.createRichTextString(commentStr);
            comment.setString(str);
            comment.setRow(cell.getRowIndex());
            comment.setColumn(cell.getColumnIndex());
            cell.setCellComment(comment);
            ++i;
        }
        params.setHeadRowNumber(rowNum);
        sheet.createFreezePane(0, rowNum, 0, rowNum);
    }

    private static void createBodyForXls(ExportParameterItem<PersPersonExportItem> params, String[] attrs) throws Exception {
        List data = params.getData();
        Sheet sheet = params.getSheet();
        if (Objects.nonNull(data) && data.size() > 0) {
            int i = 0;
            while (i < data.size()) {
                PersPersonExportItem item = (PersPersonExportItem)data.get(i);
                Row row = sheet.createRow(params.getHeadRowNumber() + i);
                int j = 0;
                while (j < attrs.length) {
                    String param = attrs[j].split("-")[1];
                    String[] paramArray = param.split("\\.");
                    Object paramValue = null;
                    if (paramArray.length < 2) {
                        paramValue = PersExportInfoUtil.getFieldValue(item, param);
                    } else if (item.getAttributeExt() != null) {
                        paramValue = PersExportInfoUtil.getFieldValue(item.getAttributeExt(), paramArray[1]);
                    }
                    String value = paramValue != null ? paramValue.toString().replaceAll(",", "&") : "";
                    PersBigExcelUtil.createCellForXls(sheet, row, j, value, params.getDataStyle());
                    ++j;
                }
                ++i;
            }
        }
    }

    private static CellStyle getHeadCellStyle(Workbook book) {
        CellStyle headStyle = book.createCellStyle();
        Font font = book.createFont();
        font.setFontName("ARIAL");
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        headStyle.setFont(font);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return headStyle;
    }

    private static CellStyle getDataCellStyle(Workbook book) {
        CellStyle dataStyle = book.createCellStyle();
        dataStyle.setBorderBottom(BorderStyle.THIN);
        dataStyle.setBorderLeft(BorderStyle.THIN);
        dataStyle.setBorderTop(BorderStyle.THIN);
        dataStyle.setBorderRight(BorderStyle.THIN);
        dataStyle.setWrapText(true);
        dataStyle.setAlignment(HorizontalAlignment.CENTER);
        dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return dataStyle;
    }

    private static Cell createCellForXls(Sheet sheet, Row row, int colInd, String attr, CellStyle style) {
        Cell cell = row.createCell(colInd);
        sheet.setColumnWidth(colInd, 5400);
        cell.setCellValue(attr);
        cell.setCellStyle(style);
        return cell;
    }

    public static Map<String, String> getPersAttributeComment() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        BaseDictionaryValueService baseDictionaryValueService = (BaseDictionaryValueService)SpringContextUtil.getBean(BaseDictionaryValueService.class);
        List certTypeList = baseDictionaryValueService.getDictionaryValues("certificateType");
        StringBuilder certName = new StringBuilder();
        for (BaseDictionaryValueItem certType : certTypeList) {
            certName.append(certType.getDictValue()).append(",");
        }
        List genderList = baseDictionaryValueService.getDictionaryValues("sex");
        StringBuilder genderStr = new StringBuilder();
        for (BaseDictionaryValueItem gender : genderList) {
            genderStr.append(I18nUtil.i18nCode((String)gender.getDictValue(), (Object[])new Object[0])).append(",");
        }
        map.put("pin", " " + I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]) + "\r\n" + I18nUtil.i18nCode((String)"pers_person_pinFirstValid", (Object[])new Object[0]));
        map.put("deptCode", " " + I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]) + "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        map.put("deptName", "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        map.put("positionCode", "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        map.put("positionName", "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        map.put("certName", "\r\n" + I18nUtil.i18nCode((String)"pers_cert_type", (Object[])new Object[0]) + ":" + certName.substring(0, certName.length() - 1));
        map.put("cardNos", "\r\n" + I18nUtil.i18nCode((String)"pers_import_cardNoStartWithZero", (Object[])new Object[0]));
        map.put("birthday", "\r\n" + I18nUtil.i18nCode((String)"base_datetime_timeFormat", (Object[])new Object[0]) + ":yyyy-MM-dd");
        map.put("certNumber", "\r\n" + I18nUtil.i18nCode((String)"pers_export_certNumberComment", (Object[])new Object[0]));
        map.put("carPlate", "\r\n" + I18nUtil.i18nCode((String)"pers_carNumber_importTip", (Object[])new Object[0]));
        map.put("gender", "\r\n" + I18nUtil.i18nCode((String)"pers_person_gender", (Object[])new Object[0]) + ":" + genderStr.substring(0, genderStr.length() - 1));
        map.put("buildingName", "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        map.put("unitName", "\r\n" + I18nUtil.i18nCode((String)"pers_export_dataExist", (Object[])new Object[0]));
        return map;
    }

    public static HSSFWorkbook generateExcelAndFillData(List<PersPersonExportItem> data, String[] attrs, String fileName) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        sheet.setDefaultColumnWidth(attrs.length);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFCellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        font.setFontHeightInPoints((short)14);
        style.setFont(font);
        style.setWrapText(true);
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue(fileName);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, attrs.length - 1));
        cell.setCellStyle(style);
        row.setHeightInPoints(20.0f);
        row.setHeight((short)540);
        row = sheet.createRow(1);
        row.setHeightInPoints(20.0f);
        row.setHeight((short)540);
        int i = 0;
        while (i < attrs.length) {
            sheet.setColumnWidth(i, 5400);
            cell = row.createCell(i);
            String[] attr = attrs[i].split("-");
            attr[0] = attr[0].replaceAll("\\+", " ");
            cell.setCellValue(attr[0]);
            cell.setCellStyle(style);
            String commentStr = I18nUtil.i18nCode((String)"pers_export_templateCommentName", (Object[])new Object[]{attr[1]});
            Map<String, String> commentMap = PersBigExcelUtil.getPersAttributeComment();
            String attrComment = commentMap.get(attr[1]);
            if (!StringUtils.isEmpty((Object)attrComment)) {
                commentStr = String.valueOf(commentStr) + attrComment;
            }
            HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
            comment.setString((RichTextString)new HSSFRichTextString(commentStr));
            cell.setCellComment((Comment)comment);
            ++i;
        }
        if (Objects.nonNull(data) && data.size() > 0) {
            for (PersPersonExportItem person : data) {
                int lastRowNum = sheet.getLastRowNum();
                row = sheet.createRow(lastRowNum + 1);
                int i2 = 0;
                while (i2 < attrs.length) {
                    cell = row.createCell(i2);
                    String param = attrs[i2].split("-")[1];
                    String[] paramArray = param.split("\\.");
                    Object paramValue = null;
                    if (paramArray.length < 2) {
                        paramValue = PersExportInfoUtil.getFieldValue(person, param);
                    } else if (person.getAttributeExt() != null) {
                        paramValue = PersExportInfoUtil.getFieldValue(person.getAttributeExt(), paramArray[1]);
                    }
                    cell.setCellValue(paramValue != null ? paramValue.toString().replaceAll(",", "&") : "");
                    cell.setCellStyle(style);
                    ++i2;
                }
            }
        }
        return workbook;
    }
}

