/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExportReadUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportReadUtil.class);
    private static StylesTable stylesTable;
    private SheetHandler sheetHandler;

    public int processOneSheet(InputStream inputStream) {
        try {
            OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
            XSSFReader r = new XSSFReader(pkg);
            stylesTable = r.getStylesTable();
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            InputStream sheet2 = r.getSheet("rId1");
            InputSource sheetSource = new InputSource(sheet2);
            parser.parse(sheetSource);
            sheet2.close();
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                log.error(I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]));
            }
            log.error(e.getMessage());
        }
        return this.sheetHandler.getCurRow();
    }

    public void processAllSheets(String filename) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            System.out.println("Processing new sheet:\n");
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
            System.out.println("");
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        SheetHandler handler = this.sheetHandler = new SheetHandler(sst);
        parser.setContentHandler(handler);
        return parser;
    }

    private static class SheetHandler
    extends DefaultHandler {
        private SharedStringsTable sst;
        private String lastContents;
        private boolean nextIsString;
        private List<String> rowlist = new ArrayList<String>();
        private int curRow = 0;
        private int curCol = 0;
        private int rowMaxCount = 30002;

        private SheetHandler(SharedStringsTable sst) {
            this.sst = sst;
        }

        public int getCurRow() {
            return this.curRow;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                String cellType = attributes.getValue("t");
                this.nextIsString = cellType != null && cellType.equals("s");
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.nextIsString) {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                this.nextIsString = false;
            }
            if (name.equals("row")) {
                ++this.curRow;
                if (this.curRow >= this.rowMaxCount) {
                    throw ZKBusinessException.errorException((String)"common_report_maxCount", (Object[])new Object[0]);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.lastContents = String.valueOf(this.lastContents) + new String(ch, start, length);
        }

        static enum CellDataType {
            BOOL,
            ERROR,
            FORMULA,
            INLINESTR,
            SSTINDEX,
            NUMBER,
            DATE,
            NULL;

        }
    }
}

