/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersUserTypeRemote;
import com.zkteco.zkbiosecurity.pers.service.PersUserTypeService;
import com.zkteco.zkbiosecurity.pers.util.PersExportTemplateUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersUserTypeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersUserTypeController
extends ExportController
implements PersUserTypeRemote {
    @Autowired
    private PersUserTypeService persUserTypeService;
    @Autowired
    private PersExportTemplateUtil persExportTemplateUtil;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:userType"})
    public ModelAndView index() {
        return new ModelAndView("pers/userType/persUserType");
    }

    @RequiresPermissions(value={"pers:userType:refresh"})
    public DxGrid list(PersUserTypeItem condition) {
        Pager pager = this.persUserTypeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PersUserTypeItem item = this.persUserTypeService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("pers/userType/editPersUserType");
    }

    @RequiresPermissions(value={"pers:userType:edit", "pers:userType:add"})
    public ZKResultMsg save(PersUserTypeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persUserTypeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:userType:del"})
    public ZKResultMsg del(String ids) {
        this.persUserTypeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(String userTypeCode) {
        return String.valueOf(this.persUserTypeService.getItemByUserTypeCode(userTypeCode) == null);
    }

    public void export(HttpServletRequest req, HttpServletResponse resp) {
        PersUserTypeItem persUserTypeItem = new PersUserTypeItem();
        this.setConditionValue((BaseItem)persUserTypeItem);
        List list = this.persUserTypeService.getPersUserTypeItemData(PersUserTypeItem.class, (BaseItem)persUserTypeItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(list, PersUserTypeItem.class);
    }

    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "userTypeCode": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "userTypeName": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                }
            }
        }
        this.persExportTemplateUtil.templateExport(request, response, commentMap);
    }

    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersUserTypeItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persUserTypeService.importExcel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PersPosition Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public TreeItem tree() {
        List demoUserTYpeItems = this.persUserTypeService.getByCondition(new PersUserTypeItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (PersUserTypeItem userType : demoUserTYpeItems) {
            item = new TreeItem();
            item.setId(userType.getId());
            item.setText(userType.getUserTypeName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg userTypeTree() {
        List userTypeItems = this.persUserTypeService.getByCondition(new PersUserTypeItem());
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (PersUserTypeItem userTypeItem : userTypeItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(userTypeItem.getUserTypeName());
            selectItem.setText((Object)userTypeItem.getUserTypeName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public String isNameExist(String userTypeName) {
        return String.valueOf(this.persUserTypeService.getItemByUserTypeName(userTypeName) == null);
    }
}

