/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersTrainerPlanRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersTrainerPlanService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTrainerPlanItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersTrainerPlanController
extends ExportController
implements PersTrainerPlanRemote {
    @Autowired
    private PersTrainerPlanService persTrainerPlanService;
    @Autowired
    private PersPersonService persPersonService;

    @RequiresPermissions(value={"pers:trainerPlan"})
    public ModelAndView index() {
        return new ModelAndView("pers/trainerPlan/persTrainerPlan");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PersTrainerPlanItem item = this.persTrainerPlanService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("pers/trainerPlan/editPersTrainerPlan");
    }

    public DxGrid list(PersTrainerPlanItem condition) {
        Pager pager = this.persTrainerPlanService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save(PersTrainerPlanItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persTrainerPlanService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg del(String ids) {
        this.persTrainerPlanService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public void export(HttpServletRequest req, HttpServletResponse resp) {
        PersTrainerPlanItem persTrainerPlanItem = new PersTrainerPlanItem();
        this.setConditionValue((BaseItem)persTrainerPlanItem);
        List list = this.persTrainerPlanService.getPersTrainerPlanItemData(PersTrainerPlanItem.class, (BaseItem)persTrainerPlanItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(list, PersTrainerPlanItem.class);
    }

    public ZKResultMsg getAllPlansBasedOnTrainer() {
        String persTrainerId = this.request.getParameter("trainerId");
        PersTrainerPlanItem condition = new PersTrainerPlanItem();
        List byCondition = this.persTrainerPlanService.getByCondition(condition.setPersTrainerId(persTrainerId));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)byCondition));
    }

    public String isNameExist(String name) {
        return String.valueOf(this.persTrainerPlanService.getItemByName(name) == null);
    }

    public ZKResultMsg getSlots() {
        String trainerPlan = this.request.getParameter("trainerPlan");
        PersTrainerPlanItem itemByName = this.persTrainerPlanService.getItemByName(trainerPlan);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)itemByName.getSlots()));
    }

    public ZKResultMsg getAllTrainers() {
        PersPersonItem condition = new PersPersonItem();
        List persTrainerItems = this.persPersonService.getByCondition(condition.setUserTypeName("Trainer"));
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (PersPersonItem persTrainerItem : persTrainerItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(persTrainerItem.getId());
            selectItem.setText((Object)persTrainerItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

