/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersTempRegRemote;
import com.zkteco.zkbiosecurity.pers.service.PerTempRegService;
import com.zkteco.zkbiosecurity.pers.service.Pers2OtherService;
import com.zkteco.zkbiosecurity.pers.service.PersMembershipService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersTempPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersTrainerPlanService;
import com.zkteco.zkbiosecurity.pers.service.PersUserTypeService;
import com.zkteco.zkbiosecurity.pers.vo.PerTempRegItem;
import com.zkteco.zkbiosecurity.pers.vo.PersMembershipItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTrainerPlanItem;
import com.zkteco.zkbiosecurity.pers.vo.PersUserTypeItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersTempRegController
extends BaseController
implements PersTempRegRemote {
    @Value(value="${system.language}")
    private String sysLanguage;
    @Autowired
    private PerTempRegService perRegSerice;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersUserTypeService persUserTypeService;
    @Autowired
    private PersMembershipService persMembershipService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private Pers2OtherService pers2OtherService;
    @Autowired
    PersTempPersonService persTempPersonService;
    @Autowired
    private PersTrainerPlanService persTrainerPlanService;

    public ZKResultMsg registrarLogin(@RequestBody PerTempRegItem item) {
        item.setPhone(item.getPhone().replaceAll("/[^\\d-]/g", ""));
        ZKResultMsg retMsg = new ZKResultMsg();
        if (item.getUserType().equalsIgnoreCase("Staff")) {
            item.setStartTime("");
        }
        this.perRegSerice.perReg(item);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView regView() {
        String selfRegistration = this.persParamsService.getValByName("pers.selfRegistration");
        if ("0".equals(selfRegistration)) {
            return new ModelAndView("404");
        }
        String pinLen = this.persParamsService.getValByName("pers.pinLen");
        String pinSupportLetter = this.persParamsService.getValByName("pers.pinSupportLetter");
        ModelAndView mv = new ModelAndView("pers/tempPerson/persTempReg");
        Date d = new Date();
        String userId = this.request.getParameter("userId");
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            PersPersonItem itemByPin = this.persPersonService.getItemById(userId);
            if (itemByPin != null) {
                mv.addObject("pin", (Object)itemByPin.getPin());
                mv.addObject("fromPersonPage", (Object)"Yes");
                itemByPin = this.persPersonService.getItemById(userId);
                PersPersonItem itemById = this.persPersonService.getItemById(itemByPin.getId());
                if (StringUtils.isNotBlank((CharSequence)itemById.getMembershipId())) {
                    PersMembershipItem membershipItem = this.persMembershipService.getItemById(itemById.getMembershipId());
                    String accTime = this.pers2OtherService.getAccStartAndEndTime(itemByPin.getId());
                    if (StringUtils.isNotBlank((CharSequence)accTime)) {
                        String[] time = accTime.split("&");
                        mv.addObject("membershipPlan", (Object)membershipItem.getMembershipPlan());
                        mv.addObject("startTime", (Object)time[0].substring(0, 19));
                        mv.addObject("endTime", (Object)time[1].substring(0, 19));
                    }
                } else {
                    mv.addObject("startTime", (Object)DateUtil.dateToString((Date)DateUtil.getDayBeginTime((Date)d), (String)"yyyy-MM-dd HH:mm:ss"));
                    mv.addObject("endTime", (Object)DateUtil.dateToString((Date)DateUtil.getDayEndTime((Date)d), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtils.isNotBlank((CharSequence)itemById.getUserTypeName())) {
                    mv.addObject("userType", (Object)itemById.getUserTypeName());
                }
                if (itemById != null) {
                    mv.addObject("name", (Object)itemById.getName());
                    mv.addObject("lastName", (Object)itemById.getLastName());
                    mv.addObject("email", (Object)itemById.getEmail());
                    mv.addObject("locality", (Object)itemById.getLocality());
                    mv.addObject("phone", (Object)itemById.getMobilePhone());
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemById.getGender()}) && itemById.getGender().equals("F")) {
                        mv.addObject("gender", (Object)I18nUtil.i18nCode((String)"pers_person_female", (Object[])new Object[0]));
                    } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemById.getGender()}) && itemById.getGender().equals("M")) {
                        mv.addObject("gender", (Object)I18nUtil.i18nCode((String)"pers_person_male", (Object[])new Object[0]));
                    } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemById.getGender()}) && itemById.getGender().equals("U")) {
                        mv.addObject("gender", (Object)I18nUtil.i18nCode((String)"common_unknown", (Object[])new Object[0]));
                    }
                    mv.addObject("amount", (Object)itemById.getAmount());
                    mv.addObject("finalAmount", (Object)itemById.getFinalAmount());
                    mv.addObject("discountAmount", (Object)itemById.getDiscountAmount());
                    mv.addObject("joinDateAndTime", (Object)DateUtil.dateToString((Date)itemById.getJoinDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    mv.addObject("certJpg", (Object)itemById.getCertJpgPath());
                    mv.addObject("experienceYears", (Object)itemById.getExperienceYears());
                    mv.addObject("experienceMonths", (Object)itemById.getExperienceMonths());
                }
            } else {
                mv = new ModelAndView("404");
            }
        } else {
            List persPersons;
            List persUserTypeItemList = this.persUserTypeService.getByCondition(new PersUserTypeItem());
            StringBuffer userType = new StringBuffer();
            persUserTypeItemList.forEach(v -> {
                StringBuffer stringBuffer2 = userType.append(v.getUserTypeName()).append(",");
            });
            List persMembershipItemList = this.persMembershipService.getByCondition(new PersMembershipItem());
            StringBuffer membershipPlan = new StringBuffer();
            persMembershipItemList.forEach(v -> {
                StringBuffer stringBuffer2 = membershipPlan.append(String.valueOf(v.getId()) + " : " + v.getMembershipPlan() + " - " + v.getMembershipAmount() + " = " + v.getMembershipCode()).append(",");
            });
            mv.addObject("userType", (Object)userType.deleteCharAt(userType.length() - 1));
            if (membershipPlan.length() != 0) {
                mv.addObject("membershipPlan", (Object)membershipPlan.deleteCharAt(membershipPlan.length() - 1));
            }
            mv.addObject("joinDateAndTime", (Object)DateUtil.dateToString((Date)d, (String)"yyyy-MM-dd HH:mm:ss"));
            StringJoiner trainerDetails = new StringJoiner(",");
            StringJoiner trainerPlanDetails = new StringJoiner(",");
            HashMap<String, String> personTrainerPlan = new HashMap<String, String>();
            PersUserTypeItem persUserTypeItem = this.persUserTypeService.getItemByUserTypeName("Trainer");
            if (persUserTypeItem != null && StringUtils.isNotBlank((CharSequence)persUserTypeItem.getId()) && !CollectionUtils.isEmpty((Collection)(persPersons = this.persPersonService.getItemsByUserTypeId(persUserTypeItem.getId())))) {
                List trainerIds = persPersons.stream().filter(p -> p != null && StringUtils.isNotBlank((CharSequence)p.getId())).map(PersPersonItem::getId).collect(Collectors.toList());
                List allTrainerPlans = this.persTrainerPlanService.getItemsByPersTrainerIds(trainerIds);
                Map<String, List<PersTrainerPlanItem>> plansByTrainerId = allTrainerPlans.stream().filter(Objects::nonNull).filter(plan -> StringUtils.isNotBlank((CharSequence)plan.getPersTrainerId())).collect(Collectors.groupingBy(PersTrainerPlanItem::getPersTrainerId));
                for (PersPersonItem pers : persPersons) {
                    if (pers == null || !StringUtils.isNotBlank((CharSequence)pers.getId()) || !StringUtils.isNotBlank((CharSequence)pers.getName())) continue;
                    trainerDetails.add(String.valueOf(pers.getId()) + " : " + pers.getName());
                    List plans = plansByTrainerId.getOrDefault(pers.getId(), Collections.emptyList());
                    for (PersTrainerPlanItem plan2 : plans) {
                        if (plan2 == null || !StringUtils.isNotBlank((CharSequence)plan2.getName())) continue;
                        trainerPlanDetails.add(String.valueOf(plan2.getPersTrainerId()) + " : " + plan2.getName());
                    }
                }
                personTrainerPlan.put("trainerDetailsData", trainerDetails.toString());
                personTrainerPlan.put("trainerPlan", trainerPlanDetails.toString());
            }
            if (!personTrainerPlan.isEmpty()) {
                personTrainerPlan.forEach((arg_0, arg_1) -> ((ModelAndView)mv).addObject(arg_0, arg_1));
            }
        }
        mv.addObject("language", (Object)this.sysLanguage);
        mv.addObject("pinLen", (Object)pinLen);
        mv.addObject("pinSupportLetter", (Object)pinSupportLetter);
        return mv;
    }

    protected String getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(name)) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public ModelAndView endPersTempReservation() {
        return new ModelAndView("pers/tempPerson/persTempSuccessReg");
    }
}

