/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersPersonnalListRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonPersonnalListSelectItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnalListItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnallistPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPersonnalListController
extends BaseController
implements PersPersonnalListRemote {
    @Autowired
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:personnallist"})
    public ModelAndView index() {
        return new ModelAndView("pers/personnallist/persPersonnalList");
    }

    @RequiresPermissions(value={"pers:personnallist:edit", "pers:personnallist:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.persPersonnalListService.getItemById(id));
        }
        return new ModelAndView("pers/personnallist/editPersPersonnalList");
    }

    @RequiresPermissions(value={"pers:personnallist:edit", "pers:personnallist:add"})
    public ZKResultMsg save(PersPersonnalListItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persPersonnalListService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:personnallist:refresh"})
    public DxGrid list(PersPersonnalListItem codition) {
        codition.setTypeNot("5");
        Pager pager = this.persPersonnalListService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List list = pager.getData();
        Map allPersonnelListCount = this.persPersonnalListService.getPersonCountByAuthUserFilter(this.request.getSession().getId());
        list.stream().forEach(item -> {
            String count = (String)allPersonnelListCount.get(item.getId());
            if (StringUtils.isBlank((CharSequence)count)) {
                item.setPersonCount("0");
            } else {
                item.setPersonCount(count);
            }
        });
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pers:personnallist:del"})
    public ZKResultMsg delete(String ids) {
        return this.persPersonnalListService.delByIds(ids);
    }

    public ZKResultMsg getPersonList(String id) {
        return new ZKResultMsg((Object)this.persPersonnalListService.getPersonIdsById(id));
    }

    @RequiresPermissions(value={"pers:personnallist:refreshPerson"})
    public DxGrid getPersonneList(PersPersonnallistPersonItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.persPersonnalListService.getPersonPager(sessionId, condition, this.getPageNo(), this.getPageSize());
        this.persPersonnalListService.protectPin(pager.getData());
        return GridUtil.convert((Pager)pager, PersPersonnallistPersonItem.class);
    }

    @RequiresPermissions(value={"pers:personnallist:addPerson"})
    public ZKResultMsg addPerson(String personnelListId, String personIds) {
        String clientId = this.request.getParameter("clientId");
        String deptIds = this.request.getParameter("deptIds");
        String checkVal = this.request.getParameter("checkVal");
        if ("2".equals(checkVal) && StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = "";
        } else {
            deptIds = "";
        }
        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
        ZKResultMsg zkResultMsg = this.persPersonnalListService.addPerson(personnelListId, personIds, deptIds);
        this.progressCache.setProcess(new ProcessBean(99, 99), clientId);
        this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectPersonlist(PersPersonPersonnalListSelectItem codition) {
        Pager pager = new Pager();
        if (codition.getType().equals("noSelected")) {
            pager = this.persPersonnalListService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (codition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pers:personnallist:delPerson"})
    public ZKResultMsg delPerson(String personnallistId, String ids) {
        return this.persPersonnalListService.deletePerson(personnallistId, ids);
    }

    public Boolean verifyName(String name) {
        return this.persPersonnalListService.getItemByName(name) == null;
    }

    public ZKResultMsg getPersonnalListSelectData() {
        return new ZKResultMsg((Object)this.persPersonnalListService.getPersonnalListSelectData());
    }
}

