/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.constants.BaseConstants;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileType;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.constants.PersConstants;
import com.zkteco.zkbiosecurity.pers.remote.PersPersonRemote;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeExtService;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeService;
import com.zkteco.zkbiosecurity.pers.service.PersBioPhotoService;
import com.zkteco.zkbiosecurity.pers.service.PersBioTemplateService;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.service.PersCertificateService;
import com.zkteco.zkbiosecurity.pers.service.PersLeavePersonService;
import com.zkteco.zkbiosecurity.pers.service.PersMeasurementsService;
import com.zkteco.zkbiosecurity.pers.service.PersMembershipRenewalService;
import com.zkteco.zkbiosecurity.pers.service.PersMembershipService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPaymentHistoryReportService;
import com.zkteco.zkbiosecurity.pers.service.PersPaymentReportService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.service.PersTrainerPlanService;
import com.zkteco.zkbiosecurity.pers.service.PersUserTypeService;
import com.zkteco.zkbiosecurity.pers.util.PersBigExcelUtil;
import com.zkteco.zkbiosecurity.pers.util.PersExportInfoUtil;
import com.zkteco.zkbiosecurity.pers.util.PersExportTemplateUtil;
import com.zkteco.zkbiosecurity.pers.util.PersExportUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeExtItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeRuleItem;
import com.zkteco.zkbiosecurity.pers.vo.PersBioPhotoItem;
import com.zkteco.zkbiosecurity.pers.vo.PersCertificateItem;
import com.zkteco.zkbiosecurity.pers.vo.PersImportPhotoItem;
import com.zkteco.zkbiosecurity.pers.vo.PersLeavePersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersMeasurementsItem;
import com.zkteco.zkbiosecurity.pers.vo.PersMembershipRenewalItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPaymentHistoryReportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPaymentReportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonExportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonImportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonPinItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTrainerPlanItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTrainerPlanViewItem;
import com.zkteco.zkbiosecurity.pers.vo.PersUserTypeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseMailService;
import com.zkteco.zkbiosecurity.system.service.BaseSendMailService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPersonController
extends ExportController
implements PersPersonRemote {
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersLeavePersonService persLeavePersonService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersCertificateService persCertificateService;
    @Autowired
    private PersAttributeService persAttributeService;
    @Autowired
    private PersAttributeExtService persAttributeExtService;
    @Autowired
    private PersBioTemplateService persBioTemplateService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PersExportTemplateUtil persExportTemplateUtil;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private PersBioPhotoService persBioPhotoService;
    @Autowired
    private PersCardService persCardService;
    @Autowired
    private PersPaymentHistoryReportService persPaymentHistoryReportService;
    @Autowired
    private PersMembershipService persMembershipService;
    @Autowired
    private PersUserTypeService persUserTypeService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseMailService baseMailService;
    @Autowired
    private BaseSendMailService baseSendMailService;
    @Autowired
    private PersMeasurementsService persMeasurementsService;
    @Autowired
    private PersPaymentReportService persPaymentReportService;
    @Autowired
    private PersMembershipRenewalService persMembershipRenewalService;
    @Autowired
    private PersTrainerPlanService persTrainerPlanService;

    @RequiresPermissions(value={"pers:person"})
    public ModelAndView index() {
        return new ModelAndView("pers/person/persPerson");
    }

    @RequiresPermissions(value={"pers:person:edit", "pers:person:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id, @RequestParam(value="leaveId", required=false) String leaveId, @RequestParam(value="deptId", required=false) String deptId, @RequestParam(value="cardNo", required=false) String cardNo) {
        PersPersonItem item;
        String bioTemplateJson = "";
        BeanMap attr = null;
        Map persParams = this.persParamsService.getPersParams();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List persBioPhotoItemList;
            String photoBase64;
            String thumbPath;
            item = this.persPersonService.getItemById(id);
            if (Objects.isNull(item)) {
                throw new ZKBusinessException("common_prompt_exception_datanoexists");
            }
            String mobilePhone = item.getMobilePhone();
            if (!"zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)mobilePhone) && mobilePhone.split("-").length > 1) {
                item.setAreaCode(mobilePhone.split("-")[0]);
                item.setMobilePhone(mobilePhone.split("-")[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)item.getPhotoPath())) {
                thumbPath = FileUtil.getThumbPath((String)item.getPhotoPath());
                if (FileUtil.fileExists((String)thumbPath)) {
                    item.setThumbPhotoPath(thumbPath);
                    photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setPhotoBase64("data:image/jpg;base64," + photoBase64);
                } else {
                    photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setPhotoBase64("data:image/jpg;base64," + photoBase64);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item.getCertJpgPath())) {
                thumbPath = FileUtil.getThumbPath((String)item.getCertJpgPath());
                if (FileUtil.fileExists((String)thumbPath)) {
                    photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setCertJpgBase64("data:image/jpg;base64," + photoBase64);
                } else {
                    photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setCertJpgBase64("data:image/jpg;base64," + photoBase64);
                }
            }
            if (!(persBioPhotoItemList = this.persBioPhotoService.findByPersonIdIn(StrUtil.strToList((String)id))).isEmpty()) {
                PersBioPhotoItem bioPhotoItem = (PersBioPhotoItem)persBioPhotoItemList.get(0);
                String cropPhotoBase64 = FileEncryptUtil.getDecryptFileBase64((String)bioPhotoItem.getPhotoPath());
                item.setCropPhotoBase64(cropPhotoBase64);
            }
            this.request.setAttribute("item", (Object)item);
            if (StringUtils.isNotBlank((CharSequence)item.getExperienceYears())) {
                this.request.setAttribute("item.experienceYears", (Object)item.getExperienceYears());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getExperienceMonths())) {
                this.request.setAttribute("item.experienceMonths", (Object)item.getExperienceMonths());
            }
            this.request.setAttribute("certJpg", (Object)item.getCertJpgPath());
            this.request.setAttribute("certificate", (Object)this.persCertificateService.getItemByPersonId(id));
            this.request.setAttribute("cardItems", (Object)this.persCardService.getAllCardByPersonIdList((Collection)StrUtil.strToList((String)id)));
            PersAttributeExtItem extItem = this.persAttributeExtService.getItemByPersonId(id);
            if (Objects.nonNull(extItem)) {
                attr = BeanMap.create((Object)extItem);
            }
            bioTemplateJson = JSON.toJSONString((Object)this.persBioTemplateService.getItemMapByPersonId(id));
        } else if (StringUtils.isNotBlank((CharSequence)leaveId)) {
            PersLeavePersonItem leaveItem = this.persLeavePersonService.getItemById(leaveId);
            if (Objects.isNull(leaveItem)) {
                throw new ZKBusinessException("common_prompt_exception_datanoexists");
            }
            PersPersonItem item2 = new PersPersonItem();
            BeanUtils.copyProperties((Object)leaveItem, (Object)item2, (String[])new String[]{"id"});
            this.request.setAttribute("item", (Object)item2);
            this.request.setAttribute("attGroupId", (Object)leaveItem.getAttGroupId());
            this.request.setAttribute("isAttendance", (Object)leaveItem.getIsAttendance());
            this.request.setAttribute("leaveId", (Object)leaveId);
        } else if ("false".equals(persParams.get("pers.pinSupportLetter")) && "true".equals(persParams.get("pers.pinSupportIncrement"))) {
            this.request.setAttribute("defPin", (Object)this.persPersonService.getIncPoint());
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            item = new PersPersonItem();
            Date d = new Date();
            this.request.setAttribute("item", (Object)item);
            PersUserTypeItem userTypeItem = this.persUserTypeService.getItemByUserTypeName("Staff");
            this.request.setAttribute("staff", (Object)userTypeItem.getId());
        }
        List attributes = this.persAttributeService.getByCondition(new PersAttributeItem());
        for (PersPersonItem item2 : attributes) {
            String attrName = I18nUtil.i18nCode((String)("pers_attr_" + item2.getAttrName()), (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)attrName) && !attrName.contains("pers_attr_")) {
                item2.setShowName(attrName);
            }
            if (!Objects.nonNull(attr)) continue;
            item2.setVal(MapUtils.getString(attr, (Object)("attrValue" + item2.getFiledIndex()), (String)""));
        }
        this.request.setAttribute("attributes", (Object)attributes);
        this.request.setAttribute("persParams", (Object)persParams);
        this.request.setAttribute("treeDeptId", (Object)deptId);
        this.request.setAttribute("treeDeptName", (Object)this.request.getParameter("deptName"));
        this.request.setAttribute("cardNo", (Object)cardNo);
        this.request.setAttribute("bioTemplateJson", (Object)bioTemplateJson);
        if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
            return new ModelAndView("pers/person/editPersPersonZH");
        }
        this.request.setAttribute("showSMS", (Object)this.persPersonService.checkShowSMS());
        this.request.setAttribute("showWhatsapp", (Object)this.persPersonService.checkShowWhatsapp());
        String baseUrl = this.baseSysParamService.getValByName("pers.tempPerson.urlCreate");
        this.request.setAttribute("baseUrl", (Object)baseUrl);
        return new ModelAndView("pers/person/editPersPerson");
    }

    @RequiresPermissions(value={"pers:person:edit", "pers:person:add"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_op_edit", requestParams={"pin", "name", "lastName"}, opContent="pers_person_pin")
    public ZKResultMsg save(PersPersonItem item, PersCertificateItem certificate, PersAttributeExtItem attributeExt, @RequestParam Map<String, String> extParams, @RequestParam(value="personPhoto", required=false) MultipartFile file, @RequestParam(value="certJpg", required=false) MultipartFile certJpg) {
        String photoPath;
        if (StringUtils.isBlank((CharSequence)item.getId()) && !this.persPersonService.persLicenseCheck()) {
            throw ZKBusinessException.warnException((String)"common_license_maxCount", (Object[])new Object[0]);
        }
        if (!(StringUtils.isBlank((CharSequence)item.getId()) || item.getEnabledCredential() != null && item.getEnabledCredential().booleanValue())) {
            throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"pers_person_disabledNotOp", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        ZKResultMsg res = new ZKResultMsg();
        certificate.setId(null);
        attributeExt.setId(null);
        if (Objects.nonNull(file) && !file.isEmpty()) {
            photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(String.valueOf(item.getPin()) + ".jpg"), (MultipartFile)file);
            item.setPhotoPath(photoPath);
        } else if (StringUtils.isNotBlank((CharSequence)extParams.get("personIdPhoto"))) {
            photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(String.valueOf(item.getPin()) + ".jpg"), (String)extParams.get("personIdPhoto"));
            item.setPhotoPath(photoPath);
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCropPhotoBase64())) {
            String cropPhotoPath = FileUtil.saveCropFaceToServer((String)item.getPin(), (String)(String.valueOf(item.getPin()) + ".jpg"), (String)item.getCropPhotoBase64());
            item.setCropPhotoPath(cropPhotoPath);
        } else if (item.getCropPhotoDel().booleanValue()) {
            item.setCropPhotoPath("");
        } else {
            item.setCropPhotoPath(null);
            if (StringUtils.isNotBlank((CharSequence)item.getPhotoPath())) {
                item.setCropPhotoBase64("");
            }
        }
        if (Objects.nonNull(certJpg) && !certJpg.isEmpty()) {
            String certPhotoPath = FileUtil.saveFileToServer((String)"pers", (String)"TrainerCertificate/Jpg", (String)(String.valueOf(item.getPin()) + ".jpg"), (MultipartFile)certJpg);
            item.setCertJpgPath(certPhotoPath);
        }
        if (StringUtils.isNotBlank((CharSequence)item.getExperienceYears()) || StringUtils.isNotBlank((CharSequence)item.getExperienceMonths())) {
            String years = StringUtils.isNotBlank((CharSequence)item.getExperienceYears()) ? item.getExperienceYears() : "0";
            String months = StringUtils.isNotBlank((CharSequence)item.getExperienceMonths()) ? item.getExperienceMonths() : "0";
            item.setExperience(String.valueOf(years) + ":" + months);
        }
        if (StringUtils.isBlank((CharSequence)item.getId())) {
            item.setIsFrom("PERS_USER_MANUALLY_ADDED");
        }
        String sessionId = this.request.getSession().getId();
        extParams.put("sessionId", sessionId);
        String email = extParams.get("mail");
        item.setEmail(email);
        this.persPersonService.saveItem(item, certificate, attributeExt, extParams);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:person:del"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_op_del", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:person"})
    public DxGrid list(PersPersonItem condition) {
        condition.setPersonType(Short.valueOf((short)0));
        Pager pager = this.persPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        List data = pager.getData();
        for (PersPersonItem persPersonItem : data) {
            if (!StringUtils.isNotBlank((CharSequence)persPersonItem.getExperience())) continue;
            String[] split = persPersonItem.getExperience().split(":");
            persPersonItem.setExperience(String.valueOf(split[0]) + "Years" + " " + split[1] + "Months");
        }
        this.persPersonService.protectPinAndCard(pager.getData());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public String checkPwd(@RequestParam(value="personId") String personId, @RequestParam(value="personPwd") String personPwd) {
        PersPersonItem item = new PersPersonItem(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            item.setNotInId(personId);
        }
        if (StringUtils.isNotBlank((CharSequence)personPwd)) {
            item.setPersonPwd(personPwd);
        }
        boolean persPersonflag = false;
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            persPersonflag = !this.persPersonService.checkPwd(personId, personPwd);
        } else {
            boolean bl = persPersonflag = !this.persPersonService.ckeckPwd(personPwd);
        }
        if (persPersonflag) {
            persPersonflag = !this.persPersonService.checkForcePwd(personPwd);
        }
        return String.valueOf(persPersonflag);
    }

    public String isExist(@RequestParam(value="pin") String pin) {
        boolean isExist = true;
        if (!this.persPersonService.isExistPin(pin).booleanValue()) {
            PersLeavePersonItem leaveItem;
            String pinRetain = this.persParamsService.getValByName("pers.pinRetain");
            if (StringUtils.isBlank((CharSequence)this.request.getParameter("leavePersonId")) && "true".equals(pinRetain) && (leaveItem = this.persLeavePersonService.getItemByPin(pin)) != null) {
                isExist = false;
            }
        } else {
            isExist = false;
        }
        return String.valueOf(isExist);
    }

    public ZKResultMsg dataCount() {
        String deptIds = this.request.getParameter("deptIds");
        Map mapCount = this.persPersonService.dataCountByDeptIdAndAuthUserFilter(this.request.getSession().getId(), deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)mapCount));
    }

    public ModelAndView batch(@RequestParam(value="ids") String ids, @RequestParam(value="type") String type) {
        StringBuffer pinStrBuf = new StringBuffer();
        String[] idsArr = ids.split(",");
        int i = 0;
        while (i < idsArr.length) {
            PersPersonItem tempPerson = this.persPersonService.getItemById(idsArr[i]);
            if (i != idsArr.length - 1) {
                pinStrBuf.append(String.valueOf(tempPerson.getPin()) + ";");
            } else {
                pinStrBuf.append(tempPerson.getPin());
            }
            ++i;
        }
        this.request.setAttribute("selectedPerson", (Object)pinStrBuf.toString());
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("pers/person/" + type);
    }

    @RequiresPermissions(value={"pers:person:batchPositionChange"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_position_change", requestParams={"pins", "positionName", "changeReason"}, opContent="pers_person_pin")
    public ZKResultMsg batchPositionChange(@RequestParam(value="ids") String ids, @RequestParam(value="positionId") String positionId, @RequestParam(value="changeReason") String changeReason) {
        this.persPersonService.batchPositionChange(ids, positionId, changeReason);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:person:deptChange"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_departmentChange", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg batchDeptChange(@RequestParam(value="ids") String ids, @RequestParam(value="deptId") String deptId, @RequestParam(value="changeReason") String changeReason, @RequestParam(value="flag") boolean flag) {
        this.persPersonService.batchDeptChange(ids, deptId, changeReason, flag);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String checkCertNumber(@RequestParam(value="certNumber") String certNumber, @RequestParam(value="personId", required=false) String personId, @RequestParam(value="certType") String certType) {
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)certNumber)) {
            flag = this.persCertificateService.isExistByCertNumberAndCertTypeAndPersonIdNe(certNumber, certType, personId);
        }
        return String.valueOf(flag);
    }

    public String checkMailParam() {
        return String.valueOf(this.persPersonService.checkMailParam());
    }

    public String checkEmailIsExist(String personId, String email) {
        PersPersonItem persPersonItem = new PersPersonItem();
        persPersonItem.setEmail(email);
        List byCondition = this.persPersonService.getByCondition(persPersonItem);
        for (PersPersonItem item : byCondition) {
            if (personId.equals(item.getId())) continue;
            return "false";
        }
        return "true";
    }

    @RequiresPermissions(value={"pers:person:import"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personInfo", requestParams={}, opContent="pers_import_personInfo")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List<PersPersonImportItem> itemList = PersExportUtil.excelImport(upload.getInputStream(), PersPersonImportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.importPersonInfo(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"pers:person:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String sortName = request.getParameter("sortName");
        String sortOrder = request.getParameter("sortOrder");
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.persPersonService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        PersPersonItem persPersonItem = new PersPersonItem();
        this.setConditionValue((BaseItem)persPersonItem);
        persPersonItem.setPersonType(Short.valueOf((short)0));
        if (StringUtils.isNotBlank((CharSequence)sortName) && StringUtils.isNotBlank((CharSequence)sortOrder)) {
            persPersonItem.setSortName(sortName);
            persPersonItem.setSortOrder(sortOrder);
        }
        String[] attrs = request.getParameterValues("attrs");
        String reportType = request.getParameter("reportType");
        this.persPersonService.buildCondition(request.getSession().getId(), persPersonItem);
        persPersonItem.setUserTypeName("Staff");
        List itemList = this.persPersonService.getItemData(PersPersonItem.class, persPersonItem, this.getBeginIndex(), this.getEndIndex());
        List persPersonExportItemList = this.persPersonService.analyzeExportData(itemList);
        if (persPersonExportItemList == null) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        try {
            if ("XLS".equals(reportType)) {
                boolean isMSIE;
                String fileNamePrefix = "";
                if (request.getParameter("tableNameSearch") != null && !"".equals(request.getParameter("tableNameSearch"))) {
                    fileNamePrefix = request.getParameter("tableNameSearch");
                } else if (request.getParameter("tableNameParam") != null && !"".equals(request.getParameter("tableNameParam"))) {
                    fileNamePrefix = request.getParameter("tableNameParam");
                }
                String excelFileNamePrefix = fileNamePrefix;
                String isEncrypt = request.getParameter("isEncrypt");
                String encryptPassword = request.getParameter("encryptPassword");
                String agent = request.getHeader("User-Agent");
                boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
                if (isMSIE) {
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                    fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
                } else {
                    fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
                }
                if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                    fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                    fileNamePrefix = fileNamePrefix.replace("%2520", " ");
                }
                if (StringUtils.isNotBlank((CharSequence)isEncrypt) && "1".equals(isEncrypt)) {
                    String fileName = String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtils.systemFilePath + File.separator + "upload" + File.separator + excelFileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase();
                    File folder = new File(fileName);
                    if (!folder.getParentFile().exists()) {
                        folder.getParentFile().mkdirs();
                    }
                    FileOutputStream outputStream = new FileOutputStream(fileName);
                    try {
                        try {
                            PersBigExcelUtil.export(persPersonExportItemList, PersPersonExportItem.class, attrs, excelFileNamePrefix, outputStream);
                        }
                        catch (Exception var18) {
                            throw new ZKBusinessException("common_op_failed");
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.flush();
                            outputStream.close();
                        }
                    }
                    ArrayList<File> files = new ArrayList<File>();
                    File file = new File(fileName);
                    if (file.exists()) {
                        files.add(file);
                    }
                    String tempPath = String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtils.systemFilePath + File.separator + "upload" + File.separator + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + "zip";
                    response = PersExportUtil.excelEncryptZip(tempPath, files, encryptPassword, request, response);
                    response.flushBuffer();
                    File zipTempFile = new File(tempPath);
                    if (zipTempFile.exists()) {
                        zipTempFile.delete();
                    }
                    for (File f : files) {
                        if (!f.exists()) continue;
                        f.delete();
                    }
                } else {
                    response.setCharacterEncoding("UTF-8");
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
                    response.setContentType("application/octet-stream");
                    ServletOutputStream outputStream = response.getOutputStream();
                    try {
                        try {
                            PersBigExcelUtil.export(persPersonExportItemList, PersPersonExportItem.class, attrs, excelFileNamePrefix, (OutputStream)outputStream);
                        }
                        catch (Exception var18) {
                            throw new ZKBusinessException("common_op_failed");
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.flush();
                            outputStream.close();
                        }
                    }
                }
                this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
                this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
                return;
            }
            JSONObject jsonColumn = new JSONObject(true);
            HashMap jsonCloumnMap = new HashMap();
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            LinkedHashMap<String, String> attributeExtMap = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < attrs.length) {
                String[] attr = attrs[i].split("-");
                String[] paramArray = attr[1].split("\\.");
                if (paramArray.length < 2) {
                    jsonColumn.put(attr[1], (Object)attr[0]);
                } else {
                    jsonColumn.put(paramArray[0], (Object)attr[0]);
                    attributeExtMap.put(attr[0], paramArray[1]);
                }
                ++i;
            }
            jsonMap.put("jsonColumn", jsonColumn.toJSONString());
            jsonCloumnMap.put("jsonColumn", jsonMap);
            LinkedHashMap<String, String> attrMap = null;
            Object attrValue = null;
            for (PersPersonExportItem person : persPersonExportItemList) {
                attrMap = new LinkedHashMap<String, String>();
                if (!attributeExtMap.isEmpty() && person.getAttributeExt() != null) {
                    for (String key : attributeExtMap.keySet()) {
                        attrValue = PersExportInfoUtil.getFieldValue(person.getAttributeExt(), (String)attributeExtMap.get(key));
                        attrMap.put(key, attrValue != null ? attrValue.toString().replaceAll(",", "&") : "");
                    }
                }
                person.setAttrMap(attrMap);
            }
            this.excelExport(persPersonExportItemList, PersPersonExportItem.class, jsonCloumnMap);
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    @RequiresPermissions(value={"pers:person:exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean isMSIE;
            String[] attrs = request.getParameterValues("attrs");
            String reportType = request.getParameter("reportType");
            Map<String, PersAttributeRuleItem> persAttributeRules = PersExportInfoUtil.getPersAttributeRule();
            String fileNamePrefix = I18nUtil.i18nCode((String)"pers_export_templateFileName", (Object[])new Object[0]);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileNamePrefix);
            sheet.setDefaultColumnWidth(attrs.length);
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = workbook.createFont();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            font.setFontHeightInPoints((short)14);
            style.setFont(font);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(fileNamePrefix);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, attrs.length - 1));
            cell.setCellStyle(style);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            row = sheet.createRow(1);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            int i = 0;
            while (i < attrs.length) {
                sheet.setColumnWidth(i, 5400);
                cell = row.createCell(i);
                String[] attr = attrs[i].split("-");
                PersAttributeRuleItem persAttr = persAttributeRules.get(attr[1]);
                if (persAttr == null) {
                    persAttr = new PersAttributeRuleItem(attr[0]);
                }
                attr[0] = attr[0].replaceAll("\\+", " ");
                cell.setCellValue(attr[0]);
                cell.setCellStyle(style);
                String commentStr = I18nUtil.i18nCode((String)"pers_export_templateCommentName", (Object[])new Object[]{attr[1]});
                Map<String, String> commentMap = PersBigExcelUtil.getPersAttributeComment();
                String attrComment = commentMap.get(attr[1]);
                if (StringUtils.isNotBlank((CharSequence)attrComment)) {
                    commentStr = String.valueOf(commentStr) + attrComment;
                }
                HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                comment.setString((RichTextString)new HSSFRichTextString(commentStr));
                cell.setCellComment((Comment)comment);
                ++i;
            }
            response.setCharacterEncoding("UTF-8");
            String agent = request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
            } else {
                fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                fileNamePrefix = fileNamePrefix.replace("%2520", " ");
            }
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outStream = response.getOutputStream();
            workbook.write((OutputStream)outStream);
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            return;
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    public String getDeptPins(String deptIds) {
        JSONObject jsonObject = new JSONObject();
        List<String> dptIds = Arrays.asList(deptIds.split(","));
        List persPersonItems = this.persPersonService.getPersPersonByDeptIds(dptIds);
        StringBuilder pins = new StringBuilder();
        StringBuilder persIds = new StringBuilder();
        int index = 1;
        for (PersPersonItem persPersonItem : persPersonItems) {
            if (index != persPersonItems.size()) {
                pins.append(String.valueOf(persPersonItem.getPin()) + ",");
                persIds.append(String.valueOf(persPersonItem.getId()) + ",");
            } else {
                pins.append(persPersonItem.getPin());
                persIds.append(persPersonItem.getId());
            }
            ++index;
        }
        jsonObject.put("pins", (Object)pins);
        jsonObject.put("persIds", (Object)persIds);
        return jsonObject.toJSONString();
    }

    @RequiresPermissions(value={"pers:person:resetSelfPwd"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_resetSelfPwd", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg resetSelfPwd(String ids) {
        this.persPersonService.resetSelfPwd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:importPhoto"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personPhoto", requestParams={"pin"}, opContent="pers_person_pin")
    public ZKResultMsg savePhoto(@RequestParam(value="pin") String pin, @RequestParam(value="photoQuality", defaultValue="false") Boolean photoQuality, @RequestParam(value="personPhoto") MultipartFile personPhoto) {
        if (this.persPersonService.isExistPin(pin).booleanValue()) {
            String importPhoto = this.request.getParameter("importPhoto");
            String importCropFace = this.request.getParameter("importCropFace");
            if (Objects.nonNull(personPhoto) && !personPhoto.isEmpty()) {
                if (personPhoto.getOriginalFilename().toLowerCase().matches(".*?(jpg|jpeg|png)$")) {
                    PersImportPhotoItem persImportPhotoItem = new PersImportPhotoItem();
                    persImportPhotoItem.setPin(pin);
                    persImportPhotoItem.setImportPhoto(Boolean.valueOf(Boolean.parseBoolean(importPhoto)));
                    persImportPhotoItem.setImportCropFace(Boolean.valueOf(Boolean.parseBoolean(importCropFace)));
                    if (persImportPhotoItem.getImportPhoto().booleanValue()) {
                        String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(String.valueOf(pin) + ".jpg"), (MultipartFile)personPhoto);
                        persImportPhotoItem.setPhotoPath(photoPath);
                    } else if (persImportPhotoItem.getImportCropFace().booleanValue()) {
                        String cropPhotoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(String.valueOf(System.currentTimeMillis()) + ".jpg"), (MultipartFile)personPhoto);
                        persImportPhotoItem.setCropPhotoPath(cropPhotoPath);
                    }
                    return I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.uploadUserPhoto(persImportPhotoItem));
                }
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_cardTemplate_jpgFormat"));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_cardTemplate_uploadFail"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_person_pinError", (Object[])new Object[]{pin}));
    }

    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personPhoto", requestParams={}, opContent="pers_import_personPhoto")
    public ZKResultMsg saveLargePhoto(@RequestParam(value="uploadFile") MultipartFile uploadFile) {
        if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
            String[] originalFilename = uploadFile.getOriginalFilename().replace("\\", "/").split("/");
            if (originalFilename.length > 0) {
                String filename = originalFilename[originalFilename.length - 1];
                String filePath = FileUtil.saveFileToServer((String)"pers", (String)("user" + File.separator + "zipPhotos"), (String)filename, (MultipartFile)uploadFile);
                String zipPath = this.persPersonService.unZipToFile(filePath, String.valueOf(File.separator) + "upload" + File.separator + "pers" + File.separator + "user" + File.separator + "zipPhotos" + File.separator);
                FileUtils.deleteFile((String)FileUtil.getLocalFullPath((String)filePath));
                String importPhoto = this.request.getParameter("importPhoto");
                String importCropFace = this.request.getParameter("importCropFace");
                PersImportPhotoItem persImportPhotoItem = new PersImportPhotoItem();
                persImportPhotoItem.setFilePath(zipPath);
                persImportPhotoItem.setImportPhoto(Boolean.valueOf(Boolean.parseBoolean(importPhoto)));
                persImportPhotoItem.setImportCropFace(Boolean.valueOf(Boolean.parseBoolean(importCropFace)));
                return I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.handlerZipUserPhoto(persImportPhotoItem));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"common_op_failed"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"common_op_failed"));
    }

    @RequiresPermissions(value={"pers:person:exportPhoto"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_export_personPhoto", opContent="pers_export_personPhoto")
    public void exportPhoto() throws Exception {
        boolean isMSIE;
        String fileNamePrefix;
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.persPersonService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        PersPersonPinItem condition = new PersPersonPinItem();
        this.setConditionValue((BaseItem)condition);
        Map pinAndPhotoMap = this.persPersonService.getAllPersonPhotoByAuthUserFilter(this.request.getSession().getId(), condition);
        if (pinAndPhotoMap.isEmpty()) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        ArrayList<File> files = new ArrayList<File>();
        pinAndPhotoMap.forEach((pin, photoPath) -> {
            File file = new File(FileUtil.getLocalFullPath((String)photoPath));
            if (file.exists()) {
                byte[] decPhoto = FileEncryptUtil.getDecryptFile((String)photoPath);
                if (Objects.nonNull(decPhoto)) {
                    String fileName = photoPath.substring(photoPath.lastIndexOf("/") + 1);
                    String decryFilePath = FileUtils.saveByte2Image((String)"pers", (String)"user/exportDecrypt", (String)fileName, (byte[])decPhoto);
                    File decryFile = new File(FileUtils.getLocalFullPath((String)decryFilePath));
                    if (decryFile.exists()) {
                        files.add(decryFile);
                    }
                } else {
                    files.add(file);
                }
            }
        });
        if (files.isEmpty()) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        String excelFileNamePrefix = fileNamePrefix = I18nUtil.i18nCode((String)"pers_import_photoType", (Object[])new Object[0]);
        String isEncrypt = this.request.getParameter("isEncrypt");
        String encryptPassword = this.request.getParameter("encryptPassword");
        String agent = this.request.getHeader("User-Agent");
        boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
        if (isMSIE) {
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
            fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
        } else {
            fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
        }
        if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
            fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
            fileNamePrefix = fileNamePrefix.replace("%2520", " ");
        }
        String tempPath = String.valueOf(ClassUtil.getRootPath()) + "/" + FileUtils.systemFilePath + "/" + "upload" + "/" + "pers" + "/" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        this.response = StringUtils.isNotBlank((CharSequence)isEncrypt) && "1".equals(isEncrypt) ? PersExportUtil.excelEncryptZip(tempPath, files, encryptPassword, this.request, this.response) : FileUtils.downLoadFiles((String)tempPath, (File[])files.toArray(new File[0]), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.response.flushBuffer();
        File zipTempFile = new File(tempPath);
        if (zipTempFile.exists()) {
            zipTempFile.delete();
        }
        String exportDecrypt = FileUtils.getLocalFullPath((String)FileUtils.createUploadFileRootPath((String)"pers", (String)"user/exportDecrypt"));
        FileUtils.deleteDirectory((String)exportDecrypt);
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
    }

    @RequiresPermissions(value={"pers:person:cardPrint"})
    public ModelAndView cardPrint(@RequestParam(value="ids") String ids) {
        List persPersonItemList = this.persPersonService.getItemsByIds(ids);
        this.request.setAttribute("persPersonItemList", (Object)persPersonItemList);
        return new ModelAndView("pers/cardPrintTemplate/opCardPrinting");
    }

    public ZKResultMsg getCountry(@RequestParam(value="countryKey") String countryKey) {
        return new ZKResultMsg((Object)this.persPersonService.getCountry(countryKey));
    }

    public String checkSMSModemParam() {
        return String.valueOf(this.persPersonService.checkSMSModemParam());
    }

    public ZKResultMsg validPersonPhoto(@RequestParam(value="personPhoto", required=false) MultipartFile file, @RequestParam(value="personIdPhoto", required=false) String personIdPhoto) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String photoPath = "";
        String filePath = FileUtil.createUploadFileRootPath((String)"pers", (String)"user/avatar");
        String photoName = String.valueOf(System.currentTimeMillis()) + ".jpg";
        try {
            if (Objects.nonNull(file) && !file.isEmpty()) {
                InputStream inputStream = file.getInputStream();
                boolean jpgImage = ImgEncodeUtil.isSupportImageType((InputStream)inputStream, (FileType[])new FileType[]{FileType.JPEG, FileType.PNG});
                if (!jpgImage) {
                    zkResultMsg.setRet("fail");
                    zkResultMsg.setMsg(String.valueOf(I18nUtil.i18nCode((String)"pers_face_validFailMsg", (Object[])new Object[0])) + I18nUtil.i18nCode((String)"pers_face_photoFormatError", (Object[])new Object[0]) + "</br>" + I18nUtil.i18nCode((String)"pers_face_notUpdateMsg", (Object[])new Object[0]));
                    return zkResultMsg;
                }
                String fullPath = String.valueOf(FileUtil.systemFilePath) + '/' + filePath;
                File fileImg = new File(new File(fullPath), photoName);
                if (!fileImg.getParentFile().exists()) {
                    fileImg.getParentFile().mkdirs();
                }
                if (fileImg.exists()) {
                    fileImg.delete();
                }
                file.transferTo(new File(fileImg.getAbsolutePath()));
                photoPath = String.valueOf('/') + filePath + photoName;
            } else if (StringUtils.isNotBlank((CharSequence)personIdPhoto)) {
                FileUtil.saveFile((String)filePath, (String)photoName, (String)personIdPhoto, (boolean)false);
                photoPath = String.valueOf('/') + filePath + photoName;
            }
            if (StringUtils.isNotBlank((CharSequence)photoPath)) {
                File tempFile;
                zkResultMsg = this.persPersonService.validCropFace(photoPath);
                if (!zkResultMsg.isSuccess()) {
                    zkResultMsg.setMsg(String.valueOf(zkResultMsg.getMsg()) + "</br>" + I18nUtil.i18nCode((String)"pers_face_notUpdateMsg", (Object[])new Object[0]));
                }
                if ((tempFile = new File(FileUtil.getLocalFullPath((String)photoPath))).exists()) {
                    tempFile.delete();
                }
            }
        }
        catch (IOException e) {
            this.log.error("pers validPersonPhoto error", (Throwable)e);
        }
        return zkResultMsg;
    }

    public TreeItem verifyModeTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = new TreeItem();
        item.setId("1000");
        item.setText(I18nUtil.i18nCode((String)"pers_card", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.FP_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_regFinger", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.PALM_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_metacarpalVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.VEIN_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_regVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.FACE_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_infraredFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_visibleFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("1001");
        item.setText(I18nUtil.i18nCode((String)"pers_person_visibleFacePhoto", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(PersConstants.PALM_BIO_TYPE_10.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_visiblePalm", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N1000");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notCard", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N1");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notRegFinger", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N8");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notMetacarpalVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N7");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notRegVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N2");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notInfraredFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N9");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notVisibleFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N1001");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notVisibleFacePhoto", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId("N10");
        item.setText(I18nUtil.i18nCode((String)"pers_person_notVisiblePalm", (Object[])new Object[0]));
        items.add(item);
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ModelAndView getBioTemplateView(@RequestParam(value="ids") String ids) {
        List personList;
        List pinList;
        if (StringUtils.isNotBlank((CharSequence)ids) && (pinList = this.persPersonService.getPinsByIds(personList = StrUtil.strToList((String)ids))) != null && !pinList.isEmpty()) {
            this.request.setAttribute("personIds", (Object)ids);
            this.request.setAttribute("pins", (Object)String.join((CharSequence)",", pinList));
        }
        List personItemList = this.persPersonService.getItemsByIds(ids);
        return new ModelAndView("pers/person/opDeleteBioTemplate");
    }

    @RequiresPermissions(value={"pers:person:delBioTemplate"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_delBioTemplate", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg deleteBioTemplate(@RequestParam Map<String, String> params) {
        String personIds = params.get("personIds");
        String personPins = params.get("pins");
        if (StringUtils.isNotBlank((CharSequence)personPins)) {
            String fp = params.get("fp");
            String face = params.get("face");
            String fv = params.get("fv");
            String palm = params.get("palm");
            String vislight = params.get("vislight");
            ArrayList<Short> bioType = new ArrayList<Short>();
            if (StringUtils.isNotBlank((CharSequence)fp)) {
                bioType.add(Short.parseShort(fp));
            }
            if (StringUtils.isNotBlank((CharSequence)face)) {
                bioType.add(Short.parseShort(face));
            }
            if (StringUtils.isNotBlank((CharSequence)fv)) {
                bioType.add(Short.parseShort(fv));
            }
            if (StringUtils.isNotBlank((CharSequence)palm)) {
                bioType.addAll(Arrays.stream(palm.split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()));
            }
            if (StringUtils.isNotBlank((CharSequence)vislight)) {
                bioType.add(Short.parseShort(vislight));
            }
            if (!bioType.isEmpty()) {
                List personIdList = StrUtil.strToList((String)personIds);
                List personPinList = StrUtil.strToList((String)personPins);
                this.persBioTemplateService.deleteByPersonPinsAndBioTypes(personIdList, personPinList, bioType);
            }
        }
        return new ZKResultMsg();
    }

    public void exportLeavePersonTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        if (jsonObject == null) {
            jsonObject = new JSONObject(new LinkedHashMap());
            jsonObject.put("pin", (Object)I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0]));
            jsonObject.put("name", (Object)I18nUtil.i18nCode((String)"pers_person_name", (Object[])new Object[0]));
            if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                jsonObject.put("lastName", (Object)I18nUtil.i18nCode((String)"pers_person_lastName", (Object[])new Object[0]));
            }
            jsonObject.put("deptName", (Object)I18nUtil.i18nCode((String)"pers_dept_deptName", (Object[])new Object[0]));
            jsonObject.put("leaveDate", (Object)I18nUtil.i18nCode((String)"pers_dimission_date", (Object[])new Object[0]));
            jsonObject.put("leaveTypeString", (Object)I18nUtil.i18nCode((String)"pers_dimission_type", (Object[])new Object[0]));
            jsonObject.put("leaveReason", (Object)I18nUtil.i18nCode((String)"pers_dimission_reason", (Object[])new Object[0]));
            commentMap.put("jsonColumn", jsonObject.toJSONString());
        }
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "pin": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "leaveDate": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"pers_dimission_dateFormat", (Object[])new Object[0]));
                    break;
                }
                case "leaveTypeString": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"pers_dimission_leaveType", (Object[])new Object[0]));
                }
            }
        }
        this.persExportTemplateUtil.templateExport(request, response, commentMap);
    }

    public ZKResultMsg getDeptIdByPersonId(@RequestParam(value="personId") String personId) {
        PersPersonItem item = this.persPersonService.getItemById(personId);
        ZKResultMsg result = new ZKResultMsg();
        if (item != null) {
            result.setData((Object)item.getDeptId());
        } else {
            result.setData(null);
        }
        return result;
    }

    public ZKResultMsg importLeavePersonExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersLeavePersonItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persLeavePersonService.importExcel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PersLeavePerson Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public ModelAndView exportPage() {
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            this.request.setAttribute(paramName, (Object)this.request.getParameter(paramName));
        }
        List items = this.persAttributeService.getByCondition(new PersAttributeItem());
        HashMap map = Maps.newHashMap();
        for (PersAttributeItem item : items) {
            String name;
            String attrName = item.getAttrName();
            if ("init".equals(item.getSqlStr()) && StringUtils.isNotBlank((CharSequence)(name = I18nUtil.i18nCode((String)("pers_attr_" + attrName), (Object[])new Object[0]))) && !name.contains("pers_attr_")) {
                attrName = name;
            }
            map.put("" + item.getFiledIndex(), attrName);
        }
        this.request.setAttribute("customAttrsMap", (Object)map);
        return new ModelAndView("pers/person/opExportRecord");
    }

    public ZKResultMsg getPersonPhotoBase64ByPin(String pin) {
        String decryptPhoto;
        String photoPath = this.persPersonService.getPersonPhotoPathByPin(pin);
        if (StringUtils.isNotBlank((CharSequence)photoPath) && StringUtils.isNotBlank((CharSequence)(decryptPhoto = FileEncryptUtil.getDecryptFileBase64((String)photoPath)))) {
            return new ZKResultMsg((Object)("data:image/jpg;base64," + decryptPhoto));
        }
        return ZKResultMsg.failMsg();
    }

    public String checkMobileIsExist(String mobilePhone) {
        PersPersonItem persPersonItem = this.persPersonService.getItemByMobile(mobilePhone);
        return String.valueOf(persPersonItem == null);
    }

    public ZKResultMsg getPersonCountByDeptIds(String deptIds) {
        int personCount = this.persPersonService.getPersonCountByDeptIds(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    @RequiresPermissions(value={"pers:person:enabled"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_enable", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg enabledPersCredential(String ids) {
        this.persPersonService.enabledCredential(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:disable"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_disable", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg disableCredential(String ids) {
        this.persPersonService.disableCredential(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:viewBioPhoto"})
    public ModelAndView viewBioPhoto(@RequestParam(value="ids") String ids) {
        List persBioPhotoItems = this.persBioPhotoService.getItemAndBase64ByPerIds(ids);
        this.request.setAttribute("bioPhotoItems", (Object)persBioPhotoItems);
        return new ModelAndView("pers/person/viewBioPhoto");
    }

    public String checkWhatsappParam() {
        return String.valueOf(this.persPersonService.checkWhatsappParam());
    }

    @RequiresPermissions(value={"pers:person:enabledApplogin"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_applogin_enabled", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg enabledApplogin(String ids) {
        this.persPersonService.enabledApplogin(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:disableApplogin"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_applogin_disable", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg disableApplogin(String ids) {
        this.persPersonService.disableApplogin(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:payment"})
    public ModelAndView makePayment(@RequestParam(value="ids") String ids) {
        PersPaymentHistoryReportItem persPaymentHistoryReportItem = new PersPaymentHistoryReportItem();
        Boolean authItemBySessionId = this.persPersonService.getAuthItemBySessionId(this.request.getSession().getId());
        this.request.setAttribute("isSuperuser", (Object)authItemBySessionId);
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PersPersonItem item1 = this.persPersonService.getItemById(ids);
            if (item1.getUserTypeName().equals("Member")) {
                PersPaymentReportItem paymentItem = new PersPaymentReportItem();
                List byCondition = this.persPaymentReportService.getByCondition(paymentItem.setPersonId(ids));
                paymentItem = (PersPaymentReportItem)byCondition.get(0);
                persPaymentHistoryReportItem.setPersonName(item1.getName());
                persPaymentHistoryReportItem.setPersonLastName(item1.getLastName());
                persPaymentHistoryReportItem.setPersonPin(item1.getPin());
                persPaymentHistoryReportItem.setPersonId(item1.getId());
                persPaymentHistoryReportItem.setMembershipPlan(paymentItem.getMembershipPlan());
                persPaymentHistoryReportItem.setFinalAmount(paymentItem.getFinalAmount());
                persPaymentHistoryReportItem.setBalanceAmount(paymentItem.getBalanceAmount());
                persPaymentHistoryReportItem.setAmountPaid(paymentItem.getAmountPaid());
                this.request.setAttribute("item", (Object)persPaymentHistoryReportItem);
                this.request.setAttribute("status", (Object)paymentItem.getStatus());
                this.request.setAttribute("previousPayableAmount", (Object)"0");
                return new ModelAndView("pers/person/makePayment");
            }
            this.request.setAttribute("item", (Object)"staff");
            this.request.setAttribute("previousPayableAmount", (Object)"0");
            return new ModelAndView("pers/person/makePayment");
        }
        this.request.setAttribute("item", (Object)"staff");
        this.request.setAttribute("previousPayableAmount", (Object)"0");
        return new ModelAndView("pers/person/makePayment");
    }

    @RequiresPermissions(value={"pers:person:renewal"})
    public ModelAndView membershipRenewal(@RequestParam(value="ids") String ids) {
        Boolean authItemBySessionId = this.persPersonService.getAuthItemBySessionId(this.request.getSession().getId());
        this.request.setAttribute("isSuperuser", (Object)authItemBySessionId);
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.log.info("membershipid " + ids);
            PersPersonItem item = this.persPersonService.getItemById(ids);
            this.log.info("perspersonitem" + item);
            System.out.println("PersPersonItem " + item);
            PersPaymentReportItem condition = new PersPaymentReportItem();
            List byCondition = this.persPaymentReportService.getByCondition(condition.setPersonId(ids));
            this.log.info("byCondition" + byCondition);
            System.out.println("byCondition " + byCondition);
            if (item.getUserTypeName().equalsIgnoreCase("Member") && byCondition.size() != 0 && ((PersPaymentReportItem)byCondition.get(0)).getStatus().equalsIgnoreCase("Fully Paid")) {
                Date endTimeOfMembership = this.persPersonService.getMembershipEndTime(ids);
                this.request.setAttribute("personPin", (Object)item.getPin());
                this.request.setAttribute("personId", (Object)item.getId());
                List byRenewalPersonByCreateTime = this.persMembershipRenewalService.getByRenewalPersonByCreateTimeDesc(item.getId());
                this.log.info("byRenewalPersonByCreateTime " + byRenewalPersonByCreateTime);
                if (endTimeOfMembership.after(DateUtil.getCurrentTime()) && byRenewalPersonByCreateTime.size() == 0) {
                    this.log.info("endTimeOfMembership is after today date");
                    try {
                        this.request.setAttribute("startTime", (Object)DateUtil.dateToString((Date)DateUtil.addDay((Date)DateUtil.getDayBeginTime((Date)endTimeOfMembership), (int)1), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception e) {
                        this.log.error("endTimeOfMembership failed", (Object)e.getMessage());
                        e.printStackTrace();
                    }
                } else if (byRenewalPersonByCreateTime.size() != 0) {
                    this.log.info("byRenewalPersonByCreateTime");
                    try {
                        Date endTime = DateUtil.stringToDate((String)((PersMembershipRenewalItem)byRenewalPersonByCreateTime.get(0)).getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
                        this.log.info("endTime in renewal" + endTime);
                        this.request.setAttribute("startTime", (Object)DateUtil.dateToString((Date)DateUtil.addDay((Date)DateUtil.getDayBeginTime((Date)endTime), (int)1), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception e) {
                        this.log.error("failed at byRenewalPersonByCreateTime");
                    }
                } else {
                    this.request.setAttribute("startTime", (Object)DateUtil.dateToString((Date)DateUtil.getDayBeginTime((Date)new Date()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            } else if (!item.getUserTypeName().equals("Member") || !((PersPaymentReportItem)byCondition.get(0)).getStatus().equals("Fully Paid")) {
                this.log.info("failed to retriew the renewal page");
                this.request.setAttribute("renewalError", (Object)true);
            }
        }
        return new ModelAndView("pers/person/membershipRenewal");
    }

    public Boolean getEmailConfiguredOrNot() {
        if (!this.baseMailService.completeMailInfo()) {
            return false;
        }
        return true;
    }

    public ZKResultMsg sendEmailToPerson() {
        String email = this.request.getParameter("email");
        String personId = this.request.getParameter("personId");
        String urlContent = this.baseSysParamService.getValByName("pers.tempPerson.urlCreate");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(urlContent).append("?userId=").append(personId);
        StringBuffer data = new StringBuffer("<style> div{margin-top:10px;margin-left:30px;font-size:16px}</style><div>");
        data.append("<div style='margin-bottom: 10px'>" + I18nUtil.i18nCode((String)"pers_qr_sendQrcodeLink", (Object[])new Object[0]) + "<a href=" + stringBuilder.toString() + ">" + I18nUtil.i18nCode((String)"pers_qr_sendClick", (Object[])new Object[0]) + "</a></div>");
        this.baseSendMailService.sendSampleHtmlMail(email, I18nUtil.i18nCode((String)"pers_qr_mailInvitation", (Object[])new Object[0]), data.toString(), "");
        return ZKResultMsg.successMsg();
    }

    public Boolean getWattsupConfiguredOrNot() {
        return this.persPersonService.checkWhatsappParam();
    }

    public ZKResultMsg sendWhatsAppToPerson() {
        String whatsappMobileNo = this.request.getParameter("whatsappMobileNo");
        String userId = this.request.getParameter("personId");
        String urlContent = this.baseSysParamService.getValByName("pers.tempPerson.urlCreate");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(urlContent).append("?userId=").append(userId);
        Boolean b = this.persPersonService.sendToWhatsApp(whatsappMobileNo, stringBuilder.toString());
        if (b.booleanValue()) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public Boolean getSmsConfiguredOrNot() {
        return this.persPersonService.checkSMSModemParam();
    }

    public ZKResultMsg sendSmsToPerson() {
        String mobilePhone = this.request.getParameter("mobilePhone");
        String userId = this.request.getParameter("personId");
        String urlContent = this.baseSysParamService.getValByName("pers.tempPerson.urlCreate");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(urlContent).append("?userId=").append(userId);
        Boolean b = this.persPersonService.sendToMobileSms(mobilePhone, stringBuilder.toString());
        if (b.booleanValue()) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public ModelAndView memberMeasurements(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PersPersonItem item1 = this.persPersonService.getItemById(ids);
            if (item1.getUserTypeName().equals("Member")) {
                PersMeasurementsItem condition = new PersMeasurementsItem();
                condition.setPersonId(ids);
                List persMeasurementsItem = this.persMeasurementsService.getByCondition(condition);
                if (persMeasurementsItem.size() != 0) {
                    this.request.setAttribute("item", persMeasurementsItem.get(0));
                } else {
                    this.request.setAttribute("item", (Object)condition);
                }
                return new ModelAndView("pers/person/measurements");
            }
            this.request.setAttribute("item", (Object)"staff");
            return new ModelAndView("pers/person/measurements");
        }
        this.request.setAttribute("item", (Object)"staff");
        return new ModelAndView("pers/person/measurements");
    }

    public ZKResultMsg getAllTrainers() {
        PersPersonItem condition = new PersPersonItem();
        List persTrainerItems = this.persPersonService.getByCondition(condition.setUserTypeName("Trainer"));
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (PersPersonItem persTrainerItem : persTrainerItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(persTrainerItem.getId());
            selectItem.setText((Object)persTrainerItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getDecryptCertPhotoBase64(String photoPath) {
        String thumbPath = FileUtil.getThumbPath((String)photoPath);
        String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
        return new ZKResultMsg((Object)("data:image/jpg;base64," + photoBase64));
    }

    public DxGrid getAllMemebrsBasedOnTrainerPlan(PersTrainerPlanViewItem condition) {
        Pager pager = this.persPersonService.getMemberItemsBasedOnTrainerPlan(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getFilledSlots() {
        String trainerPlan = this.request.getParameter("trainerPlan");
        String id = this.request.getParameter("id");
        PersTrainerPlanItem itemByName = this.persTrainerPlanService.getItemByName(trainerPlan);
        PersPersonItem condition = new PersPersonItem();
        List byCondition = this.persPersonService.getByCondition(condition.setPersTrainerPlan(trainerPlan));
        List collect = byCondition.stream().map(PersPersonItem::getId).collect(Collectors.toList());
        if (Integer.parseInt(itemByName.getSlots()) <= byCondition.size()) {
            if (collect.contains(id)) {
                return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)false));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)true));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)false));
    }

    public ZKResultMsg checkMember() {
        String personId = this.request.getParameter("personId");
        return this.persPersonService.checkMember(personId);
    }

    public ZKResultMsg getQRCodeUploadAccess() {
        ZKResultMsg res = new ZKResultMsg();
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("passwordInput");
                boolean ret = this.persPersonService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    res.setRet("fail");
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
                res.setRet("success");
            }
            catch (ZKBusinessException e) {
                res.setRet("fail");
                throw e;
            }
            catch (Exception e) {
                res.setRet("fail");
                this.log.error("", (Throwable)e);
            }
        }
        return res;
    }
}

