/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersPaymentReportRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPaymentReportService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPaymentReportExportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPaymentReportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseMailService;
import com.zkteco.zkbiosecurity.system.service.BaseSendMailService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPaymentReportController
extends ExportController
implements PersPaymentReportRemote {
    @Autowired
    private PersPaymentReportService persPaymentReportService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private BaseMailService baseMailService;
    @Autowired
    private BaseSendMailService baseSendMailService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    @RequiresPermissions(value={"pers:payment:report"})
    public ModelAndView index() {
        return new ModelAndView("pers/reports/persPaymentReport");
    }

    @RequiresPermissions(value={"pers:payment:report:refresh"})
    public DxGrid list(PersPaymentReportItem condition) {
        Pager pager = this.persPaymentReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg duePayment(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List itemByIds = this.persPaymentReportService.getIdsForDuePay(ids);
        for (PersPaymentReportItem persPaymentReportItem : itemByIds) {
            PersPersonItem personItem = this.persPersonService.getItemById(persPaymentReportItem.getPersonId());
            Boolean emailSetting = this.baseMailService.completeMailInfo();
            if (emailSetting.booleanValue()) {
                if (personItem != null) {
                    String message = "Payment Reminder for the Gym Membership. We are reaching out to remind you of an outstanding payment for your Member ID " + personItem.getPin() + " with " + persPaymentReportItem.getMembershipPlan() + " [Months] gym membership. Your attention to this matter would be greatly appreciated to avoid any disruption to your membership benefits. Please visit our front desk for the further clarifications.";
                    this.baseSendMailService.sendSampleHtmlMail(personItem.getEmail(), I18nUtil.i18nCode((String)"pers_person_mail_due_payment", (Object[])new Object[0]), message, "");
                    continue;
                }
                throw ZKBusinessException.warnException((String)"pers_person_notExist", (Object[])new Object[0]);
            }
            throw ZKBusinessException.warnException((String)"base_mail_undefineMailCallAdmin", (Object[])new Object[0]);
        }
        ZKResultMsg.successMsg();
        return res;
    }

    public ZKResultMsg sendInvoice(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        Map<Object, Object> finalData = new LinkedHashMap();
        List itemByIds = this.persPaymentReportService.getItemByIds(ids);
        if (itemByIds.size() != 0) {
            for (PersPaymentReportItem persPaymentReportItem : itemByIds) {
                PersPersonItem personItem = this.persPersonService.getItemById(persPaymentReportItem.getPersonId());
                Boolean emailSetting = this.baseMailService.completeMailInfo();
                if (personItem != null) {
                    finalData = this.fields(persPaymentReportItem, personItem);
                }
                Set array = finalData.keySet();
                String[] fields = array.toArray(new String[array.size()]);
                Collection<Object> fieldValuesCol = finalData.values();
                String[] fieldValues = fieldValuesCol.toArray(new String[fieldValuesCol.size()]);
                if (emailSetting.booleanValue()) {
                    if (fieldValues.length != 0 && fields.length != 0) {
                        StringBuilder htmlContent = new StringBuilder();
                        String header = this.baseSysParamService.getValByName("pers.invoice.header").toString();
                        String footer = this.baseSysParamService.getValByName("pers.invoice.footer").toString();
                        htmlContent.append("<!DOCTYPE html>\n").append("<html lang='en'>\n").append("<head>\n").append("    <meta charset='UTF-8'>\n").append("    <meta name='viewport' content='width=device-width, initial-scale=1.0'>\n").append("    <title>Invoice</title>\n").append("    <style>\n").append("        table { border-collapse: collapse; width: 100%; }\n").append("        th { border: none; padding: 10px 20px; background-color: transparent; text-align: left;font-size: 20px;font-family: 'Made Tommy';}\n").append("        td { border: none; padding: 10px 20px; background-color: transparent; text-align: left; font-size: 20px;font-family: 'Made Tommy';}\n").append("        .container { width: 100%; text-align: left; }\n").append("        .header, .footer { font-size: 36px; font-weight: bold; background-color: #47d1e1;text-align: center;font-family: 'Made Tommy';}\n").append("        .spacer { height: 15px; }\n").append("        .subject { font-size: 20px;font-family: 'Made Tommy'; }\n").append("    </style>\n").append("</head>\n").append("<body>\n").append("    <div class='container'>\n").append("        <div class='subject'>").append("The following details Contain Member Payment Information").append("</div>\n").append("        <div class='spacer'></div>\n").append("        <div class='header'>").append(header).append("</div>\n").append("        <div class='spacer'></div>\n").append("        <table>\n");
                        int i = 0;
                        while (i < fields.length) {
                            htmlContent.append("            <tr>\n").append("                <td>").append(fields[i]).append("</td>\n").append("                <td>:</td>\n").append("                <td>").append(fieldValues[i]).append("</td>\n").append("            </tr>\n");
                            ++i;
                        }
                        htmlContent.append("        </table>\n").append("        <div class='spacer'></div>\n").append("        <div class='footer'>").append(footer).append("</div>\n").append("        <div class='spacer'></div>\n").append("        <div class='subject'>").append("Please do not reply to this mail").append("</div>\n").append("    </div>\n").append("</body>\n").append("</html>");
                        this.baseSendMailService.sendSampleHtmlMail(personItem.getEmail(), I18nUtil.i18nCode((String)"pers_person_mail_invoice_payment", (Object[])new Object[0]), htmlContent.toString(), "");
                        continue;
                    }
                    throw ZKBusinessException.warnException((String)"pers_person_notExist", (Object[])new Object[0]);
                }
                throw ZKBusinessException.warnException((String)"base_mail_undefineMailCallAdmin", (Object[])new Object[0]);
            }
            ZKResultMsg.successMsg();
        } else {
            res.setMsg("For Unpaid Members We can't send Invoice");
        }
        return res;
    }

    public Map<String, String> fields(PersPaymentReportItem persPaymentReportItem, PersPersonItem item) {
        LinkedHashMap<String, String> finalData = new LinkedHashMap<String, String>();
        String[][] data1 = new String[][]{{"UserId", this.baseSysParamService.getValByName("pers.invoice.userId").toString()}, {"Name", this.baseSysParamService.getValByName("pers.invoice.name").toString()}, {"Last Name", this.baseSysParamService.getValByName("pers.invoice.lastName").toString()}, {"Membership Plan", this.baseSysParamService.getValByName("pers.invoice.membershipPlan").toString()}, {"Total Amount", this.baseSysParamService.getValByName("pers.invoice.totalAmount").toString()}, {"Paid Amount", this.baseSysParamService.getValByName("pers.invoice.paidAmount").toString()}, {"Due Amount", this.baseSysParamService.getValByName("pers.invoice.dueAmount").toString()}, {"Payment Date", this.baseSysParamService.getValByName("pers.invoice.paymentDate").toString()}, {"Trainer", this.baseSysParamService.getValByName("pers.invoice.trainer").toString()}, {"Trainer Plan", this.baseSysParamService.getValByName("pers.invoice.trainerPlan").toString()}, {"Payment Mode", this.baseSysParamService.getValByName("pers.invoice.paymentMode").toString()}};
        String[][] data = new String[][]{{"UserId", persPaymentReportItem.getPersonPin()}, {"Name", StringUtils.isNotBlank((CharSequence)item.getName()) ? item.getName() : ""}, {"Last Name", StringUtils.isNotBlank((CharSequence)item.getLastName()) ? item.getLastName() : ""}, {"Membership Plan", StringUtils.isNotBlank((CharSequence)persPaymentReportItem.getMembershipPlan()) ? String.valueOf(persPaymentReportItem.getMembershipPlan()) + " Months" : ""}, {"Total Amount", StringUtils.isNotBlank((CharSequence)persPaymentReportItem.getFinalAmount()) ? "\u20b9" + persPaymentReportItem.getFinalAmount() : "\u20b90"}, {"Paid Amount", StringUtils.isNotBlank((CharSequence)persPaymentReportItem.getAmountPaid()) ? "\u20b9" + persPaymentReportItem.getAmountPaid() : "\u20b90"}, {"Due Amount", StringUtils.isNotBlank((CharSequence)persPaymentReportItem.getBalanceAmount()) ? "\u20b9" + persPaymentReportItem.getBalanceAmount() : "\u20b90"}, {"Payment Date", DateUtil.dateToString((Date)DateUtil.getDayBeginTime((Date)persPaymentReportItem.getPayDay()), (String)"yyyy-MM-dd HH:mm:ss")}, {"Trainer", StringUtils.isNotBlank((CharSequence)item.getPersTrainerName()) ? item.getPersTrainerName() : "-"}, {"Trainer Plan", StringUtils.isNotBlank((CharSequence)item.getPersTrainerPlan()) ? item.getPersTrainerPlan() : "-"}, {"Payment Mode", StringUtils.isNotBlank((CharSequence)persPaymentReportItem.getPayMode()) ? persPaymentReportItem.getPayMode() : ""}};
        String[][] stringArrayArray = data1;
        int n = data1.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entry1 = stringArrayArray[n2];
            String key1 = entry1[0];
            String value1 = entry1[1];
            String[][] stringArrayArray2 = data;
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] entry2 = stringArrayArray2[n4];
                String key2 = entry2[0];
                String value2 = entry2[1];
                if (key1.equals(key2) && value1.equals("true")) {
                    finalData.put(key2, value2);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return finalData;
    }

    @RequiresPermissions(value={"pers:payment:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String sortName = request.getParameter("sortName");
        String sortOrder = request.getParameter("sortOrder");
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.persPersonService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        PersPaymentReportItem paymentReportItem = new PersPaymentReportItem();
        this.setConditionValue((BaseItem)paymentReportItem);
        if (StringUtils.isNotBlank((CharSequence)sortName) && StringUtils.isNotBlank((CharSequence)sortOrder)) {
            paymentReportItem.setSortName(sortName);
            paymentReportItem.setSortOrder(sortOrder);
        }
        String[] attrs = new String[]{"User+ID-personPin", "User+Name-name", "Payment+Id-paymentId", "Total+Amount+Paid-amountPaid", "Due+Amount-balanceAmount", "Payment+Mode-payMode", "Payment+Status-status", "Payment+Day-payDay"};
        String reportType = request.getParameter("reportType");
        List itemList = this.persPaymentReportService.getItemData(PersPaymentReportItem.class, paymentReportItem, this.getBeginIndex(), this.getEndIndex());
        if (itemList.isEmpty()) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        List paymentReportExportItems = this.persPaymentReportService.copyData(itemList);
        if (paymentReportExportItems == null) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        try {
            JSONObject jsonColumn = new JSONObject(true);
            HashMap jsonCloumnMap = new HashMap();
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            LinkedHashMap<String, String> attributeExtMap = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < attrs.length) {
                String[] attr = attrs[i].split("-");
                String[] paramArray = attr[1].split("\\.");
                if (paramArray.length < 2) {
                    jsonColumn.put(attr[1], (Object)attr[0]);
                } else {
                    jsonColumn.put(paramArray[0], (Object)attr[0]);
                    attributeExtMap.put(attr[0], paramArray[1]);
                }
                ++i;
            }
            jsonMap.put("jsonColumn", jsonColumn.toJSONString());
            jsonCloumnMap.put("jsonColumn", jsonMap);
            if (reportType.equals("PDF")) {
                this.excelExport(paymentReportExportItems, PersPaymentReportExportItem.class, jsonCloumnMap);
            } else {
                this.log.info("export in the word");
                this.exportToWord(response, paymentReportExportItems, jsonColumn);
            }
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    private void exportToWord(HttpServletResponse response, List<PersPaymentReportExportItem> paymentReportExportItems, JSONObject jsonColumn) {
        this.log.info("exporting to the word");
        if (paymentReportExportItems.isEmpty() || paymentReportExportItems.size() == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        response.setHeader("Content-Disposition", "attachment; filename=PaymentReport_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + "docx");
        boolean exportSucceeded = false;
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ServletOutputStream out = response.getOutputStream();){
                    this.log.info("generate word format");
                    this.wordgenerate((OutputStream)out, paymentReportExportItems, jsonColumn);
                    out.flush();
                    exportSucceeded = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error("PaymentReport export error", (Throwable)e);
                throw new ZKBusinessException("common_report_exportFaild");
            }
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            if (exportSucceeded) {
                try {
                    response.flushBuffer();
                }
                catch (IOException e) {
                    this.log.error("Error flushing response buffer", (Throwable)e);
                }
            }
        }
    }

    private void wordgenerate(OutputStream out, List<PersPaymentReportExportItem> paymentReportExportItems, JSONObject jsonColumn) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (XWPFDocument document = new XWPFDocument();){
                this.log.info("creating the word and setting up the data");
                XWPFParagraph title = document.createParagraph();
                title.setAlignment(ParagraphAlignment.CENTER);
                XWPFRun run = title.createRun();
                run.setText("Payment Report");
                run.setBold(true);
                run.setFontSize(16);
                XWPFTable table = document.createTable();
                XWPFTableRow header = table.getRow(0);
                header.getCell(0).setText("USER ID");
                header.addNewTableCell().setText("User Name");
                header.addNewTableCell().setText("Payment ID");
                header.addNewTableCell().setText("Total Amount Paid");
                header.addNewTableCell().setText("Due Amount");
                header.addNewTableCell().setText("Payment Mode");
                header.addNewTableCell().setText("Payment Status");
                header.addNewTableCell().setText("Payment Date");
                for (PersPaymentReportExportItem item : paymentReportExportItems) {
                    XWPFTableRow row = table.createRow();
                    row.getCell(0).setText(item.getPersonPin());
                    row.getCell(1).setText(item.getName());
                    row.getCell(2).setText(String.valueOf(item.getPaymentId()));
                    row.getCell(3).setText(item.getAmountPaid());
                    row.getCell(4).setText(item.getBalanceAmount());
                    row.getCell(5).setText(item.getPayMode());
                    row.getCell(6).setText(item.getStatus());
                    row.getCell(7).setText(DateUtil.dateToString((Date)item.getPayDay(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                document.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("failed to create the word", (Object)e.getMessage());
        }
    }

    public ModelAndView exportPage() {
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            this.request.setAttribute(paramName, (Object)this.request.getParameter(paramName));
        }
        return new ModelAndView("pers/person/exportPayment");
    }
}

