/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersPaymentHistoryReportRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPaymentHistoryReportService;
import com.zkteco.zkbiosecurity.pers.vo.PersPaymentHistoryReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPaymentHistoryReportController
extends ExportController
implements PersPaymentHistoryReportRemote {
    @Autowired
    private PersPaymentHistoryReportService persPaymentHistoryReportService;

    @RequiresPermissions(value={"pers:payment:history:report"})
    public ModelAndView index() {
        return new ModelAndView("pers/reports/persPaymentHistoryReport");
    }

    @RequiresPermissions(value={"pers:payment:history:report:refresh"})
    public DxGrid list(PersPaymentHistoryReportItem condition) {
        Pager pager = this.persPaymentHistoryReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save(PersPaymentHistoryReportItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persPaymentHistoryReportService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

