/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersParamsRemote;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.service.PersExpireMemberMailNotificationService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemPersInfo2CloudService;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PersParamsController
extends BaseController
implements PersParamsRemote {
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersCardService persCardService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private SystemPersInfo2CloudService pers2CloudService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    public static final String MAP_PATH = "/upload/pers/QRCode";
    private static final long MAX_FILE_SIZE = 0x500000L;
    @Autowired
    private PersExpireMemberMailNotificationService persExpireMembermailnotification;

    @RequiresPermissions(value={"pers:params:edit"})
    @LogRequest(module="pers_module", object="common_leftMenu_paramSet", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params, @RequestParam(value="qrCodeJpg", required=false) MultipartFile file) {
        ZKResultMsg res = new ZKResultMsg();
        params.put("pers.ocrCertNoType", params.get("certNoType"));
        params.put("pers.ocrDriveVerson", params.get("driverLink"));
        if (Objects.nonNull(file) && !file.isEmpty()) {
            String oldMap;
            String path = String.valueOf(this.systemFilePath) + MAP_PATH;
            if (Objects.nonNull(file) && !file.isEmpty()) {
                if (file == null || file.getSize() > 0x500000L) {
                    throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"acc_map_imgSizeError", (Object[])new Object[]{5}), (Object[])new Object[0]);
                }
                long fName = System.currentTimeMillis();
                String pathCreation = "/upload/pers/QRCode/" + file.getOriginalFilename();
                params.put("pers.qrCodeUPI.photo", pathCreation);
                File upLoadPicPath = new File(path);
                if (!upLoadPicPath.isAbsolute()) {
                    path = String.valueOf(ClassUtil.getRootPath()) + "/" + path;
                    upLoadPicPath = new File(path);
                }
                upLoadPicPath.exists();
                upLoadPicPath.mkdirs();
            }
            if (Objects.nonNull(file) && !file.isEmpty() && StringUtil.isNotBlank((CharSequence)(oldMap = this.baseSysParamService.getValByName("pers.qrCodeUPI.photo")))) {
                File oldPic = new File(oldMap);
                if (!oldPic.isAbsolute()) {
                    oldPic = new File(FileUtils.getLocalFullPath((String)oldMap));
                }
                if (oldPic.exists()) {
                    oldPic.delete();
                }
            }
            try {
                String mapName = String.valueOf(path) + "/" + file.getOriginalFilename();
                File mapFile = new File(mapName);
                file.transferTo(mapFile);
            }
            catch (IOException e) {
                throw new ZKBusinessException("QRCode Image Issue");
            }
        }
        this.persParamsService.saveItem(params);
        this.pers2CloudService.syncPersParamToCloud();
        this.persExpireMembermailnotification.changeProcessorTime();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.persParamsService.getPersParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String checkMaxPinLenth(@RequestParam(value="pers.pinLen") int pinLen) {
        long maxPinLen = this.persPersonService.getMaxPinLenth();
        return String.valueOf(maxPinLen <= (long)pinLen);
    }

    public ZKResultMsg checkPinLetters(@RequestParam(value="pinSupportLetter") String pinSupportLetter) {
        long personCount = this.persPersonService.getPersonCount();
        if (personCount > 0L) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_param_pinSetWarn"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public String checkPinIncrement(String pinSupportIncrement) {
        int count = this.persPersonService.checkPinIncrement(pinSupportIncrement);
        if (count > 0) {
            return String.valueOf(false);
        }
        return String.valueOf(true);
    }

    public String checkIsExistCard() {
        long count = this.persCardService.count();
        return String.valueOf(count > 0L);
    }

    public String checkIsExistCards() {
        long count = this.persCardService.countByCardType((short)1);
        return String.valueOf(count > 0L);
    }

    public String checkSingleAttSystem() {
        return String.valueOf(this.persParamsService.checkSingleAttSystem());
    }

    public ZKResultMsg getQRCodeUPI() {
        ZKResultMsg res = new ZKResultMsg();
        String valByName = this.baseSysParamService.getValByName("pers.qrCodeUPI.photo");
        if (StringUtil.isNotBlank((CharSequence)valByName)) {
            res.setRet("success");
            res.setMsg(valByName);
        } else {
            res.setRet("fail");
        }
        return res;
    }

    public String checkSuperUser() {
        Boolean authItemBySessionId = this.persPersonService.getAuthItemBySessionId(this.request.getSession().getId());
        return String.valueOf(authItemBySessionId);
    }

    public ZKResultMsg deleteQRCodeUpi() {
        ZKResultMsg res = new ZKResultMsg();
        String valByName = this.baseSysParamService.getValByName("pers.qrCodeUPI.photo");
        if (StringUtil.isNotBlank((CharSequence)valByName)) {
            File oldPic = new File(valByName);
            if (!oldPic.isAbsolute()) {
                oldPic = new File(FileUtils.getLocalFullPath((String)valByName));
            }
            if (oldPic.exists()) {
                oldPic.delete();
                this.baseSysParamService.saveValueByName("pers.qrCodeUPI.photo", " ");
                res.setMsg("success");
            } else {
                res.setMsg("no qrcode to delete");
            }
        } else {
            res.setMsg("no qrcode to delete");
        }
        return res;
    }
}

