/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersMembershipRenewalRemote;
import com.zkteco.zkbiosecurity.pers.service.PersMembershipRenewalService;
import com.zkteco.zkbiosecurity.pers.vo.PersMembershipRenewalItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersMembershipRenewalController
extends ExportController
implements PersMembershipRenewalRemote {
    @Autowired
    private PersMembershipRenewalService persMembershipRenewalService;

    @RequiresPermissions(value={"pers:memberExpiry:report"})
    public ModelAndView index() {
        return new ModelAndView("pers/reports/persMembershipRenewalHistoryReport");
    }

    public ZKResultMsg save(PersMembershipRenewalItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persMembershipRenewalService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:memberExpiry:report:refresh"})
    public DxGrid list(PersMembershipRenewalItem condition) {
        Pager pager = this.persMembershipRenewalService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

