/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersMembershipRemote;
import com.zkteco.zkbiosecurity.pers.service.PersMembershipService;
import com.zkteco.zkbiosecurity.pers.util.PersExportTemplateUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersMembershipItem;
import com.zkteco.zkbiosecurity.pers.vo.PersMembershipSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersMembershipController
extends ExportController
implements PersMembershipRemote {
    @Autowired
    private PersMembershipService persMembershipService;
    @Autowired
    private PersExportTemplateUtil persExportTemplateUtil;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:membership"})
    public ModelAndView index() {
        return new ModelAndView("pers/membership/persMembership");
    }

    @RequiresPermissions(value={"pers:membership:refresh"})
    public DxGrid list(PersMembershipItem condition) {
        Pager pager = this.persMembershipService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PersMembershipItem item = this.persMembershipService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("pers/membership/editPersMembership");
    }

    public String isExist(String membershipCode) {
        return String.valueOf(this.persMembershipService.getItemByMembershipCode(membershipCode) == null);
    }

    @RequiresPermissions(value={"pers:membership:edit", "pers:membership:add"})
    public ZKResultMsg save(PersMembershipItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persMembershipService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:membership:del"})
    public ZKResultMsg del(String ids) {
        this.persMembershipService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isPlanExist(String membershipPlan) {
        return String.valueOf(this.persMembershipService.getItemByMembershipPlan(membershipPlan) == null).toString();
    }

    public void export(HttpServletRequest req, HttpServletResponse resp) {
        PersMembershipItem persMembershipItem = new PersMembershipItem();
        this.setConditionValue((BaseItem)persMembershipItem);
        List list = this.persMembershipService.getPersMembershipItemData(PersMembershipItem.class, (BaseItem)persMembershipItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(list, PersMembershipItem.class);
    }

    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "membershipCode": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "membershipPlan": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "membershipAmount": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                }
            }
        }
        this.persExportTemplateUtil.templateExport(request, response, commentMap);
    }

    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersMembershipItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persMembershipService.importExcel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PersPosition Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public TreeItem tree() {
        List demoUserTYpeItems = this.persMembershipService.getByCondition(new PersMembershipItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (PersMembershipItem userType : demoUserTYpeItems) {
            item = new TreeItem();
            item.setId(userType.getId());
            item.setText(userType.getMembershipPlan());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public DxGrid listSelect(PersMembershipSelectItem codition) {
        Pager pager = this.persMembershipService.loadMembershipSelect(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getMembershipAmount() {
        String membershipId = this.request.getParameter("membershipId");
        PersMembershipItem item = new PersMembershipItem();
        if (!StringUtils.isEmpty((CharSequence)membershipId)) {
            item = this.persMembershipService.getItemById(membershipId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)item));
    }

    public ZKResultMsg getMembershipAmountByName() {
        String membershipPlan = this.request.getParameter("membershipPlan");
        PersMembershipItem item = new PersMembershipItem();
        if (!StringUtils.isEmpty((CharSequence)membershipPlan)) {
            item = this.persMembershipService.getItemByMembershipPlan(membershipPlan);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)item));
    }

    public ZKResultMsg getAllMemberships() {
        List byCondition = this.persMembershipService.getByCondition(new PersMembershipItem());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)byCondition));
    }

    public ZKResultMsg getMembershipAmountById() {
        String membershipId = this.request.getParameter("membershipId");
        PersMembershipItem item = Optional.ofNullable(membershipId).filter(StringUtils::isNotBlank).map(arg_0 -> ((PersMembershipService)this.persMembershipService).getItemById(arg_0)).orElse(new PersMembershipItem());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)item));
    }
}

