/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersIssueCardRemote;
import com.zkteco.zkbiosecurity.pers.service.PersIssueCardService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersIssueCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersNoCardPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersIssueCardController
extends ExportController
implements PersIssueCardRemote {
    @Autowired
    private PersIssueCardService persIssueCardService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:issueCard"})
    public ModelAndView index() {
        return new ModelAndView("pers/issueCard/persIssueCard");
    }

    @RequiresPermissions(value={"pers:issueCard:refresh"})
    public DxGrid list(PersIssueCardItem condition) {
        Pager pager = this.persIssueCardService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        this.persIssueCardService.protectIssuePinAndCard(pager.getData());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:person"})
    public DxGrid noCardPerson(PersNoCardPersonItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            pager = this.persIssueCardService.findNoCardPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert(pager, condition.getClass());
    }

    @LogRequest(module="pers_module", object="pers_card", opType="pers_batchIssCard_entity", requestParams={"pinCardListJson"}, opContent="pers_person_pin")
    @RequiresPermissions(value={"pers:card:batchIssueCard"})
    public ZKResultMsg batch(@RequestParam(value="cardListJson") String cardListJson) {
        List cardPersonItems = (List)JSON.parseObject((String)cardListJson, (TypeReference)new TypeReference<List<PersCardItem>>(){}, (Feature[])new Feature[0]);
        this.persIssueCardService.batchIssueCard(cardPersonItems);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:issueCard:export"})
    @LogRequest(module="pers_module", object="pers_card", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PersIssueCardItem persIssueCardItem = new PersIssueCardItem();
        this.setConditionValue((BaseItem)persIssueCardItem);
        List itemList = this.persIssueCardService.getItemData(PersIssueCardItem.class, (BaseItem)persIssueCardItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, PersIssueCardItem.class);
    }

    public ZKResultMsg batchAcmsCard() {
        String personIds = this.request.getParameter("personIds");
        String deptIds = this.request.getParameter("deptIds");
        String checkVal = this.request.getParameter("checkVal");
        if ("2".equals(checkVal) && StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = "";
        } else {
            deptIds = "";
        }
        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
        this.persIssueCardService.batchIssueAcmsCard(personIds, deptIds);
        this.progressCache.setProcess(new ProcessBean(99, 99));
        this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

