/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersInquiryManagementRemote;
import com.zkteco.zkbiosecurity.pers.service.PersInquiryManagementService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.ConvertToMemberItem;
import com.zkteco.zkbiosecurity.pers.vo.PersInquiryManagementItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersInquiryManagementController
extends ExportController
implements PersInquiryManagementRemote {
    @Autowired
    private PersInquiryManagementService persInquiryManagementService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersPersonService persPersonService;

    @RequiresPermissions(value={"pers:inquiryManagement"})
    public ModelAndView index() {
        return new ModelAndView("pers/inquiryManagement/persInquiryManagement");
    }

    @RequiresPermissions(value={"pers:inquiryManagement:edit", "pers:inquiryManagement:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        Map persParams = this.persParamsService.getPersParams();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PersInquiryManagementItem item;
            Boolean b = this.persInquiryManagementService.getIsExistInPerson(id);
            if (b.booleanValue()) {
                this.request.setAttribute("NoeditAccess", (Object)true);
            }
            if (StringUtils.isNotBlank((CharSequence)(item = this.persInquiryManagementService.getItemById(id)).getPhotoPath())) {
                String thumbPath = FileUtil.getThumbPath((String)item.getPhotoPath());
                if (FileUtil.fileExists((String)thumbPath)) {
                    String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setPhotoBase64("data:image/jpg;base64," + photoBase64);
                } else {
                    String photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)thumbPath);
                    item.setPhotoBase64("data:image/jpg;base64," + photoBase64);
                }
            }
            this.request.setAttribute("item", (Object)item);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            PersInquiryManagementItem item = new PersInquiryManagementItem();
            Date d = new Date();
            item.setJoinDate(d);
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("defPin", (Object)this.persInquiryManagementService.getIncPoint());
        }
        this.request.setAttribute("persParams", (Object)persParams);
        return new ModelAndView("pers/inquiryManagement/editPersInquiryManagement");
    }

    @RequiresPermissions(value={"pers:inquiryManagement"})
    public DxGrid list(PersInquiryManagementItem condition) {
        Pager pager = this.persInquiryManagementService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:inquiryManagement:edit", "pers:inquiryManagement:add"})
    public ZKResultMsg save(PersInquiryManagementItem item, @RequestParam(value="personPhoto1", required=false) MultipartFile file) {
        ZKResultMsg res = new ZKResultMsg();
        if (Objects.nonNull(file) && !file.isEmpty()) {
            String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"Inquiry Management", (String)(String.valueOf(item.getInquiryPin()) + ".jpg"), (MultipartFile)file);
            item.setPhotoPath(photoPath);
        }
        this.persInquiryManagementService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String checkEmailIsExist(String email) {
        PersInquiryManagementItem persInquiryManagementItem = this.persInquiryManagementService.getItemByEmail(email);
        PersPersonItem persPersonItem = this.persPersonService.getItemByEmail(email);
        if (persInquiryManagementItem != null) {
            return String.valueOf(this.persInquiryManagementService.getItemByEmail(email) == null);
        }
        if (persPersonItem != null) {
            return String.valueOf(this.persPersonService.getItemByEmail(email) == null);
        }
        return String.valueOf(true);
    }

    public String checkMobileIsExist(String mobilePhone) {
        PersInquiryManagementItem persInquiryManagementItem = this.persInquiryManagementService.getItemByMobile(mobilePhone);
        PersPersonItem persPersonItem = this.persPersonService.getItemByMobile(mobilePhone);
        if (persInquiryManagementItem != null) {
            return String.valueOf(this.persInquiryManagementService.getItemByEmail(mobilePhone) == null);
        }
        if (persPersonItem != null) {
            return String.valueOf(this.persPersonService.getItemByEmail(mobilePhone) == null);
        }
        return String.valueOf(true);
    }

    public ZKResultMsg convertToMember(ConvertToMemberItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getIds())) {
            Boolean b = this.persInquiryManagementService.getIsExistInPerson(item.getIds());
            if (!b.booleanValue()) {
                PersInquiryManagementItem itemById = this.persInquiryManagementService.getItemById(item.getIds());
                this.persInquiryManagementService.saveConvetToMemberItem(itemById, item);
                return I18nUtil.i18nMsg((ZKResultMsg)res);
            }
            res.setMsg("Already converted to member");
            return I18nUtil.i18nMsg((ZKResultMsg)res);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:inquiryManagement:del"})
    public ZKResultMsg del(String ids) {
        this.persInquiryManagementService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView convertInquiryToMember(String ids) {
        Boolean b;
        if (StringUtils.isNotBlank((CharSequence)ids) && (b = this.persInquiryManagementService.getIsExistInPerson(ids)).booleanValue()) {
            this.request.setAttribute("errorMsg", (Object)"Already converted to member");
        }
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("pers/person/convertInquiryPersonToMember");
    }

    public String isExist(String inquiryPin) {
        return String.valueOf(this.persInquiryManagementService.isExistInquiryPin(inquiryPin) == null);
    }
}

