/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersExpiryMemberReportRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersExpiryMemberReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseMailService;
import com.zkteco.zkbiosecurity.system.service.BaseSendMailService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersExpiryMemberReportController
extends ExportController
implements PersExpiryMemberReportRemote {
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private BaseSendMailService baseSendMailService;
    @Autowired
    private BaseMailService baseMailService;

    @RequiresPermissions(value={"pers:memberExpiry:report"})
    public ModelAndView index() {
        return new ModelAndView("pers/reports/persExpiryMemberReport");
    }

    @RequiresPermissions(value={"pers:memberExpiry:report:refresh"})
    public DxGrid list(PersExpiryMemberReportItem condition) {
        Pager pager = this.persPersonService.getExpiryMembers(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    public ZKResultMsg memberExpiry(String ids) {
        List itemsByIds2 = this.persPersonService.getItemsByIds(ids);
        List selectedExpiryPersons = this.persPersonService.getSelectedExpiryPersons(itemsByIds2);
        List itemsByIds = this.persPersonService.getItemsByIds(ids);
        ZKResultMsg res = new ZKResultMsg();
        for (PersExpiryMemberReportItem persExpiryMemberReportItem : selectedExpiryPersons) {
            Date membershipEndTime = this.persPersonService.getMembershipEndTime(persExpiryMemberReportItem.getId());
            Boolean emailSetting = this.baseMailService.completeMailInfo();
            if (emailSetting.booleanValue()) {
                String message = "We're reaching out to inform you that your membership " + persExpiryMemberReportItem.getMembershipPlan() + " month is set to expire on [" + DateUtil.dateToString((Date)membershipEndTime, (String)"yyyy-MM-dd HH:mm:ss") + "]. Renewing your membership ensures uninterrupted access to all the benefits and amenities that we have to offer. Please visit our front desk for the further clarifications.";
                this.baseSendMailService.sendSampleHtmlMail(persExpiryMemberReportItem.getEmail(), I18nUtil.i18nCode((String)"pers_member_expiry_notification", (Object[])new Object[0]), message, "");
                continue;
            }
            throw ZKBusinessException.warnException((String)"base_mail_undefineMailCallAdmin", (Object[])new Object[0]);
        }
        ZKResultMsg.successMsg();
        return res;
    }
}

