/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersCardPrintTemplateRemote;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeExtService;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeService;
import com.zkteco.zkbiosecurity.pers.service.PersCardPrintTemplateService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeExtItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PersCardPrintTemplateController
extends BaseController
implements PersCardPrintTemplateRemote {
    @Autowired
    private PersCardPrintTemplateService persCardPrintTemplateService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersAttributeService persAttributeService;
    @Autowired
    private PersAttributeExtService persAttributeExtService;
    private BufferedImage buffImage = null;
    private Graphics2D g = null;
    private Font font = new Font("Arial,\u5fae\u8f6f\u96c5\u9ed1", 0, 24);
    private int x = 0;
    private int y = 0;

    public ZKResultMsg getPersonData(@RequestParam(value="personId") String personId) {
        ZKResultMsg msg = new ZKResultMsg();
        JSONObject person = new JSONObject();
        JSONObject printData = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        PersPersonItem persPersonItem = this.persPersonService.getItemById(personId);
        if (persPersonItem != null) {
            String perName = persPersonItem.getName() == null ? "" : persPersonItem.getName();
            String perLastName = persPersonItem.getLastName() == null ? "" : persPersonItem.getLastName();
            person.put("name", (Object)(String.valueOf(perName) + " " + perLastName));
            person.put("pin", (Object)persPersonItem.getPin());
            person.put("gender", (Object)(persPersonItem.getGender() == null ? "" : persPersonItem.getGender()));
            person.put("entryDate", (Object)(persPersonItem.getHireDate() == null ? "" : sdf.format(persPersonItem.getHireDate())));
            person.put("department", (Object)(persPersonItem.getDeptName() == null ? "" : persPersonItem.getDeptName()));
            person.put("mobilephone", (Object)(persPersonItem.getMobilePhone() == null ? "" : persPersonItem.getMobilePhone()));
            person.put("email", (Object)(persPersonItem.getEmail() == null ? "" : persPersonItem.getEmail()));
            String photoBase64 = "";
            if (StringUtils.isNotBlank((CharSequence)persPersonItem.getPhotoPath())) {
                photoBase64 = FileEncryptUtil.getDecryptFileBase64((String)persPersonItem.getPhotoPath());
                photoBase64 = "data:image/jpg;base64," + photoBase64;
            }
            person.put("photo", (Object)photoBase64);
            person.put("birthday", persPersonItem.getBirthday() == null ? "" : persPersonItem.getBirthday());
            person.put("cardNo", (Object)(persPersonItem.getCardNos() == null ? "" : persPersonItem.getCardNos()));
            person.put("positionName", (Object)(persPersonItem.getPositionName() == null ? "" : persPersonItem.getPositionName()));
            PersAttributeExtItem extItem = this.persAttributeExtService.getItemByPersonId(personId);
            BeanMap attr = null;
            if (Objects.nonNull(extItem)) {
                attr = BeanMap.create((Object)extItem);
            }
            List attributes = this.persAttributeService.getByCondition(new PersAttributeItem());
            for (PersAttributeItem item : attributes) {
                if (!Objects.nonNull(attr)) continue;
                person.put("attrValue" + item.getFiledIndex(), (Object)MapUtils.getString((Map)attr, (Object)("attrValue" + item.getFiledIndex()), (String)""));
            }
            printData.put("person", (Object)person);
        }
        msg.setData((Object)printData);
        return msg;
    }

    public ZKResultMsg getPicTemplate(@RequestParam(value="templateId") String templateId, @RequestParam(value="personId") String personId) {
        HashMap<String, String> imgBase64Map = new HashMap<String, String>();
        Map templateMap = this.persCardPrintTemplateService.getPrintTemplate(templateId);
        if (templateMap != null) {
            String imgBase64Str = "";
            String templateWidth = (String)templateMap.get("width");
            String templateHeight = (String)templateMap.get("height");
            String frontData = (String)templateMap.get("frontData");
            String oppositeData = (String)templateMap.get("oppositeData");
            Map tranMap = this.persCardPrintTemplateService.getPersonData(personId);
            JSONArray frontJsonArray = JSONArray.parseArray((String)frontData);
            imgBase64Str = this.getCardTemplate(Integer.parseInt(templateWidth), Integer.parseInt(templateHeight), frontJsonArray, tranMap);
            imgBase64Map.put("front", imgBase64Str);
            JSONArray oppositeJsonArray = JSONArray.parseArray((String)oppositeData);
            imgBase64Str = this.getCardTemplate(Integer.parseInt(templateWidth), Integer.parseInt(templateHeight), oppositeJsonArray, tranMap);
            imgBase64Map.put("opposite", imgBase64Str);
            imgBase64Map.put("visEmpPin", (String)tranMap.get("printData.visTransaction.visEmpPin"));
        }
        return new ZKResultMsg(imgBase64Map);
    }

    private String getCardTemplate(int templateWidth, int templateHeight, JSONArray jsonArrayData, Map<String, String> personMap) {
        JSONObject data;
        int left = 0;
        int top = 0;
        int width = 0;
        int height = 0;
        int fontSize = 0;
        String leftPoint = "";
        String topPoint = "";
        String colorStr = "";
        String fontSizeStr = "";
        Color color = new Color(0, 0, 0);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        this.buffImage = new BufferedImage(templateWidth, templateHeight, 1);
        this.g = this.buffImage.createGraphics();
        this.g.setColor(Color.WHITE);
        this.g.fillRect(0, 0, this.buffImage.getWidth(), this.buffImage.getHeight());
        String imgBase64Str = "";
        JSONArray bgArray = new JSONArray();
        int i = 0;
        while (i < jsonArrayData.size()) {
            data = jsonArrayData.getJSONObject(i);
            if ("background".equals(data.getString("printType"))) {
                BufferedImage b;
                if (StringUtils.isNotBlank((CharSequence)data.getString("printValue")) && (b = this.loadImageLocal(data.getString("printValue"))) != null) {
                    this.g.drawImage(b, 0, 0, this.buffImage.getWidth(), this.buffImage.getHeight(), null);
                }
                bgArray.add((Object)data);
            }
            ++i;
        }
        jsonArrayData.removeAll((Collection)bgArray);
        i = 0;
        while (i < jsonArrayData.size()) {
            String[] cArray;
            data = jsonArrayData.getJSONObject(i);
            leftPoint = data.getString("leftPoint");
            left = Double.valueOf(leftPoint.substring(0, leftPoint.length() - 2)).intValue();
            topPoint = data.getString("topPoint");
            top = Double.valueOf(topPoint.substring(0, topPoint.length() - 2)).intValue();
            fontSizeStr = data.getString("fontSize");
            fontSize = Integer.parseInt(fontSizeStr.substring(0, fontSizeStr.length() - 2)) * 2;
            width = Double.valueOf(data.getString("width")).intValue();
            height = Double.valueOf(data.getString("height")).intValue();
            colorStr = data.getString("color");
            String[] stringArray = cArray = colorStr.split(",");
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                colors.add(Integer.parseInt(c.trim()));
                ++n2;
            }
            color = new Color((Integer)colors.get(0), (Integer)colors.get(1), (Integer)colors.get(2));
            switch (data.getString("printType")) {
                case "photo": {
                    BufferedImage d;
                    String decryFilePath = personMap.get(data.getString("cell"));
                    String photoPath = decryFilePath.replaceAll("\\\\", "/");
                    byte[] decPhoto = FileEncryptUtil.getDecryptFile((String)photoPath);
                    if (decPhoto != null) {
                        String fileName = photoPath.substring(photoPath.lastIndexOf("/") + 1);
                        decryFilePath = FileUtils.saveByte2Image((String)"pers", (String)"printTemplate/cardPrintImages/decrypt", (String)fileName, (byte[])decPhoto);
                    }
                    if ((d = this.loadImageLocal(decryFilePath)) != null) {
                        d = this.imageZoom(d, width * 2, height * 2);
                        this.modifyImagetogeter(d, left * 2, top * 2);
                    }
                    if (decPhoto == null) break;
                    FileUtils.deleteFile((String)FileUtil.getLocalFullPath((String)decryFilePath));
                    break;
                }
                case "images": {
                    BufferedImage imgs = this.loadImageLocal(data.getString("cell"));
                    if (imgs == null) break;
                    imgs = this.imageZoom(imgs, width * 2, height * 2);
                    this.modifyImagetogeter(imgs, left * 2, top * 2);
                    break;
                }
                case "line": {
                    this.g.setColor(color);
                    this.g.drawLine(left * 2, top * 2, (left + width) * 2, (top + height) * 2);
                    break;
                }
                case "txt": {
                    this.g.setColor(color);
                    this.modifyImage(data.getString("cell"), left * 2, top * 2 + 25, data.getString("fontFamily"), fontSize);
                    break;
                }
                case "text": {
                    this.g.setColor(color);
                    this.modifyImage(personMap.get(data.getString("cell")), left * 2, top * 2 + 25, data.getString("fontFamily"), fontSize);
                    break;
                }
            }
            ++i;
        }
        imgBase64Str = this.saveImage(String.valueOf(System.currentTimeMillis()) + ".jpg");
        return imgBase64Str.replaceAll("[\\s*\t\n\r]", "");
    }

    private BufferedImage loadImageLocal(String imgName) {
        try {
            if (new File(String.valueOf(FileUtil.systemFilePath) + File.separator + imgName).exists()) {
                return ImageIO.read(new File(String.valueOf(FileUtil.systemFilePath) + File.separator + imgName));
            }
            if (((Object)((Object)this)).getClass().getResource("/static" + imgName) != null) {
                return ImageIO.read(((Object)((Object)this)).getClass().getResource("/static" + imgName).openStream());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private void setFont(String fontStyle, int fontSize) {
        this.font = new Font("Arial,\u5fae\u8f6f\u96c5\u9ed1", 0, fontSize);
    }

    private void modifyImagetogeter(BufferedImage d, int x, int y) {
        int w = d.getWidth();
        int h = d.getHeight();
        this.g.drawImage(d, x, y, w, h, null);
    }

    private BufferedImage imageZoom(BufferedImage d, int newWidth, int newHeight) {
        int w = d.getWidth();
        int h = d.getHeight();
        float wRatio = (float)w / (float)newWidth;
        float hRatio = (float)h / (float)newHeight;
        float newRatio = (float)newWidth / (float)newHeight;
        d = wRatio > hRatio ? d.getSubimage((int)((float)w - (float)h * newRatio) / 2, 0, (int)((float)h * newRatio), h) : d.getSubimage(0, (int)((float)h - (float)w / newRatio) / 2, w, (int)((float)w / newRatio));
        BufferedImage r = new BufferedImage(newWidth, newHeight, 1);
        r.getGraphics().drawImage(d.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
        return r;
    }

    private void modifyImage(Object content, int x, int y, String fontStyle, int fontSize) {
        this.setFont(fontStyle, fontSize);
        this.g.setFont(this.font);
        this.x = x;
        this.y = y;
        if (content != null) {
            this.g.drawString(content.toString(), this.x, this.y);
        }
    }

    private String saveImage(String newImage) {
        String imgBase64Str = "";
        if (this.buffImage != null) {
            try {
                String xmlPath = "upload/pers/printTemplate/cardPrintImages/";
                String fullPath = String.valueOf(FileUtil.systemFilePath) + File.separator + xmlPath;
                File outputfile = new File(new File(fullPath), newImage);
                if (!outputfile.getParentFile().exists()) {
                    outputfile.getParentFile().mkdirs();
                } else if (outputfile.exists()) {
                    outputfile.delete();
                }
                ImageIO.write((RenderedImage)this.buffImage, "jpg", outputfile);
                imgBase64Str = ImgEncodeUtil.encodeBase64((String)outputfile.getAbsolutePath());
                this.g.dispose();
                this.g = null;
                this.buffImage.flush();
                this.buffImage = null;
                FileUtils.deleteFile((String)outputfile.getAbsolutePath());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return imgBase64Str;
    }

    public Boolean isShowCardPrint() {
        return this.persCardPrintTemplateService.isShowCardPrint();
    }
}

