/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersCardRemote;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersCardController
extends ExportController
implements PersCardRemote {
    @Autowired
    private PersCardService persCardService;

    @RequiresPermissions(value={"pers:card"})
    public ModelAndView index() {
        return new ModelAndView("pers/card/persCard");
    }

    @RequiresPermissions(value={"pers:card:refresh"})
    public DxGrid list(PersCardItem condition) {
        Pager pager = this.persCardService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        this.persCardService.protectPinAndCard(pager.getData());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:card:batchCardLoss"})
    public ZKResultMsg batchCardLoss(@RequestParam(value="ids") String ids) {
        this.persCardService.batchCardLoss(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:card:batchCardRevert"})
    public ZKResultMsg batchCardRevert(@RequestParam(value="ids") String ids) {
        this.persCardService.batchCardRevert(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(@RequestParam(value="cardNo") String cardNo, @RequestParam(value="pin", required=false) String pin) {
        return String.valueOf(!this.persCardService.isExistByCardNoAndPinAndOtherFilter(cardNo, pin));
    }

    public String checkCardBit(String cardNo) {
        return String.valueOf(this.persCardService.checkCardBit(cardNo));
    }

    public Map<String, String> cardVerification(String cardNo) {
        return this.persCardService.cardVerification(cardNo);
    }

    @RequiresPermissions(value={"pers:card:export"})
    @LogRequest(module="pers_module", object="pers_card", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PersCardItem persCardItem = new PersCardItem();
        this.setConditionValue((BaseItem)persCardItem);
        List itemList = this.persCardService.getItemData(PersCardItem.class, (BaseItem)persCardItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, PersCardItem.class);
    }
}

